/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.controls.renderers.NumberCellRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDataTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDetailPane;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentViewerState;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.DelayedLoadInterface;
import oracle.dmt.dataminer.utils.DelayedProcessWorker;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentViewerMainPanel
extends DataMinerViewGUI
implements DelayedLoadInterface {
    private static final Logger theLogger = Logger.getLogger(ClusterComponentViewerMainPanel.class.getName());
    private static final String _noSelectedAttributes = ComponentLrb.get("CLUSTER_COMPONENT_SELECTED_ATTRIBUTES_NONE");
    public static final int FILTER_DETAIL_ATTRIBUTE = 0;
    private ClusterComponentViewerState state;
    private ClusterComponentDetailPane jTabPane;
    private GraphPanel[] graphPanel;
    private Dimension _histogramRowDimension = new Dimension(120, 25);
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private boolean _reload = true;
    private boolean _success = false;
    private DelayedProcessWorker worker;
    private BlockingComponent overLayPanel = null;
    private JButton _jApplyFilterButton;
    private JComboBox _jComponentCombo;
    private JLabel _jComponentComboLabel;
    private JPanel _jDetailPanel;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private DataMinerTablePanel dataMinerTablePanel;
    private JLabel jFilterLabel;
    private JLabel jPriorLabel;
    private JLabel jPriorValue;
    private JSplitPane jSplitPane1;
    private JTextField jTextField1;

    public ClusterComponentViewerMainPanel(Editor editor, Context context) {
        super(editor, context);
        this.state = new ClusterComponentViewerState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jComponentComboLabel = new JLabel();
        this._jComponentCombo = new JComboBox();
        this.jPriorLabel = new JLabel();
        this.jPriorValue = new JLabel();
        this._jFetchSizeLabel = new JLabel();
        this._jApplyFilterButton = new JButton();
        this._jFetchSize = new JSpinner();
        this.jFilterLabel = new JLabel();
        this.jTextField1 = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this._jDetailPanel = new JPanel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(760, 463));
        this._jComponentComboLabel.setText("Component:");
        this._jComponentCombo.setMaximumSize(new Dimension(150, 20));
        this._jComponentCombo.setMinimumSize(new Dimension(150, 20));
        this._jComponentCombo.setPreferredSize(new Dimension(150, 20));
        this._jComponentCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterComponentViewerMainPanel.this._jComponentComboActionPerformed(actionEvent);
            }
        });
        this.jPriorLabel.setHorizontalAlignment(11);
        this.jPriorLabel.setText("Prior:");
        this.jPriorValue.setText("0.5");
        this._jFetchSizeLabel.setText("Fetch Size:");
        this._jFetchSizeLabel.setPreferredSize(new Dimension(60, 14));
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setHorizontalAlignment(11);
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterComponentViewerMainPanel.this._jApplyFilterButtonActionPerformed(actionEvent);
            }
        });
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(87, 20));
        this.jFilterLabel.setText("Filter by Attribute Name:");
        this.jTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    ClusterComponentViewerMainPanel.this._jApplyFilterButton_actionPerformed(null);
                }
            }
        });
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 738, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 117, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this._jDetailPanel);
        this.jSplitPane1.setLeftComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.jFilterLabel, -2, 176, -2).addGap(31, 31, 31).addComponent(this.jTextField1, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, 106, -2)).addComponent(this.jSplitPane1).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jComponentComboLabel, -2, 84, -2).addGap(18, 18, 18).addComponent(this._jComponentCombo, -2, 120, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jApplyFilterButton, -2, 106, -2)).addGroup(groupLayout2.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jPriorLabel, -2, 40, -2).addGap(18, 18, 18).addComponent(this.jPriorValue, -2, 118, -2))))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(20, 20, 20).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addComponent(this._jApplyFilterButton, -2, -1, -2).addGap(7, 7, 7).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jFetchSizeLabel, -2, -1, -2).addComponent(this._jFetchSize, -2, -1, -2))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._jComponentComboLabel).addComponent(this.jPriorValue, -2, 20, -2).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPriorLabel).addComponent(this._jComponentCombo, -2, -1, -2))).addGap(13, 13, 13).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFilterLabel).addComponent(this.jTextField1, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 373, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.linkSize(1, this._jComponentComboLabel, this.jPriorLabel, this.jPriorValue);
    }

    private void _jComponentComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this.state.setSelectedComponent((Integer)this._jComponentCombo.getSelectedItem());
        if (this._reload) {
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void _jApplyFilterButtonActionPerformed(ActionEvent actionEvent) {
        this._jApplyFilterButton_actionPerformed(actionEvent);
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ComponentLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ComponentLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(DataMinerIcons.get(Icons.QUERY));
        this._jApplyFilterButton.setToolTipText(ComponentLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)ComponentLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(ComponentLrb.get("FETCH_SIZE_ADA") + "\n" + ComponentLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(this.state.getInitialFetchSize(), 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resLabel((JLabel)this._jComponentComboLabel, (Component)this._jComponentCombo, (String)ComponentLrb.get("COMPONENT_LABEL"));
        this._jComponentComboLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("COMPONENT_LABEL"));
        this._jComponentComboLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("COMPONENT_LABEL_ADA"));
        ResourceUtils.resLabel((JLabel)this.jPriorLabel, (Component)this.jPriorValue, (String)ComponentLrb.get("PRIOR_LABEL"));
        this.jPriorLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("PRIOR_LABEL"));
        this.jPriorLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("PRIOR_LABEL_ADA"));
        ResourceUtils.resLabel((JLabel)this.jFilterLabel, (Component)this.jTextField1, (String)ComponentLrb.get("FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleName(ComponentLrb.get("FILTER_LABEL"));
        this.jFilterLabel.getAccessibleContext().setAccessibleDescription(ComponentLrb.get("FILTER_LABEL_ADA"));
        this.setTotalNumberComponents();
    }

    public HelpInfo getHelpInfo() {
        return this.state.getHelpInfo();
    }

    @Override
    public void setLoading(boolean bl) {
        super.setLoading(bl);
        this.enableControls(!bl);
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jComponentCombo.setEnabled(bl);
        this.jPriorValue.setEnabled(bl);
        this.jTextField1.setEnabled(bl);
    }

    @Override
    public void initUI() {
        this._jFetchSize.setLocale(Locale.getDefault());
        this.jTabPane = new ClusterComponentDetailPane();
        this.jTabPane.initialize(this.state, this._context);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setRightComponent(this.jTabPane);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.dataMinerTablePanel.getTable().getTableHeader().setReorderingAllowed(false);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ClusterComponentViewerMainPanel.this.handleSelectionChanged();
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this.jSplitPane1.updateUI();
        this._reload = false;
        this.worker = new DelayedProcessWorker(this);
        this.worker.execute();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public void reload() {
        if (this._jComponentCombo.getItemCount() > 0) {
            this._jComponentCombo.setSelectedIndex(0);
            this.state.setSelectedComponent((Integer)this._jComponentCombo.getSelectedItem());
            this._jApplyFilterButton_actionPerformed(null);
        }
    }

    private void initializeControls() {
        this.setupTable(this.state.getComponentTableModel());
        this.enableControls(false);
    }

    private void setupTable(GenericBaseTableModel genericBaseTableModel) {
        this.dataMinerTablePanel.setup((TableModel)genericBaseTableModel, null, 0);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(new MiniHistogramCellRenderer(this.state, this._histogramRowDimension, 20));
        tableColumnModel.getColumn(2).setCellRenderer(new NumberCellRenderer());
        tableColumnModel.getColumn(3).setCellRenderer(new NumberCellRenderer());
        if (genericBaseTableModel instanceof ClusterComponentTableModel) {
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            tableColumnModel.getColumn(1).setPreferredWidth(250);
            tableColumnModel.getColumn(2).setPreferredWidth(125);
            tableColumnModel.getColumn(3).setPreferredWidth(125);
        } else {
            tableColumnModel.getColumn(0).setPreferredWidth(800);
        }
    }

    private void setTotalNumberComponents() {
        String string = ComponentLrb.get("TOTAL_COMPONENTS");
        String string2 = NumericFormat.format(this.state.getTotalComponents());
        String string3 = MessageFormat.format(string, string2);
        this.dataMinerTablePanel.setTitle(string3);
    }

    public void showOverlayPanel() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
    }

    public void hideOverlayPanel() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }

    private void handleSelectionChanged() {
        SwingWorker swingWorker;
        boolean bl = true;
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = null;
        if (null == nArray || nArray.length == 0) {
            bl = false;
            string = _noSelectedAttributes;
        }
        if (!bl) {
            this.createMessagePanel(string);
            return;
        }
        if (!this.state.isLoaded()) {
            return;
        }
        int n = this.jTabPane.getSelectedIndex();
        this.jTabPane.showDataTab(this.isChartVisible());
        String string2 = this.getEMModelNestedAttributeName();
        boolean bl2 = null != string2;
        this.jTabPane.showProjectionsTab(bl2);
        if (bl2) {
            this.state.loadProjectionStatus();
            this.jTabPane.updateProjections();
            swingWorker = new LoadProjectionPanel(string2);
            swingWorker.execute();
        }
        this.state.loadFrequencyTable(this.getSelectedAttributeName());
        this.jTabPane.showFrequency();
        if (n > 0 && n < this.jTabPane.getTabCount()) {
            this.jTabPane.setSelectedIndex(n);
        }
        swingWorker = new LoadGraphPanel(nArray);
        swingWorker.execute();
    }

    private String getSelectedAttributeName() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (null == nArray || nArray.length == 0) {
            return null;
        }
        ClusterComponentTableModel clusterComponentTableModel = (ClusterComponentTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        Vector<ClusterComponentModelRow> vector = clusterComponentTableModel.getDataVector();
        ClusterComponentModelRow clusterComponentModelRow = vector.get(nArray[0]);
        return clusterComponentModelRow.getAttributeName();
    }

    private boolean isChartVisible() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        if (null == nArray || nArray.length == 0) {
            return false;
        }
        ClusterComponentTableModel clusterComponentTableModel = (ClusterComponentTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        Vector<ClusterComponentModelRow> vector = clusterComponentTableModel.getDataVector();
        ClusterComponentModelRow clusterComponentModelRow = vector.get(nArray[0]);
        return clusterComponentModelRow.isFrequencyAvailable();
    }

    public void createMessagePanel(String string) {
        this.jTabPane.createMessagePanel(string);
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this._jApplyFilterButton.setEnabled(false);
            if (this.validateSettings()) {
                this.setLoading(true);
                this.state.loadStatus();
                this.dataMinerTablePanel.getTable().setModel((TableModel)this.state.getComponentTableModel());
                this.showOverlayPanel();
                this._reload = true;
                this.worker = new DelayedProcessWorker(this);
                this.worker.setReloadData(true);
                this.worker.execute();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_TITLE"), (String)ClusterLrb.get("FILTER_PROCESS_FAILURE_MESG"), null);
        }
    }

    private boolean validateSettings() throws Exception {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this._jFetchSize);
        this.state.getFilterSetting().setFetchSize(number.intValue());
        this.state.getFilterSetting().setUseFilterSpecification(false);
        String string = this.jTextField1.getText();
        this.state.setAttributeNameFilter(string);
        return bl;
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private String getFormatedDoubleValue(Double d) {
        String string = null;
        try {
            string = NumericFormat.format(d, true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel()) + "";
        }
        catch (Exception exception) {
            string = d.toString();
        }
        return string;
    }

    @Override
    public void loadDataProcess() {
        try {
            this.state.load();
            this._success = this.state.isLoaded();
        }
        catch (Exception exception) {
            this._success = false;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadGUIProcess() {
        try {
            if (this._success) {
                int[] nArray;
                Serializable serializable;
                if (!this._reload) {
                    serializable = this.state.getComponentList();
                    this._jComponentCombo.setModel(new DefaultComboBoxModel<Integer>((Vector<Integer>)serializable));
                    this._jComponentCombo.setSelectedItem(this.state.getSelectedComponent());
                }
                this.state.loadTableModel();
                this.setupTable(this.state.getComponentTableModel());
                this.dataMinerTablePanel.trySearch();
                if (!this._reload) {
                    this.dataMinerTablePanel.getTable().setSortColumn(0, true);
                }
                if (null != (serializable = this.state.getSelectedPrior())) {
                    this.jPriorValue.setText(this.getFormatedDoubleValue((Double)serializable));
                } else {
                    this.jPriorValue.setText("");
                }
                this.setTotalNumberComponents();
                this.enableControls(true);
                if (this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                    int n = this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                    this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
                }
                if (null == (nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel()) || nArray.length == 0) {
                    ClusterComponentDataTableModel clusterComponentDataTableModel = new ClusterComponentDataTableModel();
                    this.state.setClusterComponentDataTableModel(clusterComponentDataTableModel);
                    this.jTabPane.reset();
                } else {
                    this.jTabPane.showFrequency();
                }
                this.setLoaded(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), (String)ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"), null);
        }
        finally {
            this.setLoading(false);
        }
        this.hideOverlayPanel();
    }

    @Override
    public void reloadDataProcess() {
        try {
            this.state.reload();
            this._success = this.state.isLoaded();
        }
        catch (Exception exception) {
            this._success = false;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private String getEMModelNestedAttributeName() {
        String string = null;
        try {
            String string2 = this.getSelectedAttributeName();
            string = this.state.getEMModelNestedAttributeName(string2);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string;
    }

    static /* synthetic */ GraphPanel[] access$602(ClusterComponentViewerMainPanel clusterComponentViewerMainPanel, GraphPanel[] graphPanelArray) {
        clusterComponentViewerMainPanel.graphPanel = graphPanelArray;
        return graphPanelArray;
    }

    private class LoadProjectionPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        String attributeName = null;
        List<ClusterComponentProjectionItem> _projectionData = new ArrayList<ClusterComponentProjectionItem>();

        public LoadProjectionPanel(String string) {
            this.attributeName = string;
        }

        protected Object doInBackground() throws Exception {
            try {
                String string = ClusterComponentViewerMainPanel.this.getSelectedAttributeName();
                if (this.attributeName != null) {
                    this._projectionData = ClusterComponentViewerMainPanel.this.state.getModelDetailsProjDetails(this.attributeName, string);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return ClusterComponentViewerMainPanel.this.state;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                ClusterComponentViewerMainPanel.this.state.loadProjectionData(this._projectionData);
            } else {
                ClusterComponentViewerMainPanel.this.state.loadProjectionErrorStatus();
            }
            ClusterComponentViewerMainPanel.this.jTabPane.updateProjections();
        }
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GraphDataModel[] localGraphModel = null;
        int[] _selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            this._selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        protected Object doInBackground() throws Exception {
            try {
                ClusterComponentTableModel clusterComponentTableModel = (ClusterComponentTableModel)((Object)ClusterComponentViewerMainPanel.this.dataMinerTablePanel.getTable().getModel());
                Vector<ClusterComponentModelRow> vector = clusterComponentTableModel.getDataVector();
                for (int i = 0; i < this._selectedRowsInModel.length; ++i) {
                    ClusterComponentModelRow clusterComponentModelRow = vector.get(this._selectedRowsInModel[i]);
                    this.localGraphModel[i] = ClusterComponentViewerMainPanel.this.state.createGraphDataModelForAttribute(clusterComponentModelRow);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return ClusterComponentViewerMainPanel.this.state;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                int n = this._selectedRowsInModel.length;
                ClusterComponentViewerMainPanel.access$602(ClusterComponentViewerMainPanel.this, new GraphPanel[n]);
                for (int i = 0; i < n; ++i) {
                    ((ClusterComponentViewerMainPanel)ClusterComponentViewerMainPanel.this).graphPanel[i] = new GraphPanel(this.localGraphModel[i]);
                    this.localGraphModel[i].setDepthRadius(ClusterComponentViewerMainPanel.this.state.getDepthRadius());
                    boolean bl = false;
                    if (n == 1) {
                        bl = true;
                        this.localGraphModel[i].setLegendSeriesCount(2);
                    }
                    this.localGraphModel[i].setLegendVisible(bl);
                    ClusterComponentViewerMainPanel.this.graphPanel[i].initGraph();
                    this.localGraphModel[i].setStyleSelection(ClusterComponentViewerMainPanel.this.state.getStyleSelection());
                    ClusterComponentViewerMainPanel.this.graphPanel[i].updateGraphStyle();
                }
                ClusterComponentViewerMainPanel.this.jTabPane.layoutCharts(n, ClusterComponentViewerMainPanel.this.graphPanel);
            }
        }
    }
}

