/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.component;

import java.awt.Color;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.GraphModelProvider;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentDataTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionsTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentTableModel;
import oracle.dmt.dataminer.mviewer.clustering.component.ComponentLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class ClusterComponentViewerState
extends BaseViewerState
implements GraphModelProvider {
    private ClusteringEM _modelEMClustering;
    private String _modelName;
    private String _userName;
    private boolean _loaded;
    private ClusteringFilterSetting _filterSetting;
    private Map<Integer, List<ClusterComponentModelRow>> _allComponentData = new HashMap<Integer, List<ClusterComponentModelRow>>();
    private Vector<Integer> _componentList = new Vector();
    private Map<String, String> modelProjectionsMap;
    private ClusterComponentTableModel _tableComponentModel;
    private Integer _selectedComponent;
    private int _totalComponents = 0;
    private String _attributeNameFilter;
    private ClusterComponentProjectionsTableModel _tableProjectionModel;
    private ClusterComponentDataTableModel _tableDataModel;
    private int _depthRadius = 0;
    public static final Color _BASE_CHART_COLOR = new Color(255, 255, 153);
    private String _styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private final int _initial_fetchsize = 2000;
    private final int _NUMERIC_NUMBER_OF_POINTS = 20;

    public ClusterComponentViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this._tableComponentModel = new ClusterComponentTableModel();
        this._tableProjectionModel = new ClusterComponentProjectionsTableModel();
        this._tableDataModel = new ClusterComponentDataTableModel();
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "em_model_view_component";
        return new HelpInfo(string);
    }

    public int getInitialFetchSize() {
        return 2000;
    }

    public Double getSelectedPrior() {
        ClusterComponentModelRow clusterComponentModelRow;
        if (this._selectedComponent == null) {
            return null;
        }
        Double d = null;
        List<ClusterComponentModelRow> list = this._allComponentData.get(this._selectedComponent);
        if (list == null) {
            return null;
        }
        Iterator<ClusterComponentModelRow> iterator = list.iterator();
        while (iterator.hasNext() && (d = (clusterComponentModelRow = iterator.next()).getPriorValue()) == null) {
        }
        return d;
    }

    public List<NameValuePair> getSelectedFrequency(String string) {
        if (this._selectedComponent == null) {
            return null;
        }
        List<NameValuePair> list = null;
        List<ClusterComponentModelRow> list2 = this._allComponentData.get(this._selectedComponent);
        for (ClusterComponentModelRow clusterComponentModelRow : list2) {
            if (!clusterComponentModelRow.getAttributeName().equals(string)) continue;
            list = clusterComponentModelRow.getFrequencyValues();
            break;
        }
        return list;
    }

    @Override
    public GraphDataModel getGraphDataModel(int n) {
        if (this._tableComponentModel == null) {
            return null;
        }
        Vector<ClusterComponentModelRow> vector = this._tableComponentModel.getDataVector();
        ClusterComponentModelRow clusterComponentModelRow = vector.get(n);
        GraphDataModel graphDataModel = clusterComponentModelRow.getGraphDataModel();
        return graphDataModel;
    }

    @Override
    public String getStyleSelection() {
        return this._styleSelection;
    }

    public GenericBaseTableModel getComponentTableModel() {
        return this._tableComponentModel;
    }

    public GenericBaseTableModel getProjectionTableModel() {
        return this._tableProjectionModel;
    }

    public void setSelectedComponent(Integer n) {
        this._selectedComponent = n;
    }

    public Integer getSelectedComponent() {
        return this._selectedComponent;
    }

    public void setTotalComponents(Integer n) {
        this._totalComponents = n;
    }

    public int getTotalComponents() {
        return this._totalComponents;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterComponentViewerState load() throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load(null);
        this._modelEMClustering = new ClusteringEM(this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        Connection connection = null;
        try {
            this._loaded = false;
            connection = Connections.getUniqueConnection(this._context);
            this.loadData(connection, true);
            this._loaded = true;
        }
        catch (Throwable throwable) {
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterComponentViewerState reload() throws Exception {
        Connection connection = null;
        try {
            this._loaded = false;
            connection = Connections.getUniqueConnection(this._context);
            this.loadData(connection, false);
            this._loaded = true;
        }
        catch (Throwable throwable) {
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
        return this;
    }

    public void loadStatus() {
        this._tableComponentModel.loadStatus();
    }

    public void loadProjectionStatus() {
        this._tableProjectionModel.loadStatus();
    }

    private void loadData(Connection connection, boolean bl) throws Exception {
        if (bl) {
            this._filterSetting = new ClusteringFilterSetting();
            this._filterSetting.setFetchSize(2000);
        }
        if (!this._allComponentData.isEmpty()) {
            this._allComponentData.clear();
        }
        Vector<Integer> vector = new Vector<Integer>();
        ClusteringEM.getModelDetailsComp(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName(), this._filterSetting.getFetchSize(), this.getAttributeNameFilter(), this._allComponentData, vector, this._selectedComponent);
        if (this._componentList.isEmpty()) {
            this._componentList.addAll(vector);
        }
        if (this._selectedComponent == null && !this._componentList.isEmpty()) {
            this._selectedComponent = this._componentList.get(0);
        }
        this.setTotalComponents(this._componentList.size());
        this.modelProjectionsMap = ClusteringEM.getEMModelProjectionFeatureNameMap(connection, this._userName, this._modelName, this._filterSetting.getFetchSize());
    }

    public void loadTableModel() throws Exception {
        List<ClusterComponentModelRow> list = this._allComponentData.get(this._selectedComponent);
        if (list == null) {
            list = new ArrayList<ClusterComponentModelRow>();
        }
        this._tableComponentModel.loadData(list);
        this.createAllGraphDataModelsTotalPopulation();
    }

    public void loadProjectionData(List<ClusterComponentProjectionItem> list) {
        this._tableProjectionModel.loadData(list);
    }

    public void loadProjectionErrorStatus() {
        this._tableProjectionModel.loadErrorStatus();
    }

    public GenericBaseTableModel getFilteredStatistics(String string, int n) throws Exception {
        return this._tableComponentModel.getFilteredStatistics(string, n);
    }

    public void setFilterSetting(ClusteringFilterSetting clusteringFilterSetting) {
        this._filterSetting = clusteringFilterSetting;
    }

    public ClusteringFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public Vector<Integer> getComponentList() {
        return this._componentList;
    }

    private void createAllGraphDataModelsTotalPopulation() throws Exception {
        Vector<ClusterComponentModelRow> vector = this._tableComponentModel.getDataVector();
        for (ClusterComponentModelRow clusterComponentModelRow : vector) {
            GraphDataModel graphDataModel = this.createGraphDataModelComponent(clusterComponentModelRow, false);
            graphDataModel.setTitle(null);
            graphDataModel.setLegendVisible(false);
            graphDataModel.setDepthRadius(0);
            graphDataModel.setLineDataLineDisplayed(false);
            clusterComponentModelRow.setGraphDataModel(graphDataModel);
        }
    }

    public GraphDataModel createGraphDataModelForAttribute(ClusterComponentModelRow clusterComponentModelRow) throws Exception {
        return this.createGraphDataModelComponent(clusterComponentModelRow, true);
    }

    private GraphDataModel createGraphDataModelComponent(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        List<NameValuePair> list = clusterComponentModelRow.getFrequencyValues();
        Double d = clusterComponentModelRow.getMeanValue();
        Double d2 = clusterComponentModelRow.getCovarianceValue();
        GraphDataModel graphDataModel = null;
        graphDataModel = (list == null || list.isEmpty()) && d != null && d2 != null ? this.createGraphDataModelComponentNumeric(clusterComponentModelRow, bl) : (list != null && !list.isEmpty() && d == null && d2 == null ? this.createGraphDataModelComponentCategoric(clusterComponentModelRow, bl) : new DefaultGraphDataModel(null, 20, null, null, null));
        return graphDataModel;
    }

    private GraphDataModel createGraphDataModelComponentCategoric(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 20, null, null, null);
        List<NameValuePair> list = clusterComponentModelRow.getFrequencyValues();
        int n = list.size();
        Object[][] objectArray = new Object[n][1];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ComponentLrb.get("CLUSTER_COMPONENT_SERIES")};
        for (int i = 0; i < n; ++i) {
            NameValuePair nameValuePair = list.get(i);
            String string = nameValuePair.getName();
            Double d = (Double)nameValuePair.getValue();
            objectArray[i][0] = (double)d;
            objectArray2[i] = string;
        }
        defaultGraphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        defaultGraphDataModel.setTitle(clusterComponentModelRow.getAttributeName());
        return defaultGraphDataModel;
    }

    private GraphDataModel createGraphDataModelComponentNumeric(ClusterComponentModelRow clusterComponentModelRow, boolean bl) throws Exception {
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 31, null, null, null);
        Double d = clusterComponentModelRow.getMeanValue();
        Double d2 = clusterComponentModelRow.getCovarianceValue();
        int n = 20;
        Double d3 = d / 2.0;
        Double d4 = d / 20.0;
        Object[][] objectArray = new Object[n][1];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ComponentLrb.get("CLUSTER_COMPONENT_SERIES")};
        for (int i = 0; i < n; ++i) {
            Double d5 = d3 + d4 * (double)i;
            String string = String.valueOf(d5);
            Double d6 = this.getGaussionValue(d5, d, d2);
            objectArray[i][0] = (double)d6;
            objectArray2[i] = string;
        }
        defaultGraphDataModel.addRowColors(new Color[]{_BASE_CHART_COLOR});
        defaultGraphDataModel.addColumnLabels(objectArray2);
        defaultGraphDataModel.addRowLabels(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        if (bl) {
            defaultGraphDataModel.setDepthRadius(this._depthRadius);
        }
        defaultGraphDataModel.setLineDataLineDisplayed(false);
        defaultGraphDataModel.setTitle(clusterComponentModelRow.getAttributeName());
        return defaultGraphDataModel;
    }

    public double getGaussionValue(double d, double d2, double d3) {
        double d4 = Math.exp(-((d - d2) * (d - d2) / (2.0 * d3)));
        double d5 = 1.0 / Math.sqrt(Math.PI * 2 * d3) * d4;
        return d5;
    }

    public int getDepthRadius() {
        return this._depthRadius;
    }

    public void setAttributeNameFilter(String string) {
        this._attributeNameFilter = string;
    }

    public String getAttributeNameFilter() {
        return this._attributeNameFilter;
    }

    public String getEMModelNestedAttributeName(String string) {
        String string2 = null;
        if (this.modelProjectionsMap != null) {
            string2 = this.modelProjectionsMap.get(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClusterComponentProjectionItem> getModelDetailsProjDetails(String string, String string2) throws Exception {
        Connection connection = null;
        ArrayList<ClusterComponentProjectionItem> arrayList = new ArrayList();
        try {
            connection = Connections.getUniqueConnection(this._context);
            arrayList = ClusteringEM.getModelDetailsProjDetails(connection, this._userName, this._modelName, string, string2);
        }
        finally {
            SQLHelper.close(connection);
        }
        return arrayList;
    }

    public ClusterComponentDataTableModel getTableDataModel() {
        return this._tableDataModel;
    }

    public void setClusterComponentDataTableModel(ClusterComponentDataTableModel clusterComponentDataTableModel) {
        this._tableDataModel = clusterComponentDataTableModel;
    }

    public void loadFrequencyTable(String string) {
        List<NameValuePair> list = this.getSelectedFrequency(string);
        this._tableDataModel.loadData(list);
    }
}

