/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.details;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.clustering.details.DetailsLrb;
import oracle.dmt.dataminer.mviewer.clustering.details.DetailsViewerState;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class DetailsViewer
extends DataMinerViewGUI {
    private DetailsViewerState _state;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel attributesTablePanel;

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState) {
        super(editor, context);
        this._context = context;
        this._state = detailsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public DetailsViewer(Editor editor, Context context, DetailsViewerState detailsViewerState, BlockingComponent blockingComponent) {
        super(editor, context);
        this.overLayPanel = blockingComponent;
        this._context = context;
        this._state = detailsViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void initComponents() {
        this.attributesTablePanel = new DataMinerTablePanel();
        this.attributesTablePanel.setModelExample(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributesTablePanel, -1, 400, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attributesTablePanel, -1, 298, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        DataMinerTable dataMinerTable = this.attributesTablePanel.getTable();
        dataMinerTable.setTooltipEnable(true);
        dataMinerTable.setAutoResizeMode(4);
        this.attributesTablePanel.setup((TableModel)((Object)this._state.getTableModel()), DetailsLrb.get("DETAILS_VIEWER_GRID_TITLE"), 0);
        dataMinerTable.setSortColumn(0, true);
        this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_DATA_MESSAGE"));
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                DetailsViewer.this._state.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return DetailsViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    DetailsViewer.this._state.loadTableModel();
                    DetailsViewer.this.setLoaded(true);
                } else {
                    DetailsViewer.this._state.loadStatus(DetailsLrb.get("DETAILS_LOADING_ERROR"));
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), (String)DetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"), (String)DetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DetailsLrb.get("DETAILS_VIEWER_FAILURE_TITLE"), (String)DetailsLrb.get("DETAILS_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                DetailsViewer.this.setLoading(false);
                if (DetailsViewer.this.overLayPanel != null) {
                    DetailsViewer.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
            }
        }
    }
}

