/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.publish.PublishPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditor;
import oracle.dmt.dataminer.mviewer.clustering.tree.RenameClusterDialog;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class ClusteringTreeContextMenu
implements ContextMenuListener,
Controller {
    private static volatile ClusteringTreeContextMenu _instance = null;
    private static final int RENAME_NODE_ACTION_ID = Ide.createCmdID((String)"RenameNodeAction");
    private static final int PRIMARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeAction");
    private static final int SECONDARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionSecondary");
    private static final int TERTIARY_EDIT_ACTION_ID = Ide.createCmdID((String)"EditNodeActionTertiary");
    private static final int COPY_IMAGE_ID = Ide.createCmdID((String)"copyImage");
    private static final int SAVE_IMAGE_ID = Ide.createCmdID((String)"saveImage");

    public static synchronized ClusteringTreeContextMenu getInstance() {
        if (_instance == null) {
            _instance = new ClusteringTreeContextMenu();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void menuWillShow(ContextMenu contextMenu) {
        contextMenu.removeAll();
        Context context = contextMenu.getContext();
        View view = context.getView();
        ArrayList<ClusTreeNode> arrayList = new ArrayList<ClusTreeNode>();
        if (!(view instanceof ClusteringTreeEditor)) return;
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        Object object = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (object == null) return;
        Enumeration enumeration = object.getSelectedObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ClusTreeNode)) continue;
            arrayList.add((ClusTreeNode)e);
        }
        ilvManagerView = IdeAction.get((int)COPY_IMAGE_ID);
        object = contextMenu.createMenuItem((ToggleAction)ilvManagerView, 1.0f);
        ((AbstractButton)object).setText(WorkflowEditorLrb.get("CONTEXT_MENU_COPY_IMAGE"));
        ilvManagerView.addController((Controller)this);
        contextMenu.add((Component)object);
        enumeration = IdeAction.get((int)SAVE_IMAGE_ID);
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)enumeration, 1.0f);
        jMenuItem.setText(WorkflowEditorLrb.get("CONTEXT_MENU_SAVE_IMAGE"));
        enumeration.addController(this);
        contextMenu.add((Component)jMenuItem);
        if (arrayList.size() == 0) {
            return;
        }
        int n = arrayList.size();
        IdeAction ideAction = IdeAction.get((int)PRIMARY_EDIT_ACTION_ID);
        ideAction.addController((Controller)this);
        if (n != 1) return;
        IdeAction ideAction2 = IdeAction.get((int)RENAME_NODE_ACTION_ID);
        JMenuItem jMenuItem2 = contextMenu.createMenuItem((ToggleAction)ideAction2, 1.0f);
        jMenuItem2.setText(WorkflowEditorLrb.get("CONTEXT_MENU_RENAME_NODE"));
        ideAction2.addController((Controller)this);
        contextMenu.add((Component)jMenuItem2, MenuConstants.SECTION_DYNAMIC_CTXT_MENU, true);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        try {
            ClusteringTreeContextMenu.handlePrimaryEdit(context, (ClusteringTreeEditor)context.getView());
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        return true;
    }

    public static void handlePrimaryEdit(Context context, ClusteringTreeEditor clusteringTreeEditor) throws Exception {
        ClusteringTreeContextMenu.handleRename(context, clusteringTreeEditor);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof ClusteringTreeEditor)) {
            return false;
        }
        if (ideAction.getCommandId() == COPY_IMAGE_ID) {
            DataMinerDiagramEditor.CopyEditorToClipboard(((DiagramView)view).getActiveManagerView());
            return true;
        }
        if (ideAction.getCommandId() == SAVE_IMAGE_ID) {
            DiagramContext diagramContext = DiagramContext.getDiagramContext((IlvManagerView)((DiagramView)view).getActiveManagerView());
            PublishPlugin publishPlugin = (PublishPlugin)diagramContext.getPlugin(PublishPlugin.class);
            publishPlugin.publish();
            return true;
        }
        ClusteringTreeEditor clusteringTreeEditor = (ClusteringTreeEditor)view;
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            try {
                ClusteringTreeContextMenu.handlePrimaryEdit(context, clusteringTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        if (ideAction.getCommandId() == RENAME_NODE_ACTION_ID) {
            try {
                ClusteringTreeContextMenu.handleRename(context, clusteringTreeEditor);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
            return true;
        }
        return false;
    }

    private static void handleRename(Context context, ClusteringTreeEditor clusteringTreeEditor) throws Exception {
        ClusTreeNode clusTreeNode = clusteringTreeEditor.getSelectedDiagramNode();
        RenameClusterDialog renameClusterDialog = new RenameClusterDialog(context, clusTreeNode);
        boolean bl = renameClusterDialog.invoke(context, clusTreeNode);
        if (bl) {
            clusteringTreeEditor.refreshLayout(clusTreeNode);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        View view = context.getView();
        if (!(view instanceof ClusteringTreeEditor)) {
            return false;
        }
        ArrayList<ClusTreeNode> arrayList = new ArrayList<ClusTreeNode>();
        IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ClusTreeNode)) continue;
                arrayList.add((ClusTreeNode)e);
            }
        } else {
            return true;
        }
        if (arrayList.size() == 0) {
            return true;
        }
        if (ideAction.getCommandId() == PRIMARY_EDIT_ACTION_ID || ideAction.equals(IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES))) {
            ideAction.setEnabled(true);
            return true;
        }
        if (ideAction.getCommandId() == SECONDARY_EDIT_ACTION_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        if (ideAction.getCommandId() == TERTIARY_EDIT_ACTION_ID) {
            ideAction.setEnabled(false);
            return true;
        }
        return true;
    }
}

