/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.tree.IlvTreeLayout;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import ilog.views.sdm.model.IlvSDMNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.readonly.DefaultDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.DiagramReadOnlyPlugin;
import oracle.diagram.framework.toolbar.DefaultDiagramToolbarPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.exception.InvalidNodeTypeException;
import oracle.dmt.dataminer.mviewer.ModelViewerLrb;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.TreeRulesPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusTreeRule;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringQuerySettingsDialog;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeContextMenu;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeDiagram;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.NodeDetailPane;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.modelnodes.ClusteringModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.DelayedLoadInterface;
import oracle.dmt.dataminer.utils.DelayedProcessWorker;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;

public class ClusteringTreeEditor
extends DataMinerDiagramEditor
implements DelayedLoadInterface {
    private static final Logger LOGGER = Logger.getLogger(ClusteringTreeEditor.class.getName());
    private int _treeFlowDirection;
    private int _maxAttributeLength;
    private int _maxValueLength;
    private NumberFormat percentFormat;
    private Integer detailTabIndex = null;
    private int topNAttributes;
    private ClusteringModelNode clustNode;
    private DelayedProcessWorker worker;
    private BlockingComponent overLayPanel = null;
    private TreeViewerToolbarPlugin tvtp;
    private JSplitPane splitComponent;
    private JScrollPane detailView;
    private JEditorPane textEditorPane;
    private static final int DOLAYOUT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doLayout");
    private static final int TOGGLE_DETAIL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.toggleDetailedHeader");
    private static final int EXPAND_ALL_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.expandAllNodes");
    private static final int MAX_VISIBLE_ATTRIBUTES = 10;
    private static final int MIN_VISIBLE_ATTRIBUTES = 1;
    private static final int DEFAULT_SELECTED_ATTRIBUTES = 4;

    public ClusteringTreeEditor() {
        super((Diagram)new ClusteringTreeDiagram());
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
        this._treeFlowDirection = !clusteringTreePreferencesSettings.isHorizontalLayout() ? 8 : 2;
        this._maxAttributeLength = clusteringTreePreferencesSettings.getMaxAttributeDisplayLength();
        this._maxValueLength = clusteringTreePreferencesSettings.getMaxValueDisplayLength();
        this.setPreferredLayoutBaseName("Tree");
        Preferences preferences = Preferences.getPreferences();
        ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)preferences);
        this.percentFormat = NumericFormat.getInstance(true, modelViewerPreferenceSettings.getPercentagePrecisionLevel(), modelViewerPreferenceSettings.getPercentagePrecisionLevel(), 1);
        this.worker = new DelayedProcessWorker(this);
        this.worker.execute();
    }

    public NumberFormat getNumberFormat() {
        return this.percentFormat;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("cluster_tree_diagram_editor");
    }

    @Override
    public ContextMenuListener getContextMenuListener() {
        return ClusteringTreeContextMenu.getInstance();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.reload();
    }

    protected void installEditorPlugins(Diagram diagram) {
        super.installEditorPlugins(diagram);
        DiagramContext diagramContext = diagram.getDiagramContext();
        diagramContext.addPlugin(DiagramMainMenuPlugin.class, (Plugin)DefaultDiagramMainMenuPlugin.getInstance());
        diagramContext.addPlugin(DiagramReadOnlyPlugin.class, (Plugin)new OdmrReadOnlyPlugin(diagramContext));
        this.tvtp = new TreeViewerToolbarPlugin(diagramContext);
        diagramContext.addPlugin(ToolbarPlugin.class, (Plugin)this.tvtp);
        diagramContext.addPlugin(SelectionChangeNotificationPlugin.class, (Plugin)new SelectionChangePlugin());
    }

    public void initializeLayout(Layout layout) {
        super.initializeLayout(layout);
        layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
    }

    @Override
    public void openImpl(boolean bl) throws OpenAbortedException {
        super.openImpl(bl);
        if (!bl) {
            return;
        }
    }

    @Override
    public void loadDataProcess() {
        this.clustNode = (ClusteringModelNode)this.getContext().getNode();
        this.clustNode.ensureOpen();
    }

    @Override
    public void loadGUIProcess() {
        try {
            IlvSDMEngine ilvSDMEngine = this.clustNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            final ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)this.clustNode.getFilteredModel(sDMUndoFilter);
            ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
            clusterTreeSDMModel.setHeaderDetailVisible(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
            ModelViewerPreferenceSettings modelViewerPreferenceSettings = ModelViewerPreferenceSettings.getInstance();
            clusteringTreePreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (changeInfo.getPropertyName().equals("treeNodeAttributeMaxLength")) {
                            ClusteringTreeEditor.this._maxAttributeLength = changeInfo.getNewValueAsInt();
                            bl = true;
                            continue;
                        }
                        if (!changeInfo.getPropertyName().equals("treeNodeAttributeMaxValLength")) continue;
                        ClusteringTreeEditor.this._maxValueLength = changeInfo.getNewValueAsInt();
                        bl = true;
                    }
                    if (bl) {
                        clusterTreeSDMModel.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            modelViewerPreferenceSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                    ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                    boolean bl = false;
                    for (int i = 0; i < changeInfoArray.length; ++i) {
                        ChangeInfo changeInfo = changeInfoArray[i];
                        if (!changeInfo.getPropertyName().equals("percentage_precision_level")) continue;
                        ClusteringTreeEditor.this.percentFormat = NumericFormat.getInstance(true, changeInfo.getNewValueAsInt(), changeInfo.getNewValueAsInt(), 1);
                        bl = true;
                    }
                    if (bl) {
                        clusterTreeSDMModel.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                    }
                }
            });
            if (this.clustNode != null) {
                this.clustNode.setModelExists(true);
                this.loadTreeModel(this.clustNode, clusterTreeSDMModel);
                ilvSDMEngine.setModel((IlvSDMModel)sDMUndoFilter);
                this.doLayout(this._treeFlowDirection, true);
                this.tvtp.initTopItemsCombo(clusterTreeSDMModel);
            }
            this.setPropertyChangeListener(ilvSDMEngine, clusterTreeSDMModel);
        }
        catch (Exception exception) {
            if (exception instanceof OpenAbortedException) {
                throw (OpenAbortedException)exception;
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelViewerLrb.get("FAILED_ERROR_TITLE"), (String)ModelViewerLrb.get("FAILED_OPEN"), null);
            this.abortOpen((Node)this.clustNode);
        }
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }

    private IlvSDMEngine getEngine() throws IOException {
        ClusteringModelNode clusteringModelNode = this.getContextNode();
        return clusteringModelNode.getEngine();
    }

    private void reload() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        }
        this.worker = new DelayedProcessWorker(this);
        this.worker.setReloadData(true);
        this.worker.execute();
    }

    @Override
    public void reloadDataProcess() {
        ClusteringModelNode clusteringModelNode = this.getContextNode();
        clusteringModelNode.setTopNAttributes(this.topNAttributes);
        clusteringModelNode.load();
    }

    private void setPropertyChangeListener(IlvSDMEngine ilvSDMEngine, ClusterTreeSDMModel clusterTreeSDMModel) {
        Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
        while (enumeration.hasMoreElements()) {
            IlvSDMNode ilvSDMNode = enumeration.nextElement();
            if (!(ilvSDMNode instanceof ClusTreeNode)) continue;
            ClusTreeNode clusTreeNode = (ClusTreeNode)ilvSDMNode;
            clusTreeNode.assignPropertyChangeListener(ilvSDMEngine);
        }
        clusterTreeSDMModel.addSDMPropertyChangeListener(new ModelListener());
    }

    public int getMaxAttributeLength() {
        return this._maxAttributeLength;
    }

    public int getMaxValueLength() {
        return this._maxValueLength;
    }

    public void setDetailTabIndex(int n) {
        this.detailTabIndex = n;
    }

    public Integer getDetailTabIndex() {
        return this.detailTabIndex;
    }

    public void refreshLayout(ClusTreeNode clusTreeNode) {
        this.doLayout(this._treeFlowDirection, false);
        try {
            this.getEngine().setSelected((Object)clusTreeNode, true);
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)iOException, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLayout(int n, boolean bl) {
        IlvSDMEngine ilvSDMEngine;
        ClusTreeNode clusTreeNode = null;
        try {
            ilvSDMEngine = this.getEngine();
            clusTreeNode = this.getSelectedDiagramNode();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            return;
        }
        IlvTreeLayout ilvTreeLayout = new IlvTreeLayout();
        IlvGrapher ilvGrapher = ilvSDMEngine.getGrapher();
        ilvTreeLayout.attach(ilvGrapher);
        ilvTreeLayout.setFlowDirection(n);
        ilvTreeLayout.setGlobalLinkStyle(2);
        try {
            ilvTreeLayout.performLayout();
            if (clusTreeNode != null) {
                ilvSDMEngine.setSelected((Object)clusTreeNode, true);
            }
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            LOGGER.log(Level.FINEST, ilvGraphLayoutException.getMessage());
        }
        finally {
            IlvManagerView ilvManagerView;
            if (bl && (ilvManagerView = this.getDiagram().getDiagramContext().getManagerView()) != null) {
                ilvManagerView.fitTransformerToContent();
            }
        }
        ilvTreeLayout.detach();
    }

    public void expandAllNodes() {
        try {
            ClusteringModelNode clusteringModelNode = this.getContextNode();
            IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
            SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
            ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
            Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
            if (enumeration == null) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                IlvSDMNode ilvSDMNode = enumeration.nextElement();
                if (!(ilvSDMNode instanceof ClusTreeNode)) continue;
                sDMUndoFilter.setObjectProperty((Object)ilvSDMNode, "expanded", (Object)1);
            }
        }
        catch (IOException iOException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)iOException, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    @Override
    public void closeImpl(boolean bl) {
        super.closeImpl(bl);
    }

    private void loadTreeModel(ClusteringModelNode clusteringModelNode, ClusterTreeSDMModel clusterTreeSDMModel) throws Exception {
        if (clusteringModelNode.isModelExists().booleanValue()) {
            clusterTreeSDMModel.load(clusteringModelNode.getClusterRowDetails(), this.getContext());
            clusteringModelNode.setReadOnly(true);
        }
    }

    public ClusTreeNode getSelectedDiagramNode() throws Exception {
        List<ClusTreeNode> list = this.getSelectedDiagramNodes();
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<ClusTreeNode> getSelectedDiagramNodes() throws Exception {
        ArrayList<ClusTreeNode> arrayList = new ArrayList<ClusTreeNode>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ClusTreeNode)) continue;
                arrayList.add((ClusTreeNode)e);
            }
        }
        return arrayList;
    }

    public ClusTreeLink getSelectedDiagramLink() throws IOException {
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return null;
        }
        IlvManager ilvManager = ilvManagerView.getManager();
        ClusteringModelNode clusteringModelNode = this.getContextNode();
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getSelectedObjects();
        if (ilvManager.getSelectedObjectsCount() > 1 || ilvManager.getSelectedObjectsCount() == 0) {
            return null;
        }
        IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
        Object object = ilvSDMEngine.getObject(ilvGraphic);
        if (object instanceof ClusTreeLink) {
            return (ClusTreeLink)((Object)object);
        }
        return null;
    }

    public List<ClusTreeLink> getSelectedDiagramLinks() throws Exception {
        ArrayList<ClusTreeLink> arrayList = new ArrayList<ClusTreeLink>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof ClusTreeLink)) continue;
                arrayList.add((ClusTreeLink)((Object)e));
            }
        }
        return arrayList;
    }

    public List<Object> getSelectedDiagramObjects() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Diagram diagram = this.getDiagram();
        DiagramContext diagramContext = diagram.getDiagramContext();
        IlvManagerView ilvManagerView = diagramContext.getManagerView();
        if (ilvManagerView == null) {
            return arrayList;
        }
        IlvSDMEngine ilvSDMEngine = SDMDiagramContextUtil.getSDMEngine((IlvManagerView)ilvManagerView);
        if (ilvSDMEngine != null) {
            Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    @Override
    public void closeEditor() {
        ClusteringTreeEditor clusteringTreeEditor = this;
        SwingUtilities.invokeLater(new Runnable((Editor)clusteringTreeEditor){
            final /* synthetic */ Editor val$thisEditor;
            {
                this.val$thisEditor = editor;
            }

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                editorManager.closeEditors(Collections.singletonList(this.val$thisEditor));
            }
        });
    }

    public Component createGUI() {
        this.detailView = new JScrollPane();
        this.detailView.setLayout(new ScrollPaneLayout());
        this.textEditorPane = new JEditorPane();
        this.textEditorPane.setEditable(false);
        this.textEditorPane.setContentType("text/html");
        this.detailView.getViewport().add(this.textEditorPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        ToolbarPlugin toolbarPlugin = (ToolbarPlugin)this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (toolbarPlugin != null) {
            Toolbar toolbar = toolbarPlugin.getToolbar();
            if (toolbar == null) {
                toolbarPlugin.createToolbar((View)this);
                toolbar = toolbarPlugin.getToolbar();
            }
            jPanel.add((Component)toolbar, "North");
        }
        jPanel.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
        this.splitComponent = new JSplitPane(0, jPanel, this.detailView);
        this.splitComponent.setDividerLocation(0.8);
        this.splitComponent.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusteringTreeEditor.this.splitComponent.setDividerLocation(0.8);
                ClusteringTreeEditor.this.splitComponent.setResizeWeight(0.8);
            }
        });
        if (this.overLayPanel == null) {
            this.overLayPanel = new BlockingComponent((JComponent)jPanel);
            this.splitComponent.setLeftComponent(this.overLayPanel.getBlockingComponent());
            this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
        }
        return this.splitComponent;
    }

    public Component getDetailView() {
        return this.splitComponent.getBottomComponent();
    }

    public Component getHorizontalScrollBar() {
        return null;
    }

    public Component getVerticalScrollBar() {
        return null;
    }

    @Override
    public void update(Object object, UpdateMessage updateMessage) {
        super.update(object, updateMessage);
    }

    private ClusterTreeSDMModel getModel(ClusteringModelNode clusteringModelNode) throws Exception {
        IlvSDMEngine ilvSDMEngine = clusteringModelNode.getEngine();
        SDMUndoFilter sDMUndoFilter = (SDMUndoFilter)ilvSDMEngine.getModel();
        ClusterTreeSDMModel clusterTreeSDMModel = (ClusterTreeSDMModel)clusteringModelNode.getFilteredModel(sDMUndoFilter);
        return clusterTreeSDMModel;
    }

    private ClusteringModelNode getContextNode() {
        Node node = this.getContext().getNode();
        if (node instanceof ClusteringModelNode) {
            return (ClusteringModelNode)node;
        }
        throw new InvalidNodeTypeException(node, ClusteringModelNode.class);
    }

    public class TreeViewerToolbarPlugin
    extends DefaultDiagramToolbarPlugin {
        private IdeAction _doFitToWindow;
        private IdeAction _toggleHeaderAction;
        private IdeAction _expandAllAction;
        private JComboBox comboMaxTargetValues;

        public TreeViewerToolbarPlugin(DiagramContext diagramContext) {
            super(diagramContext);
            this._doFitToWindow = IdeAction.get((int)DOLAYOUT_CMDID);
            this._toggleHeaderAction = IdeAction.get((int)TOGGLE_DETAIL_CMDID);
            this._expandAllAction = IdeAction.get((int)EXPAND_ALL_CMDID);
            this.comboMaxTargetValues = new JComboBox();
        }

        public void update(Context context) {
            super.update(context);
            if (this._doFitToWindow != null) {
                this._doFitToWindow.updateAction(context);
            }
        }

        protected Toolbar createToolbarImpl(View view) {
            ClusterTreeSDMModel clusterTreeSDMModel;
            ClusteringModelNode clusteringModelNode;
            ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
            boolean bl = true;
            try {
                clusteringModelNode = ClusteringTreeEditor.this.getContextNode();
                clusterTreeSDMModel = ClusteringTreeEditor.this.getModel(clusteringModelNode);
                bl = clusteringModelNode.isStatsEnabled() && !clusteringModelNode.isModelEmpty();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            final ClusterTreeSDMModel clusterTreeSDMModel2 = clusterTreeSDMModel;
            final ClusteringModelNode clusteringModelNode2 = clusteringModelNode;
            Toolbar toolbar = super.createToolbarImpl(view);
            ToolButton toolButton = new ToolButton((Action)this._doFitToWindow);
            toolButton.setIcon((Icon)DataMinerIcons.get(Icons.RESET_LAYOUT));
            toolButton.setToolTipText(ModelViewerLrb.get("FIT_TO_WINDOW_TIP"));
            toolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            ToolButton toolButton2 = new ToolButton((Action)this._expandAllAction);
            toolButton2.setIcon((Icon)DataMinerIcons.get(Icons.EXPAND_ALL));
            toolButton2.setToolTipText(ModelViewerLrb.get("EXPAND_ALL_TIP"));
            toolButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringTreeEditor.this.expandAllNodes();
                }
            });
            this._toggleHeaderAction.setState(clusteringTreePreferencesSettings.isShowNodeDetailHeader());
            final ToggleToolButton toggleToolButton = new ToggleToolButton((ToggleAction)this._toggleHeaderAction);
            toggleToolButton.setIcon((Icon)DataMinerIcons.get(Icons.TOGGLE_DETAIL));
            toggleToolButton.setToolTipText(ClusteringTreeEditorLrb.get("HEADER_HIDE_DETAIL_TIP"));
            toggleToolButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                        clusterTreeSDMModel2.toggleHeaderDetailVisible();
                        toggleToolButton.setToolTipText(clusterTreeSDMModel2.isHeaderDetailVisible() != false ? ClusteringTreeEditorLrb.get("HEADER_HIDE_DETAIL_TIP") : ClusteringTreeEditorLrb.get("HEADER_SHOW_DETAIL_TIP"));
                        clusterTreeSDMModel2.fireDataChanged(null);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                        ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode2.getEngine(), clusterTreeSDMModel2);
                        clusteringModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final DropDownMenuButton dropDownMenuButton = new DropDownMenuButton();
            final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("HORIZONTAL_LAYOUT"));
            final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(ClusteringTreeEditorLrb.get("VERTICAL_LAYOUT"));
            buttonGroup.add(jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem2);
            jRadioButtonMenuItem2.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this._treeFlowDirection = 8;
                        dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            jRadioButtonMenuItem.setIcon(DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ClusteringTreeEditor.this._treeFlowDirection = 2;
                        dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            dropDownMenuButton.setToolTipText(ModelViewerLrb.get("LAYOUT_TIP"));
            jRadioButtonMenuItem2.setSelected(ClusteringTreeEditor.this._treeFlowDirection != 2);
            jRadioButtonMenuItem.setSelected(ClusteringTreeEditor.this._treeFlowDirection == 2);
            if (ClusteringTreeEditor.this._treeFlowDirection == 2) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_H));
            } else if (ClusteringTreeEditor.this._treeFlowDirection == 8) {
                dropDownMenuButton.setIcon((Icon)DataMinerIcons.get(Icons.TREE_DIAGRAM_V));
            }
            dropDownMenuButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem2);
                        dropDownMenuButton.addPopupItem((JMenuItem)jRadioButtonMenuItem);
                    } else if (itemEvent.getStateChange() == 2) {
                        dropDownMenuButton.removeAllPopupItems();
                    }
                }
            });
            JLabel jLabel = new JLabel(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES"));
            Dimension dimension = this.comboMaxTargetValues.getPreferredSize();
            this.comboMaxTargetValues.setMaximumSize(dimension);
            this.comboMaxTargetValues.setMinimumSize(dimension);
            this.initTopItemsCombo(clusterTreeSDMModel2);
            this.comboMaxTargetValues.setToolTipText(ClusteringTreeEditorLrb.get("MAX_DISPLAYED_ATTRIBUTES_TIP"));
            this.comboMaxTargetValues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                        Integer n = (Integer)jComboBox.getSelectedItem();
                        clusterTreeSDMModel2.setMaxTargetValuesDisplayed(n);
                        ClusteringTreeEditor.this.doLayout(ClusteringTreeEditor.this._treeFlowDirection, false);
                        ClusteringTreeEditor.this.setPropertyChangeListener(clusteringModelNode2.getEngine(), clusterTreeSDMModel2);
                        clusteringModelNode2.getEngine().setSelected(list.toArray(), true);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
                    }
                }
            });
            JButton jButton = new JButton(ClusteringTreeEditorLrb.get("SETTINGS"));
            jButton.setToolTipText(ClusteringTreeEditorLrb.get("SETTINGS_TIP"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ClusteringQuerySettingsDialog clusteringQuerySettingsDialog = new ClusteringQuerySettingsDialog((Frame)Ide.getMainWindow(), true);
                    clusteringQuerySettingsDialog.setTopNAttributes(ClusteringTreeEditor.this.topNAttributes);
                    clusteringQuerySettingsDialog.setVisible(true);
                    if (!clusteringQuerySettingsDialog.isCancelled()) {
                        ClusteringTreeEditor.this.topNAttributes = clusteringQuerySettingsDialog.getTopNAttributes();
                        ClusteringTreeEditor.this.reload();
                        TreeViewerToolbarPlugin.this.initTopItemsCombo(clusterTreeSDMModel2);
                        TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                    }
                }
            });
            JButton jButton2 = new JButton();
            jButton2.setToolTipText(ClusteringTreeEditorLrb.get("REFRESH_TIP"));
            jButton2.setIcon(OracleIcons.getIcon((String)"refresh.png"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n = TreeViewerToolbarPlugin.this.getSelectedNodeId();
                    ClusteringTreeEditor.this.reload();
                    TreeViewerToolbarPlugin.this.initTopItemsCombo(clusterTreeSDMModel2);
                    TreeViewerToolbarPlugin.this.setSelectedNodeUsingId(n, clusterTreeSDMModel2, clusteringModelNode2);
                }
            });
            toolbar.addSeparator();
            toolbar.add((Component)toolButton);
            toolbar.add((Component)dropDownMenuButton);
            toolbar.add((Component)toolButton2);
            toolbar.addSeparator();
            toolbar.addFiller();
            toolbar.add((Component)toggleToolButton);
            toolbar.addSeparator(new Dimension(10, 0));
            if (bl) {
                toolbar.add((Component)jLabel);
                toolbar.addFiller();
                toolbar.add((Component)this.comboMaxTargetValues);
                toolbar.addFiller();
            }
            toolbar.addSeparator();
            toolbar.add((Component)jButton2);
            if (bl) {
                toolbar.add((Component)jButton);
            }
            toolbar.add(Box.createHorizontalGlue());
            JButton jButton3 = new JButton(ModelViewerLrb.get("TREE_SAVE_RULES_BTN"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeRulesPanel treeRulesPanel = new TreeRulesPanel();
                    treeRulesPanel.invoke(ClusteringTreeEditor.this.getContext().getNode());
                }
            });
            toolbar.add((Component)jButton3);
            return toolbar;
        }

        private Integer getSelectedNodeId() {
            Integer n = null;
            try {
                IlvSDMNode ilvSDMNode;
                List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                if (!list.isEmpty() && (ilvSDMNode = (IlvSDMNode)list.get(0)) instanceof ClusTreeNode) {
                    n = ((ClusTreeNode)ilvSDMNode).getData().getId();
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
            return n;
        }

        private void setSelectedNodeUsingId(Integer n, ClusterTreeSDMModel clusterTreeSDMModel, ClusteringModelNode clusteringModelNode) {
            if (n != null) {
                Enumeration<IlvSDMNode> enumeration = clusterTreeSDMModel.getObjects();
                while (enumeration.hasMoreElements()) {
                    Integer n2;
                    IlvSDMNode ilvSDMNode = enumeration.nextElement();
                    if (!(ilvSDMNode instanceof ClusTreeNode) || !(n2 = ((ClusTreeNode)ilvSDMNode).getData().getId()).equals(n)) continue;
                    try {
                        clusteringModelNode.getEngine().setSelected((Object)ilvSDMNode, true);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                    break;
                }
            }
        }

        private Object[] getTopItems(ClusterTreeSDMModel clusterTreeSDMModel) {
            int n = clusterTreeSDMModel.getAttributeCount() > 10 ? 10 : clusterTreeSDMModel.getAttributeCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = i + 1;
            }
            return objectArray;
        }

        public void initTopItemsCombo(ClusterTreeSDMModel clusterTreeSDMModel) {
            Integer n = (Integer)this.comboMaxTargetValues.getSelectedItem();
            Object[] objectArray = this.getTopItems(clusterTreeSDMModel);
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
            this.comboMaxTargetValues.setModel(defaultComboBoxModel);
            boolean bl = false;
            if (objectArray.length != 0) {
                for (Object object : objectArray) {
                    if (!object.equals(n)) continue;
                    this.comboMaxTargetValues.setSelectedItem(object);
                    bl = true;
                }
                if (!bl) {
                    Integer n2 = (Integer)(objectArray.length > 4 ? objectArray[4] : objectArray[objectArray.length - 1]);
                    this.comboMaxTargetValues.setSelectedItem(n2);
                }
            }
        }
    }

    public class SelectionChangePlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private boolean isEnabled = true;

        public void selectionChanged(DiagramContext diagramContext) {
            try {
                List<Object> list = ClusteringTreeEditor.this.getSelectedDiagramObjects();
                ClusteringModelNode clusteringModelNode = ClusteringTreeEditor.this.getContextNode();
                if (list.size() > 1) {
                    this.displayNoSelectionMessage(clusteringModelNode);
                } else if (list.size() == 1) {
                    Object object = list.get(0);
                    if (object instanceof ClusTreeNode) {
                        ClusTreeNode clusTreeNode = (ClusTreeNode)object;
                        NodeDetailPane nodeDetailPane = new NodeDetailPane(clusTreeNode);
                        int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                        ClusteringTreeEditor.this.splitComponent.setBottomComponent(nodeDetailPane);
                        ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                    } else if (object instanceof ClusTreeLink && clusteringModelNode instanceof OCModelNode) {
                        ClusTreeLink clusTreeLink = (ClusTreeLink)((Object)object);
                        ClusTreeNode clusTreeNode = (ClusTreeNode)clusTreeLink.getTo();
                        String string = ClusTreeRule.getSplitRulesHtml(clusTreeNode, true);
                        int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                        ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
                        ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
                        ClusteringTreeEditor.this.textEditorPane.setText(string);
                        ClusteringTreeEditor.this.textEditorPane.select(0, 0);
                    }
                } else {
                    this.displayNoSelectionMessage(clusteringModelNode);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            }
        }

        private void displayNoSelectionMessage(ClusteringModelNode clusteringModelNode) {
            String string;
            if (clusteringModelNode instanceof KMModelNode || clusteringModelNode instanceof EMClusterModelNode) {
                string = ClusteringTreeEditorLrb.get("KM_NOSELECT_MESSAGE");
            } else if (clusteringModelNode instanceof OCModelNode) {
                string = ClusteringTreeEditorLrb.get("OC_NOSELECT_MESSAGE");
            } else {
                throw new RuntimeException("Unknown clustering node type");
            }
            ClusteringTreeEditor.this.textEditorPane.setText(string);
            if (ClusteringTreeEditor.this.splitComponent != null && ClusteringTreeEditor.this.detailView != null) {
                int n = ClusteringTreeEditor.this.splitComponent.getDividerLocation();
                ClusteringTreeEditor.this.splitComponent.setBottomComponent(ClusteringTreeEditor.this.detailView);
                ClusteringTreeEditor.this.splitComponent.setDividerLocation(n);
            }
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }
    }

    private static class OdmrReadOnlyPlugin
    extends DefaultDiagramReadOnlyPlugin {
        public OdmrReadOnlyPlugin(DiagramContext diagramContext) {
            super(diagramContext);
        }

        protected boolean checkWritableDiagram() {
            return false;
        }
    }

    public static class ModelListener
    implements SDMPropertyChangeListener {
        public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
            String string = sDMPropertyChangeEvent.getPropertyName();
            Object object = sDMPropertyChangeEvent.getObject();
            if ("expanded".equals(string) && object instanceof ClusTreeNode) {
                ((ClusTreeNode)object).setChildrenVisibility();
            }
        }
    }
}

