/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.tree.model;

import ilog.views.sdm.model.IlvAbstractSDMModel;
import ilog.views.sdm.model.IlvMutableSDMNode;
import ilog.views.sdm.model.IlvSDMNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeLink;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusTreeNode;
import oracle.dmt.dataminer.server.model.CentroidRowData;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.ide.Context;

public class ClusterTreeSDMModel
extends IlvAbstractSDMModel {
    private static final Logger theLogger = Logger.getLogger(ClusterTreeSDMModel.class.getName());
    private Vector<ClusteringDetailRow> clusterDetailRows;
    private ClusteringDetailRow rootNodeMetadata;
    private LinkedHashMap<String, IlvSDMNode> nodeStore = null;
    private Context context;
    private long maxId = 0L;
    private Boolean isLoaded = false;
    private int attributeCount;
    private int maxTargetValues = 5;
    private Boolean headerDetailVisible = true;

    public IlvSDMNode getObject(String string) {
        return this.nodeStore.get(string);
    }

    public void load(Vector<ClusteringDetailRow> vector, Context context) throws Exception {
        ClusTreeNode clusTreeNode;
        HashMap<Integer, ClusTreeNode> hashMap = new HashMap<Integer, ClusTreeNode>();
        this.context = context;
        this.nodeStore = new LinkedHashMap();
        this.attributeCount = 0;
        this.clusterDetailRows = vector;
        this.rootNodeMetadata = null;
        if (vector == null || vector.size() == 0) {
            throw new RuntimeException("Unexpected state: empty cluster detail rows");
        }
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            if (clusteringDetailRow.getParent() != 0) continue;
            this.rootNodeMetadata = clusteringDetailRow;
            break;
        }
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            clusTreeNode = ClusTreeNode.createNode(clusteringDetailRow, this.context);
            hashMap.put(clusteringDetailRow.getId(), clusTreeNode);
        }
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            clusTreeNode = (ClusTreeNode)hashMap.get(clusteringDetailRow.getId());
            ClusTreeNode clusTreeNode2 = (ClusTreeNode)hashMap.get(clusteringDetailRow.getParent());
            if (clusTreeNode2 == null && clusteringDetailRow.getId() != 1) {
                throw new RuntimeException("non root node without parent encountered");
            }
            if (clusTreeNode2 != null) {
                ClusTreeLink clusTreeLink = ClusTreeLink.createLink(clusTreeNode, clusTreeNode2);
                this.addObject((Object)clusTreeLink, null, null);
            }
            this.updateAttributeCount(clusteringDetailRow);
            this.addObject(clusTreeNode, clusTreeNode2, null);
        }
        if (this.rootNodeMetadata == null) {
            throw new RuntimeException("Tree root node not found in content model");
        }
        this.setEditable(true);
        this.isLoaded = true;
    }

    public LinkedHashMap<String, IlvSDMNode> getNodeStore() {
        return this.nodeStore;
    }

    private void updateAttributeCount(ClusteringDetailRow clusteringDetailRow) {
        Vector<CentroidRowData> vector = clusteringDetailRow.getCentroid();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        if (this.attributeCount < n) {
            this.attributeCount = n;
        }
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public Boolean isLoaded() {
        return this.isLoaded;
    }

    public void addObject(Object object, Object object2, Object object3) {
        super.addObject(object, object2, object3);
        if (object instanceof ClusTreeNode) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else if (object instanceof ClusTreeLink) {
            this.nodeStore.put(((IlvSDMNode)object).getID(), (IlvSDMNode)object);
        } else {
            throw new RuntimeException("Unexpected obj type");
        }
        this.fireObjectAdded(object);
    }

    public Enumeration<IlvSDMNode> getObjects() {
        if (this.nodeStore == null) {
            return null;
        }
        return new Vector<IlvSDMNode>(this.nodeStore.values()).elements();
    }

    public void addObjectImpl(Object object, Object object2, Object object3) {
        if (object instanceof IlvMutableSDMNode) {
            IlvMutableSDMNode ilvMutableSDMNode = (IlvMutableSDMNode)object;
            ilvMutableSDMNode.setID(this.getNextNewIdString());
        }
    }

    public List<ClusTreeLink> findLinksToNode(IlvSDMNode ilvSDMNode) {
        ArrayList<ClusTreeLink> arrayList = new ArrayList<ClusTreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            ClusTreeLink clusTreeLink;
            if (!(ilvSDMNode2 instanceof ClusTreeLink) || !(clusTreeLink = (ClusTreeLink)ilvSDMNode2).getTo().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(clusTreeLink);
        }
        return arrayList;
    }

    public boolean isSplitPredicateForNode(ClusTreeNode clusTreeNode) {
        int n;
        int n2 = n = clusTreeNode.getData().getId().intValue();
        ClusTreeNode clusTreeNode2 = clusTreeNode.findParentNode();
        List<ClusTreeLink> list = this.findLinksFromNode((IlvSDMNode)clusTreeNode2);
        for (ClusTreeLink clusTreeLink : list) {
            ClusTreeNode clusTreeNode3 = (ClusTreeNode)clusTreeLink.getTo();
            if (clusTreeNode3.getData().getId() >= n2) continue;
            n2 = clusTreeNode3.getData().getId();
        }
        return n2 == n;
    }

    public List<ClusTreeLink> findLinksFromNode(IlvSDMNode ilvSDMNode) {
        ArrayList<ClusTreeLink> arrayList = new ArrayList<ClusTreeLink>();
        for (IlvSDMNode ilvSDMNode2 : this.nodeStore.values()) {
            ClusTreeLink clusTreeLink;
            if (!(ilvSDMNode2 instanceof ClusTreeLink) || !(clusTreeLink = (ClusTreeLink)ilvSDMNode2).getFrom().getID().equals(ilvSDMNode.getID())) continue;
            arrayList.add(clusTreeLink);
        }
        return arrayList;
    }

    public void clear() {
        this.nodeStore.clear();
    }

    public Context getContext() {
        return this.context;
    }

    public void refresh() {
        try {
            this.load(this.clusterDetailRows, this.context);
            this.fireDataChanged(null);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public long getNextNewId() {
        ++this.maxId;
        return this.maxId;
    }

    public String getNextNewIdString() {
        ++this.maxId;
        return Long.valueOf(this.maxId).toString();
    }

    public ClusteringDetailRow getRootNodeMetadata() {
        return this.rootNodeMetadata;
    }

    public void toggleHeaderDetailVisible() {
        this.headerDetailVisible = this.headerDetailVisible == false;
    }

    public void setHeaderDetailVisible(boolean bl) {
        this.headerDetailVisible = bl;
    }

    public Boolean isHeaderDetailVisible() {
        return this.headerDetailVisible;
    }

    public int getMaxTargetValuesDisplayed() {
        return this.maxTargetValues;
    }

    public void setMaxTargetValuesDisplayed(int n) {
        this.maxTargetValues = n;
        Set<String> set = this.nodeStore.keySet();
        for (String string : set) {
            IlvSDMNode ilvSDMNode = this.nodeStore.get(string);
            if (!(ilvSDMNode instanceof ClusTreeNode)) continue;
            ((ClusTreeNode)ilvSDMNode).setMaxValuesDisplayed(this.maxTargetValues);
        }
        this.fireDataChanged(null);
    }
}

