/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.util.Comparator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.utils.comparator.AbsoluteNumberComparator;
import oracle.dmt.dataminer.utils.comparator.NumberComparator;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CoefViewerTableModel
extends GenericBaseTableModel {
    private Vector<CoefficientRowData> _data = new Vector(1000, 500);
    public static final int ATTRIBUTE = 0;
    public static final int VALUE = 1;
    public static final int COEEFICIENT = 2;
    private boolean _absoluteSort = false;
    private static final String[] COLUMN_NAMES = new String[]{CoefficientsLrb.get("ATTRIBUTE_COLUMN"), CoefficientsLrb.get("VALUE_COLUMN"), CoefficientsLrb.get("COEFFICIENT_COLUMN")};

    public CoefViewerTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public CoefViewerTableModel(Vector<CoefficientRowData> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    public void addRows(Vector<CoefficientRowData> vector) {
        for (CoefficientRowData coefficientRowData : vector) {
            this.getDataVector().add(coefficientRowData);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public CoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public void addSelection(CoefViewerTableModel coefViewerTableModel, int[] nArray) {
        Vector<CoefficientRowData> vector = coefViewerTableModel.getDataVector();
        CoefficientRowData coefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            coefficientRowData = vector.elementAt(nArray[i]);
            this._data.add(coefficientRowData);
        }
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Vector<CoefficientRowData> getDataVector() {
        return this._data;
    }

    public void removeSelectedRows(int[] nArray) {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        CoefficientRowData coefficientRowData = null;
        for (int i = 0; i < nArray.length; ++i) {
            coefficientRowData = this._data.elementAt(nArray[i]);
            vector.add(coefficientRowData);
        }
        this._data.removeAll(vector);
        this.setRowCount(this._data.size());
        this.fireTableDataChanged();
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 2) {
            if (this._absoluteSort) {
                return AbsoluteNumberComparator.getComparator();
            }
            return NumberComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        CoefficientRowData coefficientRowData = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = coefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = coefficientRowData.getValue();
                break;
            }
            case 2: {
                object = coefficientRowData.getCoefficient1();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object == null ? "NULL" : object;
    }

    public void setAbsoluteValueSort(boolean bl) {
        this._absoluteSort = bl;
    }

    public boolean getAbsoluteValueSort() {
        return this._absoluteSort;
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        this._data.add(coefficientRowData);
    }
}

