/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.filter.FilterConsumer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.server.model.CoefficientFilterSetting;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public abstract class GeneralCoefficientFilterPanel
extends JPanel
implements DataminerGUIPanel {
    public static final String FILTER_SETTING_PROPERTY = "FILTER_SETTING_PROPERTY";
    protected CoefViewerState _state;
    protected View _consumerView;
    protected boolean _loaded;
    protected CoefViewerMainPanel _mainPanel;
    protected CoefficientFilterSetting _coefFilterSetting;
    protected Context _context;
    protected DataMinerTable _jItemFilterTable = new DataMinerTable();
    protected ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    protected BlockingComponent overLayPanel = null;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public GeneralCoefficientFilterPanel() {
        this._jItemFilterTable.setTooltipEnable(true);
    }

    public JPanel getUIComponent() {
        return this;
    }

    protected boolean isSVM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVMCModelNode;
    }

    protected boolean isGLM() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof GLMCModelNode;
    }

    protected boolean isAnomaly() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof ANModelNode;
    }

    protected boolean isNB() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NBModelNode;
    }

    protected boolean isNMF() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof NMFModelNode;
    }

    protected boolean isSVD() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        return modelNode instanceof SVDModelNode;
    }

    public void setupUI(CoefficientFilterSetting coefficientFilterSetting) {
        this._coefFilterSetting = coefficientFilterSetting;
        if (this.isAnomaly()) {
            this._coefFilterSetting.setFilterByAbsolute(true);
        }
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    protected void setLoaded(boolean bl) {
        this._loaded = bl;
    }

    protected void setNumber(JSpinner jSpinner, Number number) {
        jSpinner.setValue(number);
    }

    protected void setLocale(JSpinner jSpinner, Locale locale) {
        jSpinner.setLocale(locale);
    }

    protected Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    protected void prepareReload() {
        this._mainPanel.prepareReload();
    }

    protected void setupUIDetail() {
        FilterConsumer filterConsumer = (FilterConsumer)this._consumerView;
        this._coefFilterSetting = (CoefficientFilterSetting)filterConsumer.getCachedFilterState();
        assert (this._coefFilterSetting != null) : "Coefficient Filter Setting state is null.";
        this.loadStateAttributes();
        this.enableControls(true);
        this.setLoaded(true);
    }

    public void setupUI(View view) {
        if (this._consumerView == view) {
            return;
        }
        if (view == null) {
            return;
        }
        FilterConsumer filterConsumer = (FilterConsumer)view;
        this._consumerView = view;
        if (!filterConsumer.isLoaded()) {
            this._consumerView = view;
            return;
        }
        this.setupUIDetail();
    }

    protected abstract void loadStateAttributes();

    protected abstract void enableControls(boolean var1);

    protected abstract JSpinner getFetchSizeComponent();

    protected abstract JCheckBox getAbsoluteValueComponent();

    public void updateTarget() {
    }

    class ValidateUpdateState
    extends ProgressRunnable {
        private Exception _exception;
        private Boolean _validated;
        private boolean _canceled = false;

        ValidateUpdateState() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        public Exception getException() {
            return this._exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            Number number;
            block6: {
                this._validated = false;
                number = GeneralCoefficientFilterPanel.this.getNumber(GeneralCoefficientFilterPanel.this.getFetchSizeComponent());
                if (null != number && number.longValue() > 0L) break block6;
                this._validated = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CoefficientsLrb.get("FETCH_SIZE_RANGE_ERROR"), (String)CoefficientsLrb.get("COEFFICIENT_ERROR_TITLE"), null);
                Boolean bl = this._validated;
                return bl;
            }
            try {
                this._validated = true;
                GeneralCoefficientFilterPanel.this._coefFilterSetting.setFetchSize(number.intValue());
                GeneralCoefficientFilterPanel.this._coefFilterSetting.setUseFilterSpecification(false);
                if (null != GeneralCoefficientFilterPanel.this.getAbsoluteValueComponent()) {
                    GeneralCoefficientFilterPanel.this._coefFilterSetting.setFilterByAbsolute(GeneralCoefficientFilterPanel.this.getAbsoluteValueComponent().isSelected());
                }
            }
            catch (Exception exception) {
                this._exception = exception;
                this._validated = false;
            }
            return this._validated;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

