/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesR;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class LoadSVMModelViewer
extends SwingWorker {
    private static final Logger theLogger = Logger.getLogger(LoadSVMModelViewer.class.getName());
    Exception _ex = null;
    boolean _success = false;
    ModelInfoType _miningModel;
    boolean _isLinear = false;
    PropertyModel _model = null;
    Context _context = null;
    String _diagramNodeName;

    public LoadSVMModelViewer(ModelInfoType modelInfoType, Context context, String string) {
        this._miningModel = modelInfoType;
        this._context = context;
        this._diagramNodeName = string;
    }

    protected Object doInBackground() throws Exception {
        Connection connection = null;
        try {
            this._success = true;
            connection = Connections.getUniqueConnection(this._context);
            Model model = new Model(this._miningModel.getSchema(), this._miningModel.getName());
            model.load(connection);
            Model model2 = null;
            SupportVectorMachinesC supportVectorMachinesC = null;
            SupportVectorMachinesR supportVectorMachinesR = null;
            if (model.getModelGeneralDescription().isClassificationModel() && model.getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                model2 = new SupportVectorMachinesC();
                supportVectorMachinesC = model2;
                this._isLinear = supportVectorMachinesC.isLinear(model.getModelSettings());
            } else if (model.getModelGeneralDescription().isRegressionModel() && model.getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                model2 = new SupportVectorMachinesR();
                supportVectorMachinesR = (SupportVectorMachinesR)model2;
                this._isLinear = supportVectorMachinesR.isLinear(model.getModelSettings());
            }
        }
        catch (Exception exception) {
            this._ex = exception;
            this._success = false;
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return this._success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        block9: {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    String string = this._miningModel.getName();
                    WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
                    if (workflowNode == null) {
                        return;
                    }
                    BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, this._diagramNodeName, string);
                    if (baseTreeNode != null) {
                        EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), null, (String)CoefficientsLrb.get("SVM_MODEL_MODEL_VIEWER_ERROR_MESG"), (String)CoefficientsLrb.get("SVM_MODEL_VIEWER_ERROR_TITLE"));
                    }
                    break block9;
                }
                if (this._ex != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CoefficientsLrb.get("SVM_MODEL_VIEWER_ERROR_TITLE"), (String)CoefficientsLrb.get("SVM_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
                    break block9;
                }
                MessageDialog.error((Component)Ide.getMainWindow(), null, (String)CoefficientsLrb.get("SVM_MODEL_VIEWER_ERROR_TITLE"), (String)CoefficientsLrb.get("SVM_MODEL_MODEL_VIEWER_ERROR_MESG"));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CoefficientsLrb.get("SVM_MODEL_VIEWER_ERROR_TITLE"), (String)CoefficientsLrb.get("SVM_MODEL_MODEL_VIEWER_ERROR_MESG"), null);
            }
        }
    }
}

