/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.NBProbabilitiesCompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.SVMCPropensitiesCompareTableModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelC;
import oracle.dmt.dataminer.server.model.GeneralizedLinearModelR;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.NaiveBayes;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesC;
import oracle.dmt.dataminer.server.model.SupportVectorMachinesR;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.ObjectComparator;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.javatools.util.Version;

public class CompareState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(CompareState.class.getName());
    private Vector<TargetPriorsPredictionSet> _targetValuePriors;
    private SupportVectorMachinesC _modelSVMClassification = null;
    private GeneralizedLinearModelC _modelGLMClassification = null;
    private NaiveBayes _modelNaiveNayes;
    private String _modelName;
    private String _userName;
    private CompareFilterSetting _filterSetting;
    private CompareFilterSetting _cachedFilterSetting;
    private NBProbabilitiesCompareTableModel _nbTableModel;
    private SVMCPropensitiesCompareTableModel _svmTableModel;
    private SVMCPropensitiesCompareTableModel _glmTableModel;
    private Object _selectedTargetClass;
    private Object _secondSelectedTargetClass;
    private Integer _totalDetailCount = 0;
    private boolean _queryForTotalDetailCount = true;
    private Version dbVersion = null;

    public CompareState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        try {
            this._context = context;
            this.dbVersion = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public CompareState reloadPropensities() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            if (this._queryForTotalDetailCount) {
                LoadTotalCount loadTotalCount = new LoadTotalCount(this._userName, this._modelName, this._filterSetting);
                loadTotalCount.start();
                this.loadPropensities(connection);
                loadTotalCount.join();
                if (loadTotalCount.getException() != null) {
                    throw loadTotalCount.getException();
                }
                this._totalDetailCount = loadTotalCount.getCount();
                this._queryForTotalDetailCount = false;
            } else {
                this.loadPropensities(connection);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    public CompareState load() throws Exception {
        Connection connection = null;
        Classification classification = new Classification();
        try {
            Object object;
            connection = Connections.getUniqueConnection(this._context);
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            Model model = null;
            if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                this._modelSVMClassification = model = new SupportVectorMachinesC();
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isRegressionModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isSupportVectorMachinesAlgorithm()) {
                model = new SupportVectorMachinesR();
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
                model = new GeneralizedLinearModelC();
                this._modelGLMClassification = (GeneralizedLinearModelC)model;
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isRegressionModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isGeneralizedLinearModelAlgorithm()) {
                model = new GeneralizedLinearModelR();
            } else if (this._modelViewerState1.getOdmModel().getModelGeneralDescription().isClassificationModel() && this._modelViewerState1.getOdmModel().getModelGeneralDescription().isNaiveBayesAlgorithm()) {
                this._modelNaiveNayes = new NaiveBayes();
            } else {
                throw new Exception(CompareLrb.get("COEFFICIENT_VIEWER_UNRECOGNIZED_MODEL_TYPE"));
            }
            this._modelName = this._modelViewerState1.getModelName();
            this._userName = this._modelViewerState1.getUserName();
            this._filterSetting = new CompareFilterSetting(this);
            this._cachedFilterSetting = new CompareFilterSetting(this);
            if (this.isSVM() || this.isAnomaly()) {
                object = null;
                object = this._modelSVMClassification.getAbsMaxValue(connection, this._userName, this._modelName);
                this._filterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                this._filterSetting.setMaxCoefficient(new BigDecimal((Double)object));
                this._cachedFilterSetting.setMinCoefficient(new BigDecimal((Double)object * -1.0));
                this._cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object));
            } else if (this.isGLM()) {
                object = this._modelGLMClassification.getMinMaxValue(connection, this._userName, this._modelName);
                this._filterSetting.setMinCoefficient(new BigDecimal(object[0]));
                this._filterSetting.setMaxCoefficient(new BigDecimal(object[1]));
                this._cachedFilterSetting.setMinCoefficient(new BigDecimal(object[0]));
                this._cachedFilterSetting.setMaxCoefficient(new BigDecimal((Double)object[1]));
            }
            this.initInternalTable();
            this._targetValuePriors = classification.getTargetValuePredictionSet(connection, this._userName, this._modelName);
            if (this._targetValuePriors.size() <= 2 && this._targetValuePriors.size() != 2) {
                throw new Exception(CompareLrb.get("COEFFICIENT_VIEWER_NO_TARGET_PRIORS_VALUES"));
            }
            this._filterSetting.setTargetValuePriors(this._targetValuePriors);
            this.loadDefaultTargetValue();
            object = new LoadTotalCount(this._userName, this._modelName, this._filterSetting);
            ((Thread)object).start();
            this.loadPropensities(connection);
            ((Thread)object).join();
            if (((LoadTotalCount)object).getException() != null) {
                throw ((LoadTotalCount)object).getException();
            }
            this._totalDetailCount = ((LoadTotalCount)object).getCount();
            this._queryForTotalDetailCount = false;
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    private void initInternalTable() {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel = new SVMCPropensitiesCompareTableModel(vector);
        } else if (this.isGLM()) {
            this._glmTableModel = new SVMCPropensitiesCompareTableModel(vector);
        } else if (this.isNB()) {
            this._nbTableModel = new NBProbabilitiesCompareTableModel(vector);
        } else assert (false) : "CompareState not loaded.";
    }

    private void loadDefaultTargetValue() {
        if (this.isClassification()) {
            if (this.isSVM() || this.isAnomaly()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this._modelSVMClassification.findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this._modelSVMClassification.findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            } else if (this.isGLM()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this._modelGLMClassification.findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this._modelGLMClassification.findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            } else if (this.isNB()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = this._modelNaiveNayes.findMostCommonTargetValue(this._targetValuePriors);
                this.setSelectedTargetClass(targetPriorsPredictionSet.getPrediction());
                this.setSecondSelectedTargetClass(this._modelNaiveNayes.findSecondMostCommonTargetValue(this._targetValuePriors, targetPriorsPredictionSet).getPrediction());
            }
        }
    }

    private void loadPropensities(Connection connection) throws Exception {
        if (this.isSVM() || this.isAnomaly()) {
            Vector<CoefficientRowData> vector = this._modelSVMClassification.getPropensities(connection, this._userName, this._modelName, this._filterSetting);
            this._svmTableModel.clearRows();
            this._svmTableModel.addRows(vector);
        } else if (this.isGLM()) {
            Vector<CoefficientRowData> vector = this._modelGLMClassification.getPropensities(connection, this.dbVersion, this._userName, this._modelName, this._filterSetting);
            this._glmTableModel.clearRows();
            this._glmTableModel.addRows(vector);
        } else if (this.isNB()) {
            Vector<CoefficientRowData> vector = this._modelNaiveNayes.getPropensities(connection, this._userName, this._modelName, this._filterSetting);
            this._nbTableModel.clearRows();
            this._nbTableModel.addRows(vector);
        } else assert (false) : "CompareState not loaded.";
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "Help Topic Not Specified";
        if (this.isSVM() && this.isClassification()) {
            string = "svmc_compare";
        } else if (this.isSVM() && this.isRegression()) {
            string = "svmr_compare";
        } else if (this.isGLM() && this.isClassification()) {
            string = "glmc_compare";
        } else if (this.isGLM() && this.isRegression()) {
            string = "glmr_compare";
        } else if (this.isNB()) {
            string = "nb_view_compare";
        }
        if (this.isAnomaly() && this.isClassification()) {
            string = "svmc_compare";
        }
        return new HelpInfo(string);
    }

    public void setFilterSetting(CompareFilterSetting compareFilterSetting) {
        this._filterSetting = compareFilterSetting;
        if (this.getSelectedTargetClass() != null) {
            this._filterSetting.setTargetValue(this.getSelectedTargetClass());
        }
        if (this.getSecondSelectedTargetClass() != null) {
            this._filterSetting.setSecondTargetValue(this.getSecondSelectedTargetClass());
        }
    }

    public CompareFilterSetting getFilterSetting() {
        return this._filterSetting;
    }

    public void setSelectedTargetClass(Object object) {
        this._selectedTargetClass = object;
        this._queryForTotalDetailCount = true;
        this._filterSetting.setTargetValue(object);
    }

    public Object getSelectedTargetClass() {
        return this._selectedTargetClass;
    }

    public void setSecondSelectedTargetClass(Object object) {
        this._secondSelectedTargetClass = object;
        this._queryForTotalDetailCount = true;
        this._filterSetting.setSecondTargetValue(this._secondSelectedTargetClass);
    }

    public Object getSecondSelectedTargetClass() {
        return this._secondSelectedTargetClass;
    }

    public void clearRows() {
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.clearRows();
        } else if (this.isGLM()) {
            this._glmTableModel.clearRows();
        } else if (this.isNB()) {
            this._nbTableModel.clearRows();
        } else assert (false) : "CompareState not loaded.";
    }

    public void addRow(CoefficientRowData coefficientRowData) {
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.addRow(coefficientRowData);
        } else if (this.isGLM()) {
            this._glmTableModel.clearRows();
        } else if (this.isNB()) {
            this._nbTableModel.addRow(coefficientRowData);
        } else assert (false) : "Loaded a SVM Coefficient row when model was not SVM.";
    }

    public CompareTableModel getTableModel() {
        if (this.isSVM() || this.isAnomaly()) {
            return this._svmTableModel;
        }
        if (this.isGLM()) {
            return this._glmTableModel;
        }
        if (this.isNB()) {
            return this._nbTableModel;
        }
        assert (false) : "CompareState not loaded.";
        return null;
    }

    public void setCachedFilterSetting(CompareFilterSetting compareFilterSetting) {
        this._cachedFilterSetting = compareFilterSetting;
    }

    public CompareFilterSetting getCachedFilterSetting() {
        return this._cachedFilterSetting;
    }

    public void setSortByAbsoluteValue(boolean bl) {
        this._cachedFilterSetting.setFilterByAbsolute(bl);
        if (this.isSVM() || this.isAnomaly()) {
            this._svmTableModel.setAbsoluteValueSort(bl);
        } else if (this.isGLM()) {
            this._glmTableModel.setAbsoluteValueSort(bl);
        } else if (this.isNB()) {
            this._nbTableModel.setAbsoluteValueSort(bl);
        } else assert (false) : "CoefViewerState not loaded.";
    }

    public boolean getSortByAbsoluteValue() {
        boolean bl = false;
        if (this.isSVM() || this.isAnomaly()) {
            bl = this._svmTableModel.getAbsoluteValueSort();
        } else if (this.isGLM()) {
            bl = this._glmTableModel.getAbsoluteValueSort();
        } else if (this.isNB()) {
            bl = this._nbTableModel.getAbsoluteValueSort();
        } else assert (false) : "CoefViewerState not loaded.";
        return bl;
    }

    public Vector<Object> getTargetPredictions() {
        return ObjectComparator.getTargetPredictions(this._targetValuePriors);
    }

    public Integer getTotalDetailCount() {
        return this._totalDetailCount;
    }

    private class LoadTotalCount
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _userName;
        String _modelNamel;
        CompareFilterSetting _filterSetting;
        Integer _count = 0;

        public LoadTotalCount(String string, String string2, CompareFilterSetting compareFilterSetting) {
            this._userName = string;
            CompareState.this._modelName = string2;
            this._filterSetting = compareFilterSetting;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Connection connection = null;
            try {
                connection = Connections.getUniqueConnection(CompareState.this._context);
                Integer n = 0;
                if (CompareState.this.isSVM() || CompareState.this.isAnomaly()) {
                    if (CompareState.this.isClassification()) {
                        n = CompareState.this._modelSVMClassification.getTotalCountPropensities(connection, this._userName, CompareState.this._modelName, this._filterSetting);
                    } else if (CompareState.this.isRegression()) {
                        n = 0;
                    }
                } else if (CompareState.this.isGLM()) {
                    if (CompareState.this.isClassification()) {
                        n = CompareState.this._modelGLMClassification.getTotalCountPropensities(connection, CompareState.this.dbVersion, this._userName, CompareState.this._modelName, this._filterSetting);
                    } else if (CompareState.this.isRegression()) {
                        n = 0;
                    }
                } else if (CompareState.this.isNB()) {
                    n = CompareState.this._modelNaiveNayes.getTotalCountPropensities(connection, this._userName, CompareState.this._modelName, this._filterSetting);
                } else assert (false) : "CompareViewerState not loaded. ";
                this._count = n;
                this._success = true;
            }
            catch (Exception exception) {
                try {
                    this._ex = exception;
                    this._success = false;
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
            SQLHelper.close(connection);
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public Integer getCount() {
            return this._count;
        }
    }
}

