/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.awt.Component;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.compare.CoefCompareMainPanel;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareState;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.NBProbabilitiesCompareTableModel;
import oracle.dmt.dataminer.mviewer.compare.SVMCPropensitiesCompareTableModel;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CompareFilterSetting;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class CompareViewer
extends JPanel
implements DataminerGUIPanel {
    private DataMinerTablePanel dataMinerTablePanel;
    private CompareState _state;
    private Context _context;
    private CoefCompareMainPanel _mainPanel;
    private NumberFormat _labelFormat = NumericFormat.getInstance(true, 8, 1, 0);
    private boolean _loadedFilterSetting = false;
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);

    public CompareViewer(CoefCompareMainPanel coefCompareMainPanel, Context context, CompareState compareState) {
        this._mainPanel = coefCompareMainPanel;
        this._context = context;
        this._state = compareState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 654, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 266, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    @Override
    public void initUI() {
        this.setLoading(true);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.initializeControls();
        this._labelFormat.setMaximumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._labelFormat.setMinimumFractionDigits(this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        this._labelFormat.setMinimumIntegerDigits(1);
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = CompareLrb.get("PROPENSITIES_ROWS_OUT_OF_TOTAL");
        int n3 = 1;
        if (n == 0 && n2 == 0) {
            n3 = 0;
        }
        if (this._state.isSVM() || this._state.isGLM() || this._state.isNB() || this._state.isAnomaly()) {
            n3 = 0;
        }
        Integer n4 = n2 + n3;
        String string2 = NumericFormat.format(n);
        String string3 = NumericFormat.format(n4);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    private void setLoading(boolean bl) {
        this._mainPanel.updateLoading(bl);
    }

    private void setLoaded(boolean bl) {
        if (!this._loadedFilterSetting) {
            this._mainPanel.setFilterPanelInitialState(this._state.getFilterSetting());
            this._loadedFilterSetting = true;
        }
        this._mainPanel.updateLoaded(bl);
    }

    public void setFilterState(CompareFilterSetting compareFilterSetting) {
        if (this.isLoading()) {
            return;
        }
        this._state.setFilterSetting(compareFilterSetting);
        this.prepareReload();
    }

    public CompareFilterSetting getCachedFilterState() {
        return this._state.getCachedFilterSetting();
    }

    public void setCachedFilterState(CompareFilterSetting compareFilterSetting) {
        this._state.setCachedFilterSetting(compareFilterSetting);
    }

    void prepareReload() {
        this.setLoading(true);
        this.prepareForNewQuery();
        LoadUI loadUI = new LoadUI(true);
        loadUI.execute();
    }

    private void prepareForNewQuery() {
        this._state.clearRows();
        if (this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) {
            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
            this._state.addRow(coefficientRowData);
            this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)this._state.getTableModel()));
        }
        this.dataMinerTablePanel.getTable().setSorted(false);
        this.enableControls(false);
    }

    public boolean isLoading() {
        return this._mainPanel.isLoading();
    }

    private void initializeControls() {
        CompareTableModel compareTableModel = null;
        CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_LOADING"));
        if (this._state.isNB()) {
            compareTableModel = new NBProbabilitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
        } else if (this._state.isSVM() || this._state.isAnomaly()) {
            compareTableModel = new SVMCPropensitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
        } else if (this._state.isGLM()) {
            compareTableModel = new SVMCPropensitiesCompareTableModel();
            compareTableModel.addRow(coefficientRowData);
        } else assert (false) : "Unsupported model node";
        this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)compareTableModel));
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private void setupCompareTable(CompareTableModel compareTableModel) {
        compareTableModel.updatePropensityColumnIdentifiers(this._state.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSelectedTargetClass()) : this._state.getSelectedTargetClass().toString(), this._state.isAnomaly() ? CoefViewerState.predictiveValuesToString(this._state.getSecondSelectedTargetClass()) : this._state.getSecondSelectedTargetClass().toString());
        this.dataMinerTablePanel.setup((TableModel)((Object)compareTableModel), null, 0, true);
        this.dataMinerTablePanel.getTable().setSorted(true);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        if (this._state.isNB() || this._state.isSVM() || this._state.isGLM() || this._state.isAnomaly()) {
            tableColumnModel.getColumn(2).setCellRenderer(new HistogramBarRenderer(1L, true, this._labelFormat));
            tableColumnModel.getColumn(3).setCellRenderer(new HistogramBarRenderer(1L, true, this._labelFormat));
        }
        if (this._state.isAnomaly()) {
            this.dataMinerTablePanel.getTable().setSortColumn(2, false);
            this.dataMinerTablePanel.getTable().setSortColumn(3, false);
        }
    }

    private void enableControls(boolean bl) {
        this.dataMinerTablePanel.getSearchField().setEnabled(bl);
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;

        public LoadUI(boolean bl) {
            this._reload = bl;
        }

        public LoadUI() {
            this._reload = false;
        }

        protected Object doInBackground() throws Exception {
            try {
                if (this._reload) {
                    CompareViewer.this._state.reloadPropensities();
                } else {
                    CompareViewer.this._state.load();
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CompareViewer.this._state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            super.done();
            try {
                if (this._success && this._ex == null) {
                    if ((CompareViewer.this._state.isNB() || CompareViewer.this._state.isSVM() || CompareViewer.this._state.isGLM() || CompareViewer.this._state.isAnomaly()) && CompareViewer.this._state.isAnomaly()) {
                        CompareViewer.this._state.setSortByAbsoluteValue(CompareViewer.this._state.getFilterSetting().getFilterAndSortByAbsolute());
                    }
                    CompareViewer.this.setupCompareTable(CompareViewer.this._state.getTableModel());
                    CompareViewer.this.dataMinerTablePanel.trySearch();
                    CompareViewer.this._mainPanel.updateTargetCombos();
                    CompareViewer.this.loadRowsOutOfTotalLabel(CompareViewer.this._state.getTableModel().getRowCount(), CompareViewer.this._state.getTotalDetailCount());
                    CompareViewer.this.enableControls(true);
                    CompareViewer.this.setLoaded(true);
                } else {
                    if (CompareViewer.this._state.getTableModel() != null) {
                        CompareViewer.this._state.clearRows();
                        if (CompareViewer.this._state.isNB() || CompareViewer.this._state.isSVM() || CompareViewer.this._state.isGLM() || CompareViewer.this._state.isAnomaly()) {
                            CoefficientRowData coefficientRowData = new CoefficientRowData(CompareLrb.get("COEFFICIENT_FAILURE"));
                            CompareViewer.this._state.addRow(coefficientRowData);
                            CompareViewer.this.setupCompareTable(CompareViewer.this._state.getTableModel());
                        }
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_TITLE"), (String)CompareLrb.get("COEFFICIENT_VIEWER_FAILURE_MESG"), null);
            }
            finally {
                CompareViewer.this.setLoading(false);
            }
        }
    }
}

