/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.compare;

import java.util.Comparator;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.compare.CompareLrb;
import oracle.dmt.dataminer.mviewer.compare.CompareTableModel;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.utils.comparator.AbsoluteNumberComparator;

public class NBProbabilitiesCompareTableModel
extends CompareTableModel {
    private static final String[] COLUMN_NAMES = new String[]{CompareLrb.get("COMPARE_ATTRIBUTE_NAME"), CompareLrb.get("COMPARE_ATTRIBUTE_VALUE"), CompareLrb.get("COMPARE_PROPENSITY_FOR_TARGET"), CompareLrb.get("COMPARE_PROPENSITY_FOR_TARGET")};
    private Vector<CoefficientRowData> _data = new Vector();

    public NBProbabilitiesCompareTableModel() {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this.setRowCount(0);
    }

    public NBProbabilitiesCompareTableModel(Vector<CoefficientRowData> vector) {
        this.setColumnIdentifiers(COLUMN_NAMES);
        this._data = vector;
        this.setRowCount(vector.size());
    }

    @Override
    public void updatePropensityColumnIdentifiers(String string, String string2) {
        Object[] objectArray = new String[COLUMN_NAMES.length];
        System.arraycopy(COLUMN_NAMES, 0, objectArray, 0, COLUMN_NAMES.length);
        objectArray[2] = objectArray[2] + string;
        objectArray[3] = objectArray[3] + string2;
        this.setColumnIdentifiers(objectArray);
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public CoefficientRowData getRow(int n) {
        return this._data.get(n);
    }

    public Vector<CoefficientRowData> getDataVector() {
        return this._data;
    }

    public Comparator getColumnSortComparator(int n) {
        Comparator<Object> comparator = null;
        comparator = n == 2 || n == 3 ? AbsoluteNumberComparator.getComparator() : super.getColumnSortComparator(n);
        return comparator;
    }

    public void addRows(Vector<CoefficientRowData> vector) {
        for (CoefficientRowData coefficientRowData : vector) {
            this._data.add(coefficientRowData);
        }
    }

    @Override
    public void addRow(CoefficientRowData coefficientRowData) {
        this._data.add(coefficientRowData);
    }

    public Object getValueAt(int n, int n2) {
        CoefficientRowData coefficientRowData;
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        try {
            coefficientRowData = this._data.get(n);
        }
        catch (Exception exception) {
            return null;
        }
        Object object = null;
        switch (n2) {
            case 0: {
                object = coefficientRowData.getAttributeFullName();
                break;
            }
            case 1: {
                object = coefficientRowData.getValue();
                break;
            }
            case 2: {
                object = coefficientRowData.getCoefficient1();
                break;
            }
            case 3: {
                object = coefficientRowData.getCoefficient2();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing coefficients";
                break;
            }
        }
        return object;
    }
}

