/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DecisionTreePreferencesSettings
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dmt.dataminer.mviewer.dtree.DecisionTreeViewerPreferencesSettings";
    protected static final String SHOW_HISTOGRAM = "showHistogram";
    protected static final String SHOW_NODE_DETAIL_HEADER = "showNodeDetailHeader";
    protected static final String SORT_BY_ROOT_ORDER = "sortByRootOrder";
    protected static final String HORIZONTAL_LAYOUT = "horizontalLayout";
    protected static final String MAX_TARGET_DISPLAY_LENGTH = "targetValueDisplayMax";
    protected static final String WRAP_NODE_RULES = "wrapNodeRules";
    protected static final String WRAP_NODE_SURROGATE_RULES = "wrapSurrogateRules";
    protected static final int MAX_TARGET_DISPLAY_LENGTH_DEFAULT = 25;

    public static DecisionTreePreferencesSettings getInstance() {
        return DecisionTreePreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private DecisionTreePreferencesSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DecisionTreePreferencesSettings getInstance(PropertyStorage propertyStorage) {
        return new DecisionTreePreferencesSettings(DecisionTreePreferencesSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setShowHistogram(boolean bl) {
        this._hash.putBoolean(SHOW_HISTOGRAM, bl);
    }

    public boolean isShowHistogram() {
        return this._hash.getBoolean(SHOW_HISTOGRAM, true);
    }

    public void setShowNodeDetailHeader(boolean bl) {
        this._hash.putBoolean(SHOW_NODE_DETAIL_HEADER, bl);
    }

    public boolean isShowNodeDetailHeader() {
        return this._hash.getBoolean(SHOW_NODE_DETAIL_HEADER, true);
    }

    public void setSortByRootOrder(boolean bl) {
        this._hash.putBoolean(SORT_BY_ROOT_ORDER, bl);
    }

    public boolean isSortByRootOrder() {
        return this._hash.getBoolean(SORT_BY_ROOT_ORDER, true);
    }

    public void setHorizontalOrientation(boolean bl) {
        this._hash.putBoolean(HORIZONTAL_LAYOUT, bl);
    }

    public boolean isHorizontalLayout() {
        return this._hash.getBoolean(HORIZONTAL_LAYOUT, false);
    }

    public void setMaxTargetValueDisplayLength(int n) {
        this._hash.putInt(MAX_TARGET_DISPLAY_LENGTH, n);
    }

    public int getMaxTargetValueDisplayLength() {
        return this._hash.getInt(MAX_TARGET_DISPLAY_LENGTH, 25);
    }

    public void setWrapNodeRules(boolean bl) {
        this._hash.putBoolean(WRAP_NODE_RULES, bl);
    }

    public boolean getWrapNodeRules() {
        return this._hash.getBoolean(WRAP_NODE_RULES, false);
    }

    public void setWrapNodeSurrogateRules(boolean bl) {
        this._hash.putBoolean(WRAP_NODE_SURROGATE_RULES, bl);
    }

    public boolean getWrapNodeSurrogateRules() {
        return this._hash.getBoolean(WRAP_NODE_SURROGATE_RULES, false);
    }
}

