/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree.structure;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMModelListener;
import ilog.views.sdm.model.IlvMutableSDMNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeSelectionModel;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.view.ViewUtil;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeLink;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.mviewer.dtree.structure.DTExplorerNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.explorer.BaseTreeExplorer;

public class DTStructureExplorer
extends BaseTreeExplorer
implements ContextMenuListener {
    private DefaultFolder _root;
    private ClusterLinksFolder _links;
    private IlvSDMEngine _engine;
    private View _view;
    private Context _context;
    private ExplorerSDMModelListener _SDModellistener = new ExplorerSDMModelListener();
    private DiagramExplorerSelectionListener _selectionListener = null;
    private boolean _adjustingSelectionFromView = false;
    private boolean _rebuilding = false;
    private PopulatingThread _thread;

    private void setAdjustingSelectionFromView(boolean bl) {
        this._adjustingSelectionFromView = bl;
    }

    public boolean isAdjustingSelectionFromView() {
        return this._adjustingSelectionFromView;
    }

    private void setRebuilding(boolean bl) {
        this._rebuilding = bl;
    }

    public boolean isRebuilding() {
        return this._rebuilding;
    }

    public void setContext(Context context) {
        IlvManagerView ilvManagerView;
        View view = this.findActiveDiagramView(context);
        boolean bl = true;
        if (this._context == null || context == null) {
            bl = true;
        } else if (this._context.getNode() != context.getNode()) {
            bl = true;
        } else if (this._context.getView() != view) {
            bl = true;
        }
        if (!bl) {
            super.setContext(context);
            return;
        }
        IlvManagerView ilvManagerView2 = ilvManagerView = view != null ? this.findActiveManagerView(view) : null;
        if (view != null && ilvManagerView != null) {
            this._context = new Context(context);
            this._context.setView(view);
            this._context.setProperty("oracle.diagram.inspector.ActiveInspectedView", (Object)view);
            if (this._selectionListener == null) {
                this._selectionListener = new DiagramExplorerSelectionListener();
                this.addViewSelectionListener(this._selectionListener);
            }
        }
        super.setContext(context);
    }

    protected IlvManagerView findActiveManagerView(View view) {
        if (view instanceof DiagramView) {
            return ((DiagramView)view).getActiveManagerView();
        }
        return null;
    }

    protected void initializeContextNode(Context context, TNode[] tNodeArray) {
        super.initializeContextNode(context, tNodeArray);
        if (this._context != null) {
            context.setProperty("oracle.diagram.inspector.ActiveInspectedView", this._context.getProperty("oracle.diagram.inspector.ActiveInspectedView"));
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public DTStructureExplorer() {
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(4);
        this.getJTree().setSelectionModel(defaultTreeSelectionModel);
    }

    protected Element annotate(Context context) {
        if (this._root == null) {
            this._root = new DefaultFolder();
            this._links = new ClusterLinksFolder();
            if (context.getNode() instanceof DTModelNode) {
                try {
                    if (this._engine != null) {
                        this._engine.getModel().removeSDMModelListener((SDMModelListener)this._SDModellistener);
                    }
                    this._engine = ((DTModelNode)context.getNode()).getEngine();
                    this._engine.getModel().addSDMModelListener((SDMModelListener)this._SDModellistener);
                    this.build();
                    if (this._view == null) {
                        this._view = context.getView();
                        this._view.addViewSelectionListener((ViewSelectionListener)new ClusterViewerSelectionListener(this));
                    }
                }
                catch (IOException iOException) {
                    return this._root;
                }
            }
        }
        return this._root;
    }

    protected void build() {
        if (this._thread == null || this._thread.getState() == Thread.State.TERMINATED) {
            this._thread = new PopulatingThread();
            this._thread.start();
        } else {
            this._thread.setState(POPULATION_STATE.RESTART);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishedBuilding() {
        try {
            TNode tNode = this.getRoot();
            this.refresh(tNode);
            List<TNode> list = this.buildSelectionFromView();
            this.setSelected(list.toArray(new TNode[0]));
        }
        finally {
            this.setRebuilding(false);
        }
    }

    void rebuild() {
        this.setRebuilding(true);
        this.build();
    }

    IlvSDMEngine getEngine() {
        return this._engine;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.updateSelection();
    }

    protected View findActiveDiagramView(Context context) {
        View view;
        List list = EditorManager.getEditorManager().findEditors(context);
        if (list != null && list.size() > 0 && (view = (View)list.get(0)) instanceof DiagramView) {
            return view;
        }
        return null;
    }

    public List<TNode> buildSelectionFromView() {
        Object object;
        ArrayList<TNode> arrayList = new ArrayList<TNode>();
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        Enumeration enumeration = ilvSDMEngine.getSelectedObjects();
        ArrayList<IlvMutableSDMNode> arrayList2 = new ArrayList<IlvMutableSDMNode>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            arrayList2.add((IlvMutableSDMNode)object);
        }
        object = this.getRoot();
        Enumeration enumeration2 = object.getChildTNodes();
        while (enumeration2.hasMoreElements()) {
            IlvMutableSDMNode ilvMutableSDMNode;
            Object object2;
            TNode tNode = (TNode)enumeration2.nextElement();
            Element element = tNode.getData();
            if (element instanceof DTExplorerNode) {
                object2 = (DTExplorerNode)element;
                ilvMutableSDMNode = object2.getDiagramObject();
                if (!arrayList2.contains(ilvMutableSDMNode)) continue;
                arrayList.add(tNode);
                continue;
            }
            if (!(element instanceof ClusterLinksFolder)) continue;
            object2 = tNode.getChildTNodes();
            while (object2.hasMoreElements()) {
                DTExplorerNode dTExplorerNode;
                ilvMutableSDMNode = (TNode)object2.nextElement();
                Element element2 = ilvMutableSDMNode.getData();
                if (!(element2 instanceof DTExplorerNode) || !arrayList2.contains((dTExplorerNode = (DTExplorerNode)element2).getDiagramObject())) continue;
                arrayList.add((TNode)ilvMutableSDMNode);
            }
        }
        return arrayList;
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    private class ClusterViewerSelectionListener
    implements ViewSelectionListener {
        DTStructureExplorer _explorer;

        public ClusterViewerSelectionListener(DTStructureExplorer dTStructureExplorer2) {
            this._explorer = dTStructureExplorer2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
            try {
                DTStructureExplorer.this.setAdjustingSelectionFromView(true);
                List<TNode> list = DTStructureExplorer.this.buildSelectionFromView();
                if (!list.isEmpty()) {
                    this._explorer.setSelected(list.toArray(new TNode[0]));
                } else {
                    this._explorer.setSelected(DTStructureExplorer.this.getRoot());
                }
            }
            finally {
                DTStructureExplorer.this.setAdjustingSelectionFromView(false);
            }
        }
    }

    private class DiagramExplorerSelectionListener
    implements ViewSelectionListener {
        private DiagramExplorerSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
            if (DTStructureExplorer.this.isAdjustingSelectionFromView() || DTStructureExplorer.this.isRebuilding()) {
                return;
            }
            Element[] elementArray = viewSelectionEvent.getSelection();
            Context context = DTStructureExplorer.this.getContext();
            View view = DTStructureExplorer.this.findActiveDiagramView(context);
            if (view == null || elementArray == null) {
                return;
            }
            IlvSDMEngine ilvSDMEngine = DTStructureExplorer.this.getEngine();
            IlvManagerView ilvManagerView = ((DiagramView)view).getActiveManagerView();
            IlvManager ilvManager = ilvManagerView.getManager();
            ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>(elementArray.length);
            for (Element element : elementArray) {
                DTExplorerNode dTExplorerNode;
                IlvMutableSDMNode ilvMutableSDMNode;
                IlvGraphic ilvGraphic;
                if (view == null || !(element instanceof DTExplorerNode) || (ilvGraphic = ilvSDMEngine.getGraphic((Object)(ilvMutableSDMNode = (dTExplorerNode = (DTExplorerNode)element).getDiagramObject()), false)) == null) continue;
                arrayList.add(ilvGraphic);
            }
            try {
                ilvManager.setSelectionAdjusting(true);
                SubSelectionManager.getInstance().setAdjusting(ilvManager, true);
                ilvManager.deSelectAll(true, true);
                SubSelectionManager.getInstance().deselectAll(ilvManager, true);
                for (IlvGraphic ilvGraphic : arrayList) {
                    ilvManager.setSelected(ilvGraphic, true, true);
                    view.updateSelection();
                }
            }
            finally {
                ilvManager.setSelectionAdjusting(false);
                SubSelectionManager.getInstance().setAdjusting(ilvManager, false);
                if (arrayList.size() != 0) {
                    ViewUtil.ensureVisible((IlvManagerView)ilvManagerView, (IlvGraphic)((IlvGraphic)arrayList.get(0)), (boolean)true);
                }
            }
        }
    }

    private class ExplorerSDMModelListener
    implements SDMModelListener {
        private ExplorerSDMModelListener() {
        }

        public void objectAdded(SDMModelEvent sDMModelEvent) {
            DTStructureExplorer.this.rebuild();
        }

        public void objectRemoved(SDMModelEvent sDMModelEvent) {
            DTStructureExplorer.this.rebuild();
        }

        public void linkSourceChanged(SDMModelEvent sDMModelEvent) {
        }

        public void linkDestinationChanged(SDMModelEvent sDMModelEvent) {
        }

        public void dataChanged(SDMModelEvent sDMModelEvent) {
            DTStructureExplorer.this.rebuild();
        }

        public void adjustmentFinished(SDMModelEvent sDMModelEvent) {
        }
    }

    private static class ClusterLinksFolder
    extends DefaultFolder {
        private List<DTTreeLink> _links = new ArrayList<DTTreeLink>();

        public String getShortLabel() {
            return "Links";
        }
    }

    private class PopulatingThread
    extends Thread {
        private POPULATION_STATE _state;

        public PopulatingThread() {
            super("Explorer Populating Thread");
        }

        @Override
        public void run() {
            this._state = POPULATION_STATE.IN_PROGRESS;
            while (this._state != POPULATION_STATE.FINISHED) {
                this._state = POPULATION_STATE.IN_PROGRESS;
                DTStructureExplorer.this._root.removeAll();
                DTStructureExplorer.this._links.removeAll();
                Enumeration enumeration = DTStructureExplorer.this._engine.getAllObjects();
                while (enumeration.hasMoreElements() && this._state != POPULATION_STATE.RESTART) {
                    Object e = enumeration.nextElement();
                    if (e instanceof DTTreeLink) {
                        DTStructureExplorer.this._links.add((Element)new DTExplorerNode((IlvMutableSDMNode)((DTTreeLink)((Object)e))));
                        continue;
                    }
                    if (!(e instanceof DTTreeNode)) continue;
                    DTStructureExplorer.this._root.add((Element)new DTExplorerNode((IlvMutableSDMNode)((DTTreeNode)e)));
                }
                if (this._state == POPULATION_STATE.RESTART) continue;
                if (DTStructureExplorer.this._links.getChildren().hasNext()) {
                    DTStructureExplorer.this._root.add((Element)DTStructureExplorer.this._links);
                }
                this._state = POPULATION_STATE.FINISHED;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTStructureExplorer.this.finishedBuilding();
                }
            });
        }

        public void setState(POPULATION_STATE pOPULATION_STATE) {
            this._state = pOPULATION_STATE;
        }
    }

    public static enum POPULATION_STATE {
        IN_PROGRESS,
        RESTART,
        FINISHED;

    }
}

