/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.pca;

import java.awt.Color;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphDataModel;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.pca.PCACoefficientRowData;
import oracle.dmt.dataminer.mviewer.pca.PCAValuesTableModel;
import oracle.dmt.dataminer.mviewer.pca.ScreePlotLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class ScreePlotViewerState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(ScreePlotViewerState.class.getName());
    private boolean _loaded;
    private String _modelName;
    private String _userName;
    private GraphDataModel graphDataModel;
    private PCAValuesTableModel _model = new PCAValuesTableModel();
    private List<String> features = new ArrayList<String>();
    private List<Double> variances = new ArrayList<Double>();
    private List<Double> pctCumVariances = new ArrayList<Double>();
    private List<NameValuePair> _settings = null;
    static final Color[] colors = new Color[]{Color.RED, Color.BLUE};

    public ScreePlotViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "pca_viewer_scree";
        return new HelpInfo(string);
    }

    public int getNumberOfFeatures() {
        return this.features.size();
    }

    public String getSuggetsedCutofValue() {
        Object object = null;
        for (NameValuePair nameValuePair : this._settings) {
            if (!nameValuePair.getName().equals("SUGGESTED_CUTOFF")) continue;
            object = nameValuePair.getValue();
            break;
        }
        return object != null ? object.toString() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        this._modelViewerState1 = new ModelViewerState1(this._context);
        this._modelViewerState1.load(null);
        this._modelName = this._modelViewerState1.getModelName();
        this._userName = this._modelViewerState1.getUserName();
        Connection connection = null;
        try {
            this._loaded = false;
            connection = Connections.getUniqueConnection(this._context);
            this._settings = GlobalDetails.getModelDetailsGlobal(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
            this.loadScreePlotData(connection);
            this._loaded = true;
        }
        catch (Throwable throwable) {
            SQLHelper.close(connection);
            throw throwable;
        }
        SQLHelper.close(connection);
    }

    public void loadScreePlotData(Connection connection) throws Exception {
        boolean bl;
        this.features.clear();
        this.variances.clear();
        this.pctCumVariances.clear();
        SingularValueDecomposition.loadScreePlotValues(connection, this._userName, this._modelName, this.features, this.variances, this.pctCumVariances);
        if (this.pctCumVariances.isEmpty() || this.variances.isEmpty() || this.features.isEmpty()) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        boolean bl2 = bl = this.features.size() == this.variances.size() && this.features.size() == this.pctCumVariances.size();
        if (!bl) {
            throw new Exception(ScreePlotLrb.get("SCREE_PLOT_DATA_IS_NOTAVAILABLE"));
        }
        int n = this.features.size();
        int n2 = 2;
        Object[][] objectArray = new Object[n][n2];
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new String[]{ScreePlotLrb.get("SCREE_PLOT_VARIANCE"), ScreePlotLrb.get("SCREE_PLOT_PCT_CUM_VARIANCE")};
        Vector<PCACoefficientRowData> vector = new Vector<PCACoefficientRowData>();
        for (int i = 0; i < this.features.size(); ++i) {
            objectArray2[i] = this.features.get(i);
            objectArray[i][0] = this.variances.get(i);
            objectArray[i][1] = this.pctCumVariances.get(i);
            PCACoefficientRowData pCACoefficientRowData = new PCACoefficientRowData(this.features.get(i), this.variances.get(i) * this.variances.get(i), this.variances.get(i), this.pctCumVariances.get(i));
            vector.add(pCACoefficientRowData);
        }
        this._model = new PCAValuesTableModel(vector);
        this.graphDataModel = new DefaultGraphDataModel(null, 43, null, null, null);
        this.graphDataModel.addColumnLabels(objectArray2);
        this.graphDataModel.addRowLabels(objectArray3);
        this.graphDataModel.addGraphData(objectArray);
        this.graphDataModel.addRowColors(colors);
        this.graphDataModel.setLegendVisible(true);
        this.graphDataModel.setTitle(this._modelName);
    }

    public GraphDataModel getGraphDataModel() {
        return this.graphDataModel;
    }

    public PCAValuesTableModel getModel() {
        return this._model;
    }

    public void clearRows() {
        this._model.clearRows();
    }

    public boolean isFeatureLabelUniquie(String string) {
        return SingularValueDecomposition.isFeatureLabelUniquie(string);
    }

    public String renameFeatureLabel(String string, String string2) throws Exception {
        Connection connection = null;
        String string3 = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            string3 = SingularValueDecomposition.renameFeatureLabel(connection, this._userName, this._modelName, string, string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return string3;
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }

    public void updateFeature(String string, String string2) {
        int n = this.features.indexOf(string);
        if (-1 != n) {
            this.features.set(n, string2);
            Object[] objectArray = this.graphDataModel.getColumnLabels();
            Object[] objectArray2 = this.graphDataModel.getRowLabels();
            Object[][] objectArray3 = this.graphDataModel.getGraphData();
            objectArray[n] = string2;
            this.graphDataModel.clear();
            this.graphDataModel.addColumnLabels(objectArray);
            this.graphDataModel.addRowLabels(objectArray2);
            this.graphDataModel.addGraphData(objectArray3);
            this.graphDataModel.addRowColors(colors);
            this.graphDataModel.setLegendVisible(true);
            this.graphDataModel.setTitle(this._modelName);
        }
    }
}

