/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.Vector;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SettingsViewerFeaturesTableModel
extends GenericBaseTableModel {
    private Vector<AbstractBuildNode.TextFeature> _data = new Vector();
    public static final int FEATURE_NAME = 0;
    public static final int FEATURE_TYPE = 1;
    public static final int FEATURE_FREQUENCY = 2;
    private static final String[] _columnNames = new String[]{SettingsLrb.get("FEATURE_NAME"), SettingsLrb.get("FEATURE_TYPE"), SettingsLrb.get("FEATURE_FREQUENCY")};

    public SettingsViewerFeaturesTableModel() {
        this.setColumnIdentifiers(_columnNames);
        this.setRowCount(0);
        this.setColumnCount(_columnNames.length);
    }

    public SettingsViewerFeaturesTableModel(Vector<AbstractBuildNode.TextFeature> vector) {
        this.setColumnIdentifiers(_columnNames);
        this._data = vector;
        this.setRowCount(this.getRowCount());
        this.setColumnCount(_columnNames.length);
    }

    public void loadData(Vector<AbstractBuildNode.TextFeature> vector) {
        assert (vector != null) : "Input data is missing.";
        this.clearRows();
        this._data.addAll(vector);
        this.fireTableDataChanged();
    }

    private void clearRows() {
        if (!this._data.isEmpty()) {
            this._data.clear();
        }
    }

    public void loadStatus(String string) {
        this.clearRows();
        AbstractBuildNode.TextFeature textFeature = new AbstractBuildNode.TextFeature("", string, "", null);
        this.addRow(textFeature);
        this.setRowCount(1);
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        return this._data == null ? 0 : this._data.size();
    }

    public Class<?> getColumnClass(int n) {
        if (n == 2) {
            return Integer.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
        if (this._data == null || this._data.size() == 0) {
            return null;
        }
        AbstractBuildNode.TextFeature textFeature = this._data.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = textFeature.getName();
                break;
            }
            case 1: {
                object = ServerConstants.StopTokenType.toHuman(textFeature.getType());
                break;
            }
            case 2: {
                object = textFeature.getFrequency();
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        return object;
    }

    public void addRow(AbstractBuildNode.TextFeature textFeature) {
        this._data.add(textFeature);
    }
}

