/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.util.Vector;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SettingsViewerSignatureTableModel
extends GenericBaseTableModel {
    private Vector<MiningAttributeInfo> _data = new Vector();
    private static final int COLUMN_COUNT = 5;
    public static final int ATTRIBUTE_NAME = 0;
    public static final int DATA_TYPE = 1;
    public static final int MINING_TYPE = 2;
    public static final int IS_TARGET = 3;
    public static final int DATA_PREP = 4;
    private String[] _columnNames = new String[]{SettingsLrb.get("ATTRIBUTE_NAME_SHORT"), SettingsLrb.get("DATA_TYPE"), SettingsLrb.get("MINING_TYPE"), SettingsLrb.get("TARGET"), SettingsLrb.get("DATA_PREP")};

    public SettingsViewerSignatureTableModel() {
        this.setColumnIdentifiers(this._columnNames);
        this.setRowCount(0);
        this.setColumnCount(5);
    }

    public SettingsViewerSignatureTableModel(Vector<MiningAttributeInfo> vector) {
        this.setColumnIdentifiers(this._columnNames);
        this._data = vector;
        this.setRowCount(vector.size());
        this.setColumnCount(5);
    }

    public int getRowCount() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public void clearRows() {
        this._data.clear();
        this.setRowCount(0);
        this.fireTableDataChanged();
    }

    public String getTargetAttributeName() {
        String string = null;
        for (MiningAttributeInfo miningAttributeInfo : this._data) {
            if (miningAttributeInfo.getTarget().compareTo("YES") != 0) continue;
            string = miningAttributeInfo.getAttributeName();
            break;
        }
        return string;
    }

    public MiningAttributeInfo getTargetAttributeInfo() {
        MiningAttributeInfo miningAttributeInfo = null;
        for (MiningAttributeInfo miningAttributeInfo2 : this._data) {
            if (!"YES".equals(miningAttributeInfo2.getTarget())) continue;
            miningAttributeInfo = miningAttributeInfo2;
            break;
        }
        return miningAttributeInfo;
    }

    public Vector<MiningAttributeInfo> getTextAttributesInfo() {
        Vector<MiningAttributeInfo> vector = new Vector<MiningAttributeInfo>();
        for (MiningAttributeInfo miningAttributeInfo : this._data) {
            if (!"TEXT".equals(miningAttributeInfo.getAttributeType())) continue;
            vector.add(miningAttributeInfo);
        }
        return vector;
    }

    public Object getValueAt(int n, int n2) {
        assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
        assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
        MiningAttributeInfo miningAttributeInfo = this._data.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = miningAttributeInfo.getAttributeName();
                break;
            }
            case 1: {
                string = miningAttributeInfo.getDataType();
                break;
            }
            case 2: {
                string = ServerConstants.MiningType.toHuman(miningAttributeInfo.getAttributeType());
                break;
            }
            case 3: {
                if (miningAttributeInfo.getTarget().compareTo("YES") == 0) {
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                string = SettingsLrb.get("ATTRIBUTE_TARGET_NO");
                break;
            }
            case 4: {
                StringBuffer stringBuffer = miningAttributeInfo.getExpression();
                if (miningAttributeInfo.getDataType().equals("DM_NESTED_NUMERICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_CATEGORICALS") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_DOUBLES") || miningAttributeInfo.getDataType().equals("DM_NESTED_BINARY_FLOATS") || miningAttributeInfo.getDataType().equals("NESTED TABLE")) {
                    if (stringBuffer.toString().equals(miningAttributeInfo.getRevExpression().toString()) && -1 != stringBuffer.toString().indexOf("value")) {
                        string = SettingsLrb.get("ATTRIBUTE_TARGET_NO");
                        break;
                    }
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                if (miningAttributeInfo.isDataPrep()) {
                    string = SettingsLrb.get("ATTRIBUTE_TARGET_YES");
                    break;
                }
                string = "";
                break;
            }
            default: {
                assert (false) : "Out of bounds column when accessing model attributes";
                break;
            }
        }
        if (string == null) {
            return "NULL";
        }
        return string;
    }

    public void addRow(MiningAttributeInfo miningAttributeInfo) {
        this._data.add(miningAttributeInfo);
    }

    public Vector<MiningAttributeInfo> getDataVector() {
        return this._data;
    }
}

