/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.settings;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.CostMatrixDataProvider;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.LoadingCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.MatrixInfo;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.controls.ReadOnlyCostMatrixModel;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.settings.SettingsLrb;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerFeaturesTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerGeneralTreeTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerSignatureTableModel;
import oracle.dmt.dataminer.mviewer.settings.SettingsViewerTextAttrsTableModel;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ANModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ARModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.DTModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.GLMRModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NBModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.NMFModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.PCAModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVDModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMCModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.SVMRModelNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.MiningAttributeInfo;
import oracle.dmt.dataminer.server.model.MiningModelAttributes;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class SettingsViewerState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(SettingsViewerState.class.getName());
    private boolean _loaded;
    private Context _serverContext = null;
    private SettingsViewerSignatureTableModel _signatureTableModel;
    private SettingsViewerGeneralTreeTableModel _treetableModel;
    private SettingsViewerFeaturesTableModel _featuresTableModel;
    private SettingsViewerTextAttrsTableModel _textAttrsTableModel;
    private Vector<AbstractBuildNode.TextFeature> _textFeatures;
    private MiningAttributeInfo _lastSelectedAttr;
    private MiningAttributeInfo _lastSelectedTextAttr;
    private ReadOnlyCostMatrixModel _costMatrixModel;
    private GenericBaseTableModel _weightsModel;
    private TargetValues _targetValues;
    private static final int WEIGHT_COLUMN_COUNT = 2;
    private static final int WEIGHT_TARGET_VALUE = 0;
    private static final int WEIGHT_VALUE = 1;
    private static String[] _weight_columnNames = new String[]{DialogsLrb.get("PERFORMANCE_WEIGHTS_TARGET_VALUE"), DialogsLrb.get("PERFORMANCE_WEIGHTS_WEIGHT_VALUE")};

    public SettingsViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this._treetableModel = new SettingsViewerGeneralTreeTableModel();
        Node node = this._context.getNode();
        if (node instanceof ModelNode) {
            this._loadFromServer = true;
            this._serverContext = context;
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        ModelNode modelNode = (ModelNode)this._context.getNode();
        String string = "Help Topic Not Specified";
        if (modelNode instanceof ARModelNode) {
            string = "ar_view_settings";
        } else if (modelNode instanceof DTModelNode) {
            string = "tree_diagram_settings";
        } else if (modelNode instanceof GLMCModelNode) {
            string = "glmc_settings";
        } else if (modelNode instanceof GLMRModelNode) {
            string = "glmr_settings_help";
        } else if (modelNode instanceof SVMCModelNode) {
            string = "svmc_settings";
        } else if (modelNode instanceof ANModelNode) {
            string = "ad_viewer_settings";
        } else if (modelNode instanceof SVMRModelNode) {
            string = "svmr_settings";
        } else if (modelNode instanceof NMFModelNode) {
            string = "nmf_viewer_settings";
        } else if (modelNode instanceof NBModelNode) {
            string = "nb_viewer_settings";
        } else if (modelNode instanceof OCModelNode) {
            string = "oc_viewer_settings";
        } else if (modelNode instanceof KMModelNode) {
            string = "km_viewer_settings";
        } else if (modelNode instanceof EMClusterModelNode) {
            string = "clus_viewer_settings";
        } else if (modelNode instanceof PCAModelNode) {
            string = "pca_viewer_settings";
        } else if (modelNode instanceof SVDModelNode) {
            string = "svd_viewer_settings";
        }
        return new HelpInfo(string);
    }

    public void loadTempStatusTreeTable(String string) {
        this._treetableModel.loadTempStatusNode(string);
    }

    public ReadOnlyCostMatrixModel createDummyCostMatrix(String string) {
        return new LoadingStatusCostMatrix(new LoadingCostMatrixDataProvider(), string);
    }

    private Connection getConnection() throws Exception {
        if (this._loadFromServer) {
            return Connections.getUniqueConnection(this._serverContext);
        }
        return Connections.getUniqueConnection(this._context);
    }

    private void loadTargetAttribute() {
        this._modelViewerState1.getModelDesc().setTargetAttributeName(this._signatureTableModel.getTargetAttributeName());
    }

    private void loadTextAttributes() {
        Vector<MiningAttributeInfo> vector = this._signatureTableModel.getTextAttributesInfo();
        this._textAttrsTableModel = new SettingsViewerTextAttrsTableModel(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextFeatures(String string) {
        this._textFeatures = new Vector();
        Connection connection = null;
        try {
            connection = this.getConnection();
            String string2 = "select ATTRIBUTE_NAME, FEATURE_NAME, FREQUENCY, TYPE from\n(\n  select t.ATTRIBUTE_NAME, t.FEATURE_NAME, t.FREQUENCY, SUBSTR(s.ATTRIBUTE_SPEC, INSTR(s.ATTRIBUTE_SPEC,'TOKEN_TYPE:',-1,1)+LENGTH('TOKEN_TYPE:'), 10) \"TYPE\" from\n  table(ODM_UTIL.SYS_DM_TEXT_DF('<owner>.<model>', '<column>')) t, ALL_MINING_MODEL_ATTRIBUTES s\n  where s.OWNER='<owner>' and s.MODEL_NAME='<model>' and s.ATTRIBUTE_NAME='<column>'\n) order by frequency desc, feature_name\n";
            SQLHelper sQLHelper = new SQLHelper();
            int n = 300;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = StringUtils.getReplacedString(string2, "<owner>", this._modelViewerState1.getUserName());
            String string4 = StringUtils.getReplacedString(string3, "<model>", this._modelViewerState1.getModelName());
            String string5 = StringUtils.getReplacedString(string4, "<column>", string);
            stringBuffer.append(string5);
            sQLHelper.pstmt = connection.prepareStatement(stringBuffer.toString());
            sQLHelper.pstmt.setFetchSize(n);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string6 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string7 = sQLHelper.rs.getString("FEATURE_NAME");
                int n2 = sQLHelper.rs.getInt("FREQUENCY");
                String string8 = sQLHelper.rs.getString("TYPE");
                string8 = string8.startsWith("NORMAL") || string8.startsWith("STEM") ? "Word" : (string8.startsWith("THEME") ? "Theme" : "Unknown");
                AbstractBuildNode.TextFeature textFeature = new AbstractBuildNode.TextFeature(string6, string7, string8, n2);
                this._textFeatures.add(textFeature);
            }
            this._featuresTableModel = new SettingsViewerFeaturesTableModel();
            this._featuresTableModel.loadData(this._textFeatures);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    public SettingsViewerState load() throws Exception {
        Connection connection = null;
        Exception exception = null;
        try {
            connection = this.getConnection();
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            try {
                if (!this.isAR() && !this.isAI()) {
                    this.loadAttributes(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
                    if (!this.isAnomaly()) {
                        this.loadTargetAttribute();
                    }
                    this.loadTextAttributes();
                }
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            try {
                if (this.isClassification()) {
                    this.loadCostMatrix(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
                    if (!this.isAnomaly()) {
                        this.loadTargetValues(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            try {
                if (this.isClassification()) {
                    this.loadWeights(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
                }
            }
            catch (Exception exception4) {
                exception = exception4;
            }
            if (exception != null) {
                this._loaded = false;
                throw exception;
            }
            this._loaded = true;
        }
        catch (Exception exception5) {
            throw exception5;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    public void loadTree() {
        this._treetableModel.loadTree(this._modelViewerState1.getOdmModel());
    }

    public int getMaxStringLength() {
        return this._treetableModel.getMaxStringLength();
    }

    public SettingsViewerState reloadAttributes() throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.loadAttributes(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    private void loadTargetValues(Connection connection, String string, String string2) throws Exception {
        Classification classification = new Classification();
        Vector<TargetPriorsPredictionSet> vector = classification.getTargetValuePredictionSet(connection, string, string2);
        boolean bl = false;
        if (vector.size() > 0) {
            bl = vector.get(0).getPredictionDataType() == 1 || vector.get(0).getPredictionDataType() == 12;
        } else {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        TargetValues targetValues = new TargetValues();
        for (TargetPriorsPredictionSet targetPriorsPredictionSet : vector) {
            if (bl) {
                arrayList.add((String)targetPriorsPredictionSet.getPrediction());
                continue;
            }
            arrayList2.add(((BigDecimal)targetPriorsPredictionSet.getPrediction()).doubleValue());
        }
        if (bl) {
            targetValues.getTargetValueString().addAll(arrayList);
        } else {
            targetValues.getTargetValueNumber().addAll(arrayList2);
        }
        this._targetValues = targetValues;
    }

    private void loadAttributes(Connection connection, String string, String string2) throws Exception {
        Object object;
        TNode tNode;
        WorkflowNode workflowNode;
        WorkflowModel workflowModel;
        Map<String, ModelType> map;
        ModelType modelType;
        Vector<MiningAttributeInfo> vector = null;
        MiningAttributes miningAttributes = null;
        Node node = this._context.getNode();
        if (node instanceof BaseTreeNode && (modelType = (map = (workflowModel = (workflowNode = (WorkflowNode)(tNode = ((BaseTreeNode)(object = (BaseTreeNode)node)).getParent()).getAncestor(WorkflowNode.class)).getWorkflowModel()).getAllMiningModels()).get(string2)) != null) {
            miningAttributes = modelType.getInputMiningData().getMiningAttributes();
        }
        if ((object = Model.getMiningModelAttributes(connection, string, string2, miningAttributes != null ? miningAttributes.getMiningAttribute() : null)) == null) {
            throw new Exception(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"));
        }
        vector = ((MiningModelAttributes)object).getAttributes();
        if (vector == null) {
            throw new Exception(SettingsLrb.get("MODEL_SETTINGS_VIEWER_FAILURE_TITLE"));
        }
        this._signatureTableModel = new SettingsViewerSignatureTableModel(vector);
    }

    private void loadCostMatrix(Connection connection, String string, String string2) {
        try {
            CostMatrixInfo costMatrixInfo = Model.getModelCostMatrix(connection, string, string2);
            this._costMatrixModel = costMatrixInfo == null || !costMatrixInfo.isCostMatrixTrue() || costMatrixInfo.isEmpty() ? null : new ReadOnlyCostMatrixModel(new CostMatrixDataProvider(costMatrixInfo));
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this._costMatrixModel = null;
        }
    }

    private void loadWeights(Connection connection, String string, String string2) throws Exception {
        block12: {
            if (this.isDT()) {
                try {
                    CostMatrixInfo costMatrixInfo = Model.getModelBuildCostMatrix(connection, string, string2);
                    if (costMatrixInfo == null || !costMatrixInfo.isCostMatrixTrue() || costMatrixInfo.isEmpty()) {
                        this._weightsModel = null;
                        break block12;
                    }
                    this._weightsModel = new ReadOnlyCostMatrixModel(new CostMatrixDataProvider(costMatrixInfo));
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    this._weightsModel = null;
                }
            } else {
                MatrixInfo matrixInfo = null;
                try {
                    if (this.isSVM()) {
                        matrixInfo = Model.getSVMWeights(connection, string, string2);
                    } else if (this.isNB()) {
                        matrixInfo = Model.getNBPriors(connection, string, string2);
                    } else if (this.isGLM()) {
                        matrixInfo = Model.getGLMWeights(connection, string, string2);
                    }
                    this._weightsModel = matrixInfo == null || matrixInfo.isEmpty() ? null : new WeightModel(matrixInfo);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    this._weightsModel = null;
                }
            }
        }
    }

    @Override
    public boolean isSVM() {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isSupportVectorMachinesAlgorithm();
        }
        return this.isSVMRepository();
    }

    public boolean isDT() {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isDecisionTreeAlgorithm();
        }
        return this.isDTRepository();
    }

    public boolean isAR() throws Exception {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isAPrioriAssociationRulesAlgorithm();
        }
        return false;
    }

    public boolean isAI() throws Exception {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isAttributeImportanceModel();
        }
        return false;
    }

    @Override
    public boolean isGLM() {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isGeneralizedLinearModelAlgorithm();
        }
        return this.isGLMRepository();
    }

    @Override
    public boolean isNB() {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isNaiveBayesAlgorithm();
        }
        return this.isNBRepository();
    }

    @Override
    public boolean isClassification() {
        if (this._loadFromServer) {
            ModelGeneralDescription modelGeneralDescription = this._modelViewerState1.getOdmModel().getModelGeneralDescription();
            return modelGeneralDescription.isClassificationModel();
        }
        return false;
    }

    private boolean isDTRepository() {
        return this._algorithm != null ? ServerConstants.Algorithm.isDT(this._algorithm) : false;
    }

    private boolean isSVMRepository() {
        return this._algorithm != null ? ServerConstants.Algorithm.isSVM(this._algorithm) : false;
    }

    private boolean isNBRepository() {
        return this._algorithm != null ? ServerConstants.Algorithm.isNB(this._algorithm) : false;
    }

    private boolean isGLMRepository() {
        return this._algorithm != null ? ServerConstants.Algorithm.isGLM(this._algorithm) : false;
    }

    public SettingsViewerSignatureTableModel getSignatureTableModel() {
        return this._signatureTableModel;
    }

    public GenericBaseTableModel getWeightsModel() {
        assert (this._loaded) : "Accesing model weights prior to loading.";
        return this._weightsModel;
    }

    public ReadOnlyCostMatrixModel getCostMatrix() {
        assert (this._loaded) : "Accesing model cost benefit info prior to loading.";
        return this._costMatrixModel;
    }

    public SettingsViewerGeneralTreeTableModel getGeneralTreeTableModel() {
        return this._treetableModel;
    }

    public MiningAttributeInfo getLastSelectedAttribute() {
        return this._lastSelectedAttr;
    }

    public void setLastSelectedAttribute(int n) {
        if (n == -1) {
            this._lastSelectedAttr = null;
            return;
        }
        this._lastSelectedAttr = this._signatureTableModel.getDataVector().elementAt(n);
    }

    public TargetValues getTargetValues() {
        return this._targetValues;
    }

    public MiningAttributeInfo getLastSelectedTextAttribute() {
        return this._lastSelectedTextAttr;
    }

    public void setLastSelectedTextAttribute(int n) {
        if (n == -1) {
            this._lastSelectedTextAttr = null;
            return;
        }
        this._lastSelectedTextAttr = this._textAttrsTableModel.getDataVector().elementAt(n);
    }

    public SettingsViewerTextAttrsTableModel getTextAttrsTableModel() {
        return this._textAttrsTableModel;
    }

    public SettingsViewerFeaturesTableModel getFeaturesTableModel() {
        return this._featuresTableModel;
    }

    public Vector<AbstractBuildNode.TextFeature> getTextFeatures() {
        return this._textFeatures;
    }

    public GenericBaseTableModel createDummyWeightModel(String string) {
        if (this.isDT()) {
            return this.createDummyCostMatrix(string);
        }
        return new LoadingWeightModel(string);
    }

    private class LoadingWeightModel
    extends WeightModel {
        private String _message;

        private LoadingWeightModel(String string) {
            this._message = string;
            this.setColumnIdentifiers(_weight_columnNames);
            this.setRowCount(1);
            this.setColumnCount(2);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && n2 == 0) {
                return this._message;
            }
            return "";
        }
    }

    private class WeightModel
    extends GenericBaseTableModel {
        private MatrixInfo _pInfo;

        private WeightModel() {
        }

        private WeightModel(MatrixInfo matrixInfo) {
            this._pInfo = matrixInfo;
            this.setColumnIdentifiers(_weight_columnNames);
            this.setRowCount(matrixInfo != null ? matrixInfo.getRowCount() : 0);
            this.setColumnCount(2);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            if (this._pInfo == null) {
                return null;
            }
            String string = null;
            ArrayList<NameValuePair> arrayList = this._pInfo.getValues();
            if (arrayList == null) {
                return string;
            }
            switch (n2) {
                case 0: {
                    string = arrayList.get(n).getName();
                    break;
                }
                case 1: {
                    string = NumericFormat.format(((BigDecimal)arrayList.get(n).getValue()).doubleValue(), true, 8) + "";
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    private class LoadingStatusCostMatrix
    extends ReadOnlyCostMatrixModel {
        private String _text;

        private LoadingStatusCostMatrix(BaseCostMatrixDataProvider baseCostMatrixDataProvider, String string) {
            super(baseCostMatrixDataProvider);
            this._text = string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0 && n2 == 0) {
                return this._text;
            }
            return "";
        }
    }
}

