/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesState;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RenameFeaturePanel
extends JPanel
implements DataminerGUIPanel {
    private String _currentName;
    private Context _context;
    private SingularValuesState state;
    private JEWTDialog parentDlg;
    private JLabel _jRenameLabel;
    private JTextField _jRenameValue;

    public RenameFeaturePanel(Context context, SingularValuesState singularValuesState, String string) {
        this._context = context;
        this._currentName = string;
        this.state = singularValuesState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jRenameLabel = new JLabel();
        this._jRenameValue = new JTextField();
        this._jRenameLabel.setText("Rename To:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jRenameLabel, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jRenameValue, -1, 268, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jRenameLabel).addComponent(this._jRenameValue, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jRenameLabel, (Component)this._jRenameValue, (String)SVDLrb.get("FEATURE_RENAME_TO_LABEL"));
        this._jRenameLabel.getAccessibleContext().setAccessibleDescription(SVDLrb.get("FEATURE_RENAME_TO_LABEL_ADA"));
        this._jRenameValue.setDocument(new TextFieldLimit(30));
    }

    @Override
    public void initUI() {
        this._jRenameValue.setText(this._currentName);
    }

    public boolean doWork() {
        String string = this._jRenameValue.getText().trim();
        if (string.isEmpty()) {
            MessageDialog.error((Component)this.parentDlg, (Object)SVDLrb.get("FEATURE_NAME_EMPTY"), (String)SVDLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (string.length() > 4000) {
            MessageDialog.error((Component)this.parentDlg, (Object)SVDLrb.get("FEATURE_NAME_TOO_LONG"), (String)SVDLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (string.equals(this._currentName)) {
            MessageDialog.information((Component)this.parentDlg, (Object)SVDLrb.get("FEATURE_NAME_ALEADY_USED"), (String)SVDLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        if (!this.state.isFeatureLabelUniquie(string)) {
            MessageDialog.information((Component)this.parentDlg, (Object)SVDLrb.get("FEATURE_NAME_ALEADY_USED"), (String)SVDLrb.get("FEATURE_ERROR_TITLE"), null);
            return false;
        }
        this._currentName = string;
        return true;
    }

    public String getCurrentName() {
        return this._currentName;
    }

    public void setParentDlg(JEWTDialog jEWTDialog) {
        this.parentDlg = jEWTDialog;
    }

    public JEWTDialog getParentDlg() {
        return this.parentDlg;
    }
}

