/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientEditor;
import oracle.dmt.dataminer.mviewer.svd.RenameFeatureDialog;
import oracle.dmt.dataminer.mviewer.svd.SVDLrb;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesEditor;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesState;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesTableModel;
import oracle.dmt.dataminer.utils.NumericFormat;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;

public class SingularValuesPanel
extends DataMinerViewGUI {
    private static Preferences _p = Preferences.getPreferences();
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)_p);
    private SingularValuesState _state;
    private JButton _renameBtn;
    private BlockingComponent overLayPanel = null;
    private DataMinerTablePanel dataMinerTablePanel;

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    public SingularValuesPanel(SingularValuesEditor singularValuesEditor, Context context) {
        super(singularValuesEditor, context);
        this._state = new SingularValuesState(context);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    private void initComponents() {
        this.dataMinerTablePanel = new DataMinerTablePanel();
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.dataMinerTablePanel, -1, 472, Short.MAX_VALUE).addGap(0, 0, 0)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.dataMinerTablePanel, -1, 259, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    @Override
    public void initUI() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        NumberFormat numberFormat = NumericFormat.getInstance(true, this._modelViewerPrefenceSettings.getNumericalPrecisionLevel());
        dataMinerTable.addFormatter(1, numberFormat);
        ListSelectionModel listSelectionModel = dataMinerTable.getSelectionModel();
        dataMinerTable.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SingularValuesPanel.this._renameBtn.setEnabled(-1 != listSelectionEvent.getFirstIndex());
            }
        });
        dataMinerTable.setFillsViewportHeight(true);
        this.addCustomButons();
        dataMinerTable.setShowGrid(true);
        dataMinerTable.setSorted(true);
        dataMinerTable.setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
        dataMinerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    SingularValuesPanel.this.rename();
                }
            }
        });
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public void initRes() {
        this.dataMinerTablePanel.setTitle(SVDLrb.get("COMPONENT_TITLE"));
    }

    public void reload() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reload(String string, String string2) {
        if (string.equals(this._state.getUserName()) && string2.equals(this._state.getModelName())) {
            LoadUI loadUI = new LoadUI();
            loadUI.execute();
        }
    }

    protected void addCustomButons() {
        this.dataMinerTablePanel.removeSearchField();
        this._renameBtn = new JButton(SVDLrb.get("RENAME_FEATURE_BUTTON"));
        this._renameBtn.setToolTipText(SVDLrb.get("RENAME_FEATURE_BUTTON_TOOL_TIP"));
        this._renameBtn.setEnabled(true);
        this._renameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingularValuesPanel.this.rename();
            }
        });
        this._renameBtn.setEnabled(false);
        this.dataMinerTablePanel.addControlBarComponents(this._renameBtn);
    }

    protected void refreshActiveSVDCoefficientsEditor() {
        List list = EditorManager.getEditorManager().findEditors(this._context);
        for (Object e : list) {
            if (!(e instanceof CoefficientEditor)) continue;
            CoefficientEditor coefficientEditor = (CoefficientEditor)e;
            coefficientEditor.refresh(this._state.getUserName(), this._state.getModelName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        int[] nArray = dataMinerTable.getSelectedRowsInModel();
        RenameFeatureDialog renameFeatureDialog = new RenameFeatureDialog();
        String string = this._state.getModel().getDataVector().get(nArray[0]).getAttributeName();
        if (renameFeatureDialog.invoke(this._context, this._state, string)) {
            Cursor cursor = this.getCursor();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                String string2 = this._state.renameFeatureLabel(renameFeatureDialog.getCurrentName(), string);
                ((SingularValuesTableModel)((Object)dataMinerTable.getModel())).updateFeatureID(string2, string, nArray[0]);
                this.refreshActiveSVDCoefficientsEditor();
                this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
            }
            catch (Exception exception) {
                try {
                    if (exception.getMessage().equals(SVDLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)SVDLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"), (String)SVDLrb.get("FEATURE_RENAME_FAILURE_TITLE"), null);
                    } else {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)SVDLrb.get("FEATURE_RENAME_FAILURE_TITLE"), (String)SVDLrb.get("FEATURE_RENAME_FAILURE_MESG"), null);
                    }
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                }
                catch (Throwable throwable) {
                    this.setCursor(cursor != null ? cursor : Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
        }
    }

    private class LoadUI
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                SingularValuesPanel.this.dataMinerTablePanel.getTable().setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
                SingularValuesPanel.this._state.load();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return SingularValuesPanel.this._state;
        }

        @Override
        protected void done() {
            super.done();
            DataMinerTable dataMinerTable = SingularValuesPanel.this.dataMinerTablePanel.getTable();
            try {
                if (this._success && this._ex == null) {
                    dataMinerTable.setModel((TableModel)((Object)SingularValuesPanel.this._state.getModel()));
                    dataMinerTable.setSortColumn(0, true);
                    dataMinerTable.setSorted(true);
                } else {
                    dataMinerTable.setNoEntryInstructionText(SVDLrb.get("SINGULAR_VALUES_FAILURE"));
                    if (SingularValuesPanel.this._state.getModel() != null) {
                        SingularValuesPanel.this._state.clearRows();
                    }
                    if (this._ex != null) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_TITLE"), (String)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_MESG"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_MESG"), (String)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_TITLE"), null);
                    }
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_TITLE"), (String)SVDLrb.get("SINGULAR_VALUES_VIEWER_FAILURE_MESG"), null);
            }
            if (SingularValuesPanel.this.overLayPanel != null) {
                SingularValuesPanel.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
        }
    }
}

