/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.svd.SingularValuesTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.server.model.SingularValueDecomposition;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;

public class SingularValuesState
extends BaseViewerState {
    private static final Logger theLogger = Logger.getLogger(SingularValuesState.class.getName());
    private ModelViewerState1 _modelViewerState1;
    private String _modelName;
    private String _userName;
    private Context _context;
    private boolean _loaded;
    private SingularValuesTableModel _model = new SingularValuesTableModel();

    public SingularValuesState() {
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "svd_viewer_singular";
        return new HelpInfo(string);
    }

    public SingularValuesState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
    }

    public boolean isFeatureLabelUniquie(String string) {
        return SingularValueDecomposition.isFeatureLabelUniquie(string);
    }

    public String renameFeatureLabel(String string, String string2) throws Exception {
        Connection connection = null;
        String string3 = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            string3 = SingularValueDecomposition.renameFeatureLabel(connection, this._userName, this._modelName, string, string2);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            SQLHelper.close(connection);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(this._context);
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            this._modelName = this._modelViewerState1.getModelName();
            this._userName = this._modelViewerState1.getUserName();
            while (SingularValueDecomposition.isLoading()) {
                theLogger.log(Level.FINEST, "waiting");
                this.wait(100L);
            }
            if (SingularValueDecomposition.isFeatureIdSingularMapEmpty()) {
                SingularValueDecomposition.loadSingularValues(connection, this._userName, this._modelName);
            }
            HashMap<String, Double> hashMap = SingularValueDecomposition.getFeatureIdSingularValueMap();
            Iterator<String> iterator = hashMap.keySet().iterator();
            Vector<SVDCoefficientRowData> vector = new Vector<SVDCoefficientRowData>();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Double d = hashMap.get(string);
                SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(string, d);
                vector.add(sVDCoefficientRowData);
            }
            Collections.sort(vector);
            this._model = new SingularValuesTableModel();
            this._model.addRows(vector);
            this._loaded = true;
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    public SingularValuesTableModel getModel() {
        return this._model;
    }

    public void clearRows() {
        this._model.clearRows();
    }

    public String getModelName() {
        return this._modelName;
    }

    public String getUserName() {
        return this._userName;
    }
}

