/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.svd.details;

import java.sql.Connection;
import java.util.List;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.mviewer.BaseViewerState;
import oracle.dmt.dataminer.mviewer.ModelViewerState1;
import oracle.dmt.dataminer.mviewer.svd.details.DetailsTableModel;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.GlobalDetails;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;

public class DetailsViewerState
extends BaseViewerState {
    private DetailsTableModel _tableModel;
    private boolean _loaded;
    private Context _serverContext = null;
    private List<NameValuePair> _settings = null;

    public DetailsViewerState(Context context) {
        assert (context != null) : "Context cannot be passed into constructor as a null.";
        this._loaded = false;
        this._context = context;
        this._tableModel = new DetailsTableModel();
        Node node = this._context.getNode();
        if (node instanceof ModelNode) {
            this._loadFromServer = true;
            this._serverContext = context;
        }
    }

    @Override
    public HelpInfo getHelpInfo() {
        String string = "";
        Node node = this._context.getNode();
        if (this.isSVD()) {
            string = "svd_viewer_details";
        } else if (this.isPCA()) {
            string = "pca_viewer_details";
        }
        return new HelpInfo(string);
    }

    private Connection getConnection() throws Exception {
        if (this._loadFromServer) {
            return Connections.getUniqueConnection(this._serverContext);
        }
        return Connections.getUniqueConnection(this._context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetailsViewerState load() throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this._modelViewerState1 = new ModelViewerState1(this._context);
            this._modelViewerState1.load(connection);
            this._settings = GlobalDetails.getModelDetailsGlobal(connection, this._modelViewerState1.getUserName(), this._modelViewerState1.getModelName());
        }
        finally {
            SQLHelper.close(connection);
        }
        return this;
    }

    public void loadTableModel() {
        this._tableModel.loadData(this._settings);
    }

    public void loadStatus(String string) {
        this._tableModel.loadStatus(string);
    }

    public void setTableModel(DetailsTableModel detailsTableModel) {
        this._tableModel = detailsTableModel;
    }

    public DetailsTableModel getTableModel() {
        return this._tableModel;
    }
}

