/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.util.Enumeration;
import java.util.EventObject;
import javax.accessibility.Accessible;
import oracle.dmt.dataminer.navigator.BaseNavigatorManager;
import oracle.dmt.dataminer.navigator.DataminerNavigatorController;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableEvent;
import oracle.ide.explorer.TNode;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.MnemonicSolver;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class DataminerNavigatorWindow
extends DefaultNavigatorWindow {
    private Controller _controller;
    private static ContextMenu s_contextMenu;

    DataminerNavigatorWindow(Context context, String string) {
        super(context, string);
    }

    public String getTabName() {
        return DataminerNavigatorLrb.get("NAVIGATOR_TITLE");
    }

    protected String getTitle() {
        return this.getTabName();
    }

    public String getTitleName() {
        String string = this.getTitle();
        AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)string, (boolean)false);
        return string;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DataminerNavigatorController(super.getController());
        }
        return this._controller;
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        return context;
    }

    public Component getGUI() {
        Component component = super.getGUI();
        this.getTree().expandRow(0);
        return component;
    }

    public void dockableShown(DockableEvent dockableEvent) {
        super.dockableShown(dockableEvent);
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        runManager.registerViewSelectionListener(this.getTreeExplorer());
    }

    public void dockableHidden(DockableEvent dockableEvent) {
        super.dockableHidden(dockableEvent);
        AddinManager addinManager = AddinManager.getAddinManager();
        RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        runManager.unregisterViewSelectionListener(this.getTreeExplorer());
    }

    private TNode findNodeByName(String string) {
        TNode tNode = null;
        if (this.getTreeExplorer() != null) {
            Enumeration enumeration = this.getTreeExplorer().getRoot().getChildTNodes();
            while (enumeration.hasMoreElements()) {
                TNode tNode2 = (TNode)enumeration.nextElement();
                if (!tNode2.getData().getShortLabel().equals(string)) continue;
                tNode = tNode2;
                break;
            }
        }
        return tNode;
    }

    public ContextMenu getContextMenu() {
        return DataminerNavigatorWindow.getOrCreateContextMenu();
    }

    protected static synchronized ContextMenu getOrCreateContextMenu() {
        if (s_contextMenu == null) {
            s_contextMenu = new ContextMenu(new MnemonicSolver());
            BaseNavigatorManager.populateDataminerNavigatorContextMenu(s_contextMenu, "dm_nav");
        }
        return s_contextMenu;
    }
}

