/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;

public class DeleteObjectsWorker
implements Runnable {
    private Element[] nodesToDelete;
    private Context context;
    private DeterminateProgressMonitor progressBar;
    private String initialMsg;
    private boolean result;
    private int stepsCompleted;
    private List<Workflow.WorkflowInUseException> lockExceptions;

    public DeleteObjectsWorker(Context context, Component component, String string, String string2) {
        this.context = context;
        this.initialMsg = string2;
        this.result = false;
        this.stepsCompleted = 0;
        this.lockExceptions = new ArrayList<Workflow.WorkflowInUseException>();
        this.progressBar = new DeterminateProgressMonitor(component, string, (Object)"", string2);
        this.progressBar.setMinimum(0);
        this.nodesToDelete = context.getSelection();
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        this.progressBar.start();
        this.result = this.doWork();
    }

    public boolean hasUserCancelled() {
        return this.progressBar.isCanceled();
    }

    protected boolean doWork() {
        try {
            if (this.nodesToDelete[0] instanceof ConnectionFolder) {
                ConnectionFolder.delete(this.nodesToDelete);
            } else {
                String string;
                Connection connection = Connections.getSharedConnection(this.context);
                if (this.nodesToDelete[0] instanceof ProjectFolder) {
                    string = this.nodesToDelete.length == 1 ? DataminerNavigatorLrb.get("DELETE_PROJECT_LOCK_ONE") : DataminerNavigatorLrb.get("DELETE_PROJECT_LOCK_MANY");
                    this.deleteProjects(this.nodesToDelete, connection);
                } else if (this.nodesToDelete[0] instanceof WorkflowNode) {
                    string = this.nodesToDelete.length == 1 ? DataminerNavigatorLrb.get("DELETE_LOCK_ONE") : DataminerNavigatorLrb.get("DELETE_LOCK_MANY");
                    this.deleteNodes(this.nodesToDelete, connection, false);
                } else {
                    throw new Exception("Unexpected node type");
                }
                if (!this.lockExceptions.isEmpty()) {
                    MessageDialog.critical((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("DELETE_LOCK_TITLE"), null);
                }
            }
        }
        catch (Workflow.WorkflowInUseException workflowInUseException) {
            Object[] objectArray = new Object[]{workflowInUseException.getNode().getLabel()};
            String string = MessageFormat.format(DataminerNavigatorLrb.get("DELETE_NODES_FAILURE_INUSE"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)DataminerNavigatorLrb.get("DELETE_NODES_FAILURE_TITLE"), null);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        this.progressBar.close();
        return Boolean.TRUE;
    }

    private void deleteNodes(Element[] elementArray, Connection connection, boolean bl) throws Exception {
        if (!bl) {
            this.progressBar.setMaximum(elementArray.length);
        }
        for (Element element : elementArray) {
            WorkflowNode workflowNode;
            block4: {
                HashMap<WorkflowNode, Connection> hashMap = new HashMap<WorkflowNode, Connection>();
                workflowNode = (WorkflowNode)element;
                Connection connection2 = workflowNode.getSessionConnection();
                connection2 = connection2 != null ? connection2 : connection;
                hashMap.put(workflowNode, connection2);
                try {
                    WorkflowNode.delete(hashMap);
                }
                catch (Workflow.WorkflowInUseException workflowInUseException) {
                    if (bl) break block4;
                    this.lockExceptions.add(workflowInUseException);
                }
            }
            workflowNode.closeSessionConnection();
            if (this.progressBar.isCancelled()) break;
            this.progressBar.setProgress(++this.stepsCompleted);
        }
    }

    private void deleteProjects(Element[] elementArray, Connection connection) throws Exception {
        ProjectFolder projectFolder;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.progressBar.getPanel().setNote(DataminerNavigatorLrb.get("DELETING_PREPARE"));
        for (Element element : elementArray) {
            List<Object> list;
            projectFolder = (ProjectFolder)element;
            Iterator<Element> iterator = projectFolder.getChildren();
            if (!iterator.hasNext()) {
                list = this.getDummyWorkflowNodes(connection, projectFolder);
                arrayList.addAll(list);
            } else {
                list = new ArrayList();
                while (iterator.hasNext()) {
                    list.add((WorkflowNode)iterator.next());
                }
                arrayList.addAll(list);
            }
            if (!this.progressBar.isCanceled()) continue;
            return;
        }
        this.progressBar.setMaximum(elementArray.length + arrayList.size());
        this.progressBar.getPanel().setNote(DataminerNavigatorLrb.get("DELETING_WORKFLOWS"));
        this.deleteNodes(arrayList.toArray(new Element[0]), connection, true);
        if (this.progressBar.isCancelled()) {
            return;
        }
        this.progressBar.getPanel().setNote(DataminerNavigatorLrb.get("DELETING_PROJECTS"));
        for (Element element : elementArray) {
            projectFolder = (ProjectFolder)element;
            projectFolder.closeChildren();
            try {
                ProjectFolder.delete(connection, new Element[]{projectFolder});
            }
            catch (Workflow.WorkflowInUseException workflowInUseException) {
                this.lockExceptions.add(workflowInUseException);
            }
            if (this.progressBar.isCancelled()) {
                return;
            }
            this.progressBar.setProgress(++this.stepsCompleted);
        }
    }

    private List<WorkflowNode> getDummyWorkflowNodes(Connection connection, ProjectFolder projectFolder) throws Exception {
        ArrayList<WorkflowNode> arrayList = new ArrayList<WorkflowNode>();
        List<Workflow> list = Workflow.getWorkflows(connection, projectFolder.getId());
        for (Workflow workflow : list) {
            WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(projectFolder.getURL().getPath() + "/" + workflow.getName(), true);
            workflowNode.setId(workflow.getId());
            arrayList.add(workflowNode);
        }
        return arrayList;
    }
}

