/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.RenameNodePanel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.ExceptionDialog;

public class RenameNodeDialog {
    protected JEWTDialog _dlg;
    protected String wizName = "renameNode";
    boolean _projectNode = false;
    boolean _workflowNode = false;
    String _currentName = "";

    protected JEWTDialog buildDialog(Context context) {
        RenameNodePanel renameNodePanel = this.buildPanel(context);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)renameNodePanel);
        jEWTDialog.setTitle(this.getDialogTitle());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "renameNode.htm");
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        String string = DataminerNavigatorLrb.get("RENAME_NODE_TITLE");
        if (this._projectNode) {
            string = string + " " + DataminerNavigatorLrb.get("RENAME_NODE_PROJECT") + ": ";
        } else if (this._workflowNode) {
            string = string + " " + DataminerNavigatorLrb.get("RENAME_NODE_WORKFLOW") + ": ";
        }
        string = string + this._currentName;
        return string;
    }

    private boolean buildState(Context context) {
        boolean bl = true;
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof ProjectFolder) {
            this._projectNode = true;
            bl = true;
        } else if (elementArray[0] instanceof WorkflowNode) {
            this._workflowNode = true;
            bl = true;
        }
        this._currentName = context.getNode().getShortLabel();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Context context) {
        boolean bl = false;
        try {
            if (this.buildState(context)) {
                JEWTDialog jEWTDialog = this.buildDialog(context);
                jEWTDialog.setResizable(true);
                final RenameNodePanel renameNodePanel = (RenameNodePanel)jEWTDialog.getContent();
                jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                        String string = propertyChangeEvent.getPropertyName();
                        Object object = propertyChangeEvent.getNewValue();
                        if (string.equals("closed") && Boolean.TRUE.equals(object) && !renameNodePanel.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                });
                this._dlg = jEWTDialog;
                if (jEWTDialog != null) {
                    bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DataminerNavigatorLrb.get("RENAME_NODE_FAILURE_TITLE"), (String)DataminerNavigatorLrb.get("RENAME_NODE_FAILURE_MESG"), null);
        }
        finally {
            if (!bl) {
                this.cancel();
            }
        }
        this._dlg = null;
        return bl;
    }

    protected void cancel() {
    }

    protected RenameNodePanel buildPanel(Context context) {
        return new RenameNodePanel(context, this._projectNode, this._workflowNode, this._currentName);
    }
}

