/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.util.IlvXMLConnector;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.diagram.core.editor.EditorScrollManagerView;
import oracle.diagram.sdm.undo.ContextNodeUndoStateHelper;
import oracle.diagram.sdm.undo.StateHelper;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.AbstractSDMEngineNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.DataminerNavigatorLrb;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.BlockingComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.w3c.dom.Document;

public class WorkflowNode
extends AbstractSDMEngineNode {
    private static final Logger LOGGER = Logger.getLogger(WorkflowNode.class.getName());
    private BigDecimal _id;
    private TNode _parent = null;
    private Object _reposObj = null;
    private WorkflowModel _wfModel = null;
    private ConnectionFolder _connFolder = null;
    private Timestamp _lastSavedOn = new Timestamp(0L);
    private Connection sessionConnection = null;
    private BlockingComponent overLayPanel;
    private Object repositoryDataReadLock = new Object();

    public WorkflowNode() {
        this.disableSaveAs();
    }

    public WorkflowNode(URL uRL) {
        super(uRL);
        this.disableSaveAs();
    }

    private void disableSaveAs() {
        this.getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
        this.getAttributes().unset(ElementAttributes.SAVEABLE_AS);
    }

    public void setWorkflowModel(WorkflowModel workflowModel) {
        this._wfModel = workflowModel;
    }

    public WorkflowModel getWorkflowModel() {
        return this._wfModel;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public boolean setReadOnly(boolean bl) {
        try {
            if (this._wfModel == null) {
                throw new RuntimeException("Cannot setReadOnly because WorkflowModel not initialized (ok if node not being edited)");
            }
            this._wfModel = WorkflowUtils.getWorkflowModel(this);
            this._wfModel.setEditable(!bl);
            if (bl) {
                this.getAttributes().set(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            } else {
                this.getAttributes().unset(ElementAttributes.NON_EDITABLE | ElementAttributes.READ_ONLY);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getMessage(), exception);
        }
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return ((Workflow)this.getRepositoryData()).isReadOnly();
    }

    public Timestamp getLastSavedOn() {
        return this._lastSavedOn;
    }

    public void setLastSavedOn(Timestamp timestamp) {
        this._lastSavedOn = timestamp;
    }

    public static WorkflowNode getWorkflowNode(Context context) {
        WorkflowNode workflowNode = null;
        Node node = context.getNode();
        DataMinerNode dataMinerNode = (DataMinerNode)node;
        if (node == null) {
            return null;
        }
        if (node instanceof Connections) {
            return null;
        }
        if (node instanceof ConnectionFolder) {
            return null;
        }
        if (node instanceof ProjectFolder) {
            return null;
        }
        if (node instanceof WorkflowNode) {
            workflowNode = (WorkflowNode)node;
        } else {
            Element element = dataMinerNode.getParent().getAncestor(WorkflowNode.class);
            if (element != null && element instanceof WorkflowNode) {
                workflowNode = (WorkflowNode)element;
            }
        }
        return workflowNode;
    }

    public Icon getIcon() {
        return DataMinerIcons.get(Icons.WORKFLOW_NODE_ICON);
    }

    public Connection getSessionConnection() {
        return this.sessionConnection;
    }

    public void setSessionConnection(Connection connection) {
        this.sessionConnection = connection;
        try {
            this.sessionConnection.setAutoCommit(false);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
    }

    public void closeSessionConnection() {
        if (this.sessionConnection == null) {
            return;
        }
        try {
            Connection connection = this.sessionConnection;
            this.sessionConnection = null;
            connection.commit();
            connection.setAutoCommit(true);
            connection.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    protected void renameImpl(URL uRL, URL uRL2) throws IOException {
    }

    public void createOverLayPanel(View view) {
        WorkflowEditor workflowEditor = (WorkflowEditor)view.getContext().getView();
        Component component = workflowEditor.getGUI();
        EditorScrollManagerView editorScrollManagerView = (EditorScrollManagerView)component;
        Container container = editorScrollManagerView.getParent();
        if (container instanceof JXLayer) {
            container = container.getParent();
        }
        if (workflowEditor.getOverLayPanel() == null) {
            this.overLayPanel = new BlockingComponent((JComponent)editorScrollManagerView);
            container.add(this.overLayPanel.getBlockingComponent());
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            this.overLayPanel.setMessage(BlockingComponent.Message.LOADING);
            workflowEditor.setOverLayPanel(this.overLayPanel);
            container.validate();
        }
    }

    public void displayOverLayPanel(View view) {
        if (this.overLayPanel == null) {
            this.createOverLayPanel(view);
        }
        this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
        WorkflowEditor workflowEditor = (WorkflowEditor)view.getContext().getView();
        Component component = workflowEditor.getGUI();
        EditorScrollManagerView editorScrollManagerView = (EditorScrollManagerView)component;
        Container container = editorScrollManagerView.getParent();
        if (component.getGraphics() != null) {
            container.update(component.getGraphics());
        }
    }

    public void hideOverLayPanel() {
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }

    @Override
    protected void saveImpl() throws IOException {
        boolean bl = false;
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.overLayPanel == null) {
                this.createOverLayPanel(this._wfModel.getContext().getView());
            }
            this.overLayPanel.setMessage(BlockingComponent.Message.SAVING);
            this.displayOverLayPanel(this._wfModel.getContext().getView());
            SaveWorker saveWorker = new SaveWorker(bl);
            saveWorker.execute();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WorkflowNode.this.createOverLayPanel(WorkflowNode.this._wfModel.getContext().getView());
                        WorkflowNode.this.overLayPanel.setMessage(BlockingComponent.Message.SAVING);
                        WorkflowNode.this.displayOverLayPanel(WorkflowNode.this._wfModel.getContext().getView());
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, interruptedException.getMessage(), interruptedException);
            }
            this.save(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void save(boolean var1_1) {
        var3_2 = (Workflow)this.getRepositoryData();
        try {
            this._lastSavedOn = var3_2.save(this.sessionConnection, this._lastSavedOn, var1_1);
            ** if (this.overLayPanel == null) goto lbl-1000
        }
        catch (Exception var4_3) {
            try {
                if (this.overLayPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowNode.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                        }
                    });
                }
                if (var4_3 instanceof SQLException && ((SQLException)var4_3).getErrorCode() == 0) {
                    var2_5 = DataminerNavigatorLrb.get("CANNOT_SAVE_LOCKED");
                } else {
                    var2_6 = var4_3.getMessage();
                }
                WorkflowNode.LOGGER.log(Level.SEVERE, var4_3.getMessage(), var4_3);
                ** if (this.overLayPanel == null) goto lbl-1000
            }
            catch (Throwable var5_7) {
                if (this.overLayPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WorkflowNode.this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                        }
                    });
                }
                throw var5_7;
            }
lbl-1000:
            // 1 sources

            {
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
lbl-1000:
        // 2 sources

        {
        }
        var4_4 = CommandProcessor.getInstance();
        var4_4.flush((Node)this);
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        Workflow workflow = (Workflow)this.getRepositoryData();
        workflow.unload();
        List list = EditorManager.getEditorManager().findEditors(Context.newIdeContext((Node)this));
        for (Object e : list) {
            if (!(e instanceof WorkflowEditor)) continue;
            ((WorkflowEditor)e).stopJobMonitoring();
        }
        this.setWorkflowModel(null);
    }

    @Override
    protected void openImpl() throws IOException {
        super.openImpl();
    }

    public static void delete(Map<WorkflowNode, Connection> map) throws Exception {
        if (map.values().size() == 0) {
            return;
        }
        for (WorkflowNode workflowNode : map.keySet()) {
            Workflow.delete(map);
            workflowNode.closeNode();
            WorkflowNode.removeNodeFromProject(workflowNode);
        }
    }

    private static void removeNodeFromProject(final WorkflowNode workflowNode) {
        if (!EventQueue.isDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (workflowNode.getParent() == null) {
                            return;
                        }
                        ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
                        projectFolder.remove((Element)workflowNode, true);
                        projectFolder.markDirty(false);
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        } else {
            ProjectFolder projectFolder = (ProjectFolder)workflowNode.getParent().getData();
            projectFolder.remove((Element)workflowNode, true);
            projectFolder.markDirty(false);
        }
    }

    public String export(Context context) throws Exception {
        class Worker
        extends ProgressRunnable {
            private boolean _validate;
            private boolean _canceled;
            private final Workflow wf;
            private String workflowXML;

            Worker(boolean bl) {
                this.wf = (Workflow)WorkflowNode.this.getRepositoryData();
                this._validate = bl;
            }

            protected Object doWork() throws Exception {
                Connection connection = Connections.getSharedConnection(context2);
                if (this._validate) {
                    this.wf.validateWorkflow(connection, WorkflowNode.this._lastSavedOn);
                } else {
                    this.workflowXML = this.wf.export(connection, WorkflowNode.this._lastSavedOn, context2);
                }
                return Boolean.TRUE;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this._canceled = true;
            }

            public String getWorkflowXML() {
                return this.workflowXML;
            }
        }
        Worker worker;
        block2: {
            final Context context2 = context;
            worker = new Worker(true);
            worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
            worker.setMessage(WorkflowEditorLrb.get("VALIDATE_WORKFLOW_DESCR"));
            worker.setCancelable(false);
            try {
                worker.start(true);
                worker = new Worker(false);
                worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
                worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
                worker.setCancelable(false);
                worker.start(true);
            }
            catch (Exception exception) {
                String string = MessageFormat.format(WorkflowEditorLrb.get("WORKFLOW_EXPORT_INVALID_CONFIRM"), exception.getLocalizedMessage());
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)WorkflowEditorLrb.get("SAVE_WORKFLOW"), null, (boolean)true)) break block2;
                worker = new Worker(false);
                worker.setTitle(WorkflowEditorLrb.get("SAVE_WORKFLOW"));
                worker.setMessage(WorkflowEditorLrb.get("SAVE_WORKFLOW_DESCR"));
                worker.setCancelable(false);
                worker.start(true);
            }
        }
        return worker.getWorkflowXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void revertImpl() throws IOException {
        IlvSDMEngine ilvSDMEngine = this.getEngine();
        if (ilvSDMEngine != null && !this.isNew()) {
            this.loadEngine();
        } else {
            super.revertImpl();
        }
    }

    @Override
    protected void loadEngine() throws IOException {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/default-odmr.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    @Override
    protected IlvSDMEngine createEngine() {
        IlvSDMEngine ilvSDMEngine = super.createEngine();
        ilvSDMEngine.setHighlightingSelection(true);
        return ilvSDMEngine;
    }

    @Override
    public IlvSDMModel createModel() {
        if (this._wfModel == null) {
            this._wfModel = new WorkflowModel();
        }
        return this._wfModel;
    }

    @Override
    protected void installModelFilters(IlvSDMEngine ilvSDMEngine) {
        OdmrSDMUndoFilter odmrSDMUndoFilter = new OdmrSDMUndoFilter(ilvSDMEngine.getModel());
        odmrSDMUndoFilter.addStateHelper((StateHelper)new ContextNodeUndoStateHelper());
        ilvSDMEngine.setModel((IlvSDMModel)odmrSDMUndoFilter);
    }

    @Override
    public Object getRepositoryData() {
        return this._reposObj;
    }

    @Override
    public void setRepositoryData(Object object) {
        this._reposObj = object;
    }

    public Object getRepositoryDataReadLock() {
        return this.repositoryDataReadLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadRepositoryData() throws Exception {
        Object object;
        Object object2;
        assert (!SwingUtilities.isEventDispatchThread());
        Context context = Context.newIdeContext((Node)this);
        Connection connection = this.getSessionConnection();
        Connection connection2 = null;
        WorkflowEditor workflowEditor = WorkflowEditor.findWorkflowEditor(context);
        boolean bl = workflowEditor != null ? workflowEditor.isLockOwner() : false;
        Workflow workflow = (Workflow)this._reposObj;
        try {
            object2 = connection == null ? (connection2 = Connections.getUniqueConnection(context)) : connection;
            object = workflow.load((Connection)object2, this.getLastSavedOn(), bl);
            this.setLastSavedOn((Timestamp)object);
            object2 = null;
        }
        finally {
            if (connection2 != null) {
                try {
                    connection2.close();
                }
                catch (Exception exception) {
                    LOGGER.log(Level.INFO, exception.getLocalizedMessage(), exception);
                }
            }
        }
        this.setReadOnly(workflow.isReadOnly());
        object2 = this.getWorkflowModel();
        if (object2 == null) {
            this.createModel();
            object2 = this.getWorkflowModel();
            this.setWorkflowModel((WorkflowModel)((Object)object2));
        }
        ((WorkflowModel)((Object)object2)).load(workflow.getWorkflowProcess(), context);
        this.markDirty(false);
        UpdateMessage.fireStructureChanged((Subject)this);
        object = bl ? DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED_LOCKED") : DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED_UNLOCKED");
        LOGGER.log(Level.INFO, DataminerNavigatorLrb.get("WORKFLOW_REPOS_OBJ_RELOADED") + " " + (String)object);
    }

    public static WorkflowNode findParentWorkflowNode(Context context) {
        URL uRL = context.getNode().getURL();
        URL uRL2 = DMURLFormatHelper.getWorkflowURL(uRL);
        WorkflowNode workflowNode = uRL2 != null ? (WorkflowNode)NodeFactory.find((URL)uRL2) : null;
        return workflowNode;
    }

    @Override
    public void setParent(TNode tNode) {
        this._parent = tNode;
    }

    @Override
    public TNode getParent() {
        return this._parent;
    }

    @Override
    public void setConnectionFolder(ConnectionFolder connectionFolder) {
        this._connFolder = connectionFolder;
    }

    public void setId(BigDecimal bigDecimal) {
        this._id = bigDecimal;
    }

    public BigDecimal getId() {
        return this._id;
    }

    @Override
    public ConnectionFolder getConnectionFolder() {
        if (this._parent != null) {
            Element element = this._parent.getAncestor(ConnectionFolder.class);
            return (ConnectionFolder)element;
        }
        return this._connFolder;
    }

    @Override
    public TreeExplorer getTreeExplorer(Context context) {
        return BaseTreeNode.getTreeExplorerImpl(context);
    }

    @Override
    public BaseTreeNode getRootTreeNode(Context context) {
        return BaseTreeNode.getRootTreeNodeImpl(context);
    }

    @Override
    public void closeChildren() {
        BaseTreeNode.closeChildrenImpl((Node)this);
    }

    private class OdmrXMLConnector
    extends IlvXMLConnector {
        private OdmrXMLConnector() {
        }

        public void writeXML(IlvSDMModel ilvSDMModel, OutputStream outputStream, Enumeration enumeration, Hashtable hashtable) throws IOException {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                this.writeDOM(ilvSDMModel, document, enumeration != null ? enumeration : ilvSDMModel.getObjects(), hashtable);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                String string = this.getStringFromDoc(document);
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }

        public String getStringFromDoc(Document document) throws Exception {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = stringWriter.toString();
            return string;
        }
    }

    private class SaveWorker
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        boolean force = false;

        public SaveWorker(boolean bl) {
            this.force = bl;
        }

        protected Object doInBackground() {
            WorkflowNode.this.save(this.force);
            return null;
        }

        @Override
        protected void done() {
            super.done();
        }
    }
}

