/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import java.sql.Connection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractModelNode;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;

public class ANModelNode
extends AbstractModelNode {
    private static final Logger theLogger = Logger.getLogger(ANModelNode.class.getName());
    private Boolean _isLinear = null;

    public Boolean isLinearKernel() {
        return this._isLinear;
    }

    @Override
    public void unload() {
        super.unload();
        this._isLinear = null;
    }

    public void loadLinearKernel(Connection connection) {
        if (null == this._isLinear) {
            Object object;
            Object object2;
            Object object3;
            Object object4 = this.getRepositoryData();
            String string = null;
            if (object4 instanceof ModelType) {
                object3 = (AnomalyDetectionModelType)object4;
                object2 = object3.getAnomalyDetectionAlgo();
                object = object2.getSVMSKERNELFUNCTION();
                if (object3.getStatus().equals((Object)ModelStatusType.COMPLETE) || object3.getStatus().equals((Object)ModelStatusType.WARNING)) {
                    if (object != null && ((String)object).equals("SVMS_LINEAR")) {
                        this._isLinear = true;
                    } else if (object != null && ((String)object).equals("SVMS_GAUSSIAN")) {
                        this._isLinear = false;
                    }
                    if (this._isLinear != null) {
                        return;
                    }
                }
                string = object3.getName();
            } else if (object4 instanceof ModelNodeType.Models.Model) {
                string = ((ModelNodeType.Models.Model)object4).getName();
            }
            try {
                object3 = this.getSchema();
                object2 = new Model();
                object = ((Model)object2).getModelSetting(connection, (String)object3, string);
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", (Vector<MiningModelSettings>)object);
                this._isLinear = miningModelSettings.getSettingValue().equals("SVMS_LINEAR");
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }
}

