/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMModelEvent;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.model.IlvAbstractSDMModel;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.diagram.sdm.undo.SDMUndoFilter;
import oracle.dmt.dataminer.navigator.AbstractSDMEngineNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.dialogs.ProgressRunnable;

public abstract class AbstractDiagramModelNode
extends AbstractSDMEngineNode
implements ModelNode {
    protected IlvAbstractSDMModel _model;
    protected Model _odmModel;
    protected String schema;
    protected Boolean _exists;
    protected Icon _icon;

    @Override
    protected abstract IlvSDMModel createModel();

    public IlvAbstractSDMModel getSDMModel() {
        return this._model;
    }

    public AbstractDiagramModelNode(URL uRL) {
        super(uRL);
        this._exists = false;
    }

    public AbstractDiagramModelNode() {
    }

    @Override
    protected IlvSDMEngine createEngine() {
        IlvSDMEngine ilvSDMEngine = super.createEngine();
        ilvSDMEngine.setHighlightingSelection(false);
        return ilvSDMEngine;
    }

    @Override
    protected void installModelFilters(IlvSDMEngine ilvSDMEngine) {
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        ilvSDMEngine.setModel((IlvSDMModel)new SDMUndoFilter(ilvSDMModel));
    }

    public IlvSDMModel getFilteredModel(SDMUndoFilter sDMUndoFilter) {
        IlvSDMModel ilvSDMModel = sDMUndoFilter.getFilteredModel();
        return ilvSDMModel;
    }

    @Override
    public void propertyChanged(SDMPropertyChangeEvent sDMPropertyChangeEvent) {
        Object object;
        if (!this.isLoading() && (object = sDMPropertyChangeEvent.getObject()) instanceof AbstractNode) {
            AbstractNode abstractNode = (AbstractNode)object;
            abstractNode.setProperty(sDMPropertyChangeEvent.getPropertyName(), sDMPropertyChangeEvent.getNewValue());
        }
    }

    @Override
    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("GENERIC_MODEL_NODE_ICON"));
        }
        return this._icon;
    }

    @Override
    public void objectAdded(SDMModelEvent sDMModelEvent) {
    }

    @Override
    public void objectRemoved(SDMModelEvent sDMModelEvent) {
    }

    @Override
    public void linkSourceChanged(SDMModelEvent sDMModelEvent) {
    }

    @Override
    public void linkDestinationChanged(SDMModelEvent sDMModelEvent) {
    }

    @Override
    public void dataChanged(SDMModelEvent sDMModelEvent) {
    }

    @Override
    public void adjustmentFinished(SDMModelEvent sDMModelEvent) {
    }

    @Override
    protected void saveImpl() throws IOException {
    }

    @Override
    protected void openImpl() throws IOException {
        super.openImpl();
        this.load();
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._model = null;
        this._exists = false;
        this._odmModel = null;
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    @Override
    public Model getOdmModel() {
        return this._odmModel;
    }

    @Override
    public void setSchema(String string) {
        this.schema = string;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public Boolean isModelExists() {
        return this._exists;
    }

    public void setModelExists(Boolean bl) {
        this._exists = bl;
    }

    @Override
    public void load() {
        this.loadImpl();
    }

    protected abstract void loadImpl();

    class LoadInBackground
    extends ProgressRunnable {
        boolean _canceled = false;

        LoadInBackground() {
        }

        protected Object doWork() throws Exception {
            AbstractDiagramModelNode.this.loadImpl();
            return Boolean.TRUE;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

