/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.navigator.modelnodes;

import ilog.views.sdm.IlvSDMModel;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetails;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.clustering.tree.model.ClusterTreeSDMModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.modelnodes.AbstractDiagramModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.EMClusterModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.KMModelNode;
import oracle.dmt.dataminer.navigator.modelnodes.OCModelNode;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringEM;
import oracle.dmt.dataminer.server.model.ClusteringKM;
import oracle.dmt.dataminer.server.model.ClusteringOC;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.javatools.util.Version;

public class ClusteringModelNode
extends AbstractDiagramModelNode {
    private static final Logger theLogger = Logger.getLogger(ClusteringModelNode.class.getName());
    private static final String CLUSTER_DETAILS_LOADED = "oracle.dmt.dataminer.navigator.modelnodes.ClusteringNodelNode.clusterdetails";
    private static final String CLUSTER_DETAILS = "oracle.dmt.dataminer.navigator.modelnodes.ClusteringNodelNode.clusterdetailsloaded";
    private HashMap<String, Object> _hash = new HashMap();
    private Vector<ClusteringDetailRow> clusterRowDetails = null;
    private int topNAttributes;
    private boolean statsEnabled = true;
    private boolean modelEmpty = false;

    public ClusteringModelNode() {
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
    }

    public Object getProperty(String string) {
        return this._hash.get(string);
    }

    public void setProperty(String string, Object object) {
        this._hash.put(string, object);
    }

    public void setClusterDetailsLoaded() {
        this._hash.put(CLUSTER_DETAILS_LOADED, Boolean.TRUE);
    }

    public boolean isClusterDetailsLoaded() {
        Boolean bl = (Boolean)this._hash.get(CLUSTER_DETAILS_LOADED);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setClusterDetails(ClusterDetails clusterDetails) {
        this._hash.put(CLUSTER_DETAILS, clusterDetails);
    }

    public ClusterDetails getClusterDetails() {
        return (ClusterDetails)this._hash.get(CLUSTER_DETAILS);
    }

    public void setClusterCountsMap(String string, String string2, Map<String, ClusteringDetailRowShort> map) {
        this._hash.put(string + "." + string2, map);
    }

    public Map<String, ClusteringDetailRowShort> getClusterCountsMap(String string, String string2) {
        return (Map)this._hash.get(string + "." + string2);
    }

    public Clustering getModelLoader() {
        return (Clustering)this._odmModel;
    }

    public void setTopNAttributes(int n) {
        this.topNAttributes = n;
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        ClusteringTreePreferencesSettings clusteringTreePreferencesSettings = ClusteringTreePreferencesSettings.getInstance();
        this.topNAttributes = clusteringTreePreferencesSettings.getTopNCentroidAttributes();
        if (this._hash != null) {
            this._hash.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadImpl() {
        Connection connection;
        block18: {
            connection = null;
            try {
                String string;
                Object object;
                ConnectionFolder connectionFolder = (ConnectionFolder)this.getParent().getAncestor(ConnectionFolder.class, true);
                connection = Connections.getUniqueConnection(connectionFolder.getShortLabel());
                Version version = ConnectionFolder.getConnectionFolder(new Context((Node)this)).getDbVersion();
                String string2 = this.getSchema();
                Object object2 = this.getRepositoryData();
                if (object2 instanceof ModelType) {
                    object = (ModelType)object2;
                    string = object.getName();
                } else if (object2 instanceof TestModelType.Model) {
                    object = (TestModelType.Model)object2;
                    string = object.getName();
                } else if (object2 instanceof ModelNodeType.Models.Model) {
                    object = (ModelNodeType.Models.Model)object2;
                    string = object.getName();
                } else {
                    throw new RuntimeException("Invalid state detected");
                }
                if (this instanceof OCModelNode) {
                    this._odmModel = new ClusteringOC(string2, string);
                } else if (this instanceof KMModelNode) {
                    this._odmModel = new ClusteringKM(string2, string);
                } else if (this instanceof EMClusterModelNode) {
                    this._odmModel = new ClusteringEM(string2, string);
                }
                this._odmModel.load(connection);
                this._exists = false == this._odmModel.getModelGeneralDescription().equals(ModelGeneralDescription._NONE);
                if (!this._exists.booleanValue()) break block18;
                if (this instanceof OCModelNode) {
                    this.clusterRowDetails = version == null || version.toCanonicalString().startsWith("11.") ? ((ClusteringOC)this._odmModel).getClusterAllDetailsTopN_Db11(connection, string2, string, false, Clustering.RuleResultType.RULE_DETAILS, this.topNAttributes) : ((ClusteringOC)this._odmModel).getClusterAllDetailsTopN_Db12(connection, string2, string, this.topNAttributes);
                    break block18;
                }
                if (this instanceof KMModelNode) {
                    this.clusterRowDetails = version == null || version.toCanonicalString().startsWith("11.") ? ((ClusteringKM)this._odmModel).getClusterAllDetailsTopN_Db11(connection, string2, string, false, Clustering.RuleResultType.RULE_DETAILS, this.topNAttributes) : ((ClusteringKM)this._odmModel).getClusterAllDetailsTopN_Db12(connection, string2, string, this.topNAttributes);
                    break block18;
                }
                if (!(this instanceof EMClusterModelNode)) break block18;
                this.modelEmpty = ((ClusteringEM)this._odmModel).isModelEmpty(connection, string2, string);
                object = this._odmModel.getModelSetting(connection, string2, string);
                MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("EMCS_CLUSTER_STATISTICS", (Vector<MiningModelSettings>)object);
                if (miningModelSettings.getSettingValue().equals("EMCS_CLUS_STATS_ENABLE")) {
                    this.statsEnabled = true;
                    this.clusterRowDetails = ((ClusteringEM)this._odmModel).getClusterAllDetailsTopN_Db12(connection, string2, string, this.topNAttributes, this.modelEmpty);
                    break block18;
                }
                this.statsEnabled = false;
                this.clusterRowDetails = ((ClusteringEM)this._odmModel).getEMClusterNoStatsModel(connection, string2, string);
            }
            catch (Exception exception) {
                try {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
                catch (Throwable throwable) {
                    SQLHelper.close(connection);
                    throw throwable;
                }
                SQLHelper.close(connection);
            }
        }
        SQLHelper.close(connection);
    }

    public Vector<ClusteringDetailRow> getClusterRowDetails() {
        return this.clusterRowDetails;
    }

    @Override
    protected IlvSDMModel createModel() {
        if (this._model == null) {
            this._model = new ClusterTreeSDMModel();
        }
        return this._model;
    }

    @Override
    protected void loadEngine() throws IOException {
        try {
            String[] stringArray = new String[1];
            URL uRL = this.getClass().getResource("/oracle/dmt/dataminer/navigator/css/clust.css");
            stringArray[0] = uRL.toString();
            this.getEngine().setStyleSheets(stringArray);
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public boolean isModelEmpty() {
        return this.modelEmpty;
    }
}

