/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.SQLHelper;

public class Column
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(Column.class.getName());
    private Integer _sourceColId;
    private String _dataType;
    private String _type;
    private String _alias;
    private String _expression;
    private String _revExpression;
    private Integer _xformId;
    public static final String DG_TAB_COLS_TABLE = "ODMR_USER_DG_TAB_COLS";
    public static final String COLUMN_ID = "COLUMN_ID";
    public static final String TABLE_ID = "TABLE_ID";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_DATA_TYPE = "COLUMN_DATA_TYPE";
    public static final String COLUMN_TYPE = "COLUMN_TYPE";
    public static final String COLUMN_ALIAS_NAME = "COLUMN_ALIAS_NAME";
    public static final String COLUMN_EXPRESSION = "COLUMN_EXPRESSION";
    public static final String COLUMN_REV_EXPRESSION = "COLUMN_REV_EXPRESSION";
    public static final String SOURCE_COL_ID = "SOURCE_COL_ID";
    public static final String XFORM_ID = "XFORM_ID";
    public static final String COMMENTS = "COMMENTS";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String GROUP_ID = "GROUP_ID";
    public static final String GROUP_NAME = "GROUP_NAME";

    public Column(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    public Column(String string, String string2, String string3) {
        super(string, null, null);
        this._dataType = string2;
        this._type = string3;
    }

    public Column(BigDecimal bigDecimal, String string, String string2) {
        super(string, bigDecimal, null);
        this._dataType = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Column> getColumns(Connection connection, BigDecimal bigDecimal) {
        String string = null;
        SQLHelper sQLHelper = new SQLHelper();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        String[] stringArray = new String[]{COLUMN_ID, COLUMN_NAME, COLUMN_DATA_TYPE, COMMENTS};
        String[] stringArray2 = new String[]{DG_TAB_COLS_TABLE};
        String string2 = "TABLE_ID = ?";
        string = Column.buildQuery(stringArray, stringArray2, string2);
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(COLUMN_NAME);
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(COLUMN_ID);
                String string4 = sQLHelper.rs.getString(COLUMN_DATA_TYPE);
                String string5 = sQLHelper.rs.getString(COMMENTS);
                Column column = new Column(string3, bigDecimal2, bigDecimal);
                column.setComment(string5 != null ? string5 : "");
                column.setDataType(string4);
                arrayList.add(column);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    @Override
    public void load(Connection connection) {
    }

    @Override
    public void unload() {
    }

    @Override
    public void refresh(Connection connection) {
    }

    public void setSourceColId(Integer n) {
        this._sourceColId = n;
    }

    public Integer getSourceColId() {
        return this._sourceColId;
    }

    public void setDataType(String string) {
        this._dataType = string;
    }

    public String getDataType() {
        return this._dataType;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getType() {
        return this._type;
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setExpression(String string) {
        this._expression = string;
    }

    public String getExpression() {
        return this._expression;
    }

    public void setRevExpression(String string) {
        this._revExpression = string;
    }

    public String getRevExpression() {
        return this._revExpression;
    }

    public void setXformId(Integer n) {
        this._xformId = n;
    }

    public Integer getXformId() {
        return this._xformId;
    }

    public String getDefaultMiningType() {
        return DatabaseMetadataUtils.getDefaultMiningType(this._dataType);
    }

    public String getDefaultServerMiningType() {
        String string = this.getDefaultMiningType();
        if (string.equalsIgnoreCase("Categorical")) {
            return "Categorical";
        }
        if (string.equalsIgnoreCase("Numerical")) {
            return "Numerical";
        }
        if (string.equalsIgnoreCase("Categorical")) {
            return "Categorical";
        }
        if (string.equalsIgnoreCase("Numerical")) {
            return "Numerical";
        }
        return null;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        try {
            Column column = (Column)object;
            boolean bl2 = bl = this.getId() == null && column.getId() == null || this.getId() != null && this.getId().equals(column.getId());
            if (bl) {
                boolean bl3 = bl = this.getName() == null && column.getName() == null || this.getName() != null && this.getName().equals(column.getName());
                if (bl) {
                    bl = this.getDataType() == null && column.getDataType() == null || this.getDataType() != null && this.getDataType().equals(column.getDataType());
                }
            }
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
    }

    public int hashCode() {
        if (this.getId() == null) {
            int n = 7;
            n = 31 * n + this.getName() != null ? this.getName().hashCode() : 0;
            n = 31 * n + this.getDataType() != null ? this.getDataType().hashCode() : 0;
            return n;
        }
        return this.getId().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

