/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.CostMatrixInfo;
import oracle.dmt.dataminer.controls.PerformanceInfo;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.repository.AttributeUsage;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.SQLHelper;

public class Model
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(oracle.dmt.dataminer.server.model.Model.class.getName());
    private String _function;
    private String _algorithm;
    private Timestamp _creationTime;
    private Timestamp _modelCreationTime;
    private Timestamp _lastUpdateTime;
    private Timestamp _lastRunTime;
    private Timestamp _runDuration;
    private String _state;
    private String _stateDescription;
    private boolean _archiveEnabled;
    private String _target;
    private List<AttributeUsage> _dataUsage = new ArrayList<AttributeUsage>();
    private static String ALL_SETTING_VALUE_QRY = "SELECT SETTING_NAME, DATA_TYPE, STR_SETTING_VALUE, NUM_SETTING_VALUE FROM ODMR_USER_ATN_SETTINGS WHERE AT_NODE_ID = ?";
    private static String STR_SETTING_VALUE_QRY = "SELECT STR_SETTING_VALUE FROM ODMR_USER_ATN_SETTINGS WHERE SETTING_NAME = ? AND AT_NODE_ID = ?";
    private static String NUM_SETTING_VALUE_QRY = "SELECT NUM_SETTING_VALUE FROM ODMR_USER_ATN_SETTINGS WHERE SETTING_NAME = ? AND AT_NODE_ID = ?";
    private static String WEIGHTS_QRY = "SELECT TARGET_STR_VAL, TARGET_NUM_VAL, WEIGHT FROM ODMR_USER_ATN_WEIGHTS WHERE AT_NODE_ID = ?";
    private static String PRIORS_QRY = "SELECT TARGET_STR_VAL, TARGET_NUM_VAL, PRIOR_PROBABILITY FROM ODMR_USER_ATN_PRIORS WHERE AT_NODE_ID = ?";
    private static String COSTS_MATRIX_QRY = "SELECT TYPE, ACTUAL_TARGET_STR_VAL, PREDICTED_TARGET_STR_VAL, ACTUAL_TARGET_NUM_VAL, PREDICTED_TARGET_NUM_VAL, COST FROM ODMR_USER_ATN_COST_MATRICES  WHERE AT_NODE_ID = ?";
    public static final String AT_NODE_TABLE = "ODMR_USER_AT_NODE";
    public static final String NODE_ID = "AT_NODE_ID";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String ACTIVITY_ID = "AT_ID";
    public static final String TYPE = "NODE_TYPE";
    public static final String FUNCTION = "MINING_FUNCTION";
    public static final String ALGORITHM = "MINING_ALGORITHM";
    public static final String MODEL_NAME = "MODEL_NAME";
    public static final String CREATION_TIME = "CREATION_TIME";
    public static final String LAST_UPDATED_TIME = "LAST_UPDATED_TIME";
    public static final String LAST_RUN_TIME = "LAST_RUN_TIME";
    public static final String LAST_RUN_DURATION = "LAST_RUN_DURATION";
    public static final String STATE = "STATE";
    public static final String STATE_DESCRIPTION = "STATE_DESCRIPTION";
    public static final String ARCHIVE_ON = "ARCHIVE_ON";
    public static final String COMMENTS = "COMMENTS";
    public static final String ODM_ALL_MINING_MODELS = "USER_MINING_MODELS";
    public static final String ODM_OWNER = "OWNER";
    public static final String ODM_MODEL_NAME = "MODEL_NAME";
    public static final String ODM_CREATION_DATE = "CREATION_DATE";
    public static final int _ROUNDING_PRECISION = 4;

    public Model(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    @Override
    public void load(Connection connection) {
        if (this.isLoaded()) {
            return;
        }
        this.loadAttributeUsage(connection);
        this.setLoaded(true);
    }

    @Override
    public void unload() throws Exception {
        this._dataUsage.clear();
        this.setLoaded(false);
    }

    @Override
    public void refresh(Connection connection) {
    }

    public static Map<String, String> getAllModelNames(Connection connection) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer("select MODEL_NAME from USER_MINING_MODELS order by MODEL_NAME");
        try {
            sQLHelper.pstmt = connection.prepareStatement(stringBuffer.toString());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string = sQLHelper.rs.getString("MODEL_NAME");
                hashMap.put(string, string);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeUsage(Connection connection) {
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        String[] stringArray = new String[]{"DG_TAB_COL_ID", "ATTRIBUTE_TYPE", "IS_ATN_ATTR_INPUT", NODE_ID, "IS_ATN_ATTR_TARGET", COMMENTS};
        stringArray = Model.delimit(stringArray, "ODMR_USER_ATN_ATTR_USAGE");
        String[] stringArray2 = new String[]{"COLUMN_ID", "COLUMN_NAME"};
        stringArray2 = Model.delimit(stringArray2, "ODMR_USER_DG_TAB_COLS");
        String[] stringArray3 = Model.combine(stringArray, stringArray2);
        String[] stringArray4 = new String[]{"ODMR_USER_ATN_ATTR_USAGE", "ODMR_USER_DG_TAB_COLS"};
        string = SQLHelper.buildSimpleQuery(stringArray3, stringArray4, "AT_NODE_ID = ? AND DG_TAB_COL_ID = COLUMN_ID");
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, this.getId());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            this._dataUsage.clear();
            while (sQLHelper.rs.next()) {
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("DG_TAB_COL_ID");
                AttributeUsage attributeUsage = new AttributeUsage(sQLHelper.rs.getString("COLUMN_NAME"), bigDecimal, sQLHelper.rs.getBigDecimal(NODE_ID));
                attributeUsage.setAttributeType(sQLHelper.rs.getString("ATTRIBUTE_TYPE"));
                if (sQLHelper.rs.getString("IS_ATN_ATTR_TARGET").equals("Y")) {
                    attributeUsage.setIsTarget();
                } else if (sQLHelper.rs.getString("IS_ATN_ATTR_INPUT").equals("Y")) {
                    attributeUsage.setIsInput();
                } else {
                    attributeUsage.setIsIgnored();
                }
                this._dataUsage.add(attributeUsage);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
    }

    public List<AttributeUsage> getDataUsage() {
        return this._dataUsage;
    }

    public void setFunction(String string) {
        this._function = string;
    }

    public String getFunction() {
        return this._function;
    }

    public void setAlgorithm(String string) {
        this._algorithm = string;
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public void setCreationTime(Timestamp timestamp) {
        this._creationTime = timestamp;
    }

    public Timestamp getCreationTime() {
        return this._creationTime;
    }

    public void setLastUpdateTime(Timestamp timestamp) {
        this._lastUpdateTime = timestamp;
    }

    public Timestamp getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setLastRunTime(Timestamp timestamp) {
        this._lastRunTime = timestamp;
    }

    public Timestamp getLastRunTime() {
        return this._lastRunTime;
    }

    public void setRunDuration(Timestamp timestamp) {
        this._runDuration = timestamp;
    }

    public Timestamp getRunDuration() {
        return this._runDuration;
    }

    public void setState(String string) {
        this._state = string;
    }

    public String getState() {
        return this._state;
    }

    public void setStateDescription(String string) {
        this._stateDescription = string;
    }

    public String getStateDescription() {
        return this._stateDescription;
    }

    public void setArchiveEnabled(boolean bl) {
        this._archiveEnabled = bl;
    }

    public boolean isArchiveEnabled() {
        return this._archiveEnabled;
    }

    public void setModelCreationTime(Timestamp timestamp) {
        this._modelCreationTime = timestamp;
    }

    public Timestamp getModelCreationTime() {
        return this._modelCreationTime;
    }

    public void setTarget(String string) {
        this._target = string;
    }

    public String getTarget() {
        return this._target;
    }

    public CostMatrixInfo getCostMatrixOption(Connection connection) {
        String string = this.getModelSettingStringValue(connection, "BUILD_SETTING_COST_MATRIX_OPTION");
        if (string == null) {
            string = "BUILD_SETTING_CSTBNF_OP_NONE";
        }
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo(string);
        return costMatrixInfo;
    }

    public void loadCostBenefitInfo(Connection connection, CostMatrixInfo costMatrixInfo) {
        if (costMatrixInfo.isCostMatrixTrue()) {
            this.loadCostMatrix(connection, costMatrixInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCostMatrix(Connection connection, CostMatrixInfo costMatrixInfo) {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(COSTS_MATRIX_QRY);
            sQLHelper.pstmt.setBigDecimal(1, this.getId());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string = sQLHelper.rs.getString("TYPE");
                String string2 = sQLHelper.rs.getString("ACTUAL_TARGET_STR_VAL");
                String string3 = sQLHelper.rs.getString("PREDICTED_TARGET_STR_VAL");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("ACTUAL_TARGET_NUM_VAL");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("PREDICTED_TARGET_NUM_VAL");
                BigDecimal bigDecimal3 = sQLHelper.rs.getBigDecimal("COST");
                if (bigDecimal3 == null) continue;
                costMatrixInfo.setType(string);
                if (string2 != null && 0 != string2.length() && string3 != null && 0 != string3.length()) {
                    costMatrixInfo.put(string2, string3, bigDecimal3);
                    continue;
                }
                if (bigDecimal == null || bigDecimal2 == null) continue;
                costMatrixInfo.put(bigDecimal, bigDecimal2, bigDecimal3);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            costMatrixInfo.clear();
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWeights(Connection connection, PerformanceInfo performanceInfo) {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(WEIGHTS_QRY);
            sQLHelper.pstmt.setBigDecimal(1, this.getId());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string = sQLHelper.rs.getString("TARGET_STR_VAL");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("TARGET_NUM_VAL");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("WEIGHT");
                assert (bigDecimal2 != null) : "weight value is missing!";
                if (string != null && 0 != string.length()) {
                    performanceInfo.put(string, bigDecimal2);
                    continue;
                }
                if (bigDecimal != null) {
                    performanceInfo.put(bigDecimal.toString(), bigDecimal2);
                    continue;
                }
                assert (string == null && bigDecimal == null) : "incorrect weight specification";
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            performanceInfo.clear();
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelSettingStringValue(Connection connection, String string) {
        String string2 = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(STR_SETTING_VALUE_QRY);
            sQLHelper.pstmt.setString(1, string);
            sQLHelper.pstmt.setBigDecimal(2, this.getId());
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string2 = sQLHelper.rs.getString(1);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return string2;
    }

    public static CostMatrixInfo getROCCostBenefit(Vector<RowColumnValue> vector) {
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TUNED");
        for (int i = 0; i < vector.size(); ++i) {
            RowColumnValue rowColumnValue = vector.elementAt(i);
            Object object = rowColumnValue._row;
            Object object2 = rowColumnValue._col;
            costMatrixInfo.put(object, object2, rowColumnValue._value);
        }
        return costMatrixInfo;
    }
}

