/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class RegressTestResult
extends TestResult {
    private static final Logger theLogger = Logger.getLogger(RegressTestResult.class.getName());
    public static final String PERFORM_METRICS_TABLE_NAME = "PERFORM_METRICS_TABLE_NAME";
    public static final String RESIDUAL_PLOT_TABLE_NAME = "RESIDUAL_PLOT_TABLE_NAME";
    public static final String PREDICTIVE_CONFIDENCE = "PREDICTIVE_CONFIDENCE";
    public static final String MEAN_RMS_ERROR = "MEAN_RMS_ERROR";
    public static final String MEAN_ABSOLUTE_ERROR = "MEAN_ABSOLUTE_ERROR";
    public static final String MEAN_PREDICATED_VALUE = "MEAN_PREDICATED_VALUE";
    public static final String MEAN_ACTUAL_VALUE = "MEAN_ACTUAL_VALUE";

    public RegressTestResult(RegressTestResult regressTestResult) {
        super(regressTestResult);
    }

    public RegressTestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(context, buildNodeType, miningResultType);
        boolean bl = false;
        if (buildNodeType instanceof RegressionBuildNodeType) {
            RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
            RegressionBuildNodeType.Models models = regressionBuildNodeType.getModels();
            List list = models.getRSupportVectorMachineModel();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("REGRESSION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            for (Object object : list) {
                if (object.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                this._data.put("MODEL_NAME", object.getName());
                this._data.put("MODEL_ID", object.getId());
                this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
                bl = true;
                break;
            }
            if (!bl) {
                Object object;
                List list2 = models.getRGeneralizedLinearModel();
                object = list2.iterator();
                while (object.hasNext()) {
                    RGeneralizedLinearModelType rGeneralizedLinearModelType = (RGeneralizedLinearModelType)object.next();
                    if (rGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", rGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", rGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
                    bl = true;
                    break;
                }
            }
            if (((RegressionResultType)miningResultType).getTestMetrics() != null) {
                this._data.put(PERFORM_METRICS_TABLE_NAME, ((RegressionResultType)miningResultType).getTestMetrics().getName());
            }
            if (((RegressionResultType)miningResultType).getResidualPlot() != null) {
                this._data.put(RESIDUAL_PLOT_TABLE_NAME, ((RegressionResultType)miningResultType).getResidualPlot().getName());
            }
            this.loadMetrics();
        }
    }

    public RegressTestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(context, testNodeType, miningResultType);
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (model.getModelId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("REGRESSION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_SCHEMA", model.getSchema());
            this._data.put("MODEL_NAME", model.getName());
            this._data.put("MODEL_ID", model.getModelId());
            this._data.put("MINING_ALGORITHM", ServerConstants.Algorithm.getUIAlgorithmName(model.getMiningAlgorithm().value()));
            break;
        }
        if (((RegressionResultType)miningResultType).getTestMetrics() != null) {
            this._data.put(PERFORM_METRICS_TABLE_NAME, ((RegressionResultType)miningResultType).getTestMetrics().getName());
        }
        if (((RegressionResultType)miningResultType).getResidualPlot() != null) {
            this._data.put(RESIDUAL_PLOT_TABLE_NAME, ((RegressionResultType)miningResultType).getResidualPlot().getName());
        }
        this.loadMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetrics() {
        String string = null;
        Connection connection = null;
        String string2 = this.getPerformanceMatrixTable();
        string = "Select metric_name, metric_num_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'MEAN_RMS_ERROR', 'MEAN_ABSOLUTE_ERROR', 'MEAN_PREDICATED_VALUE', 'MEAN_ACTUAL_VALUE')";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getUniqueConnection(this._context);
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(1);
                if (PREDICTIVE_CONFIDENCE.equals(string3)) {
                    this._data.put(PREDICTIVE_CONFIDENCE, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_RMS_ERROR.equals(string3)) {
                    this._data.put(MEAN_RMS_ERROR, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_ABSOLUTE_ERROR.equals(string3)) {
                    this._data.put(MEAN_ABSOLUTE_ERROR, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (MEAN_PREDICATED_VALUE.equals(string3)) {
                    this._data.put(MEAN_PREDICATED_VALUE, sQLHelper.rs.getBigDecimal(2));
                    continue;
                }
                if (!MEAN_ACTUAL_VALUE.equals(string3)) continue;
                this._data.put(MEAN_ACTUAL_VALUE, sQLHelper.rs.getBigDecimal(2));
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
    }

    public String getPerformanceMatrixTable() {
        return (String)this._data.get(PERFORM_METRICS_TABLE_NAME);
    }

    public boolean performanceMatrixExists() {
        return this._data.get(PERFORM_METRICS_TABLE_NAME) != null;
    }

    public String getResidualPlotTable() {
        return (String)this._data.get(RESIDUAL_PLOT_TABLE_NAME);
    }

    public boolean residualPlotExists() {
        return this._data.get(RESIDUAL_PLOT_TABLE_NAME) != null;
    }

    public BigDecimal getPredictiveConfidence() {
        return (BigDecimal)this._data.get(PREDICTIVE_CONFIDENCE);
    }

    public BigDecimal getRootMeanSquareError() {
        return (BigDecimal)this._data.get(MEAN_RMS_ERROR);
    }

    public BigDecimal getMeanAbsoluteError() {
        return (BigDecimal)this._data.get(MEAN_ABSOLUTE_ERROR);
    }

    public BigDecimal getMeanPredictedValue() {
        return (BigDecimal)this._data.get(MEAN_PREDICATED_VALUE);
    }

    public BigDecimal getMeanActualValue() {
        return (BigDecimal)this._data.get(MEAN_ACTUAL_VALUE);
    }

    public boolean isAccuracyMetricsResult() {
        if (this._result instanceof RegressionResultType) {
            RegressionResultType regressionResultType = (RegressionResultType)this._result;
            return regressionResultType.getTestMetrics() != null;
        }
        return false;
    }

    public boolean isResidualsResult() {
        if (this._result instanceof RegressionResultType) {
            RegressionResultType regressionResultType = (RegressionResultType)this._result;
            return regressionResultType.getResidualPlot() != null;
        }
        return false;
    }
}

