/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.util.Vector;

public abstract class RepositoryObject {
    public static final String COMMA = ",";
    public static final String DOT = ".";
    protected String _name;
    protected String _userName;
    protected BigDecimal _id;
    protected BigDecimal _parentId;
    protected String _comment;

    public RepositoryObject(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(string, null, bigDecimal, bigDecimal2);
    }

    public RepositoryObject(String string, String string2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this._name = string;
        this._id = bigDecimal;
        this._parentId = bigDecimal2;
        this._comment = null;
        this._userName = string2;
    }

    public RepositoryObject(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        this(null, bigDecimal, bigDecimal2);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String string) {
        this._userName = string;
    }

    public BigDecimal getId() {
        return this._id;
    }

    public BigDecimal getParentId() {
        return this._parentId;
    }

    public String getComment() {
        return this._comment == null ? "" : this._comment.toString();
    }

    public void setComment(String string) {
        this._comment = string;
    }

    public static String buildQuery(String[] stringArray, String[] stringArray2, String string) {
        int n;
        assert (stringArray != null && stringArray.length >= 0) : "Columns array cannot be null";
        assert (stringArray2 != null && stringArray2.length >= 0) : "Tables array cannot be null";
        if (string != null) assert (string.length() > 0) : "Where clause cannot be empty";
        StringBuffer stringBuffer = new StringBuffer("select ");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            if (n == stringArray.length - 1) {
                stringBuffer.append(" from ");
                continue;
            }
            stringBuffer.append(", ");
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(stringArray2[n]);
            if (n == stringArray2.length - 1) {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(", ");
        }
        if (string != null) {
            stringBuffer.append(" where " + string);
        }
        return stringBuffer.toString();
    }

    public static String buildQuery(String[] stringArray, String[] stringArray2) {
        return RepositoryObject.buildQuery(stringArray, stringArray2, null);
    }

    public static String[] delimit(String[] stringArray, String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(RepositoryObject.delimit(stringArray[i], string));
        }
        String[] stringArray2 = new String[]{};
        return vector.toArray(stringArray2);
    }

    public static String delimit(String string, String string2) {
        return string2 + DOT + string;
    }

    public static String[] combine(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.add(string);
        }
        for (String string : stringArray2) {
            vector.add(string);
        }
        String[] stringArray3 = new String[]{};
        return vector.toArray(stringArray3);
    }

    public String toString() {
        return this.getName();
    }
}

