/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.awt.Component;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultNameGenerator;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.DBReservedWords;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.i18n.text.OraUnicodeProperty;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.CLOB;

public class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(StringUtils.class.getName());
    static final char DOLLAR_SIGN = '$';
    static final char POUND_SIGN = '#';
    static final char UNERSCORE = '_';
    static final char DOUBLE_QUOTE = '\"';
    static final char SINGLE_QUOTE = '\"';
    static final char DOT = '.';
    static final String ROWID = "ROWID";
    static final String SQL_SCRIPT_ESCAPE_CHAR = "\\";
    static final String DB_CHAR_LENGTH_ANONYMOUS_BLOCK = "DECLARE\n  v_length_string integer := 0;\n  v_sql_stmt      VARCHAR2(32627);\nBEGIN\n  v_sql_stmt := 'SELECT LENGTHB(''<INPUT_STRING>'') FROM DUAL';\n  EXECUTE IMMEDIATE v_sql_stmt INTO v_length_string;\n  --DBMS_OUTPUT.PUT_LINE ('Length of string : ' || v_length_string );\n  ? := v_length_string;\nEND;";
    public static final String EMPTY = "";

    public static char stripFirstCharFromString(String string) {
        char c = 'Z';
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0) {
            c = stringBuffer.charAt(0);
        }
        return c;
    }

    public static boolean isDoubleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static String addSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "'" + string + "'";
    }

    public static String addDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "\"" + string + "\"";
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isSingleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("'") && string.endsWith("'") && string.length() > 1;
    }

    public static boolean isGreater32BytesInDB(String string, Connection connection) {
        return !StringUtils.checkStringDBLengthMax(string, connection, 30);
    }

    public static String trimSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeBlankLines(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("\n{2,}", "\n");
        string2 = string2.replaceAll("\r\n{2,}", "\r\n");
        string2 = string2.replaceAll("\r{2,}", "\r");
        return string2;
    }

    public static String getReplacedString(String string, String string2, String string3) {
        try {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string2.length() > 0) {
                while ((n2 = string.indexOf(string2, n)) >= 0) {
                    stringBuffer.append(string.substring(n, n2));
                    stringBuffer.append(string3);
                    n = n2 + string2.length();
                }
            }
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String escapeCharacterForSQLScript(String string, String string2) {
        return StringUtils.getReplacedString(string, string2, SQL_SCRIPT_ESCAPE_CHAR + string2);
    }

    public static String escapeSingleQuotesForSQL(String string) {
        return StringUtils.getReplacedString(string, "'", "''");
    }

    public static String processQuotedName(String string) {
        String string2 = StringUtils.trimDoubleQuotes(string);
        string2 = StringUtils.getReplacedString(string2, "'", "''");
        return string2;
    }

    public static String stripDataSource(String string) {
        try {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0 && (n = string.lastIndexOf("FROM")) >= 0) {
                stringBuffer.append(string.substring(0, n + 4));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getTargetUserFromProxyTNSUser(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0) {
                int n = 0;
                int n2 = 0;
                n = string.lastIndexOf("[");
                n2 = string.lastIndexOf("]");
                if (n > 0 && n2 > 0 && n < n2 && n2 + 1 == string.length()) {
                    stringBuffer.append(string.subSequence(n + 1, n2));
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ArrayList<String> chopString(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            for (n3 = Math.min(n + i, n2); n3 < n2 - 1 && string.charAt(n3 + 1) == '\''; ++n3) {
            }
            String string2 = string.substring(i, n3);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean checkStringLength(String string, int n) {
        if (string == null) {
            return false;
        }
        return string.length() <= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkStringDBLengthLong(String string, Connection connection) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.length() == 0) {
            return n;
        }
        SQLHelper sQLHelper = new SQLHelper();
        CLOB cLOB = null;
        try {
            cLOB = StringUtils.getTempClob(string, connection);
            sQLHelper.cstmt = connection.prepareCall("begin ? := ODMR_UTIL.get_clob_byte_length(?); end;");
            sQLHelper.cstmt.registerOutParameter(1, 4);
            sQLHelper.cstmt.setClob(2, (Clob)cLOB);
            sQLHelper.cstmt.execute();
            n = sQLHelper.cstmt.getInt(1);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
            try {
                if (cLOB != null) {
                    cLOB.freeTemporary();
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        }
        return n;
    }

    public static CLOB getTempClob(String string, Connection connection) {
        CLOB cLOB = null;
        try {
            cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            Writer writer = cLOB.setCharacterStream(0L);
            writer.write(string);
            writer.flush();
            writer.close();
            cLOB.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINEST, " Error creating temporary clob to hold a string : " + exception.toString());
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkStringDBLength(String string, Connection connection) {
        int n = 0;
        if (string == null) {
            return n;
        }
        String string2 = "select LENGTHB(?) from DUAL";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string2);
            sQLHelper.opstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt(1);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return n;
    }

    public static boolean checkDataLossWithMsg(Context context, String string, String string2) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            if (StringUtils.checkDataLoss(Connections.getUniqueConnection(context), string, stringBuffer)) {
                String string3 = MessageFormat.format(TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_NAME_CONTAINS_SUPPORTED_CHARS"), stringBuffer);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string2, null);
                bl = true;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDataLoss(Connection connection, String string, StringBuffer stringBuffer) {
        if (string == null) {
            return false;
        }
        String string2 = "select TO_CHAR(?) from DUAL";
        String string3 = null;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            int n;
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string2);
            sQLHelper.opstmt.setString(1, string);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString(1);
            }
            stringBuffer.setLength(0);
            for (n = 0; n < string.length(); n += 1) {
                char c = string.charAt(n);
                if (c == string3.charAt(n)) continue;
                boolean bl = false;
                for (int i = 0; i < stringBuffer.length(); ++i) {
                    if (c != stringBuffer.charAt(i)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuffer.append(c);
            }
            n = string.compareTo(string3) != 0 ? 1 : 0;
            return n != 0;
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return false;
    }

    public static boolean checkStringDBLengthMax(String string, Connection connection, int n) {
        return StringUtils.checkStringDBLength(string, connection) <= n;
    }

    public static boolean checkStringDBLengthMaxLong(String string, Connection connection, int n) {
        return StringUtils.checkStringDBLengthLong(string, connection) <= n;
    }

    public static char getMnemonic(String string) {
        assert (string.length() == 1) : "Mnemonic key length not equal to 1.";
        return string.charAt(0);
    }

    public static String createFullyQualifiedName(String string, String string2) {
        String string3 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        String string4 = string3 + "." + StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string2));
        return string4;
    }

    public static String createNonQuotedCompliantName(String string) {
        String string2 = string.trim();
        char[] cArray = string2.toUpperCase().toCharArray();
        char[] cArray2 = new char[string2.length()];
        cArray2[0] = !Character.isLetter(cArray[0]) ? 65 : cArray[0];
        char c = ' ';
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            cArray2[i] = cArray[i];
            if (!Character.isLetterOrDigit(c)) {
                if (c == '$' || c == '#' || c == '_') continue;
                cArray2[i] = 95;
                continue;
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            cArray2[i] = 95;
        }
        String string3 = new String(cArray2);
        StringBuilder stringBuilder = new StringBuilder(string3);
        while (StringUtils.isDBReservedWord(stringBuilder.toString())) {
            stringBuilder.append("1");
        }
        return stringBuilder.toString();
    }

    public static boolean isDBReservedWord(String string) {
        return DBReservedWords.isReservedWord(string);
    }

    public static boolean isValidNonQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsOnlyValidDBNameCharacters(string);
        }
        return bl;
    }

    public static boolean isValidQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsNoDoubleQuotes(string);
        }
        return bl;
    }

    public static boolean isEqualToROWID(String string) {
        boolean bl = false;
        if (string.equals(ROWID)) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDoubleQuotes(String string) {
        int n = 32;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 34) continue;
            return false;
        }
        return true;
    }

    public static boolean containsDoubleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsSingleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDot(String string) {
        int n = 32;
        for (int i = 1; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 46) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMultibyteCharactes(String string) {
        boolean bl = false;
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!StringUtils.isMultibyteChar(c)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isMultibyteChar(char c) {
        boolean bl = false;
        char[] cArray = new char[]{c};
        int n = Character.codePointAt(cArray, 0);
        OraUnicodeProperty oraUnicodeProperty = OraUnicodeProperty.getInstance();
        try {
            int n2 = oraUnicodeProperty.getDisplayWidth(n, "EN_US", false);
            if (n2 != 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean containsOnlyValidDBNameCharacters(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            return bl;
        }
        bl = Character.isLetter(string.charAt(0));
        if (bl) {
            char c = ' ';
            for (int i = 1; i < string.length() && bl; ++i) {
                c = string.charAt(i);
                if (StringUtils.isValidDBNameCharacter(c)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isValidDBNameCharacter(char c) {
        boolean bl = true;
        if (!Character.isLetterOrDigit(c)) {
            if (c != '$' && c != '#' && c != '_') {
                bl = false;
            }
        } else if (Character.isLetter(c) && Character.isLowerCase(c)) {
            bl = false;
        }
        return bl;
    }

    public static String generateUniqueName(String string, HashMap hashMap) {
        String string2 = string;
        if (string2.length() > 26) {
            string2 = string2.substring(0, 26);
        }
        String string3 = string2;
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string3, EMPTY, false);
        string2 = defaultNameGenerator.nextName();
        boolean bl = true;
        do {
            boolean bl2;
            if (bl2 = hashMap.containsKey(string2)) {
                String string4;
                string2 = string4 = defaultNameGenerator.nextName();
                continue;
            }
            bl = false;
        } while (bl);
        return string2;
    }
}

