/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import oracle.dmt.dataminer.repository.Result;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public abstract class TestResult
extends Result {
    public static final String _SHOW_RESULT = "_SHOW_RESULT";
    private static int _start_index = 0;
    public static int _RESULT_NAME_IDX = _start_index++;
    public static int _MINING_FUNCTION_IDX = _start_index++;
    public static int _MINING_ALGORITHM_IDX = _start_index++;
    public static int _CREATION_TIME_IDX = _start_index++;
    public static int _ATTRIBUTE_NAME_IDX = _start_index++;
    protected Context _context;
    protected TestNodeType _test;
    protected BuildNodeType _build;
    protected MiningResultType _result;
    protected boolean _showSchema = false;

    public TestResult(TestResult testResult) {
        super(testResult.getName(), testResult.getId(), testResult.getParentId());
        this._data.putAll(testResult._data);
    }

    public TestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(miningResultType.getName(), new BigDecimal(miningResultType.getModelId()), new BigDecimal(miningResultType.getModelId()));
        this._context = context;
        this._build = buildNodeType;
        this._result = miningResultType;
    }

    public TestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(miningResultType.getName(), new BigDecimal(miningResultType.getModelId()), new BigDecimal(miningResultType.getModelId()));
        this._context = context;
        this._test = testNodeType;
        this._result = miningResultType;
    }

    public Boolean isResultSelected() {
        return (Boolean)this._data.get(_SHOW_RESULT);
    }

    public void setResultSelected(boolean bl) {
        this._data.put(_SHOW_RESULT, bl);
    }

    public BuildNodeType getBuild() {
        return this._build;
    }

    public TestNodeType getTest() {
        return this._test;
    }

    public MiningResultType getResult() {
        return this._result;
    }

    public void setResult(MiningResultType miningResultType) {
        this._result = miningResultType;
    }

    public void setShowSchema(boolean bl) {
        this._showSchema = bl;
    }

    public boolean isShowSchema() {
        return this._showSchema;
    }

    @Override
    public String toString() {
        String string = this.getModelName();
        String string2 = this.getModelSchema();
        if (string2 != null) {
            string = this._showSchema ? string2 + "." + this.getModelName() : this.getModelName();
        }
        return string;
    }
}

