/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.dmt.dataminer.generated.server.OdmrNodeReferenceSet;
import oracle.dmt.dataminer.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.navigator.ProjectFolderFilter;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.repository.RepositoryLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.wizard.workflow.WorkflowLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.migration.Migration;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractObject;
import oracle.dmt.dataminer.workflow.model.BuildTextNodeRef;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;
import oracle.sql.CLOB;
import oracle.xdb.XMLType;
import org.w3c.dom.Document;

public class Workflow
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(Workflow.class.getName());
    private WorkflowProcess wfp;
    private boolean readOnly = false;
    private static JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static String STANDARD_NLS_NUMERIC;
    public static final boolean REMOTE_DEBUG_ALL_SW = false;
    public static final boolean REMOTE_DEBUG_RUN_SW = false;
    public static final boolean REMOTE_DEBUG_SAVE_SW = false;
    public static final boolean REMOTE_DEBUG_RENAME_SW = false;
    public static final boolean REMOTE_DEBUG_LOAD_SW = false;
    public static final boolean REMOTE_DEBUG_UNLOCK_SW = false;
    public static final boolean REMOTE_DEBUG_DELETE_SW = false;
    public static final boolean REMOTE_DEBUG_CREATE_SW = false;
    public static final boolean REMOTE_DEBUG_CANCEL_SW = false;
    private static final String REMOTE_DEBUG_HOST = "XX.XXX.XXX.XXX";
    private static final String REMOTE_DEBUG_PORT = "4000";
    public static final String WORKFLOW_ID = "WORKFLOW_ID";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    public static final String WORKFLOW_DATA = "WORKFLOW_DATA";
    public static final String WF_CREATION_TIME = "WF_CREATION_TIME";
    public static final String STATUS = "STATUS";
    public static final String ODMR_USER_PROJECT_WORKFLOW = "ODMR_USER_PROJECT_WORKFLOW";
    public static final int NAME_MAX_LENGTH = 30;
    public static final int COMMENT_MAX_LENGTH = 4000;

    public Workflow(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        unmarshaller = Workflow.getJAXBContextInstance().createUnmarshaller();
        return unmarshaller;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        marshaller = Workflow.getJAXBContextInstance().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    public static JAXBContext getJAXBContextInstance() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)"oracle.dmt.dataminer.workflow.xmlschema");
        }
        return jaxbContext;
    }

    @Override
    public void load(Connection connection) throws SQLException, Exception {
        throw new Exception("Please use load(Connection, Timestamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp load(Connection connection, Timestamp timestamp, boolean bl) throws SQLException, JAXBException {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = null;
        try {
            String[] stringArray;
            odmrWorkflow = new OdmrWorkflow(connection);
            if (bl) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "W";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "R";
            }
            String[] stringArray4 = stringArray;
            timestampArray = new Timestamp[]{timestamp};
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            CLOB cLOB = odmrWorkflow.wfLoad(this.getId(), stringArray4, timestampArray);
            Reader reader = cLOB.getCharacterStream();
            if (stringArray4[0].getBytes()[0] == 82 && bl) {
                theLogger.log(Level.WARNING, "Unable to get a write lock, retrying");
                try {
                    Thread.sleep(4000L);
                    stringArray4 = new String[]{"W"};
                    cLOB = odmrWorkflow.wfLoad(this.getId(), stringArray4, timestampArray);
                    if (stringArray4[0].getBytes()[0] == 82) {
                        theLogger.log(Level.SEVERE, "Retry failed to get a write lock");
                    } else {
                        theLogger.log(Level.INFO, "Retry successful, write lock established");
                    }
                }
                catch (InterruptedException interruptedException) {
                    theLogger.log(Level.WARNING, interruptedException.getMessage(), interruptedException);
                }
            }
            this.setReadOnly(stringArray4[0].getBytes()[0] == 82);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            this.wfp = (WorkflowProcess)unmarshaller.unmarshal(reader);
            this.setLoaded(true);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return timestampArray[0];
    }

    public static Workflow WorkFlowImport(Context context, Connection connection, BigDecimal bigDecimal, String string, boolean bl, StringBuffer stringBuffer) throws Exception, JAXBException {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = new Timestamp[]{new Timestamp(0L)};
        Workflow workflow = null;
        BigDecimal bigDecimal2 = null;
        try {
            String string2 = stringBuffer.toString();
            if (!string2.startsWith("<?xml") || string2.indexOf("WorkflowProcess") <= 0) {
                throw new Exception("INVALID_WORKFLOW_XML");
            }
            String string3 = Connections.getUserAccountName(context);
            string2 = string2.replaceAll("Schema=\"\"", "Schema=\"" + StringUtils.trimDoubleQuotes(string3) + "\"");
            Migration migration = Migration.getInstance();
            WorkflowProcess workflowProcess = migration.migrate(context, string2);
            if (workflowProcess != null) {
                XMLType xMLType;
                Object object;
                odmrWorkflow = new OdmrWorkflow(connection);
                bigDecimal2 = Workflow.create(connection, bigDecimal, string, null, timestampArray);
                workflow = new Workflow(string, bigDecimal2, bigDecimal);
                workflow.setWorkflowProcess(workflowProcess);
                oracle.ide.model.Node node = context.getNode();
                WorkflowNode workflowNode = ProjectFolderFilter.getWorkflowNode(node.getURL().getPath() + "/" + string, true);
                workflowNode.setWorkflowModel(new WorkflowModel());
                workflowNode.setRepositoryData(workflow);
                workflowNode.ensureOpen();
                WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
                ProjectFolder projectFolder = (ProjectFolder)node.getData();
                workflowNode.setParent(projectFolder.getParent());
                context.setNode((oracle.ide.model.Node)workflowNode);
                Version version = DatabaseMetadataUtils.getDatabaseVersion(context);
                context.setProperty("TARGET_DATABASE_VERSION", (Object)version);
                context.setProperty("SOURCE_DATABASE_VERSION", (Object)version);
                StringBuffer stringBuffer2 = new StringBuffer("");
                if (workflowProcess.getDBVersion() != null && workflowProcess.getDBVersion().equals(version.toString())) {
                    workflowModel.load(workflow.getWorkflowProcess(), context);
                } else {
                    workflowModel.load(workflow.getWorkflowProcess(), context, true, stringBuffer2);
                    if (stringBuffer2 != null && stringBuffer2.length() > 0) {
                        String string4 = MessageFormat.format(WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES"), stringBuffer2.toString());
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)WorkflowLrb.get("IMPORT_UNSUPPORTED_NODES_TITLE"), null);
                        Workflow.delete(connection, bigDecimal2);
                        Workflow workflow2 = null;
                        return workflow2;
                    }
                }
                workflowModel.initOldNodeIds();
                workflowModel.setInPaste(true);
                ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
                Collection<Object> collection = workflowModel.getObjectsCollection();
                boolean bl2 = false;
                for (Object object22 : collection) {
                    if (!(object22 instanceof AbstractNode)) continue;
                    object = (AbstractNode)object22;
                    ((AbstractObject)object).getContext().setNode(context.getNode());
                    xMLType = ((AbstractNode)object).findParentNodes();
                    if (xMLType.isEmpty()) {
                        arrayList.add((AbstractNode)object);
                    }
                    if (object instanceof BuildTextNodeRef) {
                        bl2 = true;
                    }
                    ((AbstractNode)object).setNodeReady();
                }
                workflowModel.beginRefactoring();
                for (Node node2 : arrayList) {
                    node2.refactor(null, !bl);
                }
                WorkflowUtils.refactorPostProcess(workflowModel, collection);
                for (Node node3 : arrayList) {
                    node3.validate(true);
                }
                if (bl2) {
                    MessageDialog.optionalInformation((String)(Workflow.class.getName() + "containsTextRefNodeWarning"), (Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_CONTAINS_TEXT_REF"), (String)WorkflowLrb.get("CREATE_WORKFLOW_WARNING_NAME"), null);
                }
                workflowModel.endRefactoring();
                workflowModel.setInPaste(false);
                context.setNode(node);
                StringWriter stringWriter = new StringWriter();
                Marshaller marshaller = Workflow.createMarshaller();
                marshaller.marshal((Object)workflow.getWorkflowProcess(), (Writer)stringWriter);
                object = stringWriter.getBuffer();
                xMLType = XMLType.createXML((Connection)connection, (String)((StringBuffer)object).toString());
                String string4 = "Y";
                odmrWorkflow.wfSave(bigDecimal2, xMLType, timestampArray, "W", string4);
            }
        }
        catch (Exception exception) {
            if (bigDecimal2 != null) {
                Workflow.delete(connection, bigDecimal2);
            }
            throw exception;
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return workflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(Connection connection, String string, String string2) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfRename(this.getId(), string, string2);
            this._name = string;
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal create(Connection connection, BigDecimal bigDecimal, String string, String string2, Timestamp[] timestampArray) throws Exception {
        BigDecimal bigDecimal2 = null;
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            bigDecimal2 = odmrWorkflow.wfCreate(bigDecimal, string, string2, timestampArray);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return bigDecimal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Connection connection, BigDecimal bigDecimal) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfDelete(bigDecimal);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Map<WorkflowNode, Connection> map) throws Exception {
        Object var1_1 = null;
        try {
            if (map.size() == 1) {
                // empty if block
            }
            OdmrWorkflow odmrWorkflow = null;
            WorkflowNode workflowNode2 = null;
            try {
                for (WorkflowNode workflowNode2 : map.keySet()) {
                    odmrWorkflow = new OdmrWorkflow(map.get(workflowNode2));
                    odmrWorkflow.wfDelete(workflowNode2.getId());
                    try {
                        odmrWorkflow.release();
                        odmrWorkflow = null;
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                if (n == 20003) {
                    WorkflowInUseException workflowInUseException = new WorkflowInUseException();
                    workflowInUseException.setNode(workflowNode2);
                    throw workflowInUseException;
                }
                throw sQLException;
            }
            finally {
                if (odmrWorkflow != null) {
                    try {
                        odmrWorkflow.release();
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
        }
        finally {
            if (var1_1 != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUniqueName(Connection connection, BigDecimal bigDecimal, String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = null;
        String string3 = null;
        String[] stringArray = new String[]{WORKFLOW_NAME, WORKFLOW_ID};
        stringArray = Workflow.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string2 = SQLHelper.buildSimpleQuery(stringArray, stringArray2, "PROJECT_ID = ? AND WORKFLOW_ID IS NOT NULL");
        try {
            sQLHelper.pstmt = connection.prepareStatement(string2);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(WORKFLOW_NAME);
                hashMap.put(string4, string4);
            }
            string3 = string;
            int n = 1;
            while (hashMap.containsKey(string3)) {
                string3 = string + n++;
            }
        }
        finally {
            sQLHelper.close();
        }
        return string3;
    }

    private static void validateAndInitializeNumericalNLSSeting(Connection connection) throws SQLException {
        if (ConnectionFolder.isNumericFormatChangeRequired()) {
            ConnectionFolder.setConnectionLocaleNumberFormat(connection, STANDARD_NLS_NUMERIC);
        }
    }

    private static void validateAndReInitializeNumericalNLSSeting(Connection connection) throws SQLException {
        if (ConnectionFolder.isNumericFormatChangeRequired()) {
            ConnectionFolder.setConnectionLocaleNumberFormat(connection, ConnectionFolder.getNumericFormatForLocale());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdmrNodeReferenceSet[] getWorkflowNodesReferences(Connection connection, String string) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        OdmrNodeReferenceSet[] odmrNodeReferenceSetArray = new OdmrNodeReferenceSet[1];
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfGetNodesByType(string, odmrNodeReferenceSetArray);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return odmrNodeReferenceSetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getWorkflowNodeContent(Connection connection, String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        Object object = null;
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            CLOB cLOB = odmrWorkflow.wfGetNodeContent(string, bigDecimal, bigDecimal2, bigDecimal3);
            XMLType xMLType = XMLType.createXML((Connection)connection, (CLOB)cLOB);
            String string2 = xMLType.getStringVal();
            StringReader stringReader = new StringReader(string2);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(stringReader));
            object = jAXBElement.getValue();
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Connection connection, String[] stringArray, Timestamp timestamp, boolean bl, RunMode runMode) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        String string = null;
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            String string2 = runMode == RunMode.VALIDATE ? "UPSTREAM" : (bl ? "UPSTREAM" : "DOWNSTREAM");
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[]{new OdmrObjectNames(stringArray)};
            odmrWorkflow.wfRun(this.getId().toString(), odmrObjectNamesArray, runMode.toString(), string2, null, null, null, null, null);
            this.setReadOnly(true);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Connection connection) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfUnlock(this.getId());
            this.setReadOnly(true);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp save(Connection connection, Timestamp timestamp, boolean bl) throws Exception, SQLException, JAXBException {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            String string = ConfigUtils.getDatabaseVersion(connection).toString();
            this.wfp.setDBVersion(string);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)this.wfp, (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            if (ConfigUtils.isDebugBuild()) {
                Workflow.validateWorkflowXML(stringBuffer.toString());
            }
            XMLType xMLType = XMLType.createXML((Connection)connection, (String)stringBuffer.toString());
            timestampArray = new Timestamp[]{timestamp};
            String string2 = "N";
            if (bl) {
                string2 = "Y";
            }
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow.wfSave(this.getId(), xMLType, timestampArray, "W", string2);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return timestampArray[0];
    }

    @Override
    public void unload() {
        this.wfp = null;
        this.setLoaded(false);
    }

    @Override
    public void refresh(Connection connection) throws SQLException, Exception {
        throw new Exception("Please use refresh(Connection, Timestamp)");
    }

    public Timestamp refresh(Connection connection, Timestamp timestamp, boolean bl) throws SQLException, JAXBException {
        return this.load(connection, timestamp, bl);
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            WorkflowNode workflowNode = new WorkflowNode();
            ClassLoader classLoader = workflowNode.getClass().getClassLoader();
            uRL = classLoader.getResource(string);
            if (null == uRL) {
                throw new Exception("Cannot find XSD template: " + string);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return uRL;
    }

    private static String getTemplateFromJar(URL uRL, String string) throws Exception {
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer(16384);
        try {
            String string2;
            WorkflowNode workflowNode = new WorkflowNode();
            ClassLoader classLoader = workflowNode.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (null == inputStream) {
                throw new Exception("Cannot find template from jar: " + string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.FINEST, "Unable to get template from jar:" + uRL + " Reason:" + exception.getMessage());
            throw exception;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return stringBuffer.toString();
    }

    private static String getTemplate(String string) throws Exception {
        String string2;
        String string3 = string;
        String string4 = null;
        URL uRL = Workflow.getURL(string3);
        if (null != uRL && ((string2 = uRL.getProtocol()).equals("jar") || string2.equals("JAR") || string2.equals("bundleresource"))) {
            string4 = Workflow.getTemplateFromJar(uRL, string3);
        }
        return string4;
    }

    public static void validateWorkflowXML(String string) throws Exception {
        String string2 = "/XMLSchema.xsd";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.toString().getBytes("UTF-8")));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String string3 = Workflow.getTemplate(string2);
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(string3.getBytes("UTF-8")));
        Schema schema = schemaFactory.newSchema(streamSource);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    public void validateWorkflow(Connection connection, Timestamp timestamp) throws Exception {
        if (this.wfp == null) {
            this.load(connection, timestamp, false);
        }
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = Workflow.createMarshaller();
        marshaller.marshal((Object)this.wfp, (Writer)stringWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        Workflow.validateWorkflowXML(stringBuffer.toString());
    }

    public String export(Connection connection, Timestamp timestamp, Context context) throws Exception, JAXBException {
        String[] stringArray;
        boolean bl = false;
        if (this.wfp == null) {
            this.load(connection, timestamp, false);
            bl = true;
        }
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = Workflow.createMarshaller();
        String string = ConfigUtils.getDatabaseVersion(connection).toString();
        this.wfp.setDBVersion(string);
        marshaller.marshal((Object)this.wfp, (Writer)stringWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        if (bl) {
            this.unload();
        }
        String string2 = Connections.getUserAccountName(context);
        String string3 = stringBuffer.toString().replaceAll("Schema=\"" + string2 + "\"", "Schema=\"\"");
        string2 = string2.toUpperCase();
        string3 = string3.toString().replaceAll("Schema=\"" + string2 + "\"", "Schema=\"\"");
        string2 = string2.toLowerCase();
        string3 = string3.toString().replaceAll("Schema=\"" + string2 + "\"", "Schema=\"\"");
        int n = string3.indexOf("<InputStatisticTable");
        while (-1 != n) {
            int n2 = string3.indexOf("/>", n);
            stringArray = new StringBuilder(string3);
            stringArray.replace(n, n2 + 2, "");
            string3 = stringArray.toString();
            n = string3.indexOf("<InputStatisticTable");
        }
        String[] stringArray2 = new String[]{"View", "Sample"};
        stringArray = new String[]{"Dirty=\"false\"", "Dirty=\"true\""};
        for (String string4 : stringArray2) {
            String string5 = string4 + stringArray[0];
            String string6 = string4 + stringArray[1];
            int n3 = string3.indexOf(string5);
            while (-1 != n3) {
                int n4 = n3 + string5.length();
                StringBuilder stringBuilder = new StringBuilder(string3);
                stringBuilder.replace(n3, n4, string6);
                string3 = stringBuilder.toString();
                n3 = string3.indexOf(string5);
            }
        }
        return string3;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this.wfp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Workflow> getWorkflows(Connection connection, BigDecimal bigDecimal) throws SQLException {
        ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        String[] stringArray = new String[]{WORKFLOW_NAME, WORKFLOW_ID};
        stringArray = Workflow.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string = SQLHelper.buildSimpleQuery(stringArray, stringArray2, "PROJECT_ID = ? AND WORKFLOW_ID IS NOT NULL");
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(WORKFLOW_NAME);
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(WORKFLOW_ID);
                arrayList.add(new Workflow(string2, bigDecimal2, bigDecimal));
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static boolean validateWorkflowName(Connection connection, String string, Context context) {
        boolean bl = true;
        String string2 = "";
        try {
            ProjectFolder projectFolder = ProjectFolder.getProjectFolder(context);
            if (string.length() == 0) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_EMPTY"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!Workflow.validateWorkflowNameLength(string)) {
                bl = false;
                string2 = MessageFormat.format(WorkflowLrb.get("WORKFLOW_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!Workflow.validateWorkflowNameHasNoSlash(string)) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_CONTAINS_SLASH"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!Workflow.validateWorkflowNameUnique(connection, string, projectFolder.getId())) {
                bl = false;
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)WorkflowLrb.get("WORKFLOW_NAME_NOT_UNIQUE"), (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            } else if (!Workflow.validateWorkflowNameLengthAtDB(connection, string)) {
                bl = false;
                string2 = MessageFormat.format(WorkflowLrb.get("WORKFLOW_NAME_TOO_LONG"), Integer.toString(30));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)WorkflowLrb.get("CREATE_WORKFLOW_ERROR_NAME"), null);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean validateWorkflowNameLength(String string) {
        return string.length() <= 30;
    }

    public static boolean validateWorkflowNameHasNoSlash(String string) {
        return string.indexOf("/") == -1;
    }

    public static boolean validateWorkflowNameLengthAtDB(Connection connection, String string) {
        return StringUtils.checkStringDBLengthMax(string, connection, 30);
    }

    public static boolean validateWorkflowNameUnique(Connection connection, String string, BigDecimal bigDecimal) throws SQLException {
        List<String> list = Workflow.getWorkflowNames(connection, bigDecimal);
        assert (list != null) : "Unexpected null pointer for project list.";
        return !list.contains(string);
    }

    public static List<String> getWorkflowNames(Connection connection, BigDecimal bigDecimal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<Workflow> list = Workflow.getWorkflows(connection, bigDecimal);
            for (Workflow workflow : list) {
                arrayList.add(workflow.getName());
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    public static boolean validateWorkflowComment(Connection connection, String string) {
        boolean bl = true;
        String string2 = "";
        if (!Workflow.validateCommentLength(string)) {
            bl = false;
            string2 = MessageFormat.format(RepositoryLrb.get("COMMENT_TOO_LONG"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)RepositoryLrb.get("CREATE_WORKFLOW_ERROR_COMMENT"), null);
        } else if (!Workflow.validateCommentLengthAtDB(connection, string)) {
            bl = false;
            string2 = MessageFormat.format(RepositoryLrb.get("COMMENT_TOO_LONG_BYTES"), Integer.toString(4000));
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)RepositoryLrb.get("CREATE_WORKFLOW_ERROR_COMMENT"), null);
        }
        return bl;
    }

    public static boolean validateCommentLength(String string) {
        return string.length() <= 4000;
    }

    public static boolean validateCommentLengthAtDB(Connection connection, String string) {
        return StringUtils.checkStringDBLengthMaxLong(string, connection, 4000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void startRemoteDebug(Connection connection) {
        Workflow.endRemoteDebug(connection);
        String string = "begin dbms_debug_jdwp.connect_tcp(?,?); end;";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setString(1, REMOTE_DEBUG_HOST);
            sQLHelper.pstmt.setString(2, REMOTE_DEBUG_PORT);
            sQLHelper.pstmt.execute();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void endRemoteDebug(Connection connection) {
        String string = "begin dbms_debug_jdwp.disconnect; end;";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.execute();
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
    }

    public void setWorkflowProcess(WorkflowProcess workflowProcess) {
        this.wfp = workflowProcess;
    }

    static {
        STANDARD_NLS_NUMERIC = ".,";
    }

    public static enum RunMode {
        RUN,
        VALIDATE;

    }

    public static class WorkflowInUseException
    extends Exception {
        private transient WorkflowNode node = null;

        public void setNode(WorkflowNode workflowNode) {
            this.node = workflowNode;
        }

        public WorkflowNode getNode() {
            return this.node;
        }
    }
}

