/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.EventLog;
import oracle.dmt.dataminer.runner.EventLogPanel;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public class EventLogDialog {
    private static final Logger theLogger = Logger.getLogger(EventLogDialog.class.getName());
    protected JEWTDialog _dlg;
    protected String wizName = "EventLog!!!!";

    protected JEWTDialog buildDialog(String string, List<EventLog.Entry> list, EventLog.EntryInfo entryInfo, boolean bl) {
        EventLogPanel eventLogPanel = new EventLogPanel(string, list, entryInfo, bl);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 6;
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.wizName, n);
        jEWTDialog.setContent((Component)eventLogPanel);
        jEWTDialog.setTitle(this.getDialogTitle() + " " + string + "/" + entryInfo.getProjectName() + "/" + entryInfo.getWorkflowName());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), "view_event_log");
        return jEWTDialog;
    }

    protected String getDialogTitle() {
        return RunManagerLrb.get("EVENT_LOG_TITLE") + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, EventLog.EntryInfo entryInfo, boolean bl) {
        boolean bl2 = false;
        try {
            LogSteps logSteps = EventLogDialog.getSteps(string, bigDecimal, bigDecimal2, entryInfo.getNodeId());
            if (logSteps == null) {
                boolean bl3 = bl2;
                return bl3;
            }
            List<EventLog.Entry> list = logSteps.getSteps();
            EventLog.Entry entry = logSteps.getLastEntry();
            if (entry != null) {
                entryInfo.setEntry(entry);
            }
            JEWTDialog jEWTDialog = this.buildDialog(string, list, entryInfo, bl);
            jEWTDialog.setResizable(true);
            final EventLogPanel eventLogPanel = (EventLogPanel)jEWTDialog.getContent();
            jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                    String string = propertyChangeEvent.getPropertyName();
                    Object object = propertyChangeEvent.getNewValue();
                    if (string.equals("closed") && Boolean.TRUE.equals(object) && !eventLogPanel.doWork()) {
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            });
            this._dlg = jEWTDialog;
            if (jEWTDialog != null) {
                jEWTDialog.setCancelButtonText(RunManagerLrb.get("CLOSE_VIEWER"));
                jEWTDialog.setPreferredSize(new Dimension(1000, 500));
                jEWTDialog.setMinimumSize(new Dimension(300, 200));
                bl2 = WizardLauncher.runDialog((JDialog)jEWTDialog);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
        }
        finally {
            if (!bl2) {
                this.cancel();
            }
        }
        return bl2;
    }

    protected void cancel() {
    }

    public static LogSteps getSteps(final String string, final BigDecimal bigDecimal, final BigDecimal bigDecimal2, final String string2) {
        class GetLogEnties
        extends ProgressRunnable {
            private boolean canceled;
            private LogSteps stepsInfo = null;

            GetLogEnties() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doWork() throws Exception {
                Connection connection = null;
                try {
                    Object object;
                    connection = Connections.getUniqueConnection(string);
                    LogSteps logSteps = new LogSteps();
                    if (string2 != null) {
                        object = EventLog.getLastEntryFor(connection, bigDecimal, bigDecimal2, string2);
                        logSteps.setLastEntry((EventLog.Entry)object);
                    }
                    object = EventLog.getEntriesFor(connection, bigDecimal, bigDecimal2);
                    logSteps.setSteps((List<EventLog.Entry>)object);
                    this.stepsInfo = logSteps;
                }
                finally {
                    SQLHelper.close(connection);
                }
                return this.stepsInfo;
            }

            protected void finish(Object object) {
            }

            protected void doCancel() {
                super.doCancel();
                this.canceled = true;
            }

            public LogSteps getSteps() {
                return this.stepsInfo;
            }
        }
        GetLogEnties getLogEnties = new GetLogEnties();
        getLogEnties.setTitle(RunManagerLrb.get("GETTING_EVENT_LOG_TITLE"));
        getLogEnties.setMessage(RunManagerLrb.get("GETTING_EVENT_LOG_DESCRIPTION"));
        try {
            getLogEnties.start(true);
            if (getLogEnties.canceled) {
                return null;
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("EXCEPTION_MSG"));
            return null;
        }
        return getLogEnties.getSteps();
    }

    public static class LogSteps {
        private List<EventLog.Entry> steps = null;
        private EventLog.Entry lastEntry = null;

        public void setSteps(List<EventLog.Entry> list) {
            this.steps = list;
        }

        public List<EventLog.Entry> getSteps() {
            return this.steps;
        }

        public void setLastEntry(EventLog.Entry entry) {
            this.lastEntry = entry;
        }

        public EventLog.Entry getLastEntry() {
            return this.lastEntry;
        }
    }
}

