/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.navigator.NavigatorAddin;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.EventLog;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.repository.WorkflowJobNode;
import oracle.dmt.dataminer.runner.EventLogDialog;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.runner.RunnerPreferencesSettings;
import oracle.dmt.dataminer.runner.TasksWindow;
import oracle.dmt.dataminer.utils.DataMinerConnections;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class JobsPanel
extends JPanel
implements DataminerGUIPanel,
ConnectionListener {
    private static final Logger theLogger = Logger.getLogger(JobsPanel.class.getName());
    protected DockableWindow _dockableWindow;
    private boolean _autoSwitchConnection;
    private boolean _connectionLost;
    private DataMinerTable _jobsTable;
    private JScrollPane _scrollPane;
    private Toolbar _toolbar;
    private String _connectionName;
    private TaskTableModel _tableModel;
    private JComboBox _connCombo;
    private ToolButton _btnLog;
    private ToolButton _btnCancel;
    private ToolButton _btnPrefs;
    private ToolButton _btnResortByTime;
    private static int EVENTLOG_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.openEventLog");
    private static int TERMINATE_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.doTerminate");
    private static int PREFS_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.runManagerPrefs");
    private static int RESORT_CMDID = Ide.findOrCreateCmdID((String)"oracle.dataminer.resortTime");
    private static Object syncForSwitchConnection = new Object();
    private transient List<Object> commandQueue = new ArrayList<Object>();

    public JobsPanel(DockableWindow dockableWindow) {
        this.initComponents();
        this._dockableWindow = dockableWindow;
        this._connectionLost = false;
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesSettings.getInstance();
        this._autoSwitchConnection = runnerPreferencesSettings.getAutoSelectConnection();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._toolbar = new Toolbar();
        this._scrollPane = new JScrollPane();
        this._jobsTable = new DataMinerTable();
        this.setLayout(new BorderLayout());
        this._scrollPane.setViewportView((Component)((Object)this._jobsTable));
        this.add((Component)this._toolbar, "First");
        this.add((Component)this._scrollPane, "Center");
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        Object object;
        this._tableModel = new TaskTableModel(new ArrayList<WorkflowJob>());
        List<String> list = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            list = Connections.getInstance().getConnections();
            Connections.getInstance().addListener(this);
            arrayList.addAll(list);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)RunManagerLrb.get("JOB_UI_INIT_FAIL"), (String)RunManagerLrb.get("JOB_UI_INIT_FAIL_DESCR"), null);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        IdeAction ideAction = IdeAction.get((int)EVENTLOG_CMDID);
        IdeAction ideAction2 = IdeAction.get((int)TERMINATE_CMDID);
        IdeAction ideAction3 = IdeAction.get((int)PREFS_CMDID);
        IdeAction ideAction4 = IdeAction.get((int)RESORT_CMDID);
        this._btnCancel = new ToolButton((Action)ideAction2);
        this._btnLog = new ToolButton((Action)ideAction);
        this._btnPrefs = new ToolButton((Action)ideAction3);
        this._btnResortByTime = new ToolButton((Action)ideAction4);
        this._btnCancel.setIcon(OracleIcons.getIcon((String)"terminate.png"));
        this._btnCancel.setToolTipText(RunManagerLrb.get("STOP_WORKFLOW"));
        this._btnLog.setIcon(OracleIcons.getIcon((String)"log.png"));
        this._btnLog.setToolTipText(RunManagerLrb.get("VIEW_LOG"));
        this._btnPrefs.setIcon(OracleIcons.getIcon((String)"settings.png"));
        this._btnPrefs.setToolTipText(RunManagerLrb.get("RUN_MGR_PREFS"));
        this._btnResortByTime.setIcon(OracleIcons.getIcon((String)"sortbylocation.png"));
        this._btnResortByTime.setToolTipText(RunManagerLrb.get("SORT_BY_TIME"));
        this._connCombo = new JComboBox();
        this._connCombo.setRenderer(new ConnectionItemRenderer());
        this._connCombo.setToolTipText(RunManagerLrb.get("CONNECTION_TOOLTIP"));
        this._connCombo.setModel(defaultComboBoxModel);
        this._connCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.switchConnection();
            }
        });
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesSettings.getInstance();
        runnerPreferencesSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                ChangeInfo[] changeInfoArray = structureChangeEvent.getChangeDetails();
                for (int i = 0; i < changeInfoArray.length; ++i) {
                    ChangeInfo changeInfo = changeInfoArray[i];
                    if (changeInfo.getPropertyName().equals("autoSelectConnection")) {
                        JobsPanel.this._autoSwitchConnection = changeInfo.getNewValueAsBoolean();
                        continue;
                    }
                    if (!changeInfo.getPropertyName().equals("maxJobAge")) continue;
                    RunManager.setMaxJobAge(changeInfo.getNewValueAsInt());
                    JobsPanel.this.switchConnection();
                }
            }
        });
        if (list.size() != 0) {
            object = runnerPreferencesSettings.getDefaultConnectionName();
            if (object != null) {
                this._connCombo.setSelectedItem(object);
            } else {
                this._connectionName = objectArray[0];
                this._connCombo.setSelectedIndex(0);
            }
        } else {
            this._connectionName = null;
            this._connCombo.setEnabled(false);
            this._btnLog.setEnabled(false);
            this._btnCancel.setEnabled(false);
        }
        this._btnLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.openLog();
            }
        });
        this._btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JobsPanel.this._jobsTable.getSelectedRowsInModel();
                WorkflowJob workflowJob = JobsPanel.this._tableModel.getDataList().get(nArray[0]);
                JobsPanel.this.cancelJob(workflowJob);
            }
        });
        this._btnPrefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.openPreferences();
            }
        });
        this._btnResortByTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.setupTable(true);
            }
        });
        this._jobsTable.setAutoResizeMode(3);
        this._jobsTable.setColumnSelectorAvailable(false);
        this._jobsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                JobsPanel.this.updateButtonStates();
            }
        });
        object = new JMenuItem(RunManagerLrb.get("OPEN_WORKFLOW"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.openWorkflow();
            }
        });
        final JMenuItem jMenuItem = new JMenuItem(RunManagerLrb.get("STOP_WORKFLOW"));
        jMenuItem.setIcon(OracleIcons.getIcon((String)"terminate.png"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JobsPanel.this._jobsTable.getSelectedRowsInModel();
                if (nArray.length > 0) {
                    WorkflowJob workflowJob = JobsPanel.this._tableModel.getDataList().get(nArray[0]);
                    JobsPanel.this.cancelJob(workflowJob);
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(RunManagerLrb.get("VIEW_LOG"));
        jMenuItem2.setIcon(OracleIcons.getIcon((String)"log.png"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.openLog();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(RunManagerLrb.get("SORT_BY_TIME"));
        jMenuItem3.setIcon(OracleIcons.getIcon((String)"sortbylocation.png"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.setupTable(true);
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem(RunManagerLrb.get("RUN_MGR_PREFS"));
        jMenuItem4.setIcon(OracleIcons.getIcon((String)"settings.png"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JobsPanel.this.openPreferences();
            }
        });
        this._jobsTable.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = JobsPanel.this._jobsTable.rowAtPoint(mouseEvent.getPoint());
                if (n < 0) {
                    return;
                }
                int n2 = JobsPanel.this._jobsTable.convertRowIndexToModel(n);
                JobsPanel.this._jobsTable.setSelectedRowInModel(n2);
                if (mouseEvent.getClickCount() == 2) {
                    JobsPanel.this.openWorkflow();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
        this._jobsTable.addMouseListener(new MouseAdapter((JMenuItem)object, jMenuItem2, jMenuItem3, jMenuItem4){
            final /* synthetic */ JMenuItem val$goToItem;
            final /* synthetic */ JMenuItem val$openLogItem;
            final /* synthetic */ JMenuItem val$sortItem;
            final /* synthetic */ JMenuItem val$prefsItem;
            {
                this.val$goToItem = jMenuItem2;
                this.val$openLogItem = jMenuItem3;
                this.val$sortItem = jMenuItem4;
                this.val$prefsItem = jMenuItem5;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ContextMenu contextMenu = new ContextMenu();
                    JPopupMenu jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
                    WorkflowJob workflowJob = JobsPanel.this.getJobAtPoint(mouseEvent.getPoint());
                    if (workflowJob != null) {
                        if (workflowJob.isActive()) {
                            jPopupMenu.add(jMenuItem);
                        }
                        jPopupMenu.add(this.val$goToItem);
                        jPopupMenu.add(this.val$openLogItem);
                        jPopupMenu.add(this.val$sortItem);
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(this.val$sortItem);
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(this.val$prefsItem);
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    jPopupMenu = null;
                }
            }
        });
        this._toolbar.add((Component)this._connCombo);
        this._toolbar.forcePrimaryViewToolbar(true);
        this.updateButtonStates();
    }

    private void openPreferences() {
        String[] stringArray = new String[]{PreferencesLrb.get("DATA_MINER_PREFERENCES_KEY"), PreferencesLrb.get("RUNNER_PREFERENCES_KEY")};
        Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
    }

    private void openLog() {
        WorkflowJob workflowJob = null;
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        if (nArray.length > 0) {
            workflowJob = this._tableModel.getDataList().get(nArray[0]);
        }
        if (workflowJob == null) {
            return;
        }
        EventLogDialog eventLogDialog = new EventLogDialog();
        String string = this._tableModel.getJobConnectionName(workflowJob);
        EventLog.Entry entry = null;
        EventLog.EntryInfo entryInfo = new EventLog.EntryInfo(entry);
        if (workflowJob != null) {
            entryInfo.setJob(workflowJob);
            entryInfo.setJobId(workflowJob.getWorkflowId());
            entryInfo.setJobName(workflowJob.getName());
            entryInfo.setProjectId(workflowJob.getProjectId());
            entryInfo.setProjectName(workflowJob.getProjectName());
            entryInfo.setWorkflowId(workflowJob.getWorkflowId());
            entryInfo.setWorkflowName(workflowJob.getWorkflowName());
        }
        eventLogDialog.invoke(string, entryInfo.getJob().getProjectId(), entryInfo.getJob().getWorkflowId(), entryInfo, false);
    }

    private void openWorkflow() {
        WorkflowJob workflowJob = null;
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        if (nArray.length > 0) {
            workflowJob = this._tableModel.getDataList().get(nArray[0]);
        }
        if (workflowJob == null) {
            return;
        }
        URL uRL = DMURLFormatHelper.getURL(this.getConnectionName() + "/" + workflowJob.getProjectName() + "/" + workflowJob.getWorkflowName());
        AddinManager addinManager = AddinManager.getAddinManager();
        NavigatorAddin navigatorAddin = (NavigatorAddin)addinManager.getAddin(NavigatorAddin.class);
        NavigatorWindow navigatorWindow = navigatorAddin.getNavigatorManager().getNavigatorWindow();
        final TreeExplorer treeExplorer = navigatorWindow.getTreeExplorer();
        try {
            final WorkflowNode workflowNode = (WorkflowNode)NodeFactory.findOrCreate((URL)uRL);
            class ExpandTask
            implements Runnable {
                private TNode targetNode = null;
                ProgressBar progressBar;

                @Override
                public void run() {
                    this.progressBar.updateProgress(RunManagerLrb.get("OPEN_LOCATING"), "");
                    URL uRL = DMURLFormatHelper.getURL(JobsPanel.this.getConnectionName());
                    ConnectionFolder connectionFolder = (ConnectionFolder)NodeFactory.find((URL)uRL);
                    TNode tNode = treeExplorer.searchTNodeBreadthFirst((Element)connectionFolder, treeExplorer.getRoot());
                    this.targetNode = BaseDeferredFilter.findTreeNode((BaseTreeNode)workflowNode, tNode);
                    if (this.targetNode == null) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)new Exception(), (String)RunManagerLrb.get("OPEN_ERROR"));
                        this.progressBar.setDoneStatus();
                        return;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                progressBar.updateProgress(RunManagerLrb.get("OPEN_OPENING"), "");
                                if (progressBar.hasUserCancelled()) {
                                    return;
                                }
                                EditorManager editorManager = EditorManager.getEditorManager();
                                Context context = Context.newIdeContext((Node)workflowNode);
                                editorManager.openDefaultEditorInFrame(context);
                            }
                        });
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)RunManagerLrb.get("OPEN_ERROR"));
                    }
                    this.progressBar.setDoneStatus();
                }

                public void setProgressBar(ProgressBar progressBar) {
                    this.progressBar = progressBar;
                }
            }
            ExpandTask expandTask = new ExpandTask();
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), RunManagerLrb.get("OPEN_OPEN"), (Runnable)expandTask, false);
            progressBar.setCancelable(true);
            expandTask.setProgressBar(progressBar);
            progressBar.start(RunManagerLrb.get("OPEN_LOCATING"), "");
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unable to open workflow", (String)"Unable to open workflow due to internal error");
        }
    }

    private WorkflowJob getJobAtPoint(Point point) {
        if (!(this._jobsTable.getModel() instanceof TaskTableModel)) {
            return null;
        }
        TaskTableModel taskTableModel = (TaskTableModel)((Object)this._jobsTable.getModel());
        if (!(taskTableModel instanceof TaskTableModel)) {
            return null;
        }
        int n = this._jobsTable.rowAtPoint(point);
        if (n == -1) {
            return null;
        }
        int n2 = this._jobsTable.convertRowIndexToModel(n);
        WorkflowJob workflowJob = taskTableModel.getDataList().get(n2);
        return workflowJob;
    }

    private void cancelJob(WorkflowJob workflowJob) {
        if (workflowJob == null) {
            return;
        }
        if (this._jobsTable.getModel() instanceof TaskTableModel) {
            TaskTableModel taskTableModel = (TaskTableModel)((Object)this._jobsTable.getModel());
            int[] nArray = this._jobsTable.getSelectedRowsInModel();
            if (workflowJob.isActive()) {
                if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_WILL_BE_CANCELED"), (String)RunManagerLrb.get("WORKFLOW_CANCEL_WARNING_TITLE"), null)) {
                    try {
                        RunManager.stopWorkflow(taskTableModel.getSelectedJobs(nArray), this._connectionName);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL"), (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL_DESCR"), null);
                    }
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_NOT_RUNNING_DESCR"), (String)RunManagerLrb.get("WORKFLOW_NOT_RUNNING"), null);
            }
        }
    }

    private void updateButtonStates() {
        int n = this._jobsTable.getSelectedRowCount();
        if (n >= 1) {
            TaskTableModel taskTableModel = (TaskTableModel)((Object)this._jobsTable.getModel());
            boolean bl = taskTableModel.isJobActive(this._jobsTable.getSelectedRowsInModel());
            this._btnCancel.setEnabled(bl);
            this._btnLog.setEnabled(n == 1);
        } else {
            this.enableSelectionSensitiveControls(false);
        }
    }

    private void showLoading(boolean bl) {
        if (bl) {
            this.enableSelectionSensitiveControls(false);
            this._jobsTable.setNoEntryInstructionText(CommonLrb.get("COMMON_LOADING"));
            this._tableModel.clearJobs();
        } else {
            this._jobsTable.setModel((TableModel)((Object)this._tableModel));
            this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NO_JOBS_MSG"));
            this.setupTable(false);
        }
    }

    private void setupTable(boolean bl) {
        int[] nArray;
        ArrayList<RowSorter.SortKey> arrayList;
        if (this._jobsTable.getColumnModel().getColumnCount() < 2) {
            return;
        }
        TableColumn tableColumn = this._jobsTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new StatusCellRenderer());
        TableRowSorter<TaskTableModel> tableRowSorter = this._jobsTable.getRowSorter();
        if (tableRowSorter == null || bl) {
            boolean bl2 = false;
            if (tableRowSorter != null && (arrayList = ((RowSorter)tableRowSorter).getSortKeys()).size() == 1 && arrayList.get(0).getColumn() == 3) {
                bl2 = true;
            }
            if (!bl2) {
                tableRowSorter = new TableRowSorter<TaskTableModel>(this._tableModel);
                arrayList = new ArrayList<RowSorter.SortKey>();
                arrayList.add(new RowSorter.SortKey(3, SortOrder.DESCENDING));
                ((RowSorter)tableRowSorter).setSortKeys(arrayList);
                tableRowSorter.setSortsOnUpdates(true);
                this._jobsTable.setRowSorter(tableRowSorter);
            }
        }
        if ((nArray = this._jobsTable.getHiddenColumns()).length == 0) {
            arrayList = (ArrayList<RowSorter.SortKey>)new int[]{3};
            this._jobsTable.setHiddenColumns((int[])arrayList);
        }
    }

    private void enableSelectionSensitiveControls(boolean bl) {
        this._btnCancel.setEnabled(bl);
        this._btnLog.setEnabled(bl);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void autoSwitchConnection(String string) {
        if (!this._autoSwitchConnection) {
            return;
        }
        String string2 = (String)this._connCombo.getSelectedItem();
        if (string2 != null && !string2.equals(string)) {
            this._connCombo.setSelectedItem(string);
        }
    }

    public void switchConnection() {
        this._connectionLost = false;
        AddinManager addinManager = AddinManager.getAddinManager();
        final RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
        final String string = this._connectionName;
        this._connectionName = (String)this._connCombo.getSelectedItem();
        if (this._connectionName == null) {
            this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NOTHING_TO_MONITOR"));
            this._tableModel.clearJobs();
            this._connCombo.setEnabled(false);
            this._btnLog.setEnabled(false);
            return;
        }
        this._connCombo.setEnabled(true);
        RunnerPreferencesSettings.getInstance().setDefaultConnectionName(this._connectionName);
        final Object object = new Object();
        this.add(object);
        SwingWorker<Boolean, Object> swingWorker = new SwingWorker<Boolean, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean doInBackground() {
                Object object2 = syncForSwitchConnection;
                synchronized (object2) {
                    if (JobsPanel.this._connectionName.equals(string) && runManager.getListener((TasksWindow)JobsPanel.this._dockableWindow, JobsPanel.this._connectionName) != null) {
                        return Boolean.FALSE;
                    }
                    runManager.removeListener((TasksWindow)JobsPanel.this._dockableWindow, string);
                    if (!JobsPanel.this.isLastUIRequest(object)) {
                        return Boolean.FALSE;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JobsPanel.this.showLoading(true);
                            }
                        });
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    runManager.addListener((TasksWindow)JobsPanel.this._dockableWindow, JobsPanel.this._connectionName);
                }
                return Boolean.TRUE;
            }

            @Override
            public void done() {
                JobsPanel.this.remove(object);
            }
        };
        swingWorker.execute();
    }

    private boolean isLastUIRequest(Object object) {
        int n = this.commandQueue.indexOf(object);
        if (n == this.commandQueue.size() - 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void remove(Object object) {
        this.commandQueue.remove(object);
    }

    private void add(Object object) {
        this.commandQueue.add(object);
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        if (defaultComboBoxModel.getSize() == 0) {
            defaultComboBoxModel.insertElementAt(string, 0);
            this._connCombo.setEnabled(true);
            this._btnLog.setEnabled(true);
            this._connCombo.setSelectedIndex(0);
            return;
        }
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            int n = string2.compareTo(string);
            if (n <= 0) continue;
            defaultComboBoxModel.insertElementAt(string, i);
            return;
        }
        defaultComboBoxModel.addElement(string);
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string2.equals(string)) continue;
            defaultComboBoxModel.removeElementAt(i);
            if (defaultComboBoxModel.getSize() != 0) break;
            AddinManager addinManager = AddinManager.getAddinManager();
            RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
            runManager.removeListener((TasksWindow)this._dockableWindow, string);
            break;
        }
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        String string = DataMinerConnections.getUnqualifiedName(connectionEvent.getOldName());
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._connCombo.getModel();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string2.equals(string)) continue;
            int n = defaultComboBoxModel.getIndexOf(string2);
            int n2 = this._connCombo.getSelectedIndex();
            defaultComboBoxModel.removeElementAt(i);
            defaultComboBoxModel.insertElementAt(DataMinerConnections.getUnqualifiedName(connectionEvent.getConnectionName()), n);
            if (n2 != n) break;
            this._connCombo.setSelectedIndex(n);
            this.switchConnection();
            break;
        }
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    void clearTasks() {
        this._tableModel.clearJobs();
    }

    protected void jobsListenerInitialized() {
        this._tableModel.clearJobs();
        this.showLoading(false);
    }

    protected void addJobItem(RunManagerEvent runManagerEvent) {
        if (this._tableModel.getDataList().size() == 0 && this._jobsTable.getModel() instanceof TaskTableModel) {
            TableColumn tableColumn = this._jobsTable.getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new StatusCellRenderer());
        }
        this._tableModel.addJobItem(runManagerEvent);
        this.updateButtonStates();
    }

    protected void removeJobItem(RunManagerEvent runManagerEvent) {
        this._tableModel.removeJobItem(runManagerEvent);
        this.updateButtonStates();
    }

    protected void changeJobItem(RunManagerEvent runManagerEvent) {
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        this._tableModel.changeJobItem(runManagerEvent);
        this.setupTable(false);
        this._jobsTable.setSelectedRowsInModel(nArray);
        this.updateButtonStates();
    }

    protected void finishJobItem(RunManagerEvent runManagerEvent) {
        int[] nArray = this._jobsTable.getSelectedRowsInModel();
        this._tableModel.changeJobItem(runManagerEvent);
        this.setupTable(false);
        this._jobsTable.setSelectedRowsInModel(nArray);
        this.updateButtonStates();
    }

    public void connectionLost(RunManagerEvent runManagerEvent) {
        this._connectionLost = true;
        this._connCombo.repaint();
        if (runManagerEvent.getExceptionInfo() instanceof RunManager.UnmonitorableConnectionException) {
            RunManager.UnmonitorableConnectionException unmonitorableConnectionException = (RunManager.UnmonitorableConnectionException)runManagerEvent.getExceptionInfo();
            this._connCombo.setToolTipText(unmonitorableConnectionException.getMessage());
        } else {
            this._connCombo.setToolTipText(RunManagerLrb.get("CONNECTION_FAILED"));
        }
        this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NOT_MONITORED"));
    }

    public void connectionReestablished(RunManagerEvent runManagerEvent) {
        this._connectionLost = false;
        this._connCombo.repaint();
        this._connCombo.setToolTipText(RunManagerLrb.get("CONNECTION_CONNECTED"));
        this._jobsTable.setNoEntryInstructionText(RunManagerLrb.get("NO_JOBS_MSG"));
    }

    public void saveSettings() {
    }

    class StatusCellRenderer
    extends Component
    implements TableCellRenderer {
        private JLabel _statusLabel = new JLabel();
        private JProgressBar _progress = new JProgressBar();

        public StatusCellRenderer() {
            this._statusLabel.setOpaque(true);
            this._progress.setOpaque(true);
            this._statusLabel.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            assert (object != null);
            WorkflowJob workflowJob = (WorkflowJob)object;
            JComponent jComponent = this.getComponent(workflowJob);
            if (jComponent instanceof JLabel) {
                if (bl) {
                    jComponent.setBackground(jTable.getSelectionBackground());
                    jComponent.setForeground(jTable.getSelectionForeground());
                } else {
                    jComponent.setBackground(jTable.getBackground());
                    jComponent.setForeground(jTable.getForeground());
                }
            }
            jComponent.setOpaque(true);
            return jComponent;
        }

        private JComponent getComponent(WorkflowJob workflowJob) {
            String string = workflowJob.getState();
            JComponent jComponent = null;
            if (string.equals("INACTIVE")) {
                if (workflowJob.getHasFailedSteps()) {
                    this._statusLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
                    this._statusLabel.setText("");
                    jComponent = this._statusLabel;
                } else {
                    this._statusLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
                    this._statusLabel.setText("");
                    jComponent = this._statusLabel;
                }
            } else if (string.equals("QUEUED")) {
                this._statusLabel.setIcon(null);
                this._statusLabel.setText(RunManagerLrb.get("STATUS_INITIALIZING"));
                jComponent = this._statusLabel;
            } else if (string.equals("STOPPING")) {
                this._statusLabel.setIcon(null);
                this._statusLabel.setText(RunManagerLrb.get("STATUS_STOPPING"));
                jComponent = this._statusLabel;
            } else if (string.equals("ACTIVE")) {
                HashMap<String, WorkflowJobNode> hashMap = workflowJob.getNodes();
                this._progress.setMaximum(hashMap.size());
                int n = 0;
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    WorkflowJobNode workflowJobNode = (WorkflowJobNode)iterator.next().getValue();
                    if (!workflowJobNode.getState().equals("SUCCEEDED")) continue;
                    ++n;
                }
                this._progress.setValue(n);
                jComponent = this._progress;
            } else if (string.equals("FAILED")) {
                this._statusLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
                this._statusLabel.setText("");
                jComponent = this._statusLabel;
            } else if (string.equals("STOPPED")) {
                this._statusLabel.setText(RunManagerLrb.get("STATUS_CANCELLED"));
                this._statusLabel.setIcon(null);
                jComponent = this._statusLabel;
            } else {
                this._statusLabel.setText(RunManagerLrb.get("STATUS_UNEXPECTED"));
                this._statusLabel.setIcon(null);
                jComponent = this._statusLabel;
            }
            return jComponent;
        }
    }

    class TaskTableModel
    extends GenericBaseTableModel {
        private transient List<WorkflowJob> _data;
        private transient Map<WorkflowJob, String> _connNames;
        public static final int NAME = 0;
        public static final int PROJECT = 1;
        public static final int JOB = 2;
        public static final int TIME = 3;
        public static final int COLUMN_COUNT = 4;
        private String[] columnNames = new String[]{RunManagerLrb.get("RUN_COL_WF"), RunManagerLrb.get("RUN_COL_PROJ"), RunManagerLrb.get("RUN_COL_STATUS"), RunManagerLrb.get("RUN_COL_TIME")};

        public TaskTableModel(List<WorkflowJob> list) {
            this._data = list;
            this._connNames = new HashMap<WorkflowJob, String>();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public void addJobItem(RunManagerEvent runManagerEvent) {
            WorkflowJob workflowJob = runManagerEvent.getJob();
            this._data.add(workflowJob);
            this._connNames.put(workflowJob, runManagerEvent.getSource().getConnectionName());
            int n = this._data.indexOf(workflowJob);
            this.fireTableRowsInserted(n, n);
        }

        public void removeJobItem(RunManagerEvent runManagerEvent) {
            WorkflowJob workflowJob = runManagerEvent.getJob();
            WorkflowJob workflowJob2 = this.findJob(workflowJob.getWorkflowId());
            int n = this._data.indexOf(workflowJob2);
            if (n != -1) {
                this._data.remove(n);
                this._connNames.remove(workflowJob2);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void changeJobItem(RunManagerEvent runManagerEvent) {
            WorkflowJob workflowJob = runManagerEvent.getJob();
            WorkflowJob workflowJob2 = this.findJob(workflowJob.getWorkflowId());
            int n = this._data.indexOf(workflowJob2);
            if (n != -1) {
                this._data.set(n, workflowJob);
                this._connNames.put(workflowJob, runManagerEvent.getSource().getConnectionName());
                this.fireTableRowsUpdated(n, n);
            }
        }

        private WorkflowJob findJob(BigDecimal bigDecimal) {
            WorkflowJob workflowJob = null;
            for (WorkflowJob workflowJob2 : this._data) {
                if (!bigDecimal.equals(workflowJob2.getWorkflowId())) continue;
                workflowJob = workflowJob2;
                break;
            }
            return workflowJob;
        }

        public void clearJobs() {
            this._data.clear();
            this._connNames.clear();
            this.fireTableDataChanged();
        }

        public String getJobConnectionName(WorkflowJob workflowJob) {
            return this._connNames.get(workflowJob);
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return WorkflowJob.class;
            }
            if (n == 3) {
                return Timestamp.class;
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            WorkflowJob workflowJob = this._data.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = workflowJob.getWorkflowName();
                    break;
                }
                case 2: {
                    object = workflowJob;
                    break;
                }
                case 1: {
                    object = workflowJob.getProjectName();
                    break;
                }
                case 3: {
                    object = workflowJob.getStartTime();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public boolean isJobActive(int[] nArray) {
            boolean bl = true;
            WorkflowJob workflowJob = null;
            if (nArray.length == 0) {
                return false;
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    workflowJob = this._data.get(nArray[i]);
                    if (workflowJob.isActive()) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl;
        }

        public List<WorkflowJob> getSelectedJobs(int[] nArray) {
            ArrayList<WorkflowJob> arrayList = new ArrayList<WorkflowJob>();
            WorkflowJob workflowJob = null;
            if (nArray.length == 0) {
                return arrayList;
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    workflowJob = this._data.get(nArray[i]);
                    arrayList.add(workflowJob);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return arrayList;
        }

        public List<WorkflowJob> getDataList() {
            return this._data;
        }
    }

    class ConnectionItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public ConnectionItemRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setIcon(null);
            if (n == -1) {
                if (JobsPanel.this._connectionLost) {
                    this.setIcon(OracleIcons.getIcon((String)"error.png"));
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"dbconn.png"));
                }
            }
            return this;
        }
    }
}

