/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.DataMinerNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.runner.RunManagerEvent;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.NodeFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.NamedTimer;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class RunItem {
    private static final Logger LOGGER = Logger.getLogger(RunItem.class.getName());
    private static final long POLL_INTERVAL = 2000L;
    private static final long RETRY_DELAY = 60000L;
    private String connectionName;
    private Connection connection;
    private HashMap<BigDecimal, WorkflowJob> jobs;
    private Map<RunManagerListener, ListenerDetail> listeners;
    private Map<RunManagerListener, Object> listenerTokens;
    private Object syncObj;
    private NamedTimer refreshTimer;
    private boolean isActive;
    private boolean isInitialized;
    private boolean disconnected;
    private Semaphore refreshSync;

    RunItem(String string) {
        this.connectionName = string;
        this.jobs = new HashMap();
        this.listeners = new HashMap<RunManagerListener, ListenerDetail>();
        this.listenerTokens = new HashMap<RunManagerListener, Object>();
        this.syncObj = new Object();
        this.connection = null;
        this.isActive = false;
        this.isInitialized = false;
        this.disconnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getListenerCount() {
        Object object = this.syncObj;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isJobRunning(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this.jobs.get(bigDecimal);
        if (workflowJob == null) {
            return false;
        }
        return !workflowJob.isJobFinished();
    }

    public WorkflowJob getJob(BigDecimal bigDecimal) {
        WorkflowJob workflowJob = this.jobs.get(bigDecimal);
        if (workflowJob == null) {
            return null;
        }
        return workflowJob;
    }

    public static boolean isJobRunning(String string, BigDecimal bigDecimal) throws Exception {
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), RunManager.getMaxJobAge());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return !workflowJob.isJobFinished();
    }

    public static WorkflowJob getJob(String string, BigDecimal bigDecimal) throws Exception {
        HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(RunItem.getConnection(string), RunManager.getMaxJobAge());
        WorkflowJob workflowJob = hashMap.get(bigDecimal);
        return workflowJob;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setInitialized(boolean bl) {
        this.isInitialized = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initListeners(HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            for (RunManagerListener runManagerListener : this.listeners.keySet()) {
                ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
                if (listenerDetail.isListenerInitialized().booleanValue() || !this.isInitialized()) continue;
                this.initializeListener(listenerDetail, hashMap);
            }
        }
    }

    public void refresh() throws Exception {
        if (!this.isActive()) {
            return;
        }
        try {
            int n = RunManager.getMaxJobAge();
            HashMap<BigDecimal, WorkflowJob> hashMap = WorkflowJob.getJobs(this.getConnectionInstance(), n);
            this.refreshImpl(hashMap);
            if (!this.isInitialized()) {
                this.setInitialized(true);
            }
            this.initListeners(this.jobs);
        }
        catch (Exception exception) {
            this.disconnected = true;
            final Exception exception2 = exception;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireConnectionLost(RunItem.this.listeners, exception2);
                }
            });
            throw exception;
        }
    }

    private void refreshImpl(HashMap<BigDecimal, WorkflowJob> hashMap) {
        WorkflowJob workflowJob;
        WorkflowJob workflowJob2;
        if (!this.isActive()) {
            return;
        }
        if (this.disconnected) {
            this.disconnected = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireConnectionReestablished(RunItem.this.listeners);
                }
            });
        }
        for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
            workflowJob2 = entry.getValue();
            workflowJob = this.jobs.get(workflowJob2.getWorkflowId());
            if (workflowJob == null) {
                this.jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigUtils.isDebugBuild()) {
                            LOGGER.log(Level.FINEST, "RunItem: Added new job: " + workflowJob2.getWorkflowId());
                        }
                        RunItem.this.fireJobAdded(workflowJob2, RunItem.this.listeners);
                    }
                });
                if (!workflowJob2.isJobFinished() || !this.isInitialized()) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ConfigUtils.isDebugBuild()) {
                            LOGGER.log(Level.FINEST, "RunItem: Job finished (new): " + workflowJob2.getWorkflowId());
                        }
                        RunItem.this.fireJobFinished(workflowJob2, RunItem.this.listeners);
                    }
                });
                continue;
            }
            if (workflowJob.equalsStateOf(workflowJob2)) continue;
            this.jobs.remove(workflowJob.getWorkflowId());
            this.jobs.put(workflowJob2.getWorkflowId(), workflowJob2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (workflowJob2.isJobFinished()) {
                        if (ConfigUtils.isDebugBuild()) {
                            LOGGER.log(Level.INFO, "RunItem: Job finished: " + workflowJob2.getWorkflowId());
                        }
                        RunItem.this.fireJobFinished(workflowJob2, RunItem.this.listeners);
                    } else {
                        if (ConfigUtils.isDebugBuild()) {
                            LOGGER.log(Level.FINEST, "RunItem: Job changed: " + workflowJob2.getWorkflowId());
                        }
                        RunItem.this.fireJobChanged(workflowJob2, RunItem.this.listeners);
                    }
                }
            });
        }
        Iterator<Map.Entry<BigDecimal, WorkflowJob>> iterator = this.jobs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BigDecimal, WorkflowJob> entry;
            entry = iterator.next();
            workflowJob2 = entry.getValue();
            workflowJob = hashMap.get(workflowJob2.getWorkflowId());
            if (workflowJob != null) continue;
            iterator.remove();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunItem.this.fireJobRemoved(workflowJob2, RunItem.this.listeners);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateListenerToken(ListenerDetail listenerDetail) {
        boolean bl = false;
        Object object = this.syncObj;
        synchronized (object) {
            Object object2 = this.listenerTokens.get(listenerDetail.getListener());
            if (object2 != null && object2 == listenerDetail.getListenerToken()) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionLost(Map<RunManagerListener, ListenerDetail> map, Exception exception) {
        Object object = this.syncObj;
        synchronized (object) {
            Iterator<Map.Entry<RunManagerListener, ListenerDetail>> iterator = map.entrySet().iterator();
            RunManagerEvent runManagerEvent = new RunManagerEvent(this, null);
            runManagerEvent.setExceptionInfo(exception);
            while (iterator.hasNext()) {
                Map.Entry<RunManagerListener, ListenerDetail> entry = iterator.next();
                ListenerDetail listenerDetail = entry.getValue();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                runManagerListener.connectionLost(runManagerEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionReestablished(Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            for (Map.Entry<RunManagerListener, ListenerDetail> entry : map.entrySet()) {
                ListenerDetail listenerDetail = entry.getValue();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                runManagerListener.connectionReestablished(new RunManagerEvent(this, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobAdded(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            Collection collection = hashMap.values();
            for (ListenerDetail listenerDetail : collection) {
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                if (bigDecimal == null) {
                    runManagerListener.jobAdded(new RunManagerEvent(this, workflowJob));
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobAdded(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobFinished(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            this.updateWorkflowNodeRepositoryData(workflowJob);
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            ArrayList<ListenerDetail> arrayList = new ArrayList<ListenerDetail>();
            Collection collection = hashMap.values();
            for (ListenerDetail listenerDetail : collection) {
                if (listenerDetail.getListener() instanceof WorkflowEditor) {
                    arrayList.add(0, listenerDetail);
                    continue;
                }
                arrayList.add(listenerDetail);
            }
            for (ListenerDetail listenerDetail : arrayList) {
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail) || bigDecimal != null && (bigDecimal == null || !bigDecimal.equals(workflowJob.getWorkflowId()))) continue;
                runManagerListener.jobFinished(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    private void updateWorkflowNodeRepositoryData(WorkflowJob workflowJob) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        HashMap<URL, WorkflowNode> hashMap = new HashMap<URL, WorkflowNode>();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Object object42 : list) {
            URL uRL;
            WorkflowNode workflowNode;
            object3 = object42.getContext().getNode();
            if (!(object3 instanceof DataMinerNode) || !((String)(object2 = DMURLFormatHelper.getConnectionName((URL)(object = object3.getURL())))).equals(this.connectionName) || (workflowNode = (WorkflowNode)NodeFactory.find((URL)(uRL = DMURLFormatHelper.getWorkflowURL((URL)object)))) == null) continue;
            Workflow workflow = (Workflow)workflowNode.getRepositoryData();
            if (!workflowJob.getWorkflowId().equals(workflow.getId())) continue;
            hashMap.put(uRL, workflowNode);
        }
        Collection collection = hashMap.values();
        if (collection.size() == 0) {
            return;
        }
        if (collection.size() > 1) {
            throw new RuntimeException("Unexpected state: update repository cache detected multiple workflows");
        }
        object42 = (WorkflowNode)collection.iterator().next();
        this.refreshSync = new Semaphore(0, false);
        object3 = ((BaseTreeNode)object42).getShortLabel();
        object = new Runnable((WorkflowNode)object42){
            final /* synthetic */ WorkflowNode val$wfNode;
            {
                this.val$wfNode = workflowNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = this.val$wfNode.getRepositoryDataReadLock();
                    synchronized (object) {
                        RunItem.this.refreshSync.release(1);
                        this.val$wfNode.reloadRepositoryData();
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        };
        object2 = new Thread((Runnable)object, (String)object3);
        ((Thread)object2).start();
        try {
            this.refreshSync.acquire(1);
            this.refreshSync = null;
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.SEVERE, interruptedException.getMessage(), interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobChanged(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                boolean bl = false;
                if (bigDecimal == null) {
                    runManagerListener.jobChanged(new RunManagerEvent(this, workflowJob));
                    bl = true;
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobChanged(new RunManagerEvent(this, workflowJob));
                bl = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJobRemoved(WorkflowJob workflowJob, Map<RunManagerListener, ListenerDetail> map) {
        Object object = this.syncObj;
        synchronized (object) {
            HashMap<RunManagerListener, ListenerDetail> hashMap = new HashMap<RunManagerListener, ListenerDetail>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                ListenerDetail listenerDetail = (ListenerDetail)entry.getValue();
                BigDecimal bigDecimal = listenerDetail.getWorkflowId();
                RunManagerListener runManagerListener = listenerDetail.getListener();
                if (!this.validateListenerToken(listenerDetail)) continue;
                if (bigDecimal == null) {
                    runManagerListener.jobRemoved(new RunManagerEvent(this, workflowJob));
                    continue;
                }
                if (!bigDecimal.equals(workflowJob.getWorkflowId())) continue;
                runManagerListener.jobRemoved(new RunManagerEvent(this, workflowJob));
            }
        }
    }

    private Connection getConnectionInstance() throws DBException, SQLException, ConnectionException, Exception {
        if (this.connection != null) {
            return this.connection;
        }
        this.connection = RunItem.getConnection(this.connectionName);
        return this.connection;
    }

    private static Connection getConnection(String string) throws SQLException, ConnectionException, Exception {
        Connection connection = null;
        if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
            throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
        }
        Properties properties = DatabaseConnections.getInstance().getProperties(string);
        Properties properties2 = (Properties)properties.clone();
        DatabaseProvider databaseProvider = new DatabaseProvider(properties2);
        databaseProvider.setProperty("SQLDEV_PROMPT_KEY", "ODMR_PWD_PROMPT");
        Connection connection2 = null;
        boolean bl = false;
        while (!bl) {
            try {
                connection2 = databaseProvider.getConnection();
                break;
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_NOT_AUTH"));
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 1017) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                    if (properties2.getProperty("SavePassword").equalsIgnoreCase("true")) {
                        throw sQLException;
                    }
                } else {
                    if (sQLException.getErrorCode() == 28000) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunManagerLrb.get("CONNECT_FAIL") + sQLException.getMessage()), (String)RunManagerLrb.get("CONNECT_FAIL_TITLE"), null);
                        throw sQLException;
                    }
                    throw sQLException;
                }
                Properties properties3 = (Properties)properties.clone();
                properties3.remove("password");
                databaseProvider = new DatabaseProvider(properties3);
                DatabaseProviderHelper.PasswordPrompter passwordPrompter = DatabaseProviderHelper.getPasswordPrompter();
                passwordPrompter.disconnect(properties3);
            }
        }
        try {
            if (!ConfigUtils.isValidUserConnection(string).booleanValue()) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_PRIVILEGED"));
            }
            if (!ConfigUtils.isODMRSYSLoaded(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_REPOS"));
            }
            if (!ConfigUtils.isODMPrivsPresent(connection2)) {
                throw new RunManager.UnmonitorableConnectionException(RunManagerLrb.get("CONNECTION_LACKS_PRIVS"));
            }
            connection = connection2;
        }
        catch (Exception exception) {
            SQLHelper.close(connection2);
            throw exception;
        }
        return connection;
    }

    public synchronized void close() {
        this.stopMonitor();
    }

    public boolean addListener(RunManagerListener runManagerListener) {
        return this.addListener(runManagerListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
            if (listenerDetail != null && this.validateListenerToken(listenerDetail)) {
                return false;
            }
            if (this.listeners.size() == 0 || !this.isActive()) {
                this.startMonitor();
            }
            ListenerDetail listenerDetail2 = new ListenerDetail(runManagerListener, bigDecimal);
            this.listenerTokens.put(runManagerListener, listenerDetail2.getListenerToken());
            this.listeners.put(runManagerListener, listenerDetail2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.remove(runManagerListener);
            this.listenerTokens.remove(listenerDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunManagerListener getListener(RunManagerListener runManagerListener) {
        Object object = this.syncObj;
        synchronized (object) {
            ListenerDetail listenerDetail = this.listeners.get(runManagerListener);
            if (listenerDetail != null) {
                return listenerDetail.getListener();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeListener(final ListenerDetail listenerDetail, HashMap<BigDecimal, WorkflowJob> hashMap) {
        Object object = this.syncObj;
        synchronized (object) {
            if (!this.isActive()) {
                return;
            }
            listenerDetail.setListenerInitialized();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listenerDetail.getListener().jobsListenerInitialized();
                }
            });
            try {
                final HashMap<RunManagerListener, ListenerDetail> hashMap2 = new HashMap<RunManagerListener, ListenerDetail>();
                hashMap2.put(listenerDetail.getListener(), listenerDetail);
                for (Map.Entry<BigDecimal, WorkflowJob> entry : hashMap.entrySet()) {
                    final WorkflowJob workflowJob = entry.getValue();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunItem.this.fireJobAdded(workflowJob, hashMap2);
                        }
                    });
                }
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    void startMonitor() {
        this.startMonitor(0L);
    }

    private void startMonitor(long l) {
        if (this.isActive()) {
            this.stopMonitor();
        }
        this.isActive = true;
        this.refreshTimer = new NamedTimer("RunManagerTimer:" + this.connectionName, 5, true);
        this.refreshTimer.schedule((TimerTask)new RunTimerTask(), l, 2000L);
    }

    private void restartMonitor(long l) {
        this.stopMonitor();
        this.startMonitor(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMonitor() {
        if (this.refreshTimer == null) {
            return;
        }
        this.refreshTimer.cancel();
        if (this.connection != null) {
            Connection connection = this.connection;
            synchronized (connection) {
                SQLHelper.close(this.connection);
            }
        }
        this.connection = null;
        this.isActive = false;
        this.isInitialized = false;
        this.refreshTimer = null;
    }

    class ListenerDetail {
        private RunManagerListener listener;
        private BigDecimal workflowId;
        private Object listenerToken;
        private Boolean listenerInitialized;

        ListenerDetail(RunManagerListener runManagerListener, BigDecimal bigDecimal) {
            this.listener = runManagerListener;
            this.workflowId = bigDecimal;
            this.listenerToken = new Object();
            this.listenerInitialized = false;
        }

        public RunManagerListener getListener() {
            return this.listener;
        }

        public BigDecimal getWorkflowId() {
            return this.workflowId;
        }

        public Object getListenerToken() {
            return this.listenerToken;
        }

        public void setListenerInitialized() {
            this.listenerInitialized = true;
        }

        public Boolean isListenerInitialized() {
            return this.listenerInitialized;
        }
    }

    class RunTimerTask
    extends TimerTask {
        RunTimerTask() {
        }

        @Override
        public void run() {
            if (!RunItem.this.isActive()) {
                return;
            }
            if (RunItem.this.listeners.size() != 0) {
                try {
                    RunItem.this.refresh();
                }
                catch (RunManager.UnmonitorableConnectionException unmonitorableConnectionException) {
                    RunItem.this.stopMonitor();
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 1035) {
                        LOGGER.log(Level.FINEST, "temporarily restricted connections due to repository installation", sQLException);
                        RunItem.this.stopMonitor();
                    } else if (sQLException.getErrorCode() == 1017) {
                        LOGGER.log(Level.FINEST, "logon denied", sQLException);
                        RunItem.this.stopMonitor();
                    } else if (sQLException.getErrorCode() == 28000) {
                        LOGGER.log(Level.FINEST, "account locked", sQLException);
                        RunItem.this.stopMonitor();
                    } else {
                        RunItem.this.restartMonitor(60000L);
                    }
                }
                catch (Exception exception) {
                    RunItem.this.restartMonitor(60000L);
                }
            }
        }
    }
}

