/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.runner;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.runner.JobsPanel;
import oracle.dmt.dataminer.runner.RunItem;
import oracle.dmt.dataminer.runner.RunManagerDockableFactory;
import oracle.dmt.dataminer.runner.RunManagerListener;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.runner.RunnerPreferencesSettings;
import oracle.dmt.dataminer.runner.TasksWindow;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RunManager
implements Addin,
ShutdownHook,
Controller,
ViewSelectionListener {
    private static final Logger theLogger = Logger.getLogger(RunManager.class.getName());
    private Map<String, RunItem> _monitors = new HashMap<String, RunItem>();
    private Object _syncObj = new Object();
    private static int _maxJobAge;
    private static TimeMeasure _timeMeasure;
    private boolean _explorerListenerInitialized = false;
    public static final int SHOW_RMANAGER_CMDID;
    public static final int SHOW_STRUCTURE;

    private RunManager() {
        RunnerPreferencesSettings runnerPreferencesSettings = RunnerPreferencesSettings.getInstance();
        RunManager.setJobAgeTimeMeasure(TimeMeasure.HOURS);
        RunManager.setMaxJobAge(runnerPreferencesSettings.getMaxJobAge());
    }

    public static void setMaxJobAge(int n) {
        _maxJobAge = n;
    }

    public static int getMaxJobAge() {
        return _maxJobAge;
    }

    public static void setJobAgeTimeMeasure(TimeMeasure timeMeasure) {
        _timeMeasure = timeMeasure;
    }

    public static TimeMeasure getJobAgeTimeMeasure() {
        return _timeMeasure;
    }

    public void initialize() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SHOW_RMANAGER_CMDID) {
            RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
            Dockable dockable = runManagerDockableFactory.getDockable();
            DockStation dockStation = DockStation.getDockStation();
            dockStation.setDockableVisible(dockable, true);
        } else if (n == SHOW_STRUCTURE) {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            explorerManager.showView(context);
        } else {
            return false;
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kickStart(String string) throws Exception {
        Object object = this._syncObj;
        synchronized (object) {
            RunItem runItem = this._monitors.get(string);
            if (runItem != null) {
                runItem.startMonitor();
            }
        }
    }

    public boolean isWorkflowRunning(String string, BigDecimal bigDecimal) {
        boolean bl = false;
        RunItem runItem = this._monitors.get(string);
        if (runItem != null) {
            bl = runItem.isJobRunning(bigDecimal);
        } else {
            try {
                bl = RunItem.isJobRunning(string, bigDecimal);
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return bl;
    }

    public WorkflowJob getJob(String string, BigDecimal bigDecimal, boolean bl) {
        WorkflowJob workflowJob = null;
        if (bl) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    RuntimeException runtimeException = new RuntimeException("Force flag is true while invoke getJob() on EDT thread");
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.severe(runtimeException.getLocalizedMessage());
                    logger.severe(runtimeException.getStackTrace()[0].toString());
                    return null;
                }
                workflowJob = RunItem.getJob(string, bigDecimal);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        } else {
            RunItem runItem = this._monitors.get(string);
            if (runItem != null) {
                workflowJob = runItem.getJob(bigDecimal);
            }
        }
        return workflowJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(String string) {
        boolean bl = false;
        Object object = this._syncObj;
        synchronized (object) {
            RunItem runItem = this._monitors.get(string);
            if (runItem != null) {
                bl = runItem.isActive();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunManagerListener getListener(RunManagerListener runManagerListener, String string) {
        RunManagerListener runManagerListener2 = null;
        Object object = this._syncObj;
        synchronized (object) {
            RunItem runItem = this._monitors.get(string);
            if (runItem != null) {
                runManagerListener2 = runItem.getListener(runManagerListener);
            }
        }
        return runManagerListener2;
    }

    public boolean addListener(RunManagerListener runManagerListener, String string) {
        return this.addListener(runManagerListener, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(RunManagerListener runManagerListener, String string, BigDecimal bigDecimal) {
        boolean bl = false;
        Object object = this._syncObj;
        synchronized (object) {
            RunItem runItem = this._monitors.get(string);
            if (runItem == null) {
                runItem = new RunItem(string);
                this._monitors.put(string, runItem);
            }
            bl = runItem.addListener(runManagerListener, bigDecimal);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(RunManagerListener runManagerListener, String string) {
        Object object = this._syncObj;
        synchronized (object) {
            RunItem runItem = this._monitors.get(string);
            if (runItem == null) {
                return;
            }
            runItem.removeListener(runManagerListener);
            if (runItem.getListenerCount() == 0) {
                runItem.close();
                this._monitors.remove(runItem.getConnectionName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this._syncObj;
        synchronized (object) {
            for (Map.Entry<String, RunItem> entry : this._monitors.entrySet()) {
                RunItem runItem = entry.getValue();
                runItem.close();
                this._monitors.remove(runItem.getConnectionName());
            }
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void unregisterViewSelectionListener(TreeExplorer treeExplorer) {
        if (treeExplorer != null && this.isExplorerListenerInitialized()) {
            treeExplorer.removeViewSelectionListener((ViewSelectionListener)this);
            this._explorerListenerInitialized = false;
        }
    }

    public void registerViewSelectionListener(TreeExplorer treeExplorer) {
        if (treeExplorer != null && !this.isExplorerListenerInitialized()) {
            treeExplorer.addViewSelectionListener((ViewSelectionListener)this);
            this._explorerListenerInitialized = true;
        }
    }

    public boolean isExplorerListenerInitialized() {
        return this._explorerListenerInitialized;
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Element[] elementArray = viewSelectionEvent.getSelection();
        ConnectionFolder connectionFolder = null;
        if (elementArray.length == 1) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)elementArray[0];
            TNode tNode = baseTreeNode.getParent();
            if (baseTreeNode instanceof ConnectionFolder) {
                connectionFolder = (ConnectionFolder)baseTreeNode;
            } else if (tNode != null) {
                connectionFolder = (ConnectionFolder)tNode.getAncestor(ConnectionFolder.class, false);
            }
            if (connectionFolder != null) {
                String string = connectionFolder.getConnectionName();
                RunManagerDockableFactory runManagerDockableFactory = RunManagerDockableFactory.getInstance();
                Dockable dockable = runManagerDockableFactory.getDockable();
                if (dockable instanceof TasksWindow) {
                    if (!((DockableWindow)dockable).isVisible()) {
                        RunnerPreferencesSettings.getInstance().setDefaultConnectionName(string);
                        return;
                    }
                    JobsPanel jobsPanel = (JobsPanel)((TasksWindow)dockable).getGUI();
                    jobsPanel.autoSwitchConnection(string);
                }
            }
        }
    }

    public static boolean stopWorkflow(List<WorkflowJob> list, String string) throws Exception {
        CancelWorkflow cancelWorkflow = new CancelWorkflow(list, string);
        cancelWorkflow.setTitle(RunManagerLrb.get("CANCEL_WORKFLOW"));
        cancelWorkflow.setMessage(RunManagerLrb.get("CANCEL_WORKFLOW_DESCR"));
        cancelWorkflow.setCancelable(false);
        cancelWorkflow.start(true);
        if (!cancelWorkflow.getSuccess().booleanValue()) {
            if (cancelWorkflow.getException() != null) {
                if (cancelWorkflow.getException().getMessage().startsWith("ORA-20121")) {
                    if (list.size() > 1) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_SOME_NOT_RUNNING_DESCR"), (String)RunManagerLrb.get("WORKFLOW_NOT_RUNNING"), null);
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("WORKFLOW_NOT_RUNNING_DESCR"), (String)RunManagerLrb.get("WORKFLOW_NOT_RUNNING"), null);
                    }
                } else {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)cancelWorkflow.getException(), (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL"), (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL_DESCR"), null);
                }
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunManagerLrb.get("JOB_UI_CANCEL_FAIL_DESCR"), (String)RunManagerLrb.get("JOB_UI_CANCEL_FAIL"), null);
            }
        }
        return cancelWorkflow.getSuccess();
    }

    static {
        SHOW_RMANAGER_CMDID = Ide.findCmdID((String)"dataminer.showRunManager");
        SHOW_STRUCTURE = Ide.findCmdID((String)"dataminer.showStructure");
    }

    static class CancelWorkflow
    extends ProgressRunnable {
        List<WorkflowJob> _cancelJobs;
        Exception _exception;
        Boolean _success = Boolean.FALSE;
        String _connectionName;

        public CancelWorkflow(List<WorkflowJob> list, String string) {
            this._cancelJobs = list;
            this._connectionName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doWork() throws Exception {
            Connection connection = null;
            OdmrWorkflow odmrWorkflow = null;
            try {
                connection = Connections.getUniqueConnection(this._connectionName);
                odmrWorkflow = new OdmrWorkflow(connection);
                SQLException sQLException = null;
                for (WorkflowJob workflowJob : this._cancelJobs) {
                    try {
                        odmrWorkflow.wfStop(workflowJob.getWorkflowId());
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException2.getErrorCode() != 27475) {
                            throw sQLException2;
                        }
                        sQLException = sQLException2;
                    }
                }
                this._success = Boolean.TRUE;
                if (sQLException != null) {
                    this._exception = sQLException;
                }
            }
            catch (Exception exception) {
                this._exception = exception;
                this._success = Boolean.FALSE;
            }
            finally {
                if (odmrWorkflow != null) {
                    try {
                        odmrWorkflow.release();
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                    }
                }
                SQLHelper.close(connection);
            }
            return this._success;
        }

        public Exception getException() {
            return this._exception;
        }

        public Boolean getSuccess() {
            return this._success;
        }
    }

    static class ConnectionNotMonitored
    extends Exception {
        public ConnectionNotMonitored(String string) {
            super(string);
        }
    }

    public static class UnmonitorableConnectionException
    extends Exception {
        public UnmonitorableConnectionException(String string) {
            super(string);
        }
    }

    public static enum TimeMeasure {
        DAYS,
        HOURS,
        MINUTES;

    }
}

