/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmItem;
import oracle.dmt.dataminer.generated.server.DmItems;
import oracle.dmt.dataminer.generated.server.DmPredicate;
import oracle.dmt.dataminer.generated.server.DmPredicates;
import oracle.dmt.dataminer.navigator.Connections;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.ARRulesFilterSetting;
import oracle.dmt.dataminer.server.model.FilterItemSet;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.ItemSet;
import oracle.dmt.dataminer.server.model.ItemSetFilterSetting;
import oracle.dmt.dataminer.server.model.ItemSetsFilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ORAData;

public class ARModelDetails {
    private Number getMaxLiftValue(Context context, String string, String string2) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        String string3 = "SELECT t.rule_lift MAX_LIFT_VALUE   FROM TABLE(dbms_data_mining.get_association_rules(?,              1, NULL, NULL, NULL, NULL, NULL,             ORA_MINING_VARCHAR2_NT('RULE_LIFT DESC'), NULL, NULL, NULL)) t";
        SQLHelper sQLHelper = new SQLHelper();
        Double d = 0.0;
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble("MAX_LIFT_VALUE");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return d;
    }

    protected HashMap getGlobalDetails(Context context, String string, String string2) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        String string3 = "SELECT  GLOBAL_DETAIL_NAME, GLOBAL_DETAIL_VALUE FROM TABLE(dbms_data_mining.get_model_details_global(?))";
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = 0;
        Integer n2 = 0;
        Double d = 0.0;
        String string4 = "";
        Connection connection = null;
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        try {
            connection = Connections.getUniqueConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("GLOBAL_DETAIL_NAME");
                if (string4.equals("RULE_COUNT")) {
                    n = sQLHelper.rs.getInt("GLOBAL_DETAIL_VALUE");
                    hashMap.put("TOTAL_RULES_COUNT", n);
                    continue;
                }
                if (string4.equals("ITEMSET_COUNT")) {
                    n2 = sQLHelper.rs.getInt("GLOBAL_DETAIL_VALUE");
                    hashMap.put("TOTAL_ITEMSET_COUNT", n2);
                    continue;
                }
                if (!string4.equals("MAX_SUPPORT")) continue;
                d = sQLHelper.rs.getDouble("GLOBAL_DETAIL_VALUE");
                hashMap.put("MAXIMUM_SUPPORT_VALUE", d);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return hashMap;
    }

    protected Number getTotalRulesCount(Context context, String string, String string2) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        String string3 = "SELECT  GLOBAL_DETAIL_NAME, GLOBAL_DETAIL_VALUE FROM TABLE(dbms_data_mining.get_model_details_global(?))";
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = 0;
        String string4 = "";
        Connection connection = null;
        try {
            connection = Connections.getUniqueConnection(context);
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("GLOBAL_DETAIL_NAME");
                if (!string4.equals("RULE_COUNT")) continue;
                n = sQLHelper.rs.getInt("GLOBAL_DETAIL_VALUE");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return n;
    }

    protected HashMap getItemGlobalMetrics(Context context, String string, String string2) throws Exception {
        HashMap<String, Object> hashMap;
        block8: {
            assert (string2 != null) : "Model name can not be null";
            assert (string != null) : "User name can not be null";
            String string3 = "SELECT count(itemset_id) SINGLE_ITEMSET_COUNT,\n  MIN(item.attribute_name) MIN_ATTRIBUTE_NAME,\n  MAX(item.attribute_name) MAX_ATTRIBUTE_NAME,\n  COUNT(item.attribute_subname) ATTRIBUTE_SUBNAME_COUNT,\n  MIN(item.attribute_subname) MIN_ATTRIBUTE_SUBNAME,\n  MAX(item.attribute_subname) MAX_ATTRIBUTE_SUBNAME,\n  MIN(nvl(TO_CHAR(item.attribute_num_value), item.attribute_str_value)) MIN_ATTRIBUTE_VALUE,\n  MAX(nvl(TO_CHAR(item.attribute_num_value), item.attribute_str_value)) MAX_ATTRIBUTE_VALUE \nFROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   NULL,   1)) t, TABLE(t.items) item";
            SQLHelper sQLHelper = new SQLHelper();
            Connection connection = null;
            hashMap = new HashMap<String, Object>();
            try {
                connection = Connections.getUniqueConnection(context);
                sQLHelper.pstmt = connection.prepareStatement(string3);
                sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
                sQLHelper.pstmt.execute();
                sQLHelper.rs = sQLHelper.pstmt.getResultSet();
                if (sQLHelper.rs.next()) {
                    String string4 = sQLHelper.rs.getString("MIN_ATTRIBUTE_NAME");
                    hashMap.put("MIN_ATTRIBUTE_NAME", string4);
                    string4 = sQLHelper.rs.getString("MAX_ATTRIBUTE_NAME");
                    hashMap.put("MAX_ATTRIBUTE_NAME", string4);
                    string4 = sQLHelper.rs.getString("MIN_ATTRIBUTE_SUBNAME");
                    hashMap.put("MIN_ATTRIBUTE_SUBNAME", string4);
                    string4 = sQLHelper.rs.getString("MAX_ATTRIBUTE_SUBNAME");
                    hashMap.put("MAX_ATTRIBUTE_SUBNAME", string4);
                    Integer n = sQLHelper.rs.getInt("SINGLE_ITEMSET_COUNT");
                    hashMap.put("SINGLE_ITEMSET_COUNT", n);
                    n = sQLHelper.rs.getInt("ATTRIBUTE_SUBNAME_COUNT");
                    hashMap.put("ATTRIBUTE_SUBNAME_COUNT", n);
                    Object object = sQLHelper.rs.getObject("MIN_ATTRIBUTE_VALUE");
                    hashMap.put("MIN_ATTRIBUTE_VALUE", object);
                    object = sQLHelper.rs.getObject("MAX_ATTRIBUTE_VALUE");
                    hashMap.put("MAX_ATTRIBUTE_VALUE", object);
                    break block8;
                }
                throw new Exception("No result when querying model itemset.");
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                sQLHelper.close();
                SQLHelper.close(connection);
            }
        }
        return hashMap;
    }

    public HashMap getGlobalMetrics(Context context, String string, String string2) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        LoadGlobalDetails loadGlobalDetails = new LoadGlobalDetails(context, string, string2);
        loadGlobalDetails.start();
        LoadItemMetrics loadItemMetrics = new LoadItemMetrics(context, string, string2);
        loadItemMetrics.start();
        Number number = this.getMaxLiftValue(context, string, string2);
        loadGlobalDetails.join();
        if (loadGlobalDetails.getException() != null) {
            throw loadGlobalDetails.getException();
        }
        HashMap hashMap = loadGlobalDetails.getGlobalDetailsResult();
        loadItemMetrics.join();
        if (loadItemMetrics.getException() != null) {
            throw loadItemMetrics.getException();
        }
        HashMap hashMap2 = loadItemMetrics.getItemMetrics();
        hashMap.put("MAXIMUM_LIFT_VALUE", number);
        Set set = hashMap2.entrySet();
        for (Map.Entry entry : set) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public HashMap getItemSetsGlobalMetrics(Context context, String string, String string2) throws Exception {
        assert (context != null) : "Context can not be null";
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        Connection connection = null;
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        String string3 = "";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            connection = Connections.getUniqueConnection(context);
            string3 = "SELECT count(*) TOTAL_ITEMSETS_COUNT, max(support) MAXIMUM_SUPPORT_VALUE   FROM TABLE(DBMS_DATA_MINING.GET_FREQUENT_ITEMSETS(?)) ";
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            if (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt("TOTAL_ITEMSETS_COUNT");
                Double d = sQLHelper.rs.getDouble("MAXIMUM_SUPPORT_VALUE");
                hashMap.put("TOTAL_ITEMSETS_COUNT", n);
                hashMap.put("MAXIMUM_SUPPORT_VALUE", d);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
            SQLHelper.close(connection);
        }
        return hashMap;
    }

    public Vector<FilterItemSet> getItemSets(Connection connection, String string, String string2, ItemSetFilterSetting itemSetFilterSetting) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        Vector<FilterItemSet> vector = new Vector<FilterItemSet>();
        String string3 = "";
        Vector<SortSpec> vector2 = itemSetFilterSetting.getSortSpecification();
        boolean bl = false;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            Object object;
            Object object2;
            switch (itemSetFilterSetting.getResultType()) {
                case 1: {
                    string3 = "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                    string3 = StringUtils.getReplacedString(string3, "<BASE_SELECT_CLAUSE>", "SELECT CONCAT(item.attribute_name,'\"') full_name ");
                    break;
                }
                case 2: {
                    string3 = "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, NULL support, NULL attribute_value FROM (Select distinct(full_name)full_name       FROM base_query) a <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                    string3 = StringUtils.getReplacedString(string3, "<BASE_SELECT_CLAUSE>", "SELECT NVL2(item.attribute_subname, item.attribute_name || '\"' || item.attribute_subname, CONCAT(item.attribute_name,'\"')) full_name ");
                    break;
                }
                case 3: {
                    string3 = "With base_query as (<BASE_SELECT_CLAUSE> FROM TABLE(dbms_data_mining.get_frequent_itemsets(?,   ?,   ?)) t, TABLE(t.items) item), final_query as (Select SUBSTR(full_name,1,REGEXP_INSTR(full_name,'[\"]+',1, 1)-1) attribute_name, SUBSTR(full_name, REGEXP_INSTR(full_name,'[\"]+',1, 1)+1) attribute_subname, attribute_num_value, attribute_str_value, support, NVL2( attribute_num_value, TO_CHAR(attribute_num_value), attribute_str_value) attribute_value  FROM base_query <WHERE_CLAUSE> <ORDER_BY_CLAUSE> ) Select * from final_query where rownum <= ? ";
                    string3 = StringUtils.getReplacedString(string3, "<BASE_SELECT_CLAUSE>", "SELECT NVL2(item.attribute_subname, item.attribute_name || '\"' || item.attribute_subname, CONCAT(item.attribute_name,'\"')) full_name, item.attribute_num_value attribute_num_value, item.attribute_str_value attribute_str_value, support ");
                    break;
                }
                default: {
                    throw new Exception("Invalid query result type request for itemsets.");
                }
            }
            String string4 = "";
            if (itemSetFilterSetting.getNameFilter() != null && itemSetFilterSetting.getNameFilter().length() > 0) {
                string4 = string4 + " WHERE REPLACE(full_name,'\"','.') like (?)";
                bl = true;
            }
            string3 = StringUtils.getReplacedString(string3, "<WHERE_CLAUSE>", string4);
            StringBuffer stringBuffer = new StringBuffer();
            if (vector2 != null && vector2.size() > 0) {
                stringBuffer.append("order by ");
                object2 = vector2.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (!((SortSpec)object).isUseIt()) continue;
                    stringBuffer.append("\"" + ((SortSpec)object).getAttributeName() + "\" ");
                    if (((SortSpec)object).isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!object2.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY_CLAUSE>", stringBuffer.toString());
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            if (itemSetFilterSetting.isUseTopN()) {
                sQLHelper.pstmt.setInt(2, itemSetFilterSetting.getTopNBySupport());
            } else {
                sQLHelper.pstmt.setNull(2, 4);
            }
            if (itemSetFilterSetting.isUseNumberOfItems()) {
                sQLHelper.pstmt.setInt(3, itemSetFilterSetting.getNumberOfItems());
            } else {
                sQLHelper.pstmt.setNull(3, 4);
            }
            if (bl) {
                sQLHelper.pstmt.setString(4, "%" + itemSetFilterSetting.getNameFilter() + "%");
                sQLHelper.pstmt.setInt(5, itemSetFilterSetting.getFetchSize());
            } else {
                sQLHelper.pstmt.setInt(4, itemSetFilterSetting.getFetchSize());
            }
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            object2 = "";
            object = "";
            Object object3 = null;
            String string5 = "";
            Double d = null;
            switch (itemSetFilterSetting.getResultType()) {
                case 1: 
                case 2: {
                    while (sQLHelper.rs.next()) {
                        object2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                        object = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                        Item item = new Item((String)object2, (String)object, null, null);
                        FilterItemSet filterItemSet = new FilterItemSet(null, item, null, itemSetFilterSetting.getNumberOfItems());
                        vector.add(filterItemSet);
                    }
                    break;
                }
                case 3: {
                    while (sQLHelper.rs.next()) {
                        object2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                        object = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                        Double d2 = sQLHelper.rs.getDouble("SUPPORT");
                        string5 = sQLHelper.rs.getString("ATTRIBUTE_STR_VALUE");
                        object3 = sQLHelper.rs.getObject("ATTRIBUTE_NUM_VALUE");
                        d = object3 != null ? Double.valueOf(sQLHelper.rs.getDouble("ATTRIBUTE_NUM_VALUE")) : null;
                        Item item = new Item((String)object2, (String)object, d, string5);
                        FilterItemSet filterItemSet = new FilterItemSet(null, item, d2, itemSetFilterSetting.getNumberOfItems());
                        vector.add(filterItemSet);
                    }
                    break;
                }
                default: {
                    throw new Exception("Invalid query result type request for itemsets.");
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<ItemSet> getItemSets(Connection connection, String string, String string2, ItemSetsFilterSetting itemSetsFilterSetting) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (itemSetsFilterSetting != null) : "Filter setting can not be null";
        Vector<ItemSet> vector = new Vector<ItemSet>();
        String string3 = "";
        SQLHelper sQLHelper = new SQLHelper();
        try {
            string3 = "SELECT ITEMSET_ID, ITEMS, SUPPORT, NUMBER_OF_ITEMS FROM TABLE(DBMS_DATA_MINING.GET_FREQUENT_ITEMSETS(?,?,?)) WHERE ROWNUM <= ? <SUPPORT_WHERE_CONSTRAINT> <ORDER_BY_CLAUSE> ";
            string3 = itemSetsFilterSetting.isUseFilterSpecification() ? StringUtils.getReplacedString(string3, "<SUPPORT_WHERE_CONSTRAINT>", "AND SUPPORT >= ?  ") : StringUtils.getReplacedString(string3, "<SUPPORT_WHERE_CONSTRAINT>", "");
            String string4 = itemSetsFilterSetting.getSortString();
            string3 = string4 != null ? (string4.trim().length() != 0 ? StringUtils.getReplacedString(string3, "<ORDER_BY_CLAUSE>", "ORDER BY " + string4) : StringUtils.getReplacedString(string3, "<ORDER_BY_CLAUSE>", "")) : StringUtils.getReplacedString(string3, "<ORDER_BY_CLAUSE>", "");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            if (itemSetsFilterSetting.isFirstSortColumnSupport()) {
                sQLHelper.pstmt.setInt(2, itemSetsFilterSetting.getFetchSize());
            } else {
                sQLHelper.pstmt.setNull(2, 4);
            }
            if (itemSetsFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setInt(3, itemSetsFilterSetting.getMaxItemSetLength());
                sQLHelper.pstmt.setDouble(5, itemSetsFilterSetting.getMinSupport());
            } else {
                sQLHelper.pstmt.setNull(3, 4);
            }
            sQLHelper.pstmt.setInt(4, itemSetsFilterSetting.getFetchSize());
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt("ITEMSET_ID");
                Integer n2 = sQLHelper.rs.getInt("NUMBER_OF_ITEMS");
                Double d = sQLHelper.rs.getDouble("SUPPORT");
                DmItems dmItems = (DmItems)((OracleResultSet)sQLHelper.rs).getORAData("ITEMS", DmItems.getORADataFactory());
                Vector<Item> vector2 = new Vector<Item>();
                for (int i = 0; i < dmItems.length(); ++i) {
                    DmItem dmItem = dmItems.getElement(i);
                    Item item = new Item(dmItem);
                    vector2.add(item);
                }
                ItemSet itemSet = new ItemSet(n, vector2, d, n2);
                vector.add(itemSet);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<RuleRowData> getRules(Connection connection, String string, String string2, ARRulesFilterSetting aRRulesFilterSetting) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (aRRulesFilterSetting != null) : "Requires a filter setting to query for AR rules";
        String string3 = "SELECT t.rule_id rule_id,\n  t.rule_support rule_support,\n  t.rule_confidence rule_confidence,\n  t.rule_lift rule_lift,\n  t.antecedent antecedent,\n  t.consequent consequent,\n  t.number_of_items number_of_items,\n  t.antecedent_support antecedent_support,\n  t.consequent_support consequent_support\nFROM TABLE(dbms_data_mining.get_association_rules(?,  ?,   NULL,  ?,  ?,?, ?, ?,?, ?, ?)) t ";
        SQLHelper sQLHelper = new SQLHelper();
        Vector<RuleRowData> vector = new Vector<RuleRowData>();
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(2, aRRulesFilterSetting.getFetchSize());
            if (aRRulesFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(3, aRRulesFilterSetting.getMinConfidence());
                sQLHelper.pstmt.setDouble(4, aRRulesFilterSetting.getMinSupport());
                sQLHelper.pstmt.setInt(5, aRRulesFilterSetting.getMaxRuleLength());
                sQLHelper.pstmt.setInt(6, aRRulesFilterSetting.getMinRuleLength());
                sQLHelper.pstmt.setDouble(10, aRRulesFilterSetting.getMinLift());
            } else {
                sQLHelper.pstmt.setNull(3, 8);
                sQLHelper.pstmt.setNull(4, 8);
                sQLHelper.pstmt.setNull(5, 4);
                sQLHelper.pstmt.setNull(6, 4);
                sQLHelper.pstmt.setNull(10, 8);
            }
            ((OraclePreparedStatement)sQLHelper.pstmt).setORAData(7, (ORAData)aRRulesFilterSetting.getSortCollection());
            if (aRRulesFilterSetting.isUseFilterSpecification()) {
                ((OraclePreparedStatement)sQLHelper.pstmt).setORAData(8, (ORAData)aRRulesFilterSetting.getConditionItemFilters());
                ((OraclePreparedStatement)sQLHelper.pstmt).setORAData(9, (ORAData)aRRulesFilterSetting.getAssociationItemFilters());
            } else {
                ((OraclePreparedStatement)sQLHelper.pstmt).setNull(8, 2002, "DM_ITEMS");
                ((OraclePreparedStatement)sQLHelper.pstmt).setNull(9, 2002, "DM_ITEMS");
            }
            sQLHelper.pstmt.setFetchSize(1000);
            sQLHelper.pstmt.execute();
            RuleRowData ruleRowData = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Object object;
                ruleRowData = new RuleRowData(sQLHelper.rs.getInt("RULE_ID"));
                ruleRowData.setRule_support(sQLHelper.rs.getDouble("RULE_SUPPORT"));
                ruleRowData.setRule_lift(sQLHelper.rs.getDouble("RULE_LIFT"));
                ruleRowData.setRule_confidence(sQLHelper.rs.getDouble("RULE_CONFIDENCE"));
                ruleRowData.setNumber_of_items(sQLHelper.rs.getInt("NUMBER_OF_ITEMS"));
                ruleRowData.setConsequent_support(sQLHelper.rs.getDouble("CONSEQUENT_SUPPORT"));
                ruleRowData.setAntecedent_support(sQLHelper.rs.getDouble("ANTECEDENT_SUPPORT"));
                DmPredicates dmPredicates = (DmPredicates)((OracleResultSet)sQLHelper.rs).getORAData("CONSEQUENT", DmPredicates.getORADataFactory());
                Vector<PredicateRowData> vector2 = new Vector<PredicateRowData>();
                for (int i = 0; i < dmPredicates.length(); ++i) {
                    DmPredicate dmPredicate = dmPredicates.getElement(i);
                    object = new PredicateRowData(dmPredicate);
                    vector2.add((PredicateRowData)object);
                }
                ruleRowData.setConsequent(vector2);
                DmPredicates dmPredicates2 = (DmPredicates)((OracleResultSet)sQLHelper.rs).getORAData("ANTECEDENT", DmPredicates.getORADataFactory());
                Vector<PredicateRowData> vector3 = new Vector<PredicateRowData>();
                for (int i = 0; i < dmPredicates2.length(); ++i) {
                    object = dmPredicates2.getElement(i);
                    PredicateRowData predicateRowData = new PredicateRowData((DmPredicate)object);
                    vector3.add(predicateRowData);
                }
                ruleRowData.setAntecedent(vector3);
                vector.add(ruleRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private class LoadItemMetrics
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _userName;
        String _modelName;
        Context _context;
        Number _totalRulesCount = null;
        HashMap _itemMetrics = null;

        public LoadItemMetrics(Context context, String string, String string2) {
            this._userName = string;
            this._modelName = string2;
            this._context = context;
        }

        @Override
        public void run() {
            try {
                this._itemMetrics = ARModelDetails.this.getItemGlobalMetrics(this._context, this._userName, this._modelName);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public HashMap getItemMetrics() {
            return this._itemMetrics;
        }
    }

    private class LoadGlobalDetails
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _userName;
        String _modelName;
        Context _context;
        HashMap _globalDetails = null;

        public LoadGlobalDetails(Context context, String string, String string2) {
            this._userName = string;
            this._modelName = string2;
            this._context = context;
        }

        @Override
        public void run() {
            try {
                this._globalDetails = ARModelDetails.this.getGlobalDetails(this._context, this._userName, this._modelName);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public HashMap getGlobalDetailsResult() {
            return this._globalDetails;
        }
    }

    private class LoadTotalRulesCount
    extends Thread {
        Exception _ex = null;
        boolean _success = false;
        boolean _reload = false;
        String _userName;
        String _modelName;
        Context _context;
        Number _totalRulesCount = null;

        public LoadTotalRulesCount(Context context, String string, String string2) {
            this._userName = string;
            this._modelName = string2;
            this._context = context;
        }

        @Override
        public void run() {
            try {
                this._totalRulesCount = ARModelDetails.this.getTotalRulesCount(this._context, this._userName, this._modelName);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
        }

        public boolean isSuccessful() {
            return this._success;
        }

        public Exception getException() {
            return this._ex;
        }

        public Number getTotalRulesValue() {
            return this._totalRulesCount;
        }
    }

    public static class ODM_DM_PREDICATE {
        public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        public static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
        public static final String CONDITIONAL_OPERATOR = "CONDITIONAL_OPERATOR";
        public static final String ATTRIBUTE_NUM_VALUE = "ATTRIBUTE_NUM_VALUE";
        public static final String ATTRIBUTE_STR_VALUE = "ATTRIBUTE_STR_VALUE";
        public static final String ATTRIBUTE_SUPPORT = "ATTRIBUTE_SUPPORT";
        public static final String ATTRIBUTE_CONFIDENCE = "ATTRIBUTE_CONFIDENCE";
    }

    private static class ODM_DM_PREDICATE_MAPPING {
        public static final String RULE_ID = "RULE_ID";
        public static final String ANTECDENT = "ANTECEDENT";
        public static final String CONSEQUENT = "CONSEQUENT";
        public static final String RULE_SUPPORT = "RULE_SUPPORT";
        public static final String RULE_CONFIDENCE = "RULE_CONFIDENCE";
        public static final String RULE_LIFT = "RULE_LIFT";
        public static final String ANTECDENT_SUPPORT = "ANTECEDENT_SUPPORT";
        public static final String CONSEQUENT_SUPPORT = "CONSEQUENT_SUPPORT";
        public static final String NUMBER_OF_ITEMS = "NUMBER_OF_ITEMS";

        private ODM_DM_PREDICATE_MAPPING() {
        }
    }

    public static class ODM_DM_GLOBAL_METRICS {
        public static final String RULE_COUNT = "RULE_COUNT";
        public static final String ITEMSET_COUNT = "ITEMSET_COUNT";
        public static final String MAX_SUPPORT = "MAX_SUPPORT";
    }

    public static class ODM_DM_GLOBAL_DETAIL {
        public static final String GLOBAL_DETAIL_NAME = "GLOBAL_DETAIL_NAME";
        public static final String GLOBAL_DETAIL_VALUE = "GLOBAL_DETAIL_VALUE";
    }

    public static class ODM_DM_ITEM_SORT {
        public static final String ATTRIBUTE = "FULL_NAME";
        public static final String VALUE = "ATTRIBUTE_VALUE";
        public static final String SUPPORT = "SUPPORT";
    }

    public static class ODM_DM_ITEMSET {
        public static final String ITEMSET_ID = "ITEMSET_ID";
        public static final String ITEMS = "ITEMS";
        public static final String SUPPORT = "SUPPORT";
        public static final String NUMBER_OF_ITEMS = "NUMBER_OF_ITEMS";
    }

    public static class ODM_DM_RULE {
        public static final String RULE_ID = "RULE_ID";
        public static final String ANTECDENT = "ANTECEDENT";
        public static final String CONSEQUENT = "CONSEQUENT";
        public static final String RULE_SUPPORT = "RULE_SUPPORT";
        public static final String RULE_CONFIDENCE = "RULE_CONFIDENCE";
        public static final String RULE_LIFT = "RULE_LIFT";
        public static final String ANTECDENT_SUPPORT = "ANTECEDENT_SUPPORT";
        public static final String CONSEQUENT_SUPPORT = "CONSEQUENT_SUPPORT";
        public static final String NUMBER_OF_ITEMS = "NUMBER_OF_ITEMS";
    }

    public static class ODM_DM_ITEM {
        public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        public static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
        public static final String ATTRIBUTE_NUM_VALUE = "ATTRIBUTE_NUM_VALUE";
        public static final String ATTRIBUTE_STR_VALUE = "ATTRIBUTE_STR_VALUE";
    }

    public static class GET_ASSOCIATION_RULES {
        public static final String MIN_LIFT = "MIN_LIFT";
        public static final String MIN_CONFIDENCE = "MIN_CONFIDENCE";
        public static final String MIN_SUPPORT = "MIN_SUPPORT";
        public static final String MAX_RULE_LENGTH = "MAX_RULE_LENGTH";
        public static final String MIN_RULE_LENGTH = "MIN_RULE_LENGTH";
    }
}

