/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmItem;
import oracle.dmt.dataminer.generated.server.DmItems;
import oracle.dmt.dataminer.generated.server.OraMiningVarchar2Nt;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesFilterSettings;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesViewerState;
import oracle.dmt.dataminer.server.model.FilterItemSet;
import oracle.dmt.dataminer.server.model.Item;
import oracle.dmt.dataminer.server.model.ModelLrb;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class ARRulesFilterSetting {
    private Double _minLift;
    private Double _minConfidence;
    private Double _minSupport;
    private int _minRuleLength;
    private int _maxRuleLength;
    private int _fetchSize;
    private Vector<SortSpec> _sortSpecs;
    private Vector<FilterItemSet> _filterItems;
    private boolean bUseFilterSpec = false;
    private ARRulesViewerState _viewerState;
    private ModelViewerPreferenceSettings _modelViewerPrefenceSettings = ModelViewerPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private ARRulesFilterSettings _arRulesFilterSettings = ARRulesFilterSettings.getInstance((PropertyStorage)Preferences.getPreferences());

    public ARRulesFilterSetting() throws Exception {
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeARModel();
        this._minLift = this._arRulesFilterSettings.getMinimumLift();
        this._minConfidence = this._arRulesFilterSettings.getMinimumConfidence();
        this._minSupport = this._arRulesFilterSettings.getMinimumSupport();
        this._minRuleLength = this._arRulesFilterSettings.getMinimumItems();
        this._maxRuleLength = this._arRulesFilterSettings.getMaximumItems();
        this._sortSpecs = new Vector();
        this._sortSpecs.add(new SortSpec("RULE_LIFT", SortSpec.SortDirection.DESCENDING, true));
        this._filterItems = new Vector();
    }

    public ARRulesFilterSetting(ARRulesViewerState aRRulesViewerState) throws Exception {
        this._viewerState = aRRulesViewerState;
        this._fetchSize = this._modelViewerPrefenceSettings.getFetchSizeARModel();
        this._minLift = this._arRulesFilterSettings.getMinimumLift();
        this._minConfidence = this._arRulesFilterSettings.getMinimumConfidence();
        this._minSupport = this._arRulesFilterSettings.getMinimumSupport();
        this._minRuleLength = this._arRulesFilterSettings.getMinimumItems();
        this._maxRuleLength = this._arRulesFilterSettings.getMaximumItems();
        this._sortSpecs = new Vector();
        this._sortSpecs.add(new SortSpec("RULE_LIFT", SortSpec.SortDirection.DESCENDING, true));
        this._filterItems = new Vector();
    }

    public ARRulesFilterSetting(int n, Double d, Double d2, Double d3, int n2, int n3, Vector<SortSpec> vector, Vector<FilterItemSet> vector2) throws Exception {
        this._fetchSize = n;
        this._minLift = d;
        this._minConfidence = d2;
        this._minSupport = d3;
        this._minRuleLength = n2;
        this._maxRuleLength = n3;
        this._sortSpecs = vector;
        vector2 = new Vector();
    }

    public void setMinLift(Double d) throws Exception {
        if (this._viewerState != null && d < 0.0) {
            throw new Exception(ModelLrb.get("MINIMUM_LIFT_RANGE_ERROR"));
        }
        this._minLift = d;
    }

    public Double getMinLift() {
        return this._minLift;
    }

    public void setMinConfidence(Double d) throws Exception {
        if (this._viewerState != null && (d < 0.0 || d > 1.0)) {
            throw new Exception(ModelLrb.get("MINIMUM_CONFIDENCE_RANGE_ERROR"));
        }
        this._minConfidence = d;
    }

    public Double getMinConfidence() {
        return this._minConfidence;
    }

    public void setMinSupport(Double d) throws Exception {
        if (this._viewerState != null && (d < 0.0 || d > 1.0)) {
            throw new Exception(ModelLrb.get("MINIMUM_SUPPORT_RANGE_ERROR"));
        }
        this._minSupport = d;
    }

    public Double getMinSupport() {
        return this._minSupport;
    }

    public void setMinRuleLength(int n) throws Exception {
        if (this._viewerState != null && n < 1) {
            throw new Exception(ModelLrb.get("MINIMUM_ITEMS_RANGE_ERROR"));
        }
        this._minRuleLength = n;
    }

    public int getMinRuleLength() {
        return this._minRuleLength;
    }

    public void setMaxRuleLength(int n) throws Exception {
        if (this._viewerState != null && n < 1) {
            throw new Exception(ModelLrb.get("MAXIMUM_ITEMS_RANGE_ERROR"));
        }
        this._maxRuleLength = n;
    }

    public int getMaxRuleLength() {
        return this._maxRuleLength;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public void setFetchSize(int n) {
        this._fetchSize = n;
    }

    public Vector<SortSpec> getSortSpecification() {
        return this._sortSpecs;
    }

    public void setSortSpecification(Vector<SortSpec> vector) {
        this._sortSpecs = vector;
    }

    public ARRulesViewerState getViewerState() {
        return this._viewerState;
    }

    public String getSortString() {
        Iterator<SortSpec> iterator = this._sortSpecs.iterator();
        SortSpec sortSpec = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            stringBuffer.append(sortSpec.getSortSQLString() + " ");
        }
        return stringBuffer.toString();
    }

    public DmItems getConditionItemFilters() throws Exception {
        return this.getDMItemsFilters(1);
    }

    public DmItems getAssociationItemFilters() throws Exception {
        return this.getDMItemsFilters(2);
    }

    private Vector<SortSpec> getIsUsedSortSpecItems() {
        Iterator<SortSpec> iterator = this._sortSpecs.iterator();
        Vector<SortSpec> vector = new Vector<SortSpec>();
        SortSpec sortSpec = null;
        while (iterator.hasNext()) {
            sortSpec = iterator.next();
            if (!sortSpec.isUseIt()) continue;
            vector.add(sortSpec);
        }
        return vector;
    }

    private DmItems getDMItemsFilters(int n) throws Exception {
        DmItems dmItems = new DmItems();
        Vector<DmItem> vector = new Vector<DmItem>();
        for (FilterItemSet filterItemSet : this._filterItems) {
            if (filterItemSet.getFilterAction() != 0 && filterItemSet.getFilterAction() != n) continue;
            Item item = filterItemSet.getItems().get(0);
            DmItem dmItem = new DmItem(item.getAttribute_name(), item.getAttribute_subname(), item.getAttribute_num_value() != null ? new BigDecimal(item.getAttribute_num_value()) : null, item.getAttribute_str_value());
            vector.add(dmItem);
        }
        DmItem[] dmItemArray = new DmItem[vector.size()];
        dmItems.setArray(vector.toArray(dmItemArray));
        return dmItems;
    }

    public OraMiningVarchar2Nt getSortCollection() throws Exception {
        Vector<SortSpec> vector = this.getIsUsedSortSpecItems();
        OraMiningVarchar2Nt oraMiningVarchar2Nt = new OraMiningVarchar2Nt();
        SortSpec sortSpec = null;
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sortSpec = vector.get(i);
            stringArray[i] = sortSpec.getSortSQLString() + " ";
        }
        oraMiningVarchar2Nt.setArray(stringArray);
        return oraMiningVarchar2Nt;
    }

    public void setFilterItems(Vector<FilterItemSet> vector) {
        this._filterItems = vector;
    }

    public Vector<FilterItemSet> getFilterItems() {
        return this._filterItems;
    }

    public void setUseFilterSpecification(boolean bl) {
        this.bUseFilterSpec = bl;
    }

    public boolean isUseFilterSpecification() {
        return this.bUseFilterSpec;
    }
}

