/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.generated.server.DmCentroids;
import oracle.dmt.dataminer.generated.server.DmChild;
import oracle.dmt.dataminer.generated.server.DmChildren;
import oracle.dmt.dataminer.generated.server.DmCluster;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.generated.server.DmPredicates;
import oracle.dmt.dataminer.generated.server.DmRule;
import oracle.dmt.dataminer.server.model.CentroidRowData;
import oracle.dmt.dataminer.server.model.HistogramRowData;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleRowData;

public class ClusteringDetailRow {
    private static final Logger theLogger = Logger.getLogger(ClusteringDetailRow.class.getName());
    private Integer _id;
    private String _cluster_id;
    private Integer _count;
    private Integer _parent;
    private Integer _tree_level;
    private Double _dispersion;
    private Vector<PredicateRowData> _split_predicate;
    private Vector<Integer> _child;
    private Vector<CentroidRowData> _centroid;
    private Vector<HistogramRowData> _histogram;
    private RuleRowData _rule;

    public ClusteringDetailRow() {
        this._id = 0;
        this._cluster_id = "";
        this._count = 0;
        this._parent = 0;
        this._tree_level = 0;
        this._dispersion = 0.0;
        this._split_predicate = new Vector();
        this._child = new Vector();
        this._centroid = new Vector();
        this._histogram = new Vector();
        this._rule = null;
    }

    public ClusteringDetailRow(Integer n, String string, Integer n2, Integer n3, Integer n4, Double d, Vector<PredicateRowData> vector, Vector<Integer> vector2, Vector<CentroidRowData> vector3, Vector<HistogramRowData> vector4, RuleRowData ruleRowData) {
        this._id = n;
        this._cluster_id = string;
        this._count = n2;
        this._parent = n3;
        this._tree_level = n4;
        this._dispersion = d;
        this._split_predicate = vector;
        this._child = vector2;
        this._centroid = vector3;
        this._histogram = vector4;
        this._rule = ruleRowData;
    }

    public ClusteringDetailRow(Integer n, String string, Integer n2, Integer n3, Integer n4, Double d, DmPredicates dmPredicates, DmChildren dmChildren, DmCentroids dmCentroids, DmHistograms dmHistograms, DmRule dmRule) throws Exception {
        try {
            this._id = n;
            this._cluster_id = string;
            this._count = n2;
            this._parent = n3;
            this._tree_level = n4;
            this._dispersion = d;
            this._split_predicate = dmPredicates != null ? PredicateRowData.createPredicatesFromDmPredicates(dmPredicates) : null;
            this._child = dmChildren != null ? ClusteringDetailRow.createChildrenFromDmChildren(dmChildren) : null;
            this._centroid = dmCentroids != null ? CentroidRowData.createCentroidsFromDmCentroids(dmCentroids) : null;
            this._histogram = dmHistograms != null ? HistogramRowData.createHistogramsFromDmHistograms(dmHistograms) : null;
            this._rule = dmRule != null ? new RuleRowData(dmRule) : null;
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
    }

    public ClusteringDetailRow(DmCluster dmCluster) throws Exception {
        this._id = dmCluster.getId() != null ? Integer.valueOf(dmCluster.getId().intValue()) : null;
        this._cluster_id = dmCluster.getClusterId() != null ? dmCluster.getClusterId() : null;
        this._count = dmCluster.getRecordCount() != null ? Integer.valueOf(dmCluster.getRecordCount().intValue()) : null;
        this._parent = dmCluster.getParent() != null ? Integer.valueOf(dmCluster.getParent().intValue()) : null;
        this._tree_level = dmCluster.getTreeLevel() != null ? Integer.valueOf(dmCluster.getTreeLevel().intValue()) : null;
        this._dispersion = dmCluster.getDispersion() != null ? Double.valueOf(dmCluster.getDispersion().doubleValue()) : null;
        this._split_predicate = dmCluster.getSplitPredicate() != null ? PredicateRowData.createPredicatesFromDmPredicates(dmCluster.getSplitPredicate()) : null;
        this._child = dmCluster.getChild() != null ? ClusteringDetailRow.createChildrenFromDmChildren(dmCluster.getChild()) : null;
        this._centroid = dmCluster.getCentroid() != null ? CentroidRowData.createCentroidsFromDmCentroids(dmCluster.getCentroid()) : null;
        this._histogram = dmCluster.getHistogram() != null ? HistogramRowData.createHistogramsFromDmHistograms(dmCluster.getHistogram()) : null;
        this._rule = dmCluster.getRule() != null ? new RuleRowData(dmCluster.getRule()) : null;
    }

    public static Vector<Integer> createChildrenFromDmChildren(DmChildren dmChildren) throws Exception {
        DmChild dmChild;
        Vector<Integer> vector = new Vector<Integer>();
        BigDecimal bigDecimal = null;
        for (int i = 0; i < dmChildren.length() && (bigDecimal = (dmChild = dmChildren.getElement(i)).getId()) != null; ++i) {
            Integer n = dmChild.getId().intValue();
            vector.add(n);
        }
        return vector;
    }

    public static HashMap<String, ClusteringDetailRow> createMappedClusterLabelToID(Vector<ClusteringDetailRow> vector, boolean bl) {
        HashMap<String, ClusteringDetailRow> hashMap = new HashMap<String, ClusteringDetailRow>();
        for (ClusteringDetailRow clusteringDetailRow : vector) {
            if (bl) {
                if (clusteringDetailRow.getChild() != null && clusteringDetailRow.getChild().size() != 0) continue;
                hashMap.put(clusteringDetailRow.getCluster_id(), clusteringDetailRow);
                continue;
            }
            hashMap.put(clusteringDetailRow.getCluster_id(), clusteringDetailRow);
        }
        return hashMap;
    }

    public void setId(Integer n) {
        this._id = n;
    }

    public Integer getId() {
        return this._id;
    }

    public void setCount(Integer n) {
        this._count = n;
    }

    public Integer getCount() {
        return this._count;
    }

    public void setParent(Integer n) {
        this._parent = n;
    }

    public Integer getParent() {
        return this._parent;
    }

    public void setTree_level(Integer n) {
        this._tree_level = n;
    }

    public Integer getTree_level() {
        return this._tree_level;
    }

    public void setDispersion(Double d) {
        this._dispersion = d;
    }

    public Double getDispersion() {
        return this._dispersion;
    }

    public void setSplit_predicate(Vector<PredicateRowData> vector) {
        this._split_predicate = vector;
    }

    public Vector<PredicateRowData> getSplit_predicate() {
        return this._split_predicate;
    }

    public void setChild(Vector<Integer> vector) {
        this._child = vector;
    }

    public Vector<Integer> getChild() {
        return this._child;
    }

    public void setCentroid(Vector<CentroidRowData> vector) {
        this._centroid = vector;
    }

    public Vector<CentroidRowData> getCentroid() {
        return this._centroid;
    }

    public void setHistogram(Vector<HistogramRowData> vector) {
        this._histogram = vector;
    }

    public Vector<HistogramRowData> getHistogram() {
        return this._histogram;
    }

    public void setRule(RuleRowData ruleRowData) {
        this._rule = ruleRowData;
    }

    public RuleRowData getRule() {
        return this._rule;
    }

    public void setCluster_id(String string) {
        this._cluster_id = string;
    }

    public String getCluster_id() {
        return this._cluster_id;
    }
}

