/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.NameValuePair;
import oracle.dmt.dataminer.generated.server.DmCentroid;
import oracle.dmt.dataminer.generated.server.DmCentroids;
import oracle.dmt.dataminer.generated.server.DmChildren;
import oracle.dmt.dataminer.generated.server.DmHistogramBin;
import oracle.dmt.dataminer.generated.server.DmHistograms;
import oracle.dmt.dataminer.generated.server.DmPredicates;
import oracle.dmt.dataminer.generated.server.DmRule;
import oracle.dmt.dataminer.mviewer.clustering.ClusterDetailsModelRow;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentData;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentModelRow;
import oracle.dmt.dataminer.mviewer.clustering.component.ClusterComponentProjectionItem;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CentroidRowData;
import oracle.dmt.dataminer.server.model.Clustering;
import oracle.dmt.dataminer.server.model.ClusteringDetailRow;
import oracle.dmt.dataminer.server.model.ClusteringDetailRowShort;
import oracle.dmt.dataminer.server.model.ClusteringFilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleRowData;
import oracle.dmt.dataminer.server.model.SortSpec;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.ide.Context;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class ClusteringDetailsImpl {
    private static final Logger theLogger = Logger.getLogger(ClusteringDetailsImpl.class.getName());
    private static final String CLUSTER_DETAIL_QUERY_TOPN_JOIN = "WITH first_query AS\n  (SELECT a.ID,\n    d.attribute_name,\n    d.attribute_subname,\n    d.attribute_confidence,\n    nvl2 (d.attribute_subname, d.attribute_name\n    || '.'\n    || d.attribute_subname, d.attribute_name) full_name\n   FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,null,null,0,0,2<SUBNAME_PARAM>)) a,\n    TABLE(a.rule.ANTECEDENT) D\n  ),\n  antecedents_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  FROM first_query order by attribute_confidence desc, full_name\n  ),\n  top_items_txn_query AS\n  (SELECT id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name,\n    ROW_NUMBER () over (partition BY id order by attribute_confidence DESC) AS rank\n  FROM antecedents_query\n  GROUP BY id,\n    attribute_name,\n    attribute_subname,\n    attribute_confidence,\n    full_name\n  ),\n  top_items_txn_filtered AS\n  (SELECT /*+ MATERIALIZE */ * FROM top_items_txn_query WHERE rank <= :topN\n  ),\n centroid_subq AS\n  (SELECT /*+ MATERIALIZE */ A.id, c.*\n   FROM\n    TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,null,null,1,0,0<SUBNAME_PARAM>)) a,\n    TABLE (A.centroid) c\n  ),\n  centroids_txn AS\n  (SELECT\n    c.*,\n    top_items_txn_filtered.attribute_confidence,\n    top_items_txn_filtered.rank\n    FROM centroid_subq c,\n    top_items_txn_filtered\n  WHERE c.id = top_items_txn_filtered.id\n  AND nvl2 (c.attribute_subname, c.attribute_name\n    || '.'\n    || c.attribute_subname, c.attribute_name) = top_items_txn_filtered.full_name\n  ),\n  top_centroids_txn AS\n  (SELECT *\n  FROM\n    (SELECT id,\n      attribute_name,\n      attribute_subname,\n      attribute_confidence,\n      mean,\n      mode_value,\n      variance,\n      rank\n    FROM centroids_txn\n    )\n  ),\n  top_centroids AS\n    (SELECT id,\n      CAST (collect (DM_CENTROID (attribute_name, attribute_subname, mean, mode_value, variance)) AS DM_CENTROIDS) AS centroid\n    FROM top_centroids_txn\n    GROUP BY ID\n    )\n SELECT clusters.id, \n    clusters.cluster_id, \n    clusters.record_count, \n    clusters.parent, \n    clusters.tree_level, \n    clusters.dispersion, \n    clusters.split_predicate, \n    clusters.child, \n    top_centroids.centroid,\n    clusters.rule \n  FROM\n    TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:model_name,null,null,0,0,2<SUBNAME_PARAM>)) clusters,\n  top_centroids\nWHERE clusters.ID = top_centroids.ID(+)\n order by id";
    private static String CLUSTER_DETAILS_QUERY_NEW = "WITH dup_attributes AS\n  (SELECT a.id            ,\n    a.cluster_id          ,\n    a.rule.rule_id        ,\n    r.attribute_name      ,\n    r.attribute_subname   ,\n    r.attribute_support   ,\n    r.attribute_confidence,\n    NVL2(r.attribute_subname, r.attribute_name\n    || '.'\n    || r.attribute_subname, r.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS1>)a,\n    TABLE(a.rule.antecedent) r\n  ),\n  rule_attributes AS\n  ( SELECT DISTINCT * FROM dup_attributes d\n  ),\n  all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS2>)a,\n     TABLE(a.centroid) b),\n  join_attributes AS\n    (SELECT a.attribute_name,\n      a.attribute_subname   ,\n      a.attribute_name_subname ,\n      b.attribute_support   ,\n      b.attribute_confidence\n       FROM all_attributes a,\n      rule_attributes b\n      WHERE a.attribute_name_subname = b.attribute_name_subname(+)\n      <ORDER_BY1>\n    ),\n    filtered_attributes AS\n    (SELECT * FROM join_attributes <FETCH_CONDITION>\n      <WHERE_CONFIDENCE> \n    ),\n    centroids AS\n    (SELECT b.attribute_name,\n      b.attribute_subname   ,\n      NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name) attribute_name_subname,  \n      b.mean                ,\n      b.mode_value          ,\n      b.variance            ,\n      CAST(MULTISET\n      (SELECT e.*\n         FROM TABLE(a.histogram)e\n        WHERE NVL2(e.attribute_subname, e.attribute_name\n        || '.'\n        || e.attribute_subname, e.attribute_name) = NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name)\n      ) AS DM_HISTOGRAMS) AS histogram\n       FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS3>)a,\n      TABLE(a.centroid) b\n    )\n   SELECT a.attribute_name                 ,\n    a.attribute_subname                    ,\n    a.attribute_name_subname AS attribute_name_subname, \n    nvl(a.attribute_support,0) attribute_support, \n    nvl(a.attribute_confidence,0)  attribute_confidence, \n    b.attribute_name    AS centroid_name   ,\n    b.attribute_subname AS centroid_subname, \n    b.attribute_name_subname AS centroid_name_subname, \n    b.mean                                 ,\n    b.mode_value                           ,\n    b.variance                             ,\n    b.histogram\n     FROM filtered_attributes a,\n    centroids b\n    WHERE a.attribute_name_subname = b.attribute_name_subname \n    <ORDER_BY2>\n";
    private static String KM_DBMS_API_1_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL, ?)";
    private static String OC_DBMS_API_1 = "GET_MODEL_DETAILS_OC(?,?,NULL,0,0,2)";
    private static String EM_DBMS_API_1 = "GET_MODEL_DETAILS_EM(?,?,NULL,0,0,2,NULL, ?)";
    private static String KM_DBMS_API_2_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL, ?)";
    private static String OC_DBMS_API_2 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)";
    private static String EM_DBMS_API_2 = "GET_MODEL_DETAILS_EM(?,?,NULL,1,0,0,NULL, ?)";
    private static String KM_DBMS_API_3_12_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL, ?)";
    private static String OC_DBMS_API_3 = "GET_MODEL_DETAILS_OC(?,?,NULL,1,1,0)";
    private static String EM_DBMS_API_3 = "GET_MODEL_DETAILS_EM(?,?,NULL,1,1,0,NULL, ?)";
    private static String CONFIDENCE_DBMS_API_RANGE_OC = "AND attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String CONFIDENCE_DBMS_API_RANGE_KM_EM = " attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String FETCH_SIZE_OC = "rownum <= <FETCH_SIZE>";
    private static String CLUSTER_DETAILS_QUERY = "WITH dup_attributes AS\n  (SELECT a.id            ,\n    a.cluster_id          ,\n    a.rule.rule_id        ,\n    r.attribute_name      ,\n    r.attribute_subname   ,\n    r.attribute_support   ,\n    r.attribute_confidence,\n    NVL2(r.attribute_subname, r.attribute_name\n    || '.'\n    || r.attribute_subname, r.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS1>)a,\n    TABLE(a.rule.antecedent) r\n  ),\n  rule_attributes AS\n  ( SELECT DISTINCT * FROM dup_attributes d\n  ),\n  all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS2>)a,\n     TABLE(a.centroid) b),\n  join_attributes AS\n    (SELECT a.attribute_name,\n      a.attribute_subname   ,\n      a.attribute_name_subname ,\n      b.attribute_support   ,\n      b.attribute_confidence\n       FROM all_attributes a,\n      rule_attributes b\n      WHERE a.attribute_name_subname = b.attribute_name_subname(+)\n      <ORDER_BY1>\n    ),\n    filtered_attributes AS\n    (SELECT * FROM join_attributes WHERE rownum <= <FETCH_SIZE>\n      <WHERE_CONFIDENCE> \n    ),\n    centroids AS\n    (SELECT b.attribute_name,\n      b.attribute_subname   ,\n      NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name) attribute_name_subname,  \n      b.mean                ,\n      b.mode_value          ,\n      b.variance            ,\n      CAST(MULTISET\n      (SELECT e.*\n         FROM TABLE(a.histogram)e\n        WHERE NVL2(e.attribute_subname, e.attribute_name\n        || '.'\n        || e.attribute_subname, e.attribute_name) = NVL2(b.attribute_subname, b.attribute_name\n        || '.'\n        || b.attribute_subname, b.attribute_name)\n      ) AS DM_HISTOGRAMS) AS histogram\n       FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS3>)a,\n      TABLE(a.centroid) b\n    )\n   SELECT a.attribute_name                 ,\n    a.attribute_subname                    ,\n    a.attribute_name_subname AS attribute_name_subname, \n    nvl(a.attribute_support,0) attribute_support, \n    nvl(a.attribute_confidence,0)  attribute_confidence, \n    b.attribute_name    AS centroid_name   ,\n    b.attribute_subname AS centroid_subname, \n    b.attribute_name_subname AS centroid_name_subname, \n    b.mean                                 ,\n    b.mode_value                           ,\n    b.variance                             ,\n    b.histogram\n     FROM filtered_attributes a,\n    centroids b\n    WHERE a.attribute_name_subname = b.attribute_name_subname \n    <ORDER_BY2>\n";
    private static String KM_DBMS_API_1 = "GET_MODEL_DETAILS_KM(?,?,NULL,0,0,2,NULL)";
    private static String KM_DBMS_API_2 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)";
    private static String KM_DBMS_API_3 = "GET_MODEL_DETAILS_KM(?,?,NULL,1,1,0,NULL)";
    private static String CONFIDENCE_DBMS_API_RANGE = "AND attribute_confidence >= ?  AND attribute_confidence <= ?";
    private static String _compare_sql = "select aname, subname, \n  CASE WHEN mean_val1 IS NULL THEN mode_val1 ELSE TO_CHAR(mean_val1) END centroid1,\n  CASE WHEN mean_val2 IS NULL THEN mode_val2 ELSE TO_CHAR(mean_val2) END centroid2,\n  rnk,\n  sym_kld\nFROM (WITH\nnode1 AS (\n  SELECT t.record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\nnode2 AS (\n  SELECT t. record_count rec_cnt, histogram, centroid\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(?,?,NULL,1,1)) t),\ncent1 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node1 t, TABLE(centroid) c),\ncent2 AS (\n  SELECT c.attribute_name aname, \n         c.attribute_subname subname,\n         c.mean mean_val,\n         c.mode_value mode_val\n  FROM node2 t, TABLE(centroid) c), \ncent AS (\n  SELECT nvl(c1.aname, c2.aname) aname,\n         nvl(c1.subname, c2.subname) subname,\n         nvl(c1.mean_val, 0)  mean_val1, \n         c1.mode_val mode_val1,\n         nvl(c2.mean_val, 0) mean_val2, \n         c2.mode_val mode_val2\n  FROM cent1 c1 full outer join cent2 c2\n    ON c1.aname = c2.aname AND \n       nvl(c1.subname, c1.aname) = nvl(c2.subname, c2.aname)),\nhist1 AS (\n  SELECT h.attribute_name aname,\n         h.attribute_subname subname,\n         h.bin_id bin_id,\n         h.count/t.rec_cnt prob\n  FROM node1 t, TABLE(t.histogram) h),\nhist2 AS (\n  SELECT h.attribute_name aname,\n       h.attribute_subname subname,\n       h.bin_id bin_id,\n       h.count/rec_cnt prob\n  FROM node2 t, TABLE(t.histogram) h),\nhist_av AS(\n  SELECT nvl(h1.aname, h2.aname) aname,\n          nvl(h1.subname, h2.subname) subname, \n          nvl(h1.bin_id, h2.bin_id) bin_id,\n          (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n  FROM hist1 h1 full outer join hist2 h2 \n      ON h1.aname = h2.aname AND\n         nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname) AND \n         h1.bin_id = h2.bin_id),\nkld AS (\n  SELECT aname, subname, sum(kld)/2 sym_kld FROM \n  (SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist1 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname\n  UNION all\n  SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist2 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname)\n  GROUP BY aname, subname)\nSELECT k.aname, k.subname, \n  CASE WHEN c.mode_val1 IS NULL THEN c.mean_val1 ELSE NULL END mean_val1,\n  c.mode_val1, \n  CASE WHEN c.mode_val2 IS NULL THEN c.mean_val2 ELSE NULL END mean_val2,    \n  c.mode_val2, \n  rank() over (order by sym_kld desc) rnk, sym_kld \nFROM kld k, cent c\nWHERE k.aname=c.aname \n    AND nvl(k.subname, k.aname)=nvl(c.subname, c.aname) \n ORDER BY rnk)";
    private static String _DIVERGENCE_SQL = "SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, rnk, sym_kld FROM (\nWITH\nnode1 AS (\n  SELECT t.record_count rec_cnt, histogram\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>) t),\nnode2 AS (\n  SELECT t. record_count rec_cnt, histogram\n  FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>) t),\nhist1 AS (\n  SELECT h.attribute_name aname,\n         h.attribute_subname subname,\n         h.bin_id bin_id,\n         h.count/t.rec_cnt prob\n  FROM node1 t, TABLE(t.histogram) h),\nhist2 AS (\n  SELECT h.attribute_name aname,\n       h.attribute_subname subname,\n       h.bin_id bin_id,\n       h.count/rec_cnt prob\n  FROM node2 t, TABLE(t.histogram) h),\nhist_av AS(\n  SELECT nvl(h1.aname, h2.aname) aname,\n          nvl(h1.subname, h2.subname) subname, \n          nvl(h1.bin_id, h2.bin_id) bin_id,\n          (nvl(h1.prob,0) + nvl(h2.prob,0))/2 prob \n  FROM hist1 h1 full outer join hist2 h2 \n      ON h1.aname = h2.aname AND\n         nvl(h1.subname,h1.aname)=nvl(h2.subname, h2.aname) AND \n         h1.bin_id = h2.bin_id),\nkld AS (\n  SELECT aname, subname, sum(kld)/2 sym_kld FROM \n  (SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist1 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname\n  UNION all\n  SELECT h2.aname aname, h2.subname subname, \n         sum(h1.prob*ln(h1.prob/h2.prob)) kld\n  FROM hist2 h1, hist_av h2\n  WHERE h1.prob > 0 \n  AND h1.aname = h2.aname \n  AND nvl(h1.subname, h1.aname)=nvl(h2.subname, h2.aname) \n  AND h1.bin_id=h2.bin_id \n  GROUP BY h2.aname, h2.subname)\n  GROUP BY aname, subname)\nSELECT k.aname ATTRIBUTE_NAME, k.subname ATTRIBUTE_SUBNAME,  rank() OVER (ORDER BY sym_kld DESC) rnk, sym_kld FROM kld k\nORDER BY rnk) where rownum <= ?";
    final String KM_API = "GET_MODEL_DETAILS_KM(?,?,NULL, 0, 1, 0)";
    final String OC_API = "GET_MODEL_DETAILS_OC(?,?,NULL, 0, 1, 0)";
    final String EM_API = "GET_MODEL_DETAILS_EM(?,?,NULL, 0, 1, 0)";
    static String ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2 = " with all_attributes AS\n  (SELECT a.id ID, a.cluster_id CLUSTER_ID, a.parent CLUSTER_PARENT, ch.id CHILD_ID \n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b, TABLE(A.CHILD) ch)\n select id, cluster_id, cluster_parent, child_id, count(*) TOTAL_ATTRIBUTE_COUNT from all_attributes\n group by id, cluster_id, cluster_parent, child_id\n order by id";
    private static String _query_kmeans = "WITH \n   all_data AS (\n SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_KM (:model_name, :cluster_id1, null, 1, 1, 0, NULL)) t, TABLE(t.centroid) c\nUNION ALL\n  SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_KM (:model_name, :cluster_id2, null, 1, 1, 0, NULL )) t, TABLE(t.centroid) c\n),\ncent AS (SELECT cluster_id, aname, subname, mean_val, mode_val, histogram  FROM all_data )\n  SELECT cluster_id, NVL2(subname, aname || '.' || subname, aname) attribute_name_subname,\n     CASE WHEN mean_val IS NULL THEN mode_val ELSE TO_CHAR(mean_val) END centroid,\n     histogram from cent \nWHERE NVL2(subname, aname || '.' || subname, aname) IN (\n <list_of_columns>)\n";
    private static String _o_cluster = "WITH \n   all_data AS (\n SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_OC (:model_name, :cluster_id1, null, 1, 1, 0)) t, TABLE(t.centroid) c\nUNION ALL\n  SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_OC (:model_name, :cluster_id2, null, 1, 1, 0)) t, TABLE(t.centroid) c\n),\ncent AS (SELECT cluster_id, aname, subname, mean_val, mode_val, histogram  FROM all_data )\n  SELECT cluster_id, NVL2(subname, aname || '.' || subname, aname) attribute_name_subname,\n     CASE WHEN mean_val IS NULL THEN mode_val ELSE TO_CHAR(mean_val) END centroid,\n     histogram from cent \nWHERE NVL2(subname, aname || '.' || subname, aname) IN (\n <list_of_columns>)\n";
    private static String _query_emcluster = "WITH \n   all_data AS (\n SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM (:model_name, :cluster_id1, null, 1, 1, 0, NULL)) t, TABLE(t.centroid) c\nUNION ALL\n  SELECT t.cluster_id, c.attribute_name aname, c.attribute_subname subname, c.mean mean_val, c.mode_value mode_val, histogram\n  FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM (:model_name, :cluster_id2, null, 1, 1, 0, NULL )) t, TABLE(t.centroid) c\n),\ncent AS (SELECT cluster_id, aname, subname, mean_val, mode_val, histogram  FROM all_data )\n  SELECT cluster_id, NVL2(subname, aname || '.' || subname, aname) attribute_name_subname,\n     CASE WHEN mean_val IS NULL THEN mode_val ELSE TO_CHAR(mean_val) END centroid,\n     histogram from cent \nWHERE NVL2(subname, aname || '.' || subname, aname) IN (\n <list_of_columns>)\n";
    private static String _get_model_details_comp_no_condition = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) WHERE ROWNUM < :fetch_size <component_condition>";
    private static String _get_model_details_comp_condition = "SELECT * FROM (\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, ATTRIBUTE_NAME, COVARIATE_NAME, ATTRIBUTE_VALUE, VALUE\nFROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) \nWHERE <where_conditon_name>UNION ALL\nSELECT INFO_TYPE, COMPONENT_ID, CLUSTER_ID, NULL, NULL, NULL, VALUE FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) \nWHERE INFO_TYPE IN ( 'Prior', 'Cluster') \nORDER BY INFO_TYPE, COMPONENT_ID\n) where ROWNUM < :fetch_size <component_condition>";
    private static String _where_conditon_name = "ATTRIBUTE_NAME LIKE '%<pattern>%' ";
    private static String _component_condition = "AND COMPONENT_ID = :component";
    private static String _cluster = "Cluster";
    private static String _prior = "Prior";
    private static String _mean = "Mean";
    private static String _covariance = "Covariance";
    private static String _frequency = "Frequency";
    private static String _get_model_details_proj_attr_name = "SELECT ATTRIBUTE_NAME FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name)) WHERE FEATURE_NAME=:feature_name AND ROWNUM = 1";
    private static String _get_model_details_proj_details = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name)) WHERE FEATURE_NAME = :feature_name AND ATTRIBUTE_NAME = :attribute_name";
    private static String _get_model_details_proj = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name))";
    private static String NUM_COMPONENTS = "NUM_COMPONENTS";
    private static String NUM_CLUSTERS = "NUM_CLUSTERS";
    private static String GLOBAL_DETAIL_NAME = "GLOBAL_DETAIL_NAME";
    private static String GLOBAL_DETAIL_VALUE = "GLOBAL_DETAIL_VALUE";
    private static String LOGLIKELIHOOD = "LOGLIKELIHOOD";
    private static String _get_model_details_global = "SELECT * FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLOBAL(:model_name))";
    private static final String CLUSTER_DETAIL_QUERY_TOPN_2 = "WITH\n  clusters AS\n    (SELECT * FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>(:modelname,null,null,1,0,2,<ATTRIBUTE_SUBNAME>:topn)))\nSELECT clusters.ID, clusters.cluster_id, clusters.record_count, clusters.PARENT,\n       clusters.tree_level, clusters.dispersion, clusters.split_predicate, clusters.CHILD,\n       clusters.centroid, clusters.RULE\nFROM clusters";
    private static final String CLUSTER_DETAIL_QUERY_TOPN_NO_STATS_MODEL = "SELECT clusters.ID, clusters.cluster_id, clusters.record_count, clusters.PARENT,\n       clusters.tree_level, clusters.dispersion, clusters.split_predicate, clusters.CHILD\nFROM\n  TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM(:modelname)) clusters";
    private static String _get_model_details_proj_names_counts = "SELECT FEATURE_NAME, ATTRIBUTE_NAME FROM (  SELECT FEATURE_NAME, ATTRIBUTE_NAME, count(ATTRIBUTE_NAME) NUM FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_PROJ(:model_name) )    WHERE FEATURE_NAME IN (     SELECT ATTRIBUTE_NAME FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_EM_COMP(:model_name)) WHERE ROWNUM < :fetch_size   ) GROUP BY FEATURE_NAME, ATTRIBUTE_NAME ) WHERE NUM > 0";

    public Vector<ClusteringDetailRow> getClusterAllDetailsKMTopN_Db11(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n) throws Exception {
        return this.getClusterAllDetailsTopN_Db11(connection, string, string2, bl, ruleResultType, n, AlgorithmType.KMEANS);
    }

    public Vector<ClusteringDetailRow> getClusterAllDetailsKMTopN_Db12(Connection connection, String string, String string2, int n) throws Exception {
        return this.getClusterAllDetailsTopN_Db12(connection, string, string2, n, AlgorithmType.KMEANS);
    }

    public Vector<ClusteringDetailRow> getClusterAllDetailsEMTopN_Db12(Connection connection, String string, String string2, int n, boolean bl) throws Exception {
        if (bl) {
            return this.getClusterAllDetailsNoStatsModel(connection, string, string2);
        }
        return this.getClusterAllDetailsTopN_Db12(connection, string, string2, n, AlgorithmType.EMCLUSTER);
    }

    public Vector<ClusteringDetailRow> getClusterAllDetailsOCTopN_Db11(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n) throws Exception {
        return this.getClusterAllDetailsTopN_Db11(connection, string, string2, bl, ruleResultType, n, AlgorithmType.OCLUSTER);
    }

    public Vector<ClusteringDetailRow> getClusterAllDetailsOCTopN_Db12(Connection connection, String string, String string2, int n) throws Exception {
        return this.getClusterAllDetailsTopN_Db12(connection, string, string2, n, AlgorithmType.OCLUSTER);
    }

    public List<CompareClustersModelRow> getDivergenceKM(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3) throws Exception {
        return this.getDivergence(connection, string, string2, n, string3, n2, string4, n3, AlgorithmType.KMEANS);
    }

    public List<CompareClustersModelRow> getDivergenceEM(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3) throws Exception {
        return this.getDivergence(connection, string, string2, n, string3, n2, string4, n3, AlgorithmType.EMCLUSTER);
    }

    public List<CompareClustersModelRow> getDivergenceOC(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3) throws Exception {
        return this.getDivergence(connection, string, string2, n, string3, n2, string4, n3, AlgorithmType.OCLUSTER);
    }

    public void getCenteroidAndHistogramKM(Connection connection, String string, String string2, int n, int n2, List<CompareClustersModelRow> list) throws Exception {
        this.getCenteroidAndHistogram(connection, string, string2, n, n2, list, AlgorithmType.KMEANS);
    }

    public void getCenteroidAndHistogramEM(Connection connection, String string, String string2, Integer n, Integer n2, List<CompareClustersModelRow> list) throws Exception {
        this.getCenteroidAndHistogram(connection, string, string2, n, n2, list, AlgorithmType.EMCLUSTER);
    }

    public void getCenteroidAndHistogramOC(Connection connection, String string, String string2, int n, int n2, List<CompareClustersModelRow> list) throws Exception {
        this.getCenteroidAndHistogram(connection, string, string2, n, n2, list, AlgorithmType.OCLUSTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<ClusteringDetailRow> getClusterAllDetailsTopN_Db11(Connection connection, String string, String string2, boolean bl, Clustering.RuleResultType ruleResultType, int n, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        HashMap<Integer, ClusteringDetailRow> hashMap = new HashMap<Integer, ClusteringDetailRow>();
        String string3 = CLUSTER_DETAIL_QUERY_TOPN_JOIN;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        try {
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM");
                string3 = StringUtils.getReplacedString(string3, "<SUBNAME_PARAM>", ",:attributesubname");
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
                string3 = StringUtils.getReplacedString(string3, "<SUBNAME_PARAM>", "");
            }
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setIntAtName("topN", n);
            if (algorithmType == AlgorithmType.KMEANS) {
                sQLHelper.opstmt.setNullAtName("attributesubname", 12);
            }
            sQLHelper.opstmt.execute();
            ClusteringDetailRow clusteringDetailRow = null;
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Object object;
                Object object2;
                Integer n2 = sQLHelper.rs.getInt("ID");
                clusteringDetailRow = (ClusteringDetailRow)hashMap.get(n2);
                DmCentroids dmCentroids = (DmCentroids)((OracleResultSet)sQLHelper.rs).getORAData("CENTROID", DmCentroids.getORADataFactory());
                Vector<CentroidRowData> vector2 = null;
                if (null == clusteringDetailRow) {
                    clusteringDetailRow = new ClusteringDetailRow();
                    vector2 = new Vector();
                    clusteringDetailRow.setId(n2);
                    hashMap.put(n2, clusteringDetailRow);
                    vector.add(clusteringDetailRow);
                    clusteringDetailRow.setCentroid(vector2);
                } else {
                    vector2 = clusteringDetailRow.getCentroid();
                }
                if (dmCentroids != null && (object2 = dmCentroids.getArray()) != null && ((DmCentroid[])object2).length > 0) {
                    for (int i = 0; i < ((DmCentroid[])object2).length; ++i) {
                        object = new CentroidRowData(object2[i]);
                        vector2.add((CentroidRowData)object);
                    }
                }
                object2 = sQLHelper.rs.getString("CLUSTER_ID");
                clusteringDetailRow.setCluster_id((String)object2);
                Integer n3 = sQLHelper.rs.getInt("RECORD_COUNT");
                clusteringDetailRow.setCount(n3);
                object = sQLHelper.rs.getInt("PARENT");
                clusteringDetailRow.setParent((Integer)object);
                Integer n4 = sQLHelper.rs.getInt("TREE_LEVEL");
                clusteringDetailRow.setTree_level(n4);
                Double d = sQLHelper.rs.getDouble("DISPERSION");
                clusteringDetailRow.setDispersion(d);
                DmPredicates dmPredicates = (DmPredicates)((OracleResultSet)sQLHelper.rs).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                if (dmPredicates != null) {
                    clusteringDetailRow.setSplit_predicate(PredicateRowData.createPredicatesFromDmPredicates(dmPredicates));
                }
                DmChildren dmChildren = (DmChildren)((OracleResultSet)sQLHelper.rs).getORAData("CHILD", DmChildren.getORADataFactory());
                clusteringDetailRow.setChild(ClusteringDetailRow.createChildrenFromDmChildren(dmChildren));
                DmRule dmRule = (DmRule)((OracleResultSet)sQLHelper.rs).getORAData("RULE", DmRule.getORADataFactory());
                if (dmRule == null) continue;
                clusteringDetailRow.setRule(new RuleRowData(dmRule));
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetailsKM(Context context, Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        if (version == null || version.toCanonicalString().startsWith("11.")) {
            return this.getModelAttributeDetails(connection, string, string2, clusteringFilterSetting, AlgorithmType.KMEANS);
        }
        return this.getModelAttributeDetails12_1(connection, string, string2, clusteringFilterSetting, AlgorithmType.KMEANS);
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetailsEM(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        return this.getModelAttributeDetails12_1(connection, string, string2, clusteringFilterSetting, AlgorithmType.EMCLUSTER);
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetailsOC(Context context, Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting) throws Exception {
        Version version = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        if (version == null || version.toCanonicalString().startsWith("11.")) {
            return this.getModelAttributeDetails(connection, string, string2, clusteringFilterSetting, AlgorithmType.OCLUSTER);
        }
        return this.getModelAttributeDetails12_1(connection, string, string2, clusteringFilterSetting, AlgorithmType.OCLUSTER);
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetails12_1(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting, AlgorithmType algorithmType) throws Exception {
        assert (clusteringFilterSetting != null) : "Condition can not be null.";
        assert (clusteringFilterSetting.getClusterId() != null) : "Cluster id can not be null. Will cause join problems.";
        assert (clusteringFilterSetting.getClusterId() >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAILS_QUERY_NEW;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusterDetailsModelRow> vector = new Vector<ClusterDetailsModelRow>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<SortSpec> vector2 = null;
        Double d = clusteringFilterSetting.getMinConfidence() / 100.0;
        Double d2 = clusteringFilterSetting.getMaxConfidence() / 100.0;
        String string4 = "";
        try {
            Object object;
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1_12_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2_12_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3_12_1);
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3);
                string4 = StringUtils.getReplacedString(FETCH_SIZE_OC, "<FETCH_SIZE>", clusteringFilterSetting.getFetchSize() + "");
            } else if (algorithmType == AlgorithmType.EMCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", EM_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", EM_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", EM_DBMS_API_3);
            }
            if (!string4.isEmpty()) {
                string4 = " WHERE " + string4;
            }
            string3 = StringUtils.getReplacedString(string3, "<FETCH_CONDITION>", string4);
            vector2 = clusteringFilterSetting.getSortSpecification();
            if (vector2 != null && vector2.size() > 0) {
                stringBuffer.append("order by ");
                object = vector2.iterator();
                while (object.hasNext()) {
                    SortSpec sortSpec = object.next();
                    if (!sortSpec.isUseIt()) continue;
                    stringBuffer.append(sortSpec.getAttributeName() + " ");
                    if (sortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!object.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY1>", stringBuffer.toString());
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY2>", stringBuffer.toString());
            object = "";
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                object = algorithmType == AlgorithmType.OCLUSTER ? CONFIDENCE_DBMS_API_RANGE_OC : CONFIDENCE_DBMS_API_RANGE_KM_EM;
            }
            if (string4.isEmpty()) {
                if (((String)object).isEmpty()) {
                    string3 = StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", "");
                } else {
                    object = " WHERE " + (String)object;
                    string3 = StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", (String)object);
                }
            } else {
                string3 = ((String)object).isEmpty() ? StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", "") : StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", (String)object);
            }
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n = 1;
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (algorithmType != AlgorithmType.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (algorithmType != AlgorithmType.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(n++, d);
                sQLHelper.pstmt.setDouble(n++, d2);
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (algorithmType != AlgorithmType.OCLUSTER) {
                sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getFetchSize());
            }
            sQLHelper.pstmt.execute();
            ClusterDetailsModelRow clusterDetailsModelRow = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string6 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                Double d3 = sQLHelper.rs.getDouble("ATTRIBUTE_SUPPORT");
                Double d4 = sQLHelper.rs.getDouble("ATTRIBUTE_CONFIDENCE");
                Double d5 = sQLHelper.rs.getDouble("MEAN");
                Double d6 = sQLHelper.rs.getDouble("VARIANCE");
                String string7 = sQLHelper.rs.getString("MODE_VALUE");
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                clusterDetailsModelRow = new ClusterDetailsModelRow(string5, string6, dmHistograms, d4, d3, d5, string7, d6);
                vector.add(clusterDetailsModelRow);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            theLogger.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
            throw outOfMemoryError;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Vector<ClusterDetailsModelRow> getModelAttributeDetails(Connection connection, String string, String string2, ClusteringFilterSetting clusteringFilterSetting, AlgorithmType algorithmType) throws Exception {
        assert (clusteringFilterSetting != null) : "Condition can not be null.";
        assert (clusteringFilterSetting.getClusterId() != null) : "Cluster id can not be null. Will cause join problems.";
        assert (clusteringFilterSetting.getClusterId() >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAILS_QUERY;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusterDetailsModelRow> vector = new Vector<ClusterDetailsModelRow>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<SortSpec> vector2 = null;
        Double d = clusteringFilterSetting.getMinConfidence() / 100.0;
        Double d2 = clusteringFilterSetting.getMaxConfidence() / 100.0;
        try {
            Object object;
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", KM_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", KM_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", KM_DBMS_API_3);
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", OC_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", OC_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", OC_DBMS_API_3);
            } else if (algorithmType == AlgorithmType.EMCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS1>", EM_DBMS_API_1);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS2>", EM_DBMS_API_2);
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS3>", EM_DBMS_API_3);
            }
            string3 = StringUtils.getReplacedString(string3, "<FETCH_SIZE>", clusteringFilterSetting.getFetchSize() + "");
            vector2 = clusteringFilterSetting.getSortSpecification();
            if (vector2 != null && vector2.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<SortSpec> iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!((SortSpec)object).isUseIt()) continue;
                    stringBuffer.append(((SortSpec)object).getAttributeName() + " ");
                    if (((SortSpec)object).isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY1>", stringBuffer.toString());
            string3 = StringUtils.getReplacedString(string3, "<ORDER_BY2>", stringBuffer.toString());
            string3 = clusteringFilterSetting.isUseFilterSpecification() ? StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", CONFIDENCE_DBMS_API_RANGE) : StringUtils.getReplacedString(string3, "<WHERE_CONFIDENCE>", "");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n = 1;
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n++, clusteringFilterSetting.getClusterId());
            if (clusteringFilterSetting.isUseFilterSpecification()) {
                sQLHelper.pstmt.setDouble(n++, d);
                sQLHelper.pstmt.setDouble(n++, d2);
            }
            sQLHelper.pstmt.setString(n++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n, clusteringFilterSetting.getClusterId());
            sQLHelper.pstmt.execute();
            object = null;
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string5 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                Double d3 = sQLHelper.rs.getDouble("ATTRIBUTE_SUPPORT");
                Double d4 = sQLHelper.rs.getDouble("ATTRIBUTE_CONFIDENCE");
                Double d5 = sQLHelper.rs.getDouble("MEAN");
                Double d6 = sQLHelper.rs.getDouble("VARIANCE");
                String string6 = sQLHelper.rs.getString("MODE_VALUE");
                DmHistograms dmHistograms = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                object = new ClusterDetailsModelRow(string4, string5, dmHistograms, d4, d3, d5, string6, d6);
                vector.add((ClusterDetailsModelRow)object);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            throw exception;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            theLogger.log(Level.SEVERE, outOfMemoryError.getMessage(), outOfMemoryError);
            throw outOfMemoryError;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    public Integer getTotalNumberOfModelAttributesKM(Connection connection, String string, String string2, Integer n) throws Exception {
        return this.getTotalNumberOfModelAttributes(connection, string, string2, n, AlgorithmType.KMEANS);
    }

    public Integer getTotalNumberOfModelAttributesOC(Connection connection, String string, String string2, Integer n) throws Exception {
        return this.getTotalNumberOfModelAttributes(connection, string, string2, n, AlgorithmType.OCLUSTER);
    }

    private Integer getTotalNumberOfModelAttributes(Connection connection, String string, String string2, int n, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        assert (n >= 1) : "Cluster id can not be zero or less than one. Will cause join problems.";
        String string3 = "with all_attributes AS\n  (SELECT b.attribute_name,\n    b.attribute_Subname   ,\n    NVL2(b.attribute_subname, b.attribute_name\n    || '.'\n    || b.attribute_subname, b.attribute_name) attribute_name_subname\n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b)\n select count(*)TOTAL_ATTRIBUTE_COUNT  from all_attributes\n";
        SQLHelper sQLHelper = new SQLHelper();
        Integer n2 = null;
        try {
            string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,?,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,?,NULL,1,0,0)");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n3 = 1;
            sQLHelper.pstmt.setString(n3++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.setInt(n3++, n);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            boolean bl = sQLHelper.rs.next();
            if (bl) {
                n2 = sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n2;
    }

    private HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerCluster(Connection connection, String string, String string2, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = " with all_attributes AS\n  (SELECT a.id ID \n     FROM TABLE(DBMS_DATA_MINING.<GET_MODEL_DETAILS>)a,\n     TABLE(a.centroid) b)\n select id, count(*)TOTAL_ATTRIBUTE_COUNT  from all_attributes\n group by id\n order by id";
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = null;
        Integer n2 = null;
        try {
            string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL)") : StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0)");
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n3 = 1;
            sQLHelper.pstmt.setString(n3++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                n2 = sQLHelper.rs.getInt("ID");
                n = sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT");
                hashMap.put(n2, n);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerClusterKM(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster(connection, string, string2, AlgorithmType.KMEANS);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterKM2(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster2(connection, string, string2, AlgorithmType.KMEANS);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterEM(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster2(connection, string, string2, AlgorithmType.EMCLUSTER);
    }

    public Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerClusterOC2(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster2(connection, string, string2, AlgorithmType.OCLUSTER);
    }

    public HashMap<Integer, Integer> getTotalNumberOfModelAttributesPerClusterOC(Connection connection, String string, String string2) throws Exception {
        return this.getTotalNumberOfModelAttributesPerCluster(connection, string, string2, AlgorithmType.OCLUSTER);
    }

    public void getCompareClusterDetailsKM(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector) throws Exception {
        this.getCompareClusterDetails(connection, string, string2, n, n2, n3, vector, AlgorithmType.KMEANS);
    }

    public void getCompareClusterDetailsOC(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector) throws Exception {
        this.getCompareClusterDetails(connection, string, string2, n, n2, n3, vector, AlgorithmType.OCLUSTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCompareClusterDetails(Connection connection, String string, String string2, int n, int n2, Integer n3, Vector<CompareClustersModelRow> vector, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = algorithmType == AlgorithmType.KMEANS ? StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM") : StringUtils.getReplacedString(_compare_sql, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
        HashMap<String, CompareClustersModelRow> hashMap = new HashMap<String, CompareClustersModelRow>();
        for (CompareClustersModelRow object : vector) {
            hashMap.put(object.getFullAttributeName(), object);
        }
        String string4 = Model.getCombinedUserNameModelName(string, string2, false);
        try {
            sQLHelper.pstmt = connection.prepareStatement(string3);
            sQLHelper.pstmt.setString(1, string4);
            sQLHelper.pstmt.setInt(2, n);
            sQLHelper.pstmt.setString(3, string4);
            sQLHelper.pstmt.setInt(4, n2);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("aname");
                String string6 = sQLHelper.rs.getString("subname");
                String string7 = sQLHelper.rs.getString("centroid1");
                String string8 = sQLHelper.rs.getString("centroid2");
                int n4 = sQLHelper.rs.getInt("rnk");
                double d = sQLHelper.rs.getDouble("sym_kld");
                String string9 = this.getFullAttributeName(string5, string6);
                CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)hashMap.get(string9);
                if (null == compareClustersModelRow) continue;
                compareClustersModelRow.setCentroid1(string7);
                compareClustersModelRow.setCentroid2(string8);
                compareClustersModelRow.setDivergence(d);
                compareClustersModelRow.setRank(n4);
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    private String getFullAttributeName(String string, String string2) {
        String string3 = string2 != null ? string + "." + string2 : string;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CompareClustersModelRow> getDivergence(Connection connection, String string, String string2, Integer n, String string3, Integer n2, String string4, int n3, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string5 = _DIVERGENCE_SQL;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<CompareClustersModelRow> vector = new Vector<CompareClustersModelRow>();
        try {
            if (algorithmType == AlgorithmType.KMEANS) {
                string5 = StringUtils.getReplacedString(string5, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,?,NULL, 0, 1, 0)");
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string5 = StringUtils.getReplacedString(string5, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,?,NULL, 0, 1, 0)");
            } else if (algorithmType == AlgorithmType.EMCLUSTER) {
                string5 = StringUtils.getReplacedString(string5, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_EM(?,?,NULL, 0, 1, 0)");
            }
            sQLHelper.pstmt = connection.prepareStatement(string5);
            String string6 = Model.getCombinedUserNameModelName(string, string2, false);
            sQLHelper.pstmt.setString(1, string6);
            if (n != null) {
                sQLHelper.pstmt.setInt(2, n);
            } else {
                sQLHelper.pstmt.setNull(2, 4);
            }
            sQLHelper.pstmt.setString(3, string6);
            if (n2 != null) {
                sQLHelper.pstmt.setInt(4, n2);
            } else {
                sQLHelper.pstmt.setNull(4, 4);
            }
            sQLHelper.pstmt.setInt(5, n3);
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string7 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string8 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                int n4 = sQLHelper.rs.getInt("rnk");
                double d = sQLHelper.rs.getDouble("sym_kld");
                CompareClustersModelRow compareClustersModelRow = new CompareClustersModelRow(string7, string8, n, n2);
                compareClustersModelRow.setCluster1Label1(string3);
                compareClustersModelRow.setCluster1Label2(string4);
                compareClustersModelRow.setRank(n4);
                compareClustersModelRow.setDivergence(d);
                vector.add(compareClustersModelRow);
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ClusteringDetailRowShort> getTotalNumberOfModelAttributesPerCluster2(Connection connection, String string, String string2, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = ALL_CLUSTERS_ATTRIBUTE_COUNT_QUERY_2;
        HashMap<String, ClusteringDetailRowShort> hashMap = new HashMap<String, ClusteringDetailRowShort>();
        SQLHelper sQLHelper = new SQLHelper();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        try {
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM(?,NULL,NULL,1,0,0,NULL)");
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC(?,NULL,NULL,1,0,0)");
            } else if (algorithmType == AlgorithmType.EMCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_EM(?,NULL,NULL,1,0,0,NULL)");
            }
            sQLHelper.pstmt = connection.prepareStatement(string3);
            int n5 = 1;
            sQLHelper.pstmt.setString(n5++, Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.pstmt.execute();
            sQLHelper.rs = sQLHelper.pstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                n2 = sQLHelper.rs.getInt("ID");
                int n6 = sQLHelper.rs.getInt("CLUSTER_PARENT");
                n3 = sQLHelper.rs.wasNull() ? null : Integer.valueOf(n6);
                n6 = sQLHelper.rs.getInt("CHILD_ID");
                n4 = sQLHelper.rs.wasNull() ? null : Integer.valueOf(n6);
                String string4 = sQLHelper.rs.getString("CLUSTER_ID");
                n = sQLHelper.rs.getInt("TOTAL_ATTRIBUTE_COUNT");
                ClusteringDetailRowShort clusteringDetailRowShort = (ClusteringDetailRowShort)hashMap.get(string4);
                ArrayList<Integer> arrayList = null;
                if (clusteringDetailRowShort == null) {
                    if (n4 != null) {
                        arrayList = new ArrayList<Integer>();
                        arrayList.add(n4);
                    }
                    clusteringDetailRowShort = new ClusteringDetailRowShort(n2, string4, n, n3, arrayList);
                    hashMap.put(string4, clusteringDetailRowShort);
                    continue;
                }
                if (n4 == null) continue;
                clusteringDetailRowShort.getChildren().add(n4);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCenteroidAndHistogram(Connection connection, String string, String string2, Integer n, Integer n2, List<CompareClustersModelRow> list, AlgorithmType algorithmType) throws Exception {
        Object object;
        Serializable serializable;
        String string3;
        SQLHelper sQLHelper = new SQLHelper();
        StringBuilder stringBuilder = null;
        if (algorithmType == AlgorithmType.KMEANS) {
            stringBuilder = new StringBuilder(_query_kmeans);
        } else if (algorithmType == AlgorithmType.OCLUSTER) {
            stringBuilder = new StringBuilder(_o_cluster);
        } else if (algorithmType == AlgorithmType.EMCLUSTER) {
            stringBuilder = new StringBuilder(_query_emcluster);
        }
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        int n3 = 0;
        for (CompareClustersModelRow object2 : list) {
            StringBuffer stringBuffer = new StringBuffer(object2.getName());
            string3 = null;
            if (algorithmType == AlgorithmType.KMEANS || algorithmType == AlgorithmType.EMCLUSTER) {
                string3 = object2.getSubName();
            }
            if (string3 != null) {
                stringBuffer.append(".");
                stringBuffer.append(string3);
            }
            serializable = new StringBuffer(StringUtils.addSingleQuotes(stringBuffer.toString()));
            if (n3 > 300 || arrayList.isEmpty()) {
                arrayList.add(new StringBuffer());
                n3 = 0;
            }
            if (((StringBuffer)(object = (StringBuffer)arrayList.get(arrayList.size() - 1))).length() > 0) {
                ((StringBuffer)object).append(",");
            }
            ((StringBuffer)object).append((StringBuffer)serializable);
            ++n3;
        }
        String string4 = Model.getCombinedUserNameModelName(string, string2, false);
        for (StringBuffer stringBuffer : arrayList) {
            string3 = StringUtils.getReplacedString(stringBuilder.toString(), "<list_of_columns>", stringBuffer.toString());
            serializable = new HashMap();
            for (CompareClustersModelRow compareClustersModelRow : list) {
                serializable.put(compareClustersModelRow.getFullAttributeName(), compareClustersModelRow);
            }
            try {
                sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
                sQLHelper.opstmt.setStringAtName("model_name", string4);
                sQLHelper.opstmt.setIntAtName("cluster_id1", n.intValue());
                if (n2 != null) {
                    sQLHelper.opstmt.setIntAtName("cluster_id2", n2.intValue());
                } else {
                    sQLHelper.opstmt.setNullAtName("cluster_id2", 4);
                }
                sQLHelper.opstmt.execute();
                sQLHelper.rs = sQLHelper.opstmt.getResultSet();
                while (sQLHelper.rs.next()) {
                    Object object2;
                    String string5 = sQLHelper.rs.getString("CLUSTER_ID");
                    String string6 = sQLHelper.rs.getString("ATTRIBUTE_NAME_SUBNAME");
                    String string7 = sQLHelper.rs.getString("CENTROID");
                    object = (DmHistograms)((OracleResultSet)sQLHelper.rs).getORAData("HISTOGRAM", DmHistograms.getORADataFactory());
                    DmHistogramBin[] dmHistogramBinArray = ((DmHistograms)object).getArray();
                    ArrayList<DmHistogramBin> arrayList2 = new ArrayList<DmHistogramBin>();
                    for (int i = 0; i < dmHistogramBinArray.length; ++i) {
                        Object object3 = object2 = dmHistogramBinArray[i].getAttributeSubname() != null ? dmHistogramBinArray[i].getAttributeName() + "." + dmHistogramBinArray[i].getAttributeSubname() : dmHistogramBinArray[i].getAttributeName();
                        if (!string6.equals(object2)) continue;
                        arrayList2.add(new DmHistogramBin(dmHistogramBinArray[i].getAttributeName(), dmHistogramBinArray[i].getAttributeSubname(), dmHistogramBinArray[i].getBinId(), dmHistogramBinArray[i].getLowerBound(), dmHistogramBinArray[i].getUpperBound(), dmHistogramBinArray[i].getLabel(), dmHistogramBinArray[i].getCount()));
                    }
                    dmHistogramBinArray = null;
                    DmHistograms dmHistograms = new DmHistograms();
                    dmHistograms.setArray(arrayList2.toArray(new DmHistogramBin[arrayList2.size()]));
                    object2 = (CompareClustersModelRow)serializable.get(string6);
                    if (null == object2) continue;
                    if (string5.equals(((CompareClustersModelRow)object2).getCluster1Label1())) {
                        ((CompareClustersModelRow)object2).setCentroid1(string7);
                        ((CompareClustersModelRow)object2).setFirstClusterHistogram(dmHistograms);
                        continue;
                    }
                    if (string5.equals(((CompareClustersModelRow)object2).getCluster1Label2())) {
                        ((CompareClustersModelRow)object2).setCentroid2(string7);
                        ((CompareClustersModelRow)object2).setSecondClusterHistogram(dmHistograms);
                        continue;
                    }
                    assert (false);
                }
            }
            finally {
                sQLHelper.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getModelDetailsComp(Connection connection, String string, String string2, int n, String string3, Map<Integer, List<ClusterComponentModelRow>> map, Vector<Integer> vector, Integer n2) throws SQLException {
        Object object;
        ArrayList<Object> arrayList;
        Map<String, Object> map2;
        Map<String, Double> map3;
        Object object2;
        Object object3;
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        String string4 = null;
        if (string3 != null && string3.length() > 0) {
            string4 = _get_model_details_comp_condition;
            object3 = StringUtils.isDoubleQuotedString(string3) ? string3 : string3.toUpperCase();
            string4 = StringUtils.getReplacedString(string4, "<where_conditon_name>", _where_conditon_name);
            string4 = StringUtils.getReplacedString(string4, "<pattern>", (String)object3);
        } else {
            string4 = _get_model_details_comp_no_condition;
            string4 = StringUtils.getReplacedString(string4, "<where_conditon_name>", "");
        }
        string4 = n2 != null ? StringUtils.getReplacedString(string4, "<component_condition>", _component_condition) : StringUtils.getReplacedString(string4, "<component_condition>", "");
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setIntAtName("fetch_size", n);
            if (n2 != null) {
                sQLHelper.opstmt.setIntAtName("component", n2.intValue());
            }
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            object3 = null;
            while (sQLHelper.rs.next()) {
                String object4 = sQLHelper.rs.getString("INFO_TYPE");
                int n3 = sQLHelper.rs.getInt("COMPONENT_ID");
                object3 = (ClusterComponentData)hashMap.get(n3);
                if (object3 == null) {
                    object3 = new ClusterComponentData(n3);
                    hashMap.put(n3, object3);
                    vector.add(n3);
                }
                if (object4.equals(_cluster)) {
                    int d = sQLHelper.rs.getInt("CLUSTER_ID");
                    ((ClusterComponentData)object3).setClusterId(d);
                    continue;
                }
                if (object4.equals(_prior)) {
                    Double d = sQLHelper.rs.getDouble("VALUE");
                    ((ClusterComponentData)object3).setPriorValue(d);
                    continue;
                }
                if (object4.equals(_mean)) {
                    Double string5 = sQLHelper.rs.getDouble("VALUE");
                    object2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    map3 = ((ClusterComponentData)object3).getMeanValues();
                    if (map3 == null) {
                        map3 = new HashMap<String, Double>();
                        ((ClusterComponentData)object3).setMeanValues(map3);
                    }
                    map3.put((String)object2, string5);
                    continue;
                }
                if (object4.equals(_covariance)) {
                    Double n5 = sQLHelper.rs.getDouble("VALUE");
                    object2 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    map3 = ((ClusterComponentData)object3).getCovarianceValues();
                    if (map3 == null) {
                        map3 = new HashMap<String, Double>();
                        ((ClusterComponentData)object3).setCovarianceValues(map3);
                    }
                    map3.put((String)object2, n5);
                    continue;
                }
                if (object4.equals(_frequency)) {
                    String string5 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                    object2 = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                    map3 = sQLHelper.rs.getDouble("VALUE");
                    map2 = ((ClusterComponentData)object3).getFrequencyValues();
                    if (map2 == null) {
                        map2 = new HashMap();
                        ((ClusterComponentData)object3).setFrequencyValues(map2);
                    }
                    if ((arrayList = (List)map2.get(string5)) == null) {
                        arrayList = new ArrayList<Object>();
                        map2.put(string5, arrayList);
                    }
                    object = new NameValuePair((String)object2, map3);
                    arrayList.add(object);
                    continue;
                }
                assert (false) : "this should never happen";
            }
        }
        finally {
            sQLHelper.close();
        }
        for (Integer n4 : vector) {
            Object object4;
            List<NameValuePair> list;
            ClusterComponentData clusterComponentData = (ClusterComponentData)hashMap.get(n4);
            Integer n5 = clusterComponentData.getClusterId();
            object2 = clusterComponentData.getPriorValue();
            map3 = clusterComponentData.getMeanValues();
            map2 = clusterComponentData.getCovarianceValues();
            arrayList = clusterComponentData.getFrequencyValues();
            object = new ArrayList();
            if (!arrayList.isEmpty()) {
                for (String string6 : arrayList.keySet()) {
                    list = arrayList.get(string6);
                    if (list == null || list.isEmpty()) continue;
                    object4 = new ClusterComponentModelRow(n4, n5, string6, (Double)object2);
                    ((ClusterComponentModelRow)object4).setFrequencyValues(list);
                    object.add(object4);
                }
            }
            if (!map3.isEmpty() && !map2.isEmpty()) {
                for (String string6 : map3.keySet()) {
                    list = (Double)map3.get(string6);
                    object4 = (Double)map2.get(string6);
                    if (list == null || object4 == null) continue;
                    ClusterComponentModelRow clusterComponentModelRow = new ClusterComponentModelRow(n4, n5, string6, (Double)object2);
                    clusterComponentModelRow.setMeanValue((Double)((Object)list));
                    clusterComponentModelRow.setCovarianceValue((Double)object4);
                    object.add(clusterComponentModelRow);
                }
            }
            map.put(n4, (List<ClusterComponentModelRow>)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEMModelAttributeName(Connection connection, String string, String string2, String string3) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string4 = null;
        String string5 = _get_model_details_proj_attr_name;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string5);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("feature_name", string3);
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            if (sQLHelper.rs.next()) {
                string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
            }
        }
        finally {
            sQLHelper.close();
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClusterComponentProjectionItem> getModelDetailsProjDetails(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        ArrayList<ClusterComponentProjectionItem> arrayList = new ArrayList<ClusterComponentProjectionItem>();
        String string5 = _get_model_details_proj_details;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string5);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("feature_name", string4);
            sQLHelper.opstmt.setStringAtName("attribute_name", string3);
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string6 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                String string7 = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                Double d = sQLHelper.rs.getDouble("COEFFICIENT");
                ClusterComponentProjectionItem clusterComponentProjectionItem = new ClusterComponentProjectionItem();
                clusterComponentProjectionItem.setFeatureName(string4);
                clusterComponentProjectionItem.setAttributName(string3);
                clusterComponentProjectionItem.setAttributeSubname(string6);
                if (string7 != null) {
                    clusterComponentProjectionItem.setAttributeValue(string7);
                }
                clusterComponentProjectionItem.setCoefficient(d);
                arrayList.add(clusterComponentProjectionItem);
            }
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Map<String, List<ClusterComponentProjectionItem>>> getModelDetailsProj(Connection connection, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<String, Map<String, List<ClusterComponentProjectionItem>>> hashMap = new HashMap<String, Map<String, List<ClusterComponentProjectionItem>>>();
        String string3 = _get_model_details_proj;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                ArrayList<ClusterComponentProjectionItem> arrayList;
                String string4 = sQLHelper.rs.getString("FEATURE_NAME");
                String string5 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                String string6 = sQLHelper.rs.getString("ATTRIBUTE_SUBNAME");
                String string7 = sQLHelper.rs.getString("ATTRIBUTE_VALUE");
                Double d = sQLHelper.rs.getDouble("COEFFICIENT");
                ClusterComponentProjectionItem clusterComponentProjectionItem = new ClusterComponentProjectionItem();
                clusterComponentProjectionItem.setFeatureName(string4);
                clusterComponentProjectionItem.setAttributName(string5);
                clusterComponentProjectionItem.setAttributeSubname(string6);
                if (string7 != null) {
                    clusterComponentProjectionItem.setAttributeValue(string7);
                }
                clusterComponentProjectionItem.setCoefficient(d);
                HashMap<String, ArrayList<ClusterComponentProjectionItem>> hashMap2 = (HashMap<String, ArrayList<ClusterComponentProjectionItem>>)hashMap.get(string5);
                if (null == hashMap2) {
                    hashMap2 = new HashMap<String, ArrayList<ClusterComponentProjectionItem>>();
                    hashMap.put(string5, hashMap2);
                }
                if ((arrayList = (ArrayList<ClusterComponentProjectionItem>)hashMap2.get(string4)) == null) {
                    arrayList = new ArrayList<ClusterComponentProjectionItem>();
                    hashMap2.put(string4, arrayList);
                }
                arrayList.add(clusterComponentProjectionItem);
            }
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getModelDetailsGlobal(Connection connection, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string3 = _get_model_details_global;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(GLOBAL_DETAIL_NAME);
                if (string4.equals(NUM_COMPONENTS)) {
                    int n = sQLHelper.rs.getInt(GLOBAL_DETAIL_VALUE);
                    hashMap.put(NUM_COMPONENTS, n);
                    continue;
                }
                if (string4.equals(NUM_CLUSTERS)) {
                    int n = sQLHelper.rs.getInt(GLOBAL_DETAIL_VALUE);
                    hashMap.put(NUM_CLUSTERS, n);
                    continue;
                }
                if (!string4.equals(LOGLIKELIHOOD)) continue;
                double d = sQLHelper.rs.getDouble(GLOBAL_DETAIL_VALUE);
                hashMap.put(LOGLIKELIHOOD, d);
            }
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public static boolean isModelEmpty(Connection connection, String string, String string2) throws SQLException {
        Map<String, Object> map = ClusteringDetailsImpl.getModelDetailsGlobal(connection, string, string2);
        Integer n = (Integer)map.get("NUM_COMPONENTS");
        if (n == null) {
            return true;
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<ClusteringDetailRow> getClusterAllDetailsTopN_Db12(Connection connection, String string, String string2, int n, AlgorithmType algorithmType) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAIL_QUERY_TOPN_2;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        try {
            if (algorithmType == AlgorithmType.KMEANS) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_KM");
                string3 = StringUtils.getReplacedString(string3, "<ATTRIBUTE_SUBNAME>", ":attributesubname,");
            } else if (algorithmType == AlgorithmType.EMCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_EM");
                string3 = StringUtils.getReplacedString(string3, "<ATTRIBUTE_SUBNAME>", ":attributesubname,");
            } else if (algorithmType == AlgorithmType.OCLUSTER) {
                string3 = StringUtils.getReplacedString(string3, "<GET_MODEL_DETAILS>", "GET_MODEL_DETAILS_OC");
                string3 = StringUtils.getReplacedString(string3, "<ATTRIBUTE_SUBNAME>", "");
            }
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("modelname", Model.getCombinedUserNameModelName(string, string2, false));
            if (algorithmType != AlgorithmType.OCLUSTER) {
                sQLHelper.opstmt.setNullAtName("attributesubname", 12);
            }
            sQLHelper.opstmt.setIntAtName("topn", n);
            sQLHelper.opstmt.execute();
            ClusteringDetailRow clusteringDetailRow = null;
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Integer n2 = sQLHelper.rs.getInt("ID");
                String string4 = sQLHelper.rs.getString("CLUSTER_ID");
                Integer n3 = sQLHelper.rs.getInt("RECORD_COUNT");
                Integer n4 = sQLHelper.rs.getInt("PARENT");
                Integer n5 = sQLHelper.rs.getInt("TREE_LEVEL");
                Double d = sQLHelper.rs.getDouble("DISPERSION");
                DmPredicates dmPredicates = (DmPredicates)((OracleResultSet)sQLHelper.rs).getORAData("SPLIT_PREDICATE", DmPredicates.getORADataFactory());
                DmChildren dmChildren = (DmChildren)((OracleResultSet)sQLHelper.rs).getORAData("CHILD", DmChildren.getORADataFactory());
                DmCentroids dmCentroids = (DmCentroids)((OracleResultSet)sQLHelper.rs).getORAData("CENTROID", DmCentroids.getORADataFactory());
                DmRule dmRule = (DmRule)((OracleResultSet)sQLHelper.rs).getORAData("RULE", DmRule.getORADataFactory());
                clusteringDetailRow = new ClusteringDetailRow(n2, string4, n3, n4, n5, d, dmPredicates, dmChildren, dmCentroids, null, dmRule);
                vector.add(clusteringDetailRow);
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ClusteringDetailRow> getClusterAllDetailsNoStatsModel(Connection connection, String string, String string2) throws Exception {
        assert (string2 != null) : "Model name can not be null";
        assert (string != null) : "User name can not be null";
        assert (connection != null) : "Connection can not be null";
        String string3 = CLUSTER_DETAIL_QUERY_TOPN_NO_STATS_MODEL;
        SQLHelper sQLHelper = new SQLHelper();
        Vector<ClusteringDetailRow> vector = new Vector<ClusteringDetailRow>();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("modelname", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.execute();
            ClusteringDetailRow clusteringDetailRow = null;
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt("ID");
                String string4 = sQLHelper.rs.getString("CLUSTER_ID");
                Integer n2 = sQLHelper.rs.getInt("RECORD_COUNT");
                Integer n3 = sQLHelper.rs.getInt("PARENT");
                Integer n4 = sQLHelper.rs.getInt("TREE_LEVEL");
                DmChildren dmChildren = (DmChildren)((OracleResultSet)sQLHelper.rs).getORAData("CHILD", DmChildren.getORADataFactory());
                clusteringDetailRow = new ClusteringDetailRow(n, string4, n2, n3, n4, null, null, dmChildren, null, null, null);
                vector.add(clusteringDetailRow);
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getEMModelProjectionFeatureNameMap(Connection connection, String string, String string2, int n) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = null;
        String string4 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string5 = _get_model_details_proj_names_counts;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string5);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setIntAtName("fetch_size", n);
            sQLHelper.opstmt.execute();
            sQLHelper.rs = sQLHelper.opstmt.getResultSet();
            while (sQLHelper.rs.next()) {
                string3 = sQLHelper.rs.getString("FEATURE_NAME");
                string4 = sQLHelper.rs.getString("ATTRIBUTE_NAME");
                hashMap.put(string3, string4);
            }
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public static class ODM_DM_CLUSTER_COMPARE {
        public static final String ATTRIBUTE_NAME = "aname";
        public static final String ATTRIBUTE_SUBNAME = "subname";
        public static final String CENTROID1 = "centroid1";
        public static final String CENTROID2 = "centroid2";
        public static final String RANK = "rnk";
        public static final String DIVERGENCE = "sym_kld";
    }

    public static class ODM_DM_CLUSTER_ATTRIBUTES {
        public static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
        public static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
        public static final String ATTRIBUTE_SUPPORT = "ATTRIBUTE_SUPPORT";
        public static final String ATTRIBUTE_CONFIDENCE = "ATTRIBUTE_CONFIDENCE";
        public static final String MEAN = "MEAN";
        public static final String MODE_VALUE = "MODE_VALUE";
        public static final String VARIANCE = "VARIANCE";
        public static final String HISTOGRAM = "HISTOGRAM";
    }

    public static class ODM_DM_CLUSTERS {
        public static final String ID = "ID";
        public static final String CLUSTER_ID = "CLUSTER_ID";
        public static final String RECORD_COUNT = "RECORD_COUNT";
        public static final String PARENT = "PARENT";
        public static final String TREE_LEVEL = "TREE_LEVEL";
        public static final String DISPERSION = "DISPERSION";
        public static final String SPLIT_PREDICATE = "SPLIT_PREDICATE";
        public static final String CHILD = "CHILD";
        public static final String CENTROID = "CENTROID";
        public static final String HISTOGRAM = "HISTOGRAM";
        public static final String RULE = "RULE";
    }

    private static enum AlgorithmType {
        KMEANS,
        OCLUSTER,
        EMCLUSTER;

    }
}

