/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.io.Reader;
import java.sql.Connection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.dmt.dataminer.mviewer.dt.schema.PMML;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.ModelGeneralDescription;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.sql.CLOB;

public class DecisionTree
extends Classification {
    private static JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private PMML root;
    private final String GET_DT_MODEL_XML_SQL = "DECLARE   xml_result XMLTYPE;  clob_val   CLOB;   xml_string VARCHAR2(32627);BEGIN  xml_result := DBMS_DATA_MINING.GET_MODEL_DETAILS_XML (?);  clob_val := xml_result.getClobVal();   ? := clob_val;END;";

    public DecisionTree(String string, String string2) {
        super(string, string2);
    }

    public PMML getRootObject() {
        return this.root;
    }

    @Override
    public void load(Connection connection) throws Exception {
        super.load(connection);
        if (this.getModelGeneralDescription().equals(ModelGeneralDescription._NONE)) {
            return;
        }
        SQLHelper sQLHelper = new SQLHelper();
        sQLHelper.cstmt = connection.prepareCall("DECLARE   xml_result XMLTYPE;  clob_val   CLOB;   xml_string VARCHAR2(32627);BEGIN  xml_result := DBMS_DATA_MINING.GET_MODEL_DETAILS_XML (?);  clob_val := xml_result.getClobVal();   ? := clob_val;END;");
        sQLHelper.cstmt.setString(1, "\"" + this.getUserName() + "\".\"" + this.getModelName() + "\"");
        sQLHelper.cstmt.registerOutParameter(2, 2005);
        sQLHelper.cstmt.execute();
        CLOB cLOB = (CLOB)sQLHelper.cstmt.getClob(2);
        Reader reader = cLOB.getCharacterStream();
        Unmarshaller unmarshaller = DecisionTree.createUnmarshaller();
        this.root = (PMML)unmarshaller.unmarshal(reader);
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        unmarshaller = DecisionTree.getJAXBContextInstance().createUnmarshaller();
        return unmarshaller;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        marshaller = DecisionTree.getJAXBContextInstance().createMarshaller();
        return marshaller;
    }

    public static JAXBContext getJAXBContextInstance() throws JAXBException {
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((String)"oracle.dmt.dataminer.mviewer.dt.schema");
        }
        return jaxbContext;
    }
}

