/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dataminer.server.ServerConstants;
import oracle.dmt.dataminer.server.model.ModelLrb;

public class MiningModelSettings {
    String _owner;
    String _modelName;
    String _settingName;
    String _settingValue;
    String _settingType;

    public void setSettingValue(String string) {
        this._settingValue = string;
    }

    public void setSettingType(String string) {
        this._settingType = string;
    }

    public String getSettingType() {
        return this._settingType;
    }

    public static String translateModelSettingsName(String string) {
        return (String)ALL_MINING_MODEL_SETTINGS._SETTING_NAMES.get(string);
    }

    public static boolean filterOutSettings(String string) {
        return string.compareTo("CLAS_WEIGHTS_TABLE_NAME") == 0 || string.compareTo("CLAS_PRIORS_TABLE_NAME") == 0 || string.compareTo("CLAS_COST_TABLE_NAME") == 0;
    }

    public static String translateModelSettingsValue(String string) {
        String string2 = (String)ALL_MINING_MODEL_SETTINGS._SETTING_VALUES.get(string);
        if (string2 == null) {
            string2 = ServerConstants.Algorithm.getUIAlgorithmName(string);
        }
        return string2;
    }

    public MiningModelSettings(String string, String string2, String string3, String string4, String string5) {
        this._owner = string;
        this._modelName = string2;
        this._settingName = string3;
        this._settingValue = string4;
        this._settingType = string5;
    }

    public static MiningModelSettings findSetting(String string, Vector<MiningModelSettings> vector) {
        MiningModelSettings miningModelSettings = null;
        for (MiningModelSettings miningModelSettings2 : vector) {
            if (!miningModelSettings2._settingName.equals(string)) continue;
            miningModelSettings = miningModelSettings2;
            break;
        }
        return miningModelSettings;
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    public String getOwner() {
        return this._owner;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public String getModelName() {
        return this._modelName;
    }

    public void setSettingName(String string) {
        this._settingName = string;
    }

    public String getSettingName() {
        return this._settingName;
    }

    public String getSettingValue() {
        return this._settingValue;
    }

    public static class ALL_MINING_MODEL_SETTINGS {
        private static Hashtable<String, String> _SETTING_VALUES = new Hashtable();
        private static Hashtable<String, String> _SETTING_NAMES;
        public static final String CLAS_WEIGHTS_TABLE_NAME = "CLAS_WEIGHTS_TABLE_NAME";
        public static final String CLAS_PRIORS_TABLE_NAME = "CLAS_PRIORS_TABLE_NAME";
        public static final String CLAS_COST_TABLE_NAME = "CLAS_COST_TABLE_NAME";
        public static final String IMBEDDED_SCORING_COST_MATRIX_NAME = "IMBEDDED_SCORING_COST_MATRIX";
        public static final String IMBEDDED_SCORING_COST_MATRIX_TRUE = "TRUE";
        public static final String SETTING_TYPE_INPUT = "INPUT";

        static {
            _SETTING_VALUES.put("SVMS_GAUSSIAN", ModelLrb.get("SVMS_GAUSSIAN"));
            _SETTING_VALUES.put("SVMS_LINEAR", ModelLrb.get("SVMS_LINEAR"));
            _SETTING_VALUES.put("SVMS_AL_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("SVMS_AL_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("PREP_AUTO_OFF", ModelLrb.get("PREP_AUTO_OFF"));
            _SETTING_VALUES.put("PREP_AUTO_ON", ModelLrb.get("PREP_AUTO_ON"));
            _SETTING_VALUES.put("ON", ModelLrb.get("ON"));
            _SETTING_VALUES.put("OFF", ModelLrb.get("OFF"));
            _SETTING_VALUES.put("TREE_IMPURITY_ENTROPY", ModelLrb.get("TREE_IMPURITY_ENTROPY"));
            _SETTING_VALUES.put("TREE_IMPURITY_GINI", ModelLrb.get("TREE_IMPURITY_GINI"));
            _SETTING_VALUES.put("ODMS_MISSING_VALUE_MEAN_MODE", ModelLrb.get("ODMS_MISSING_VALUE_MEAN_MODE"));
            _SETTING_VALUES.put("ODMS_MISSING_VALUE_DELETE_ROW", ModelLrb.get("ODMS_MISSING_VALUE_DELETE_ROW"));
            _SETTING_VALUES.put("GLMS_RIDGE_REG_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_RIDGE_REG_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_VIF_RIDGE_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_VIF_RIDGE_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("EMCS_ATTR_FILTER_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("EMCS_ATTR_FILTER_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("EMCS_CLUSTER_COMP_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("EMCS_CLUSTER_COMP_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("EMCS_CLUS_STATS_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("EMCS_CLUS_STATS_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("EMCS_NUM_DISTR_BERNOULLI", ModelLrb.get("EMCS_NUM_DISTR_BERNOULLI"));
            _SETTING_VALUES.put("EMCS_NUM_DISTR_GAUSSIAN", ModelLrb.get("EMCS_NUM_DISTR_GAUSSIAN"));
            _SETTING_VALUES.put("EMCS_NUM_DISTR_SYSTEM", ModelLrb.get("MODEL_SETTING_SYSTEM_DETERMINED"));
            _SETTING_VALUES.put("EMCS_CONV_CRIT_HELDASIDE", ModelLrb.get("EMCS_CONV_CRIT_HELDASIDE"));
            _SETTING_VALUES.put("EMCS_CONV_CRIT_BIC", ModelLrb.get("EMCS_CONV_CRIT_BIC"));
            _SETTING_VALUES.put("EMCS_LINKAGE_SINGLE", ModelLrb.get("EMCS_LINKAGE_SINGLE"));
            _SETTING_VALUES.put("EMCS_LINKAGE_AVERAGE", ModelLrb.get("EMCS_LINKAGE_AVERAGE"));
            _SETTING_VALUES.put("EMCS_LINKAGE_COMPLETE", ModelLrb.get("EMCS_LINKAGE_COMPLETE"));
            _SETTING_VALUES.put("GLMS_PRUNE_MODEL_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_PRUNE_MODEL_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_SELECT_BLOCK_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_SELECT_BLOCK_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_FTR_ACCEPTANCE_STRICT", ModelLrb.get("GLMS_FTR_ACCEPTANCE_STRICT"));
            _SETTING_VALUES.put("GLMS_FTR_ACCEPTANCE_RELAXED", ModelLrb.get("GLMS_FTR_ACCEPTANCE_RELAXED"));
            _SETTING_VALUES.put("GLMS_FTR_SEL_AIC", ModelLrb.get("GLMS_FTR_SEL_AIC"));
            _SETTING_VALUES.put("GLMS_FTR_SEL_SBIC", ModelLrb.get("GLMS_FTR_SEL_SBIC"));
            _SETTING_VALUES.put("GLMS_FTR_SEL_RIC", ModelLrb.get("GLMS_FTR_SEL_RIC"));
            _SETTING_VALUES.put("GLMS_FTR_SEL_ALPHA_INV", ModelLrb.get("GLMS_FTR_SEL_ALPHA_INV"));
            _SETTING_VALUES.put("ODMS_APPR_COMP_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("ODMS_APPR_COMP_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_FTR_GENERATION_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_FTR_GENERATION_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_FTR_SELECTION_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("GLMS_FTR_SELECTION_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_VALUES.put("GLMS_FTR_GEN_QUADRATIC", ModelLrb.get("GLMS_FTR_GEN_QUADRATIC"));
            _SETTING_VALUES.put("GLMS_FTR_GEN_CUBIC", ModelLrb.get("GLMS_FTR_GEN_CUBIC"));
            _SETTING_VALUES.put("SVDS_SCORING_SVD", ModelLrb.get("SVDS_SCORING_SVD"));
            _SETTING_VALUES.put("SVDS_SCORING_PCA", ModelLrb.get("SVDS_SCORING_PCA"));
            _SETTING_VALUES.put("SVDS_U_MATRIX_ENABLE", ModelLrb.get("MODEL_SETTING_ENABLE"));
            _SETTING_VALUES.put("SVDS_U_MATRIX_DISABLE", ModelLrb.get("MODEL_SETTING_DISABLE"));
            _SETTING_NAMES = new Hashtable();
            _SETTING_NAMES.put("ALGO_NAME", ModelLrb.get("ALGO_NAME"));
            _SETTING_NAMES.put("SVMS_KERNEL_FUNCTION", ModelLrb.get("SVMS_KERNEL_FUNCTION"));
            _SETTING_NAMES.put("SVMS_CONV_TOLERANCE", ModelLrb.get("SVMS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("SVMS_ACTIVE_LEARNING", ModelLrb.get("SVMS_ACTIVE_LEARNING"));
            _SETTING_NAMES.put("SVMS_COMPLEXITY_FACTOR", ModelLrb.get("SVMS_COMPLEXITY_FACTOR"));
            _SETTING_NAMES.put("SVMS_STD_DEV", ModelLrb.get("SVMS_STD_DEV"));
            _SETTING_NAMES.put("SVMS_KERNEL_CACHE_SIZE", ModelLrb.get("SVMS_KERNEL_CACHE_SIZE"));
            _SETTING_NAMES.put("NABS_PAIRWISE_THRESHOLD", ModelLrb.get("NABS_PAIRWISE_THRESHOLD"));
            _SETTING_NAMES.put("GLMS_CONF_LEVEL", ModelLrb.get("GLMS_CONF_LEVEL"));
            _SETTING_NAMES.put("GLMS_RIDGE_VALUE", ModelLrb.get("GLMS_RIDGE_VALUE"));
            _SETTING_NAMES.put("GLMS_DIAGNOSTICS_TABLE_NAME", ModelLrb.get("GLMS_DIAGNOSTICS_TABLE_NAME"));
            _SETTING_NAMES.put("PREP_AUTO", ModelLrb.get("PREP_AUTO"));
            _SETTING_NAMES.put("TREE_IMPURITY_METRIC", ModelLrb.get("TREE_IMPURITY_METRIC"));
            _SETTING_NAMES.put("ODMS_MISSING_VALUE_TREATMENT", ModelLrb.get("ODMS_MISSING_VALUE_TREATMENT"));
            _SETTING_NAMES.put("ODMS_ROW_WEIGHT_COLUMN_NAME", ModelLrb.get("ODMS_ROW_WEIGHT_COLUMN_NAME"));
            _SETTING_NAMES.put("TREE_TERM_MINREC_SPLIT", ModelLrb.get("TREE_TERM_MINREC_SPLIT"));
            _SETTING_NAMES.put("TREE_TERM_MINPCT_SPLIT", ModelLrb.get("TREE_TERM_MINPCT_SPLIT"));
            _SETTING_NAMES.put("GLMS_RIDGE_REGRESSION", ModelLrb.get("GLMS_RIDGE_REGRESSION"));
            _SETTING_NAMES.put("TREE_TERM_MINREC_NODE", ModelLrb.get("TREE_TERM_MINREC_NODE"));
            _SETTING_NAMES.put("NABS_SINGLETON_THRESHOLD", ModelLrb.get("NABS_SINGLETON_THRESHOLD"));
            _SETTING_NAMES.put("GLMS_VIF_FOR_RIDGE", ModelLrb.get("GLMS_VIF_FOR_RIDGE"));
            _SETTING_NAMES.put("GLMS_REFERENCE_CLASS_NAME", ModelLrb.get("GLMS_REFERENCE_CLASS_NAME"));
            _SETTING_NAMES.put("TREE_TERM_MAX_DEPTH", ModelLrb.get("TREE_TERM_MAX_DEPTH"));
            _SETTING_NAMES.put("ASSO_MAX_RULE_LENGTH", ModelLrb.get("ASSO_MAX_RULE_LENGTH"));
            _SETTING_NAMES.put("ASSO_MIN_SUPPORT", ModelLrb.get("ASSO_MIN_SUPPORT"));
            _SETTING_NAMES.put("ASSO_MIN_CONFIDENCE", ModelLrb.get("ASSO_MIN_CONFIDENCE"));
            _SETTING_NAMES.put("FEAT_NUM_FEATURES", ModelLrb.get("FEAT_NUM_FEATURES"));
            _SETTING_NAMES.put("NMFS_CONV_TOLERANCE", ModelLrb.get("NMFS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("NMFS_NUM_ITERATIONS", ModelLrb.get("NMFS_NUM_ITERATIONS"));
            _SETTING_NAMES.put("NMFS_RANDOM_SEED", ModelLrb.get("NMFS_RANDOM_SEED"));
            _SETTING_NAMES.put("GLMS_PRUNE_MODEL", ModelLrb.get("GLMS_PRUNE_MODEL"));
            _SETTING_NAMES.put("GLMS_MAX_FEATURES", ModelLrb.get("GLMS_MAX_FEATURES"));
            _SETTING_NAMES.put("GLMS_FTR_GENERATION", ModelLrb.get("GLMS_FTR_GENERATION"));
            _SETTING_NAMES.put("GLMS_FTR_ACCEPTANCE", ModelLrb.get("GLMS_FTR_ACCEPTANCE"));
            _SETTING_NAMES.put("GLMS_SELECT_BLOCK", ModelLrb.get("GLMS_SELECT_BLOCK"));
            _SETTING_NAMES.put("GLMS_FTR_SEL_CRIT", ModelLrb.get("GLMS_FTR_SEL_CRIT"));
            _SETTING_NAMES.put("GLMS_FTR_SELECTION", ModelLrb.get("GLMS_FTR_SELECTION"));
            _SETTING_NAMES.put("GLMS_FTR_GEN_METHOD", ModelLrb.get("GLMS_FTR_GEN_METHOD"));
            _SETTING_NAMES.put("KMNS_BLOCK_GROWTH", ModelLrb.get("KMNS_BLOCK_GROWTH"));
            _SETTING_NAMES.put("CLUS_NUM_CLUSTERS", ModelLrb.get("CLUS_NUM_CLUSTERS"));
            _SETTING_NAMES.put("KMNS_NUM_BINS", ModelLrb.get("KMNS_NUM_BINS"));
            _SETTING_NAMES.put("KMNS_CONV_TOLERANCE", ModelLrb.get("KMNS_CONV_TOLERANCE"));
            _SETTING_NAMES.put("KMNS_MIN_PCT_ATTR_SUPPORT", ModelLrb.get("KMNS_MIN_PCT_ATTR_SUPPORT"));
            _SETTING_NAMES.put("KMNS_DISTANCE", ModelLrb.get("KMNS_DISTANCE"));
            _SETTING_NAMES.put("KMNS_SPLIT_CRITERION", ModelLrb.get("KMNS_SPLIT_CRITERION"));
            _SETTING_NAMES.put("KMNS_ITERATIONS", ModelLrb.get("KMNS_ITERATIONS"));
            _SETTING_NAMES.put("OCLT_SENSITIVITY", ModelLrb.get("OCLT_SENSITIVITY"));
            _SETTING_NAMES.put("OCLT_MAX_BUFFER", ModelLrb.get("OCLT_MAX_BUFFER"));
            _SETTING_NAMES.put("EMCS_NUM_COMPONENTS", ModelLrb.get("EMCS_NUM_COMPONENTS"));
            _SETTING_NAMES.put("EMCS_NUM_PROJECTIONS", ModelLrb.get("EMCS_NUM_PROJECTIONS"));
            _SETTING_NAMES.put("EMCS_LINKAGE_FUNCTION", ModelLrb.get("EMCS_LINKAGE_FUNCTION"));
            _SETTING_NAMES.put("EMCS_CONVERGENCE_CRITERION", ModelLrb.get("EMCS_CONVERGENCE_CRITERION"));
            _SETTING_NAMES.put("EMCS_MAX_NUM_ATTR_2D", ModelLrb.get("EMCS_MAX_NUM_ATTR_2D"));
            _SETTING_NAMES.put("EMCS_ATTRIBUTE_FILTER", ModelLrb.get("EMCS_ATTRIBUTE_FILTER"));
            _SETTING_NAMES.put("EMCS_CLUSTER_COMPONENTS", ModelLrb.get("EMCS_CLUSTER_COMPONENTS"));
            _SETTING_NAMES.put("EMCS_CLUSTER_THRESH", ModelLrb.get("EMCS_CLUSTER_THRESH"));
            _SETTING_NAMES.put("EMCS_MIN_PCT_ATTR_SUPPORT", ModelLrb.get("EMCS_MIN_PCT_ATTR_SUPPORT"));
            _SETTING_NAMES.put("EMCS_NUM_DISTRIBUTION", ModelLrb.get("EMCS_NUM_DISTRIBUTION"));
            _SETTING_NAMES.put("EMCS_NUM_EQUIWIDTH_BINS", ModelLrb.get("EMCS_NUM_EQUIWIDTH_BINS"));
            _SETTING_NAMES.put("EMCS_NUM_QUANTILE_BINS", ModelLrb.get("EMCS_NUM_QUANTILE_BINS"));
            _SETTING_NAMES.put("ODMS_APPROXIMATE_COMPUTATION", ModelLrb.get("ODMS_APPROXIMATE_COMPUTATION"));
            _SETTING_NAMES.put("EMCS_CLUSTER_STATISTICS", ModelLrb.get("EMCS_CLUSTER_STATISTICS"));
            _SETTING_NAMES.put("EMCS_LOGLIKE_IMPROVEMENT", ModelLrb.get("EMCS_LOGLIKE_IMPROVEMENT"));
            _SETTING_NAMES.put("EMCS_NUM_ITERATIONS", ModelLrb.get("EMCS_NUM_ITERATIONS"));
            _SETTING_NAMES.put("EMCS_NUM_TOPN_BINS", ModelLrb.get("EMCS_NUM_TOPN_BINS"));
            _SETTING_NAMES.put("SVDS_SCORING_MODE", ModelLrb.get("SVDS_SCORING_MODE"));
            _SETTING_NAMES.put("SVDS_U_MATRIX_OUTPUT", ModelLrb.get("SVDS_U_MATRIX_OUTPUT"));
            _SETTING_NAMES.put("TREE_TERM_MINPCT_NODE", ModelLrb.get("TREE_TERM_MINPCT_NODE"));
        }
    }
}

