/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmPredicate;
import oracle.dmt.dataminer.generated.server.DmPredicates;
import oracle.dmt.dataminer.server.model.RuleContentOption;
import oracle.dmt.dataminer.utils.NumericFormat;

public class PredicateRowData {
    private String _attribute_name;
    private String _attribute_subname;
    private String _conditional_operator;
    private Double _attribute_num_value;
    private String _attribute_str_value;
    private Double _attribute_support;
    private Double _attribute_confidence;

    public PredicateRowData() {
        this._attribute_name = "";
        this._attribute_subname = "";
        this._conditional_operator = "";
        this._attribute_num_value = 0.0;
        this._attribute_str_value = "";
        this._attribute_support = 0.0;
        this._attribute_confidence = 0.0;
    }

    public PredicateRowData(String string, String string2, String string3, Double d, String string4, Double d2, Double d3) {
        this._attribute_name = string;
        this._attribute_subname = string2;
        this._conditional_operator = string3;
        this._attribute_num_value = d;
        this._attribute_str_value = string4;
        this._attribute_support = d2;
        this._attribute_confidence = d3;
    }

    public PredicateRowData(DmPredicate dmPredicate) throws Exception {
        this._attribute_name = dmPredicate.getAttributeName();
        this._attribute_subname = dmPredicate.getAttributeSubname() != null ? dmPredicate.getAttributeSubname() : null;
        this._conditional_operator = dmPredicate.getConditionalOperator();
        this._attribute_num_value = dmPredicate.getAttributeNumValue() != null ? Double.valueOf(dmPredicate.getAttributeNumValue().doubleValue()) : null;
        this._attribute_str_value = dmPredicate.getAttributeStrValue() != null ? dmPredicate.getAttributeStrValue() : null;
        this._attribute_support = dmPredicate.getAttributeSupport() != null ? Double.valueOf(dmPredicate.getAttributeSupport().doubleValue()) : null;
        this._attribute_confidence = dmPredicate.getAttributeConfidence() != null ? Double.valueOf(dmPredicate.getAttributeConfidence().doubleValue()) : null;
    }

    public static Vector<PredicateRowData> createPredicatesFromDmPredicates(DmPredicates dmPredicates) throws Exception {
        Vector<PredicateRowData> vector = new Vector<PredicateRowData>();
        for (int i = 0; i < dmPredicates.length(); ++i) {
            DmPredicate dmPredicate = dmPredicates.getElement(i);
            PredicateRowData predicateRowData = new PredicateRowData(dmPredicate);
            vector.add(predicateRowData);
        }
        return vector;
    }

    public void setAttribute_name(String string) {
        this._attribute_name = string;
    }

    public String getAttribute_name() {
        return this._attribute_name;
    }

    public void setAttribute_subname(String string) {
        this._attribute_subname = string;
    }

    public String getAttribute_subname() {
        return this._attribute_subname;
    }

    public void setConditional_operator(String string) {
        this._conditional_operator = string;
    }

    public String getConditional_operator() {
        return this._conditional_operator;
    }

    public void setAttribute_num_value(Double d) {
        this._attribute_num_value = d;
    }

    public Double getAttribute_num_value() {
        return this._attribute_num_value;
    }

    public void setAttribute_str_value(String string) {
        this._attribute_str_value = string;
    }

    public String getAttribute_str_value() {
        return this._attribute_str_value;
    }

    public void setAttribute_support(Double d) {
        this._attribute_support = d;
    }

    public Double getAttribute_support() {
        return this._attribute_support;
    }

    public void setAttribute_confidence(Double d) {
        this._attribute_confidence = d;
    }

    public Double getAttribute_confidence() {
        return this._attribute_confidence;
    }

    public String getFullAttributeName() {
        return this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY);
    }

    public String getFullAttributeName(NameContent nameContent) {
        String string = "";
        switch (nameContent) {
            case NC_NAME_ONLY: {
                string = this._attribute_name;
                break;
            }
            case NC_NAME_SUBNAME_ONLY: {
                string = this._attribute_name;
                if (this._attribute_subname == null || this._attribute_subname.trim().length() == 0) break;
                string = this._attribute_name + "." + this._attribute_subname;
                break;
            }
            case NC_SUBNAME_ONLY: {
                if (this._attribute_subname == null) break;
                string = this._attribute_subname;
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public String getValue() {
        if (this._attribute_num_value != null) {
            return NumericFormat.format(this._attribute_num_value, true, 8) + "";
        }
        return this._attribute_str_value;
    }

    public String getFullPredicate(RuleContentOption ruleContentOption) {
        String string = "";
        switch (ruleContentOption) {
            case NAME_SUBNAME_VALUE: {
                string = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY) + " " + this._conditional_operator + this.getValue();
                break;
            }
            case NAME_SUBNAME: {
                string = this.getFullAttributeName(NameContent.NC_NAME_SUBNAME_ONLY);
                break;
            }
            case SUBNAME: {
                string = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY);
                break;
            }
            case SUBNAME_VALUE: {
                string = this.getFullAttributeName(NameContent.NC_SUBNAME_ONLY) + " " + this._conditional_operator + this.getValue();
                break;
            }
        }
        return string;
    }

    public String getFullPredicate() {
        return this.getFullPredicate(RuleContentOption.NAME_SUBNAME_VALUE);
    }

    public static enum NameContent {
        NC_NAME_ONLY,
        NC_NAME_SUBNAME_ONLY,
        NC_SUBNAME_ONLY;

    }
}

