/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dataminer.generated.server.DmRule;
import oracle.dmt.dataminer.server.model.PredicateRowData;
import oracle.dmt.dataminer.server.model.RuleContentOption;

public class RuleRowData {
    private Integer rule_id;
    private Vector<PredicateRowData> antecedent;
    private Vector<PredicateRowData> consequent;
    private Double rule_support;
    private Double rule_confidence;
    private Double rule_lift;
    private Double antecedent_support;
    private Double consequent_support;
    private Integer number_of_items;
    private static final String BROWSER_NEXT_LINE = "<BR>";
    private static final String AND_CONSTANT = "AND";

    public RuleRowData() {
        this.rule_id = 0;
        this.rule_support = 0.0;
        this.rule_confidence = 0.0;
        this.rule_lift = 0.0;
        this.antecedent_support = 0.0;
        this.consequent_support = 0.0;
        this.number_of_items = 0;
        this.antecedent = new Vector();
        this.consequent = new Vector();
    }

    public RuleRowData(Integer n) {
        this.rule_id = n;
        this.rule_support = 0.0;
        this.rule_confidence = 0.0;
        this.rule_lift = 0.0;
        this.antecedent_support = 0.0;
        this.consequent_support = 0.0;
        this.number_of_items = 0;
        this.antecedent = new Vector();
        this.consequent = new Vector();
    }

    public RuleRowData(Integer n, Double d, Double d2, Double d3, Double d4, Double d5, Integer n2, Vector<PredicateRowData> vector, Vector<PredicateRowData> vector2) {
        this.rule_id = n;
        this.rule_support = d;
        this.rule_confidence = d2;
        this.rule_lift = d3;
        this.antecedent_support = d4;
        this.consequent_support = d5;
        this.number_of_items = n2;
        this.antecedent = vector;
        this.consequent = vector2;
    }

    public RuleRowData(DmRule dmRule) throws Exception {
        this.rule_id = dmRule.getRuleId() != null ? Integer.valueOf(dmRule.getRuleId()) : null;
        this.rule_support = dmRule.getRuleSupport() != null ? Double.valueOf(dmRule.getRuleSupport().doubleValue()) : null;
        this.rule_confidence = dmRule.getRuleConfidence() != null ? Double.valueOf(dmRule.getRuleConfidence().doubleValue()) : null;
        this.rule_lift = dmRule.getRuleLift() != null ? Double.valueOf(dmRule.getRuleLift().doubleValue()) : null;
        this.antecedent_support = dmRule.getAntecedentSupport() != null ? Double.valueOf(dmRule.getAntecedentSupport().doubleValue()) : null;
        this.consequent_support = dmRule.getConsequentSupport() != null ? Double.valueOf(dmRule.getConsequentSupport().doubleValue()) : null;
        this.number_of_items = dmRule.getNumberOfItems() != null ? Integer.valueOf(dmRule.getNumberOfItems()) : null;
        this.number_of_items = dmRule.getNumberOfItems() != null ? Integer.valueOf(dmRule.getNumberOfItems()) : null;
        this.antecedent = dmRule.getAntecedent() != null ? PredicateRowData.createPredicatesFromDmPredicates(dmRule.getAntecedent()) : null;
        this.consequent = dmRule.getConsequent() != null ? PredicateRowData.createPredicatesFromDmPredicates(dmRule.getConsequent()) : null;
    }

    private String getFullPredicate(Vector<PredicateRowData> vector, RuleContentOption ruleContentOption, boolean bl) {
        Iterator<PredicateRowData> iterator = vector.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().getFullPredicate(ruleContentOption));
            if (!iterator.hasNext()) continue;
            if (bl) {
                stringBuffer.append(" AND<BR>");
                continue;
            }
            stringBuffer.append(" AND ");
        }
        return stringBuffer.toString();
    }

    private String getFullPredicate(Vector<PredicateRowData> vector, RuleContentOption ruleContentOption) {
        return this.getFullPredicate(vector, ruleContentOption, false);
    }

    public String getFullAntecedent() {
        return this.getFullPredicate(this.antecedent, RuleContentOption.NAME_SUBNAME_VALUE);
    }

    public String getFullAntecedent(RuleContentOption ruleContentOption) {
        return this.getFullPredicate(this.antecedent, ruleContentOption);
    }

    public String getFullAntecedent(RuleContentOption ruleContentOption, boolean bl) {
        return this.getFullPredicate(this.antecedent, ruleContentOption, bl);
    }

    public String getFullConsequent() {
        return this.getFullPredicate(this.consequent, RuleContentOption.NAME_SUBNAME_VALUE);
    }

    public String getFullConsequent(RuleContentOption ruleContentOption) {
        return this.getFullPredicate(this.consequent, ruleContentOption);
    }

    public String getFullConsequent(RuleContentOption ruleContentOption, boolean bl) {
        return this.getFullPredicate(this.consequent, ruleContentOption, bl);
    }

    public void setRule_id(Integer n) {
        this.rule_id = n;
    }

    public Integer getRule_id() {
        return this.rule_id;
    }

    public void setRule_support(Double d) {
        this.rule_support = d;
    }

    public Double getRule_support() {
        return this.rule_support;
    }

    public void setRule_confidence(Double d) {
        this.rule_confidence = d;
    }

    public Double getRule_confidence() {
        return this.rule_confidence;
    }

    public void setRule_lift(Double d) {
        this.rule_lift = d;
    }

    public Double getRule_lift() {
        return this.rule_lift;
    }

    public void setAntecedent_support(Double d) {
        this.antecedent_support = d;
    }

    public Double getAntecedent_support() {
        return this.antecedent_support;
    }

    public void setConsequent_support(Double d) {
        this.consequent_support = d;
    }

    public Double getConsequent_support() {
        return this.consequent_support;
    }

    public void setNumber_of_items(Integer n) {
        this.number_of_items = n;
    }

    public Integer getNumber_of_items() {
        return this.number_of_items;
    }

    public void setAntecedent(Vector<PredicateRowData> vector) {
        this.antecedent = vector;
    }

    public Vector<PredicateRowData> getAntecedent() {
        return this.antecedent;
    }

    public void setConsequent(Vector<PredicateRowData> vector) {
        this.consequent = vector;
    }

    public Vector<PredicateRowData> getConsequent() {
        return this.consequent;
    }

    public HashMap<String, RuleAttributeValues> getRuleAttributeValues() {
        HashMap<String, RuleAttributeValues> hashMap = new HashMap<String, RuleAttributeValues>();
        RuleAttributeValues ruleAttributeValues = null;
        for (PredicateRowData predicateRowData : this.antecedent) {
            ruleAttributeValues = new RuleAttributeValues(predicateRowData.getAttribute_name(), predicateRowData.getAttribute_subname(), predicateRowData.getAttribute_confidence(), predicateRowData.getAttribute_support());
            hashMap.put(predicateRowData.getFullAttributeName(), ruleAttributeValues);
        }
        return hashMap;
    }

    public class RuleAttributeValues {
        String attribute_name;
        String attribute_subName;
        Double confidence;
        Double support;

        public RuleAttributeValues(String string, String string2, Double d, Double d2) {
            this.attribute_name = string;
            this.attribute_subName = string2;
            this.confidence = d;
            this.support = d2;
        }

        public void setAttribute_name(String string) {
            this.attribute_name = string;
        }

        public String getAttribute_name() {
            return this.attribute_name;
        }

        public void setAttribute_subName(String string) {
            this.attribute_subName = string;
        }

        public String getAttribute_subName() {
            return this.attribute_subName;
        }

        public void setConfidence(Double d) {
            this.confidence = d;
        }

        public Double getConfidence() {
            return this.confidence;
        }

        public String getFullAttributeName() {
            String string = this.attribute_subName != null ? this.attribute_name + "." + this.attribute_subName : this.attribute_name;
            return string;
        }

        public void setSupport(Double d) {
            this.support = d;
        }

        public Double getSupport() {
            return this.support;
        }
    }
}

