/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientRowData;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.MiningModelSettings;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.SVMBiasRowData;
import oracle.dmt.dataminer.server.model.SVMModelDetails;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class SVMModelDetailsImpl
implements SVMModelDetails {
    private static final Logger LOGGER = Logger.getLogger(SVMModelDetailsImpl.class.getName());
    private static final String QRY_CLASSIFICATION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n     <internal_where_clause> \n ) r  ) \n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String QRY_REGRESSION_COEFFICIENTS = "SELECT * FROM ( \nSELECT * FROM ( \n  SELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"coefficient\" from  \n      (SELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n                       r.attribute_name || '.' ||  r.attribute_subname \n                  ELSE r.attribute_name \n       END \"attribute_name_subname\", \n       r.attribute_name \"attribute_name\", \n       r.attribute_value \"attribute_value\",  \n       r.coefficient \"coefficient\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value, <coefficient_value> \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n  <where_key_word> <and2> <and3> ) r )\n  <where_condition> ) <order> \n) <rownum> \n";
    private static final String _TARGET_CONDITION = "  WHERE t.class = :target_value_param \n";
    private static final String QRY_CLASSIFICATION_COEFFICIENTS_ALL = "SELECT * FROM ( \nSELECT * FROM ( \nSELECT \n<select_stmt>\n\tfrom ( \tSELECT CASE WHEN r.attribute_subname IS NOT NULL THEN \n\t      r.attribute_name || '.' ||  r.attribute_subname \n\t     ELSE r.attribute_name \n\t     END \"attribute_name_subname\", \n\t  r.attribute_name \"attribute_name\", \n\t  r.attribute_value \"attribute_value\" \n  FROM (SELECT t.class, s.attribute_name, s.attribute_subname, s.attribute_value \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n<target_condition> ) r ) \n<name_filter_condition><group_by>) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_BINARY = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT * FROM (\n  SELECT \"target\",\n       NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\", \n       attribute_name  \"attribute_name\", \n        \"attribute_value\", \n        case when (c1 is not null) AND (c2 is not null) AND (c1 > c2) then c1 \n             when (c2 is null) then c1 \n             else null \n        end \"propensity_target_one\",\n        case when (c2 is not null) AND (c1 is not null) AND (c2 > c1) then c2 \n             when (c1 is null) then c2 \n             else null \n       end \"propensity_target_two\",\n       <ABSOLUTE_VALUE>(  nvl(c1, 0)  +  nvl(c2,0) ) \"propensity_target\"\n  FROM (\n    SELECT t.class \"target_attribute_value\", t.class \"target\", \n           s.attribute_name, s.attribute_subname, s.attribute_value \"attribute_value\", \n           s.coefficient \"coefficient\" \n   FROM \n     TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n     TABLE(t.attribute_set) s   \n   <where_clause> \n  )\n  pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) )   where c1 is not null or c2 is not null \n) <where_clause_like> \n) <order> \n) <rownum> \n";
    private static final String QRY_ALL_PROPENSITIES_MULTI = "SELECT <COUNT_ONLY> FROM (\nSELECT * FROM (\nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\", \"propensity_target_one\", \"propensity_target_two\", \n  ((nvl(<ABSOLUTE_VALUE>(\"propensity_target_one\"), 0.0) + nvl(<ABSOLUTE_VALUE>(\"propensity_target_two\"), 0.0) ) ) \"propensity_target\" \nFROM ( \nSELECT \"attribute_name_subname\", \"attribute_name\", \"attribute_value\",  \n       case  \n         when c1 > 0 and c2 > 0 and c1 > c2 then (c1-c2)/(c1+c2) \n         when c1 > 0 and c2 < 0 and c1 > c2 then (c1)/(c1+abs(c2)) \n         when c1 < 0 and c2 < 0 and c1 > c2 then -1.0 * (c1-c2)/(abs(c1)+abs(c2)) \n         when (c2 is null) and (c1 is not null) then c1  \n         else null \n       end \"propensity_target_one\", \n       case  \n         when c1 > 0 and c2 > 0 and c2 > c1 then (c2-c1)/(c1+c2)   \n         when c2 > 0 and c1 < 0 and c2 > c1 then (c2)/(abs(c1)+c2) \n         when c1 < 0 and c2 < 0 and c2 > c1 then -1.0 * (c2-c1)/(abs(c1)+abs(c2)) \n         when (c1 is null) and (c2 is not null) then c2 \n         else null \n       end \"propensity_target_two\" \n  FROM ( \n    SELECT t.class \"target_attribute_value\",  \n           NVL2( attribute_subname, attribute_name || '.' || attribute_subname, attribute_name) \"attribute_name_subname\",  \n           s.attribute_name \"attribute_name\", s.attribute_value \"attribute_value\", s.coefficient \"coefficient\" \n    FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, TABLE(t.attribute_set) s \n    <where_clause> \n  )\n   pivot(max(\"coefficient\") FOR \"target_attribute_value\" IN (<target_value_one> c1, <target_value_two> c2 ) ) \n  <where_clause_like> \n)\n) <order> \n) <rownum> \n";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s \n   WHERE t.class IN(<target_values>)  ";
    private static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION = "SELECT COUNT(*) TOTAL_COEFFICIENTS, \n   max(abs(coefficient))MAXIMUM_ABS_COEFFICIENT_VALUE \n   FROM TABLE(dbms_data_mining.get_model_details_svm(:model_name_param)) t, \n   TABLE(t.attribute_set) s ";
    static final String QUERY_MIN_MAX = "SELECT  MAX(abs(coefficient)) maximum_value \nFROM TABLE(dbms_data_mining.get_model_details_svm('<model_name>')) t, TABLE(t.attribute_set) s";

    private static String createInternalWhereClause(FilterSetting filterSetting, String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = null;
        if (null != filterSetting.getTargetValue()) {
            stringBuilder = new StringBuilder();
            String string5 = null;
            string5 = filterSetting.getTargetValue() instanceof Number ? StringUtils.getReplacedString(" t.class = <target_value>", "<target_value>", string) : StringUtils.getReplacedString(" t.class = <target_value>", "<target_value>", "'" + string + "'");
            stringBuilder.append("   WHERE ");
            stringBuilder.append(string5);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string2 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string3);
        }
        if (string4 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string4);
        }
        return stringBuilder != null ? stringBuilder.toString() : "";
    }

    private Vector<CoefficientRowData> invokeItemPickerQuery(SQLHelper sQLHelper) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string, null, null);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            vector.clear();
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private Vector<CoefficientRowData> invokeCoefficientQuery(SQLHelper sQLHelper) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                Double d = sQLHelper.rs.getDouble("coefficient");
                CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string, d);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private String prepareCoefficientSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, String string3, boolean bl) throws Exception {
        String string4 = QRY_CLASSIFICATION_COEFFICIENTS;
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string9 = "";
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            bl2 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            String string10 = string5 = bl ? "s.coefficient * -1 as coefficient" : "s.coefficient";
            if (filterSetting.getFetchSize() > 0) {
                string9 = " where rownum <= :fetch_size_param ";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string4 = StringUtils.getReplacedString(string4, "<coefficient_value>", string5);
        string4 = StringUtils.getReplacedString(string4, "<internal_where_clause>", SVMModelDetailsImpl.createInternalWhereClause(filterSetting, StringUtils.escapeSingleQuotesForSQL(string3), string6, string7, string8));
        string4 = StringUtils.getReplacedString(string4, "<order>", stringBuffer.toString());
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string4 = StringUtils.getReplacedString(string4, "<where_condition>", stringBuilder.toString());
        string4 = StringUtils.getReplacedString(string4, "<rownum>", string9);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (string9.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string4;
    }

    private String prepareRegressionCoefficientSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, boolean bl) throws Exception {
        String string3 = QRY_REGRESSION_COEFFICIENTS;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        StringBuilder stringBuilder = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "";
        Boolean bl2 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            bl2 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            String string8 = string4 = bl ? "s.coefficient * -1 as coefficient" : "s.coefficient";
            if (filterSetting.getFetchSize() > 0) {
                string7 = " where rownum <= :fetch_size_param";
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string3 = StringUtils.getReplacedString(string3, "<coefficient_value>", string4);
        if (!string5.isEmpty() || !string6.isEmpty()) {
            string3 = StringUtils.getReplacedString(string3, "<where_key_word>", "WHERE");
            if (string6.isEmpty()) {
                string3 = StringUtils.getReplacedString(string3, "<and2>", string5);
                string3 = StringUtils.getReplacedString(string3, "<and3>", string6);
            } else {
                string3 = StringUtils.getReplacedString(string3, "<and2>", string5);
                string3 = StringUtils.getReplacedString(string3, "<and3>", " AND " + string6);
            }
        } else {
            string3 = StringUtils.getReplacedString(string3, "<where_key_word>", "");
            string3 = StringUtils.getReplacedString(string3, "<and2>", "");
            string3 = StringUtils.getReplacedString(string3, "<and3>", "");
        }
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_condition>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<rownum>", string7);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (string7.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string3;
    }

    private void prepareCoefficientSQLAll(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting) throws Exception {
        String string3 = QRY_CLASSIFICATION_COEFFICIENTS_ALL;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        String string5 = null;
        String string6 = "";
        StringBuilder stringBuilder = null;
        String string7 = null;
        if (filterSetting != null) {
            Vector<CoefficientSortSpec> vector;
            if (filterSetting.getFetchSize() > 0) {
                string4 = " WHERE rownum <= :fetch_size_param";
            }
            if ((vector = filterSetting.getSortSpecification()) != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    String string8 = coefficientSortSpec.getAttributeName();
                    if (string8.equals("attribute_name_subname")) {
                        string5 = "\"attribute_name_subname\", max(\"attribute_name\") \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name_subname\"";
                        stringBuffer.append("\"attribute_name_subname\"");
                    } else if (string8.equals("attribute_name")) {
                        string5 = "max(\"attribute_name_subname\") \"attribute_name_subname\", \"attribute_name\", max(\"attribute_value\") \"attribute_value\"";
                        string6 = "GROUP BY \"attribute_name\"";
                        stringBuffer.append("\"attribute_name\"");
                    } else if (string8.equals("attribute_value")) {
                        string5 = "\"attribute_name_subname\", \"attribute_name\", \"attribute_value\"";
                        stringBuffer.append("\"attribute_value\"");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append(" ASC ");
                    } else {
                        stringBuffer.append(" DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
            string7 = null != filterSetting.getTargetValue() ? _TARGET_CONDITION : "";
        }
        string3 = StringUtils.getReplacedString(string3, "<select_stmt>", string5);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder("");
        }
        string3 = StringUtils.getReplacedString(string3, "<name_filter_condition>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<target_condition>", string7);
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = StringUtils.getReplacedString(string3, "<group_by>", string6.toString());
        string3 = StringUtils.getReplacedString(string3, "<rownum>", string4);
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (string4.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        if (string7.length() > 0) {
            sQLHelper.opstmt.setStringAtName("target_value_param", filterSetting.getTargetValue().toString());
        }
    }

    @Override
    public Vector<CoefficientRowData> getAllCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<CoefficientRowData> vector = new Vector();
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareCoefficientSQLAll(connection, sQLHelper, string, string2, filterSetting);
        vector = this.invokeItemPickerQuery(sQLHelper);
        return vector;
    }

    public Vector<CoefficientRowData> getRegressionCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareRegressionCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, false);
        return this.invokeCoefficientQuery(sQLHelper);
    }

    public Vector<CoefficientRowData> getAnomalyCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<Object> vector = new Vector();
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
            vector = this.invokeCoefficientQuery(sQLHelper);
            if (vector.size() == 0) {
                this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getAnomalyNonSelectedBinaryClassValue().toString(), true);
                vector = this.invokeCoefficientQuery(sQLHelper);
            }
        } else {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
            vector = this.invokeCoefficientQuery(sQLHelper);
        }
        return vector;
    }

    @Override
    public Vector<CoefficientRowData> getCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<Object> vector = new Vector();
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
            vector = this.invokeCoefficientQuery(sQLHelper);
            if (vector.size() == 0) {
                this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getNonSelectedBinaryClassValue().toString(), true);
                vector = this.invokeCoefficientQuery(sQLHelper);
            }
        } else {
            this.prepareCoefficientSQL(connection, sQLHelper, string, string2, filterSetting, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", false);
            vector = this.invokeCoefficientQuery(sQLHelper);
        }
        return vector;
    }

    public Integer getTotalCountCoefficients(Connection connection, String string, String string2) throws Exception {
        Integer n = null;
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareTotalCountCoefficientsRegressionQuery(connection, sQLHelper, string, string2);
        n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
        return n;
    }

    public Integer getTotalCountCoefficients(Connection connection, String string, String string2, List<Object> list, FilterSetting filterSetting) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        Integer n = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
            if (n == 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, arrayList);
                n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
            }
        } else {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            n = this.invokeTotalCountCoefficientsQuery(sQLHelper);
        }
        return n;
    }

    public HashMap getCoefficientStatistics(Connection connection, String string, String string2, List<Object> list, FilterSetting filterSetting) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        HashMap hashMap = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            Integer n = (Integer)hashMap.get("TOTAL_COEFFICIENTS");
            if (n == 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(filterSetting.getNonSelectedBinaryClassValue());
                this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, arrayList);
                hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
            }
        } else {
            this.prepareTotalCountCoefficientsClassificationQuery(connection, sQLHelper, string, string2, list);
            hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        }
        return hashMap;
    }

    public HashMap getCoefficientStatistics(Connection connection, String string, String string2) throws Exception {
        HashMap hashMap = null;
        SQLHelper sQLHelper = new SQLHelper();
        this.prepareTotalCountCoefficientsRegressionQuery(connection, sQLHelper, string, string2);
        hashMap = this.invokeCoefficientsStatisticsQuery(sQLHelper);
        return hashMap;
    }

    private void prepareTotalCountCoefficientsClassificationQuery(Connection connection, SQLHelper sQLHelper, String string, String string2, List<Object> list) throws Exception {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        boolean bl = list.get(0) instanceof String;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n = 0;
        for (Object object : list) {
            ++n;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append(":target_value_");
            stringBuilder.append(n);
            hashMap.put(object, n);
        }
        string3 = StringUtils.getReplacedString(string3, "<target_values>", stringBuilder.toString());
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (bl) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string4 = "target_value_" + ((Integer)entry.getValue()).toString();
                String string5 = entry.getKey().toString();
                sQLHelper.opstmt.setStringAtName(string4, string5);
            }
        } else {
            for (Map.Entry entry : hashMap.entrySet()) {
                Object object;
                String string6 = "target_value_" + ((Integer)entry.getValue()).toString();
                Object k = entry.getKey();
                if (k instanceof BigDecimal) {
                    object = (BigDecimal)k;
                    sQLHelper.opstmt.setBigDecimalAtName(string6, (BigDecimal)object);
                    continue;
                }
                if (k instanceof Float) {
                    object = (Float)k;
                    sQLHelper.opstmt.setFloatAtName(string6, ((Float)object).floatValue());
                    continue;
                }
                if (k instanceof Double) {
                    object = (Double)k;
                    sQLHelper.opstmt.setDoubleAtName(string6, ((Double)object).doubleValue());
                    continue;
                }
                if (k instanceof Integer) {
                    object = (Integer)k;
                    sQLHelper.opstmt.setIntAtName(string6, ((Integer)object).intValue());
                    continue;
                }
                if (k instanceof Short) {
                    object = (Short)k;
                    sQLHelper.opstmt.setShortAtName(string6, ((Short)object).shortValue());
                    continue;
                }
                if (k instanceof Byte) {
                    object = (Byte)k;
                    sQLHelper.opstmt.setByteAtName(string6, ((Byte)object).byteValue());
                    continue;
                }
                object = k.toString();
                sQLHelper.opstmt.setStringAtName(string6, (String)object);
            }
        }
    }

    private void prepareTotalCountCoefficientsRegressionQuery(Connection connection, SQLHelper sQLHelper, String string, String string2) throws Exception {
        String string3 = QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_REGRESSION;
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
    }

    private Integer invokeTotalCountCoefficientsQuery(SQLHelper sQLHelper) throws Exception {
        Integer n = 0;
        try {
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                n = sQLHelper.rs.getInt("TOTAL_COEFFICIENTS");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n;
    }

    private HashMap invokeCoefficientsStatisticsQuery(SQLHelper sQLHelper) throws Exception {
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        try {
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt("TOTAL_COEFFICIENTS");
                hashMap.put("TOTAL_COEFFICIENTS", n);
                Double d = sQLHelper.rs.getDouble("MAXIMUM_ABS_COEFFICIENT_VALUE");
                hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", d);
            } else {
                hashMap.put("TOTAL_COEFFICIENTS", 0);
                hashMap.put("MAXIMUM_ABS_COEFFICIENT_VALUE", 0.0);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    @Override
    public Vector<SVMBiasRowData> getBiases(Connection connection, String string, String string2) throws Exception {
        return this.invokeBiasQuery(connection, string, string2, null);
    }

    @Override
    public SVMBiasRowData getBias(Connection connection, String string, String string2, String string3) throws Exception {
        return this.invokeBiasQuery(connection, string, string2, string3).get(0);
    }

    private Vector<SVMBiasRowData> invokeBiasQuery(Connection connection, String string, String string2, String string3) throws Exception {
        String string4 = "SELECT t.class,       s.coefficient as bias   FROM TABLE(dbms_data_mining.get_model_details_svm('<model_name>')) t,      TABLE(t.attribute_set) s    WHERE    attribute_name IS NULL <target_value>   ORDER BY \"CLASS\" ASC";
        Vector<SVMBiasRowData> vector = new Vector<SVMBiasRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            string4 = StringUtils.getReplacedString(string4, "<model_name>", Model.getCombinedUserNameModelName(string, string2, true));
            string4 = string3 != null ? (string3.trim().length() != 0 ? StringUtils.getReplacedString(string4, "<target_value>", " AND t.class = '" + string3 + "'") : StringUtils.getReplacedString(string4, "<target_value>", " ")) : StringUtils.getReplacedString(string4, "<target_value>", " ");
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.stmt.setFetchSize(200);
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string4);
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("class");
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("bias");
                SVMBiasRowData sVMBiasRowData = new SVMBiasRowData(string5, bigDecimal);
                vector.add(sVMBiasRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    @Override
    public boolean isGuasian(Vector<MiningModelSettings> vector) throws Exception {
        MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
        return miningModelSettings._settingValue.equals("SVMS_GAUSSIAN");
    }

    @Override
    public boolean isLinear(Vector<MiningModelSettings> vector) throws Exception {
        MiningModelSettings miningModelSettings = MiningModelSettings.findSetting("SVMS_KERNEL_FUNCTION", vector);
        return miningModelSettings._settingValue.equals("SVMS_LINEAR");
    }

    public Integer getTotalCountPropensities(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Integer n = null;
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareBinaryPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, true);
            n = this.invokeCompareCountQuery(sQLHelper);
        } else {
            this.prepareMultiTargetPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, true);
            n = this.invokeCompareCountQuery(sQLHelper);
        }
        return n;
    }

    public Vector<CoefficientRowData> getPropensities(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        Vector<CoefficientRowData> vector = new Vector();
        SQLHelper sQLHelper = new SQLHelper();
        if (filterSetting.isBinaryClassModel()) {
            this.prepareBinaryPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, false);
            vector = this.invokeCompareQuery(sQLHelper, true);
        } else {
            this.prepareMultiTargetPropensitiesSQL(connection, sQLHelper, string, string2, filterSetting, false);
            vector = this.invokeCompareQuery(sQLHelper, false);
        }
        return vector;
    }

    private String prepareBinaryPropensitiesSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, boolean bl) throws Exception {
        boolean bl2;
        String string3 = QRY_ALL_PROPENSITIES_BINARY;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Boolean bl3 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", filterSetting.getTargetValue().toString());
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", filterSetting.getSecondTargetValue().toString());
        } else {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_clause>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<where_clause_like>", stringBuilder2 != null ? stringBuilder2.toString() : "");
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", "ABS") : StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", " ");
        if (bl) {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "COUNT(*) TOTAL_PROPENSITIES");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", " ");
        } else {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "*");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
        return string3;
    }

    private Vector<CoefficientRowData> invokeCompareQuery(SQLHelper sQLHelper, boolean bl) throws Exception {
        Vector<CoefficientRowData> vector = new Vector<CoefficientRowData>();
        try {
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string;
                String string2 = sQLHelper.rs.getString("attribute_name_subname");
                if (string2 == null) {
                    string2 = "<" + CoefficientsLrb.get("INTERCEPT_NAME") + ">";
                }
                if ((string = sQLHelper.rs.getString("attribute_value")) == null) {
                    string = "";
                }
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("propensity_target_one");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("propensity_target_two");
                if (bl) {
                    if (bigDecimal == null && bigDecimal2 != null) {
                        bigDecimal = new BigDecimal(-1.0 * bigDecimal2.doubleValue());
                    } else if (bigDecimal2 == null && bigDecimal != null) {
                        bigDecimal2 = new BigDecimal(-1.0 * bigDecimal.doubleValue());
                    }
                }
                CoefficientRowData coefficientRowData = new CoefficientRowData(string2, string, bigDecimal != null ? Double.valueOf(bigDecimal.doubleValue()) : null, bigDecimal2 != null ? Double.valueOf(bigDecimal2.doubleValue()) : null);
                vector.add(coefficientRowData);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    private Integer invokeCompareCountQuery(SQLHelper sQLHelper) throws Exception {
        Integer n = null;
        try {
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            sQLHelper.rs.next();
            n = sQLHelper.rs.getInt("TOTAL_PROPENSITIES");
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double getAbsMaxValue(Connection connection, String string, String string2) {
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        String string3 = StringUtils.getReplacedString(QUERY_MIN_MAX, "<model_name>", Model.getCombinedUserNameModelName(string, string2, true));
        try {
            sQLHelper.stmt = connection.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(string3);
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            d = null;
        }
        finally {
            sQLHelper.close();
        }
        return d;
    }

    private void prepareMultiTargetPropensitiesSQL(Connection connection, SQLHelper sQLHelper, String string, String string2, FilterSetting filterSetting, boolean bl) throws Exception {
        boolean bl2;
        String string3 = QRY_ALL_PROPENSITIES_MULTI;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder3 = new StringBuilder();
        Boolean bl3 = null;
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            bl3 = filterSetting.getFilterAndSortByAbsolute();
            vector = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                stringBuilder3.append(" WHERE rownum <= :fetch_size_param ");
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("coefficient")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        if (bl2 = filterSetting.getTargetValue() instanceof Number) {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", filterSetting.getTargetValue().toString());
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", filterSetting.getSecondTargetValue().toString());
        } else {
            string3 = StringUtils.getReplacedString(string3, "<target_value_one>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getTargetValue().toString()) + "'");
            string3 = StringUtils.getReplacedString(string3, "<target_value_two>", "'" + StringUtils.escapeSingleQuotesForSQL(filterSetting.getSecondTargetValue().toString()) + "'");
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(" ");
        }
        if (stringBuilder2 != null) {
            stringBuilder2.append(" AND (c1 is not null or c2 is not null) ");
        } else {
            stringBuilder2 = new StringBuilder(" where c1 is not null or c2 is not null ");
        }
        string3 = StringUtils.getReplacedString(string3, "<where_clause>", stringBuilder.toString());
        string3 = StringUtils.getReplacedString(string3, "<where_clause_like>", stringBuilder2.toString());
        string3 = StringUtils.getReplacedString(string3, "<order>", stringBuffer.toString());
        string3 = filterSetting.getFilterAndSortByAbsolute() ? StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", "ABS") : StringUtils.getReplacedString(string3, "<ABSOLUTE_VALUE>", " ");
        if (bl) {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "COUNT(*) TOTAL_PROPENSITIES");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", " ");
        } else {
            string3 = StringUtils.getReplacedString(string3, "<COUNT_ONLY>", "*");
            string3 = StringUtils.getReplacedString(string3, "<rownum>", stringBuilder3.toString());
        }
        sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
        sQLHelper.opstmt.setStringAtName("model_name_param", Model.getCombinedUserNameModelName(string, string2, false));
        if (!bl && stringBuilder3.length() > 0) {
            sQLHelper.opstmt.setIntAtName("fetch_size_param", filterSetting.getFetchSize());
        }
    }
}

