/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.server.model.CoefficientSortSpec;
import oracle.dmt.dataminer.server.model.FilterSetting;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.server.model.ModelDetails;
import oracle.dmt.dataminer.server.model.SVDCoefficientRowData;
import oracle.dmt.dataminer.server.model.TargetPriorsPredictionSet;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OraclePreparedStatement;

public class SingularValueDecomposition
extends Model
implements ModelDetails {
    protected static boolean loading = false;
    protected static final String FEATURE_ID = "FEATURE_ID";
    protected static final String MAPPED_FEATURE_ID = "MAPPED_FEATURE_ID";
    protected static final HashMap<Integer, String> featureIDToLabelMap = new HashMap();
    protected static HashMap<String, Double> featureIdSingularValue;
    protected static final String MATRIX_TYPE_V = "V";
    protected static final String MATRIX_TYPE_S = "S";
    protected static final String QRY_FEATURE_COEFFICIENTS = "SELECT * FROM ( \n  SELECT CASE WHEN ATTRIBUTE_SUBNAME IS NOT NULL THEN \n                 ATTRIBUTE_NAME || '.' || ATTRIBUTE_SUBNAME\n                 ELSE ATTRIBUTE_NAME \n      END \"attribute_name_subname\", \"value\" FROM ( \n    SELECT ATTRIBUTE_NAME, ATTRIBUTE_SUBNAME, VALUE \"value\"\n      FROM TABLE(dbms_data_mining.get_model_details_svd(:model_name))\n      WHERE MATRIX_TYPE = :matrix_type AND MAPPED_FEATURE_ID = :feature_id \n  ) <order> \n) <rownum> \n";
    protected static final String QUERY_FEATURES = "SELECT distinct t.feature_id, t.mapped_feature_id FROM TABLE(dbms_data_mining.get_model_details_svd(:model_name)) t ORDER BY feature_id";
    protected static final String QUERY_SINGULAR_VALUES = "SELECT MAPPED_FEATURE_ID, VALUE\n FROM TABLE(dbms_data_mining.get_model_details_svd(:model_name)) \n WHERE MATRIX_TYPE = :matrix_type";
    protected static final String QUERY_SCREE_PLOT_VALUES = "SELECT MAPPED_FEATURE_ID, VARIANCE, PCT_CUM_VARIANCE\n FROM TABLE(dbms_data_mining.get_model_details_svd(:model_name)) \n WHERE MATRIX_TYPE = :matrix_type";
    public static final String TOTAL_COEFFICIENTS = "TOTAL_COEFFICIENTS";
    public static final String MAXIMUM_ABS_COEFFICIENT_VALUE = "MAXIMUM_ABS_COEFFICIENT_VALUE";
    protected static final String QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION = "SELECT COUNT(*) TOTAL_COEFFICIENTS,\n  MAX(VALUE) MAXIMUM_ABS_COEFFICIENT_VALUE \nFROM TABLE(dbms_data_mining.get_model_details_svd(:model_name)) \nWHERE MATRIX_TYPE = :matrix_type AND mapped_feature_id IN(:target_values)";
    public static final String ALTER_REVERSE_EXPRESSION_FEATURE_ID = "when value = [FEATURE_ID] then ";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_RENAME = "'[NEW_NAME]'\n";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_KEEP_OLD = "'[OLD_NAME]'\n";
    public static final String ALTER_REVERSE_EXPRESSION_CASE_END = "                else TO_CHAR(value) end";
    public static final String ALTER_REVERSE_EXPRESSION_FINAL = "BEGIN\n  dbms_data_mining.alter_reverse_expression(\n :MODEL_NAME, :CASE_STATEMENT);\nEND;\n";

    public Vector<SVDCoefficientRowData> getCoefficients(Connection connection, String string, String string2, FilterSetting filterSetting) throws Exception {
        String string3 = this.prepareCoefficientSQL(filterSetting);
        Vector<SVDCoefficientRowData> vector = this.invokeCoefficientQuery(connection, string, string2, filterSetting.getTargetValue() != null ? filterSetting.getTargetValue().toString() : "", string3);
        return vector;
    }

    protected String prepareCoefficientSQL(FilterSetting filterSetting) throws Exception {
        String string = QRY_FEATURE_COEFFICIENTS;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        Vector<CoefficientSortSpec> vector = null;
        if (filterSetting != null) {
            vector = filterSetting.getSortSpecification();
            if (filterSetting.getFetchSize() > 0) {
                string2 = " where rownum <= " + filterSetting.getFetchSize();
            }
            if (vector != null && vector.size() > 0) {
                stringBuffer.append("order by ");
                Iterator<CoefficientSortSpec> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    CoefficientSortSpec coefficientSortSpec = iterator.next();
                    if (!coefficientSortSpec.isUseIt()) continue;
                    if (coefficientSortSpec.getAttributeName().equals("value")) {
                        if (filterSetting.getFilterAndSortByAbsolute()) {
                            stringBuffer.append("ABS(\"" + coefficientSortSpec.getAttributeName() + "\") ");
                        } else {
                            stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                        }
                    } else {
                        stringBuffer.append("\"" + coefficientSortSpec.getAttributeName() + "\" ");
                    }
                    if (coefficientSortSpec.isAscending()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC NULLS LAST ");
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                }
                if (stringBuffer.substring(stringBuffer.length() - 1, stringBuffer.length()).equalsIgnoreCase(",")) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            }
        }
        string = StringUtils.getReplacedString(string, "<order>", stringBuffer.toString());
        string = StringUtils.getReplacedString(string, "<rownum>", string2);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<SVDCoefficientRowData> invokeCoefficientQuery(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        Vector<SVDCoefficientRowData> vector = new Vector<SVDCoefficientRowData>();
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string4);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("feature_id", string3);
            sQLHelper.opstmt.setStringAtName("matrix_type", MATRIX_TYPE_V);
            sQLHelper.opstmt.setFetchSize(1000);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString("attribute_name_subname");
                Double d = sQLHelper.rs.getDouble("value");
                SVDCoefficientRowData sVDCoefficientRowData = new SVDCoefficientRowData(string5, null, d);
                vector.add(sVDCoefficientRowData);
            }
        }
        finally {
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TargetPriorsPredictionSet> getTargetValuePredictionSet(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        Vector<TargetPriorsPredictionSet> vector = new Vector<TargetPriorsPredictionSet>();
        String string3 = "select FEATURE_ID, VALUE from table(FEATURE_SET( " + Model.getCombinedUserNameModelName(string, string2, false) + " using <bfile_workaround>)) ORDER BY FEATURE_ID";
        String string4 = this.getBFILEColumns(connection, string, string2);
        String string5 = StringUtils.getReplacedString(string3, "<bfile_workaround>", string4);
        String string6 = null;
        try {
            string6 = DatabaseMetadataUtils.createUniqueTableName("ODMR$", connection, "");
            String string7 = "CREATE TABLE " + string6 + " AS " + string5;
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string7);
            sQLHelper.opstmt.execute();
            string7 = "SELECT FEATURE_ID, VALUE FROM " + string6;
            sQLHelper.pstmt = connection.prepareStatement(string7);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            ResultSetMetaData resultSetMetaData = sQLHelper.rs.getMetaData();
            int n = resultSetMetaData.getColumnType(1);
            while (sQLHelper.rs.next()) {
                TargetPriorsPredictionSet targetPriorsPredictionSet = null;
                Object object = null;
                if (DatabaseMetadataUtils.isSQLDataTypeNumeric(n)) {
                    object = sQLHelper.rs.getBigDecimal(FEATURE_ID);
                } else if (DatabaseMetadataUtils.isSQLDataTypeString(n)) {
                    object = sQLHelper.rs.getString(FEATURE_ID);
                } else {
                    throw new Exception("Unexpected target data type. Expected either a number or string.");
                }
                targetPriorsPredictionSet = new TargetPriorsPredictionSet(object, n, sQLHelper.rs.getDouble("VALUE"));
                vector.add(targetPriorsPredictionSet);
            }
            SingularValueDecomposition.initFeatures(connection, string, string2);
        }
        finally {
            DatabaseMetadataUtils.dropTable(connection, null, string6);
            sQLHelper.close();
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initFeatures(Connection connection, String string, String string2) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            loading = true;
            featureIDToLabelMap.clear();
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(QUERY_FEATURES);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                Integer n = sQLHelper.rs.getInt(FEATURE_ID);
                String string3 = sQLHelper.rs.getString(MAPPED_FEATURE_ID);
                featureIDToLabelMap.put(n, string3);
            }
        }
        finally {
            sQLHelper.close();
            loading = false;
        }
    }

    public TargetPriorsPredictionSet findMostCommonTargetValue(Vector<TargetPriorsPredictionSet> vector) {
        Double d = 0.0;
        Object object = null;
        TargetPriorsPredictionSet targetPriorsPredictionSet = null;
        for (TargetPriorsPredictionSet targetPriorsPredictionSet2 : vector) {
            if (!(d <= targetPriorsPredictionSet2.getProbability())) continue;
            d = targetPriorsPredictionSet2.getProbability();
            object = targetPriorsPredictionSet2.getPrediction();
            targetPriorsPredictionSet = targetPriorsPredictionSet2;
        }
        assert (object != null) : "Unable to find a target value with a prob value >= 0";
        return targetPriorsPredictionSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSingularValues(Connection connection, String string, String string2) throws Exception {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = QUERY_SINGULAR_VALUES;
        if (featureIdSingularValue == null) {
            featureIdSingularValue = new HashMap();
        } else {
            featureIdSingularValue.clear();
        }
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("matrix_type", MATRIX_TYPE_S);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(MAPPED_FEATURE_ID);
                Double d = sQLHelper.rs.getDouble("value");
                featureIdSingularValue.put(string4, d);
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadScreePlotValues(Connection connection, String string, String string2, List<String> list, List<Double> list2, List<Double> list3) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        String string3 = QUERY_SCREE_PLOT_VALUES;
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(string3);
            sQLHelper.opstmt.setStringAtName("model_name", Model.getCombinedUserNameModelName(string, string2, false));
            sQLHelper.opstmt.setStringAtName("matrix_type", MATRIX_TYPE_S);
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string4 = sQLHelper.rs.getString(MAPPED_FEATURE_ID);
                list.add(string4);
                Double d = sQLHelper.rs.getDouble("VARIANCE");
                list2.add(d);
                Double d2 = sQLHelper.rs.getDouble("PCT_CUM_VARIANCE");
                list3.add(d2);
            }
        }
        finally {
            sQLHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getCoefficientStatistics(Connection connection, String string, String string2, List<Object> list) throws Exception {
        assert (list != null) : "Must provide a non null collection of target values.";
        assert (list != null && list.size() > 0) : "Must provide at least one target value";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SQLHelper sQLHelper = new SQLHelper();
        boolean bl = list.get(0) instanceof String;
        String string3 = Model.getCombinedUserNameModelName(string, string2, false);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Object object : list) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(",");
            }
            if (bl) {
                stringBuilder.append("'");
                stringBuilder.append(object.toString());
                stringBuilder.append("'");
                continue;
            }
            stringBuilder.append(object.toString());
        }
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(QUERY_TOTAL_COEFFICIENTS_FOR_TARGET_CLASSIFICATION);
            sQLHelper.opstmt.setStringAtName("model_name", string3);
            sQLHelper.opstmt.setStringAtName("matrix_type", MATRIX_TYPE_V);
            sQLHelper.opstmt.setStringAtName("target_values", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                Object object;
                Integer n = sQLHelper.rs.getInt(TOTAL_COEFFICIENTS);
                hashMap.put(TOTAL_COEFFICIENTS, n);
                object = sQLHelper.rs.getDouble(MAXIMUM_ABS_COEFFICIENT_VALUE);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, object);
            } else {
                hashMap.put(TOTAL_COEFFICIENTS, 0);
                hashMap.put(MAXIMUM_ABS_COEFFICIENT_VALUE, 0.0);
            }
        }
        finally {
            sQLHelper.close();
        }
        return hashMap;
    }

    public static boolean isFeatureLabelUniquie(String string) {
        return !featureIDToLabelMap.containsValue(string);
    }

    public static String renameFeatureLabel(Connection connection, String string, String string2, String string3, String string4) throws Exception {
        Integer comparable2 = null;
        Set<Integer> set = featureIDToLabelMap.keySet();
        for (Integer comparable3 : set) {
            String string5 = featureIDToLabelMap.get(comparable3);
            if (!string5.equals(string4)) continue;
            comparable2 = comparable3;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder("case ");
        set = featureIDToLabelMap.keySet();
        for (Integer n : set) {
            String string6 = featureIDToLabelMap.get(n);
            StringBuilder stringBuilder2 = new StringBuilder();
            String string7 = StringUtils.getReplacedString(ALTER_REVERSE_EXPRESSION_FEATURE_ID, "[FEATURE_ID]", n.toString());
            stringBuilder2.append(string7);
            if (n.equals(comparable2)) {
                featureIDToLabelMap.put(n, string3);
                string7 = StringUtils.getReplacedString(ALTER_REVERSE_EXPRESSION_CASE_RENAME, "[NEW_NAME]", string3);
            } else {
                string7 = StringUtils.getReplacedString(ALTER_REVERSE_EXPRESSION_CASE_KEEP_OLD, "[OLD_NAME]", string6);
            }
            stringBuilder2.append(string7);
            stringBuilder.append(stringBuilder2.toString());
        }
        stringBuilder.append(ALTER_REVERSE_EXPRESSION_CASE_END);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.opstmt = (OraclePreparedStatement)connection.prepareStatement(ALTER_REVERSE_EXPRESSION_FINAL);
            sQLHelper.opstmt.setStringAtName("MODEL_NAME", Model.getCombinedUserNameModelName(string, string2, true));
            sQLHelper.opstmt.setStringAtName("CASE_STATEMENT", stringBuilder.toString());
            sQLHelper.rs = sQLHelper.opstmt.executeQuery();
        }
        catch (Exception exception) {
            if (exception.getMessage().startsWith("ORA-01031")) {
                throw new Exception(CoefficientsLrb.get("FEATURE_RENAME_NO_PRIVILEGE_MESG"));
            }
            throw exception;
        }
        finally {
            sQLHelper.close();
        }
        return string3;
    }

    public static Double getSingularByFeatureIdValue(String string) {
        return featureIdSingularValue.get(string);
    }

    public static boolean isFeatureIdSingularMapEmpty() {
        return featureIdSingularValue.isEmpty();
    }

    public static boolean isLoading() {
        return loading;
    }

    public static HashMap<String, Double> getFeatureIdSingularValueMap() {
        return featureIdSingularValue;
    }
}

